<?php

	/**
	 * 麦迪钩子&插件类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	abstract class Plugin{

		public $var;
		static private $gather=array();

		/**
		 * 实例化
		 */
		final public function __construct(){

		}

		/**
		 * 获取
		 */
		final public function __get($name){
			if($name == 'MDPHP')
				return $GLOBALS['MDPHP']->var;
			else
				return $var[$name];
		}

		/**
		 * 设置
		 */
		final public function __set($name, $value){
			if($name == 'MDPHP')
				$GLOBALS['MDPHP']->assign($name, $value);
			else
				$this->assign($name, $value);
		}

		/**
		 * 重载
		 */
		final public function __call($name, $args){
			if(method_exists($GLOBALS['MDPHP'], $name)){
				return call_user_func_array(array($GLOBALS['MDPHP'], $name), $args);
			}
		}

		/**
		 * 定义模板变量
		 * @param	string	$name	变量名
		 * @param	string	$value	值
		 * @return					MDPHP类
		 */
		public function assign($name, $value){
			$this->var[$name] = $value;
			return $this;
		}

		/**
		 * 引入模板文件
		 * @param	string	$name	模板文件名
		 */
		public function display($name, $path=null){

			//模板目录
			is_null($path) && $path=MD_PATH_PLUGIN.ucfirst(get_class($this)).'/';
			$file = $path . $name . C('TMPL_SUFFIX');

			if(file_exists($file)){

				$cache = MD_PATH_CACHE . md5(MD_CTR.MD_ACT) . '.php';

				//编译模板
				if(!file_put_contents($cache, '<?php if(!defined(\'MDPHP_CACHE\')) exit; ?>' . MDPHP\Custom::parsing(file_get_contents($file))))
					error('Not_Compile_Template', $cache);

				//转换变量
				extract($this->var);

				//添加日志
				MDPHP\Custom::log(array('name'=>$name, 'cache'=>$cache), 'T');

				require $cache;

			}else{
				error('Template_Not_Exist', $file);
			}

		}

		/**
		 * 添加插件
		 * @param	string			$event	事件名
		 * @param	string/array	$name	插件名
		 */
		static public function add($event, $name){

			if(empty(self::$gather[$event]))
				self::$gather[$event] = array();

			if(is_array($name))
				self::$gather[$event] = array_merge(self::$gather[$event], $name);
			else
				self::$gather[$event][] = $name;

		}

		/**
		 * 获取插件信息
		 * @param	string	$event	事件名, 为空获取所有
		 * @return	array			插件组
		 */
		static public function get($event=null){
			if(is_null($event))
				return self::$gather;
			else
				return self::$gather[$event];
		}

		/**
		 * 导入插件
		 * @param	array	$data		插件组
		 * @param	boolean	$overlay	是否覆盖导入
		 */
		static public function import($data, $overlay=false){

			if($overlay){												//覆盖
				self::$gather = array_merge(self::$gather, $data);
			}else{
				foreach($data as $key => $value){
					if(empty(self::$gather[$key]))
						self::$gather[$key] = array();
					if(empty($value['_overlay'])){						//合并
						self::$gather[$key] = array_merge(self::$gather[$key], $value);
					}else{												//指定合并
						unset($value['_overlay']);
						self::$gather[$key] = $value;
					}
				}
			}

		}

		/**
		 * 执行插件
		 * @param	string	$name	名称
		 * @param	array	$event	事件
		 * @param	array	$param	参数
		 * @return	[type]			返回值
		 * 
		 * exec('name')
		 * exec('name', array(1, 2))
		 * exec('name', 'a')
		 * exec('name', 'a', array(1, 2))
		 * 
		 */
		static public function exec($name, $event='run', &$param=array()){

			if(is_array($event)){
				$param = $event;
				$event = 'run';
			}

			$file = self::getFileName($name);
			if(!import($file, '')) error('Not_Load_Plugin', $file);

			if(!class_exists($name)) error('该插件代码格式不正确');

			$class = new $name();
			if(!method_exists($class, $event)) error('Plugin_Method_Not_Exist', null, $name, $event);
			return call_user_func_array(array($class, $event), (array)$param);

		}

		/**
		 * 钩子监听
		 * @param	string	$event	事件名
		 * @param	array	&$param	参数
		 */
		static public function listen($event, &$param=array()){

			if(isset(self::$gather[$event])){
				foreach(self::$gather[$event] as $value){
					if(self::exec($value, $event, $param) === false)	//中断执行
						return;
				}
			}

		}

		/**
		 * 获取插件信息
		 * @param	string	$name	插件名
		 * @return	array
		 */
		static public function getInfo($name){

			$file = self::getFileName($name);
			if(!import($file, ''))
				return null;

			return class_exists($name) ? $name::$info : null;

		}

		/**
		 * 获取文件名
		 * @param	string	$name	插件名
		 * @return	string
		 */
		static public function getFileName(&$name){

			//名称、事件
			$array = explode('/', $name);
			if(count($array) == 2)
				list($module, $name) = explode('/', $name);

			//格式化
			isset($module)		&& $module.=($module ? '/' : '');

			//目录解析
			$path = MD_PATH.(isset($module) ? ucfirst($module) : MD_PATH_MODULE).C('LAYER_P').'/';
			if(is_dir($path.ucfirst($name)))
				$path .= ucfirst($name).'/public.php';
			else
				$path .= $name.'.php';

			return $path;

		}

		/**
		 * 安装-抽象
		 * @return	boolean	是否允许安装
		 */
		abstract public function install();

		/**
		 * 卸载-抽象
		 * @return	boolean	是否允许卸载
		 */
		abstract public function uninstall();

	}

