<?php

	/**
	 * 获取用户输入数据
	 * @param	string	$id		获取方式: 类型.名称
	 * @param	[type]	$default默认值
	 * @param	[type]	$filter	用作处理的方法
	 * @return	string			用户数据
	 */
	function I($id, $default=null, $filter='htmlspecialchars'){
		$name = array(
			'G'			=>	'_GET',
			'P'			=>	'_POST',
			'S'			=>	'_SERVER',
			'R'			=>	'_REQUEST',
			'T'			=>	'_TMPLVAR',
		);
		$id = trim($id, '.');
		if(isset($name[strtoupper($id)])){
			$id = $name[strtoupper($id)];							//整个数组
		}else{
			$type = strtoupper(substr($id, 0, 2));
			if(substr($type, -1)=='.' && strlen($id)>2 && isset($name[rtrim($type, '.')])){
				$id = $name[rtrim($type, '.')] . substr($id, 1);	//指定
			}else{													//内部获取
				$key	= strtoupper(substr($id, 0, 6));
				$array	= array('COOKIE'=>6, 'SESSIO'=>7);
				if($bool=array_key_exists($key, $array))
					$id = '_' . strtoupper(substr($id, 0, $array[$key])) . substr($id, $array[$key]);
				else
					$id = (isset($_REQUEST[$id]) ? '_REQUEST.' : 'GLOBALS.') . $id;
			}
		}
		if($id === '') return;
		$name = MDPHP\Custom::parseVar($id);
		//内部 cookie session 方法调用
		if(!empty($bool) && func_num_args()==2){
			if($default===null)
				eval('unset(' . $name . ');');
			else
				eval($name . ' = $default;');
			return;
		}
		if(substr($id, 0, 8) == '_TMPLVAR')
			$_TMPLVAR = (array)$GLOBALS['MDPHP'];
		//数据处理
		$result = eval('return isset(' . $name . ') ? ' . $name . ' : $default;');
		if(MAGIC_QUOTES_GPC)
			$result = MDPHP\Custom::runMagicQuotes($result, 'stripslashes');
		if($filter)
			return MDPHP\Custom::runMagicQuotes($result, $filter);
		else
			return $result;
	}

	/**
	 * 生成URL地址
	 * @param	string	$url	动作 或 控制器/动作
	 * @param	array	$param	传递参数
	 * @return	string			URL地址
	 */
	function U($url, $args=null){

		//变量初始
		if($url{0}=='#' && !method_exists(MD_PREFIX_CTR.MD_CTR, $url))
			$url = array('path' => '_' . MD_ACT . (($sub=substr($url, 1)) ? '_' : '') . $sub);
		else
			$url = parse_url($url);
		$param = C('URL.PARAM') && $args;

		//参数解析
		parse_str((isset($url['query']) ? $url['query'] : ''), $url['query']);
		if(is_string($args)) parse_str($args, $args);
		$url['query'] = array_merge($url['query'], (array)$args);

		//锚点解析
		$url['fragment'] = isset($url['fragment']) ? $url['fragment'] : null;

		//控制器、动作解析
		$array = explode('/', $url['path']);
		$default = arrayCallBack(C('DEFAULT'), function($v){ return strtolower($v); });
		switch(count($array)){
			case 1:
				$url['path'] = MD_MOD . '/' . MD_CTR . '/' . $array[0];
			break;
			case 2:
				$url['path'] = MD_MOD . '/' . $array[0] . '/' . $array[1];
			break;
			case 3:
				$url['path'] = $array[0] . '/' . $array[1] . '/' . $array[2];
			break;
		}
		$array = explode('/', $url['path']);

		//简化地址
		if(!$param){
			if(strtolower($array[0]) == $default['MODULE'])
				$array[0] = null;
			if(!$array[0] && strtolower($array[1])==$default['CONTROLLER'])
				$array[1] = null;
			if(!$array[0] && !$array[1] && strtolower($array[2])==$default['ACTION'])
				$array[2] = null;
		}
		$url['path'] = ($array[0] ? $array[0].'/' : '') . ($array[1] ? $array[1].'/' : '') . ($array[2] ? $array[2] : '');
		$url['path'] = $url['path'] . ((!$url['path'] || substr($url['path'], -1)=='/') ? '' : C('TMPL_SUFFIX'));

		//拼接URL
		array_walk($url['query'], function(&$v, $k, $e){
			$v = $k . $e . $v;
		}, ($param ? '/' : '='));
		$url['query'] = (empty($url['query']) ? '' : (($param ? '' : '?').implode(($param ? '/' : '&'), $url['query'])));
		if(($url['path']||$url['query']) && ($param||!C('URL.PSEUDO'))){
			$url['path'] = APP_ROOT . getFileName($_SERVER['SCRIPT_NAME']) . ($url['path'] ? '/' : '') . $url['path'];
		}else{
			$url['path'] = APP_ROOT . ltrim($url['path'], '/');
		}
		$url = $url['path'] . ($param&&$url['query'] ? '/' : '') . $url['query'] . (is_null($url['fragment']) ? '' : '#'.$url['fragment']);

		//返回结果
		return $url;
	}

	/**
	 * 读取配置项
	 * @param	string	$name	配置项名称
	 * @param	[type]	$value	(可空)修改为的值
	 * @param	string	$module	模块名称, 用于跨模块配置项获取
	 */
	function C($name=null, $value=null, $module=null){
		static $_config = array();
		if(is_array($name)){
			$_config = array_merge($_config, $name);
			return;
		}
		if(!is_null($module)){
			if(file_exists($file=MD_PATH.ucfirst($module).'/config.php'))
				$config = include $file;
			else
				$config = array();
		}else{
			$config =& $_config;
		}
		$name = MDPHP\Custom::parseVar('config' . (is_null($name) ? '' : '.'.$name));
		if(func_num_args() == 2)
			return eval('return ' . $name . ' = $value;');
		else
			return eval('return isset(' . $name . ') ? ' . $name . ' : null;');
	}

	/**
	 * 写文件
	 * @param	string			$name	为'config/config-root(总)' 修改配置文件, 默认为'auto' 自动生成
	 * @param	[type]			$data	支持任何类型(删除文件填null)
	 * @return	boolean/string			返回 布尔值 或 文件名(未指定文件名时)
	 */
	function F($name='auto', $data=array()){
		$type = strtolower($name);
		switch(strtolower($name)){
			case 'auto':
				$name = MD_PATH_CACHE . getRandName('.php');
			break;
			case 'config':
				$name = MD_PATH_COMPLETE . 'config.php';
			break;
			case 'config-root':
				$name = MD_PATH . 'config.php'; $type='config';
			break;
		}
		if(func_num_args() == 1){		//读取
			return ($type=='config' ? (include $name) : unserialize(substr(file_get_contents($name), 13)));
		}else{
			if(is_null($data)){			//删除
				return ($type=='config' ? (bool)file_put_contents($name, '<?php return array(); ?>') : @unlink($name));
			}else{						//设置
				if($type == 'config')
					$data = '<?php return ' . var_export(array_merge((array)include $name, (array)$data), true) . '; ?>';
				else
					$data = '<?php die; ?>' . serialize($data);
				return (bool)file_put_contents($name, $data);
			}
		}
	}

	/**
	 * 实例化一个模型
	 * @param	string			$name	模型名称
	 * @return	实例化模型
	 */
	function M($name=null){
		return new MDPHP\Model($name, C('DB_CONFIG'));
	}

	/**
	 * 缓存功能
	 * @param	string	$name	缓存名称
	 * @param	[type]	$data	数据
	 * @param	integer	$expire	有效期(秒)
	 * @return					缓存数据
	 */
	function S($name, $data=null, $expire=0){
		$name = MD_PATH_CACHE . md5('MD_'.base64_encode($name)) . '.php';
		if(func_num_args() == 1){																//读取
			$data = F($name);
			$time = substr($data, 0, ($int = strpos($data, '$$$')));
			if($time<1 || $time>time()){
				MDPHP\Custom::log(1, 'C');
				return unserialize(substr($data, $int+3));
			}else{
				MDPHP\Custom::log(2, 'C');
				F($name, null); return null;
			}
		}else{
			if(is_null($data)){
				return F($name, null);															//删除
			}else{
				MDPHP\Custom::log(0, 'C');
				return F($name, ($expire ? time()+$expire : '') . '$$$' . serialize($data));	//设置
			}
		}
	}

	/**
	 * 执行插件
	 * @param	string	$name	名称
	 * @param	array	$param	事件
	 * @param	array	$event	参数
	 * @return	[type]			返回值
	 * 
	 * exec('name')
	 * exec('name', array(1, 2))
	 * exec('name', 'a')
	 * exec('name', 'a', array(1, 2))
	 * 
	 */
	function P($name, $event='run', &$param=array()){
		return Plugin::exec($name, $event, $param);
	}

	/**
	 * 数据统计
	 * @param	string	$name	名称
	 * @param	integer	$step	步进值
	 * @return	integer
	 */
	function N($name, $step=null){
		static $_number = array();
		if(is_null($step))
			return isset($_number[$name]) ? $_number[$name] : null;
		else
			return isset($_number[$name]) ? $_number[$name]+=$step : $_number[$name]=$step;
	}

	/**
	 * 钩子监听
	 * @param	string	$event	事件名
	 * @param	array	&$param	参数
	 */
	function hook($event, &$param=array()){
		Plugin::listen($event, $param);
	}

	/**
	 * cookie操作
	 * @param	string	$name	名称
	 * @param	string	$value	值
	 * @param	array	$option	配置项
	 * @return	[type]			处理结果
	 */
	function cookie($name='', $value=null, $option=array()){
		$option = array_merge(array(
			'prefix'	=>	C('COOKIE.PREFIX'),
			'expire'	=>	C('COOKIE.EXPIRE'),
			'path'		=>	C('COOKIE.PATH'),
			'domain'	=>	C('COOKIE.DOMAIN'),
			'secure'	=>	C('COOKIE.SECURE'),
			'httponly'	=>	C('COOKIE.HTTPONLY')
		), (array)$option);
		if(func_num_args() <= 1){
			if($name === null){			//全部删除
				$time = time() - 3600;
				foreach(MDPHP\Custom::parseCookie() as $key => $value){
					setcookie($key, null, $time, $option['path'], $option['domain'], $option['secure'], $option['httponly']);
				}
				$_COOKIE = array();
			}elseif($name === ''){		//全部获取
				return I('COOKIE');
			}else{						//获取指定
				return I('COOKIE.' . $option['prefix'] . $name);
			}
		}else{
			if(is_array($value)){		//配置
				$option = array_merge($option, $value);
			}elseif($value === null){	//删除指定
				setcookie($option['prefix'].$name, null, time()-3600, $option['path'], $option['domain'], $option['secure'], $option['httponly']);
				I('COOKIE.'.$option['prefix'].$name, null);
			}else{						//设置
				setcookie($option['prefix'].$name, $value, time()+$option['expire'], $option['path'], $option['domain'], $option['secure'], $option['httponly']);
				I('COOKIE.'.$option['prefix'].$name, $value);
			}
		}
	}

	/**
	 * session操作
	 * @param	string	$name	名称
	 * @param	[type]	$value	值
	 * @return	[type]			处理结果
	 */
	function session($name='', $value=''){
		C('SESSION.START', true) || session_start();
		if($name === null){							//全部删除
			$_SESSION = array();
		}elseif($name === ''){						//全部获取
			return I('SESSION');
		}elseif($value === null){					//删除指定
			I('SESSION.' . $name, null);
		}elseif($value === ''){						//获取指定
			return I('SESSION.' . $name);
		}else{										//设置
			I('SESSION.' . $name, $value);
		}
	}

	/**
	 * 生成表单Hash值
	 * @return	string
	 */
	function hash_get($id=0){
		$hash = substr(md5(base64_encode(uniqid().mt_rand(0, 999999))), 3, 12);
		session('_MDPHP_HASH_'.$id.'_', $hash);
		return $hash;
	}

	/**
	 * 验证表单Hash值
	 * @return	boolean	是否正确
	 */
	function hash_check($hash, $id=0){
		$hash = ($hash == session('_MDPHP_HASH_'.$id.'_'));
		session('_MDPHP_HASH_'.$id.'_', null);
		return $hash;
	}

	/**
	 * 获取文件后缀
	 * @param	string	$name	文件名
	 * @return	string
	 */
	function getFileExt($name){
		return pathinfo($name, PATHINFO_EXTENSION);
	}

	/**
	 * 获取文件名称
	 * @param	string	$name	文件名
	 * @return	string
	 */
	function getFileName($name){
		return pathinfo($name, PATHINFO_BASENAME);
	}

	/**
	 * HTML代码压缩
	 * @param	string	$source	源码
	 * @return	string			压缩后的源码
	 */
	function compress_html($source){
		$chunks = preg_split('/(<pre.*?\/pre>)/ms', $source, -1, PREG_SPLIT_DELIM_CAPTURE);
		$source = '';
		foreach($chunks as $c){
			if(strpos($c, '<pre') !== 0){
				$c = preg_replace('/[\\n\\r\\t]+/', ' ', $c);
				$c = preg_replace('/\\s{2,}/', ' ', $c);
				$c = preg_replace('/>\\s</', '><', $c);
				$c = preg_replace('/\\/\\*.*?\\*\\//i', '', $c);
			}
			$source .= $c;
		}
		return $source;
	}

	/**
	 * GZIP压缩
	 * @param	string	$data	数据
	 * @param	integer	$level	压缩等级(0-9)
	 * @return	string			压缩后的数据
	 */
	function ob_gzip($data, $level=0){
		$level = ($level<1 ? C('COMPRESS.LEVEL') : $level);
		if(!headers_sent() && extension_loaded('zlib') && strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')){
			$data = gzencode($data, $level);
			header('Content-Encoding: gzip');
			header('Vary: Accept-Encoding');
			header('Content-Length: '.strlen($data));
		}
		return $data;
	}

	/**
	 * 检测IP地址是否正确
	 * @param	string	$str
	 * @return	boolean
	 */
	function is_ip($str){
		$ip = explode('.', $str);
		for($i=0; $i<count($ip); $i++){
			if($ip[$i] > 255)
				return false;
		}
		return preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/', $str);
	}

	/**
	 * 检测URL是否正确
	 * @param	string	$value
	 * @param	integer	$option
	 *		0.要求 URL 包含主机名（http://www.example.com）
	 *		1.要求 URL 存在查询字符串（比如：eg.php?age=37）
	 *		2.要求 URL 是 RFC 兼容 URL。（比如：http://example）
	 *		3.要求 URL 在主机名后存在路径（比如：eg.com/example1/）
	 * @return	boolean
	 */
	function is_url($value, $option=0){
		$array = array(FILTER_FLAG_HOST_REQUIRED, FILTER_FLAG_QUERY_REQUIRED, FILTER_FLAG_SCHEME_REQUIRED, FILTER_FLAG_PATH_REQUIRED);
		return filter_var($value, FILTER_VALIDATE_URL, $array[$option]) != false;
	}

	/**
	 * 检测邮箱是否正确
	 * @param	string	$value	值
	 * @return	boolean
	 */
	function is_email($value){
		return filter_var($value, FILTER_VALIDATE_EMAIL) != false;
	}

	/**
	 * 容量单位转换
	 * @param	integer	$size		容量大小
	 * @param	string	$unit		容量计算单位，默认为字节
	 * @param	integer	$decimals	小数点后保留的位数，默认保留二位
	 * @param	string	$targetUnit	转换的目标单位，默认自动进位
	 * @return	string				返回符合要求的带单位结果
	 */
	function fileSizeConv($size, $unit='B', $decimals=2, $targetUnit='auto'){
		$units		=	array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB');
		//判断初始单位
		$theUnit	=	array_search(strtoupper($unit), $units);
		//判断自动计算
		if ($targetUnit != 'auto') $targetUnit = array_search(strtoupper($targetUnit), $units);
		//分流计算
		if($theUnit > $targetUnit){			//单位: 大 -> 小
			$size = $size * pow(1024, $theUnit - $targetUnit);
		}elseif($theUnit < $targetUnit){	//单位: 小 -> 大
			$size = $size / pow(1024, $targetUnit - $theUnit);
		}else{								//单位: 自动(小到大)
			$targetUnit = $theUnit;
			while($size >= 1024){
				$size/=1024;
				$targetUnit++;
			}
		}
		return sprintf("%1\$.{$decimals}f", $size) . $units[$targetUnit];
	}

	/**
	 * MD5安全版
	 * @param	string	$data	数据
	 * @return	string			加密后的数据
	 */
	function md6($data){
		return md5(crypt($data, md5(base64_encode($data . strlen($data)))));
	}

	/**
	 * Crypt加密
	 * @param	string	$data	数据
	 * @return	string			加密后的数据
	 */
	function crypt_encode($data, $key){
		$key	=	md6($key);
		$x		=	0;
		$len	=	strlen($data);
		$l		=	strlen($key);
		$char	=	'';
		for($i=0; $i<$len; $i++){
			if($x == $l)
				$x = 0;
			$char .= $key{$x};
			$x++;
		}
		$str	=	'';
		for($i=0; $i<$len; $i++){
			$str .= chr(ord($data{$i}) + (ord($char{$i})) % 256);
		}
		return base64_encode($str);
	}

	/**
	 * Crypt解密
	 * @param	string	$data	数据
	 * @return	string			解密后的数据
	 */
	function crypt_decode($data, $key){
		$key	=	md6($key);
		$x		=	0;
		$data	=	base64_decode($data);
		$len	=	strlen($data);
		$l		=	strlen($key);
		$char	=	'';
		for($i=0; $i<$len; $i++){
			if($x == $l)
				$x = 0;
			$char .= substr($key, $x, 1);
			$x++;
		}
		$str = '';
		for($i=0; $i<$len; $i++){
			if(ord(substr($data, $i, 1)) < ord(substr($char, $i, 1))){
				$str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
			}else{
				$str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
			}
		}
		return $str;
	}

	/**
	 * 检测提交参数是否正确
	 * @param	array	$group	参数组
	 * @param	string	$value	不允许字符
	 * @return	string			是否正确
	 */
	function check_param($group, $value=''){
		if(is_array($group)){
			foreach($group as $v){
				if($v === $value) return false;
			}
			return true;
		}else{
			return $group !== $value;
		}
	}

	/**
	 * 终止提示
	 */
	function halt($e){
		if(!constant('APP_DEBUG'))
			error('系统出错, 请稍后访问.');
		if(!is_array($e)){
			$trace = debug_backtrace();
			$e['message']	= $e;
			$e['title']		= '程序错误';
			$e['file']		= $trace[0]['file'];
			$e['line']		= $trace[0]['line'];
			$e['class']		= isset($trace[0]['class']) ? $trace[0]['class'] : '';
			$e['function']	= isset($trace[0]['function']) ? $trace[0]['function'] : '';			
		}
		ob_start();
		debug_print_backtrace();
		$e['trace'] = nl2br(htmlspecialchars(ob_get_clean()));
		include MD_ROOT.'Library/Default/halt';
		exit;
	}

	/**
	 * 提示错误
	 */
	function error(){

		$args		= func_get_args(0);
		$language	= C('Language');

		switch(count($args)){
			case 1:
				$content = $args[0];
			break;
			case 2:
				if(array_key_exists($args[0], $language)){
					$content = sprintf($language[$args[0]], $args[1]);
				}else{
					$title=$args[0]; $content=$args[1];
				}
			break;
			default:
				$title = $args[1];
				if(array_key_exists($args[0], $language)){
					$content = $language[$args[0]];
					array_splice($args, 0, 2, $content);
					$content = call_user_func_array('sprintf', $args);
				}
			break;
		}

		$title = empty($title) ? '程序错误' : $title;

		include MD_ROOT.'Library/Default/error';
		exit;

	}

	/**
	 * 小提示
	 * @param	array	$mess	提示内容
	 * @param	string	$url	跳转地址(为空后退)
	 * @param	integer	$time	等待跳转时间(秒)
	 */
	function alert($mess, $url=null, $time=3){
		if($url===true) $url=$_SERVER['HTTP_REFERER'];
		$time *= 1000;
		str_replace('"', '\"', $url);
		$mess = htmlspecialchars($mess);
		include MD_ROOT.'Library/Default/alert';
		exit;
	}

	/**
	 * 获取随机文件名
	 * @param	string	$ext	文件后缀名, 如".png"
	 * @return	string			文件名
	 */
	function getRandName($ext=''){
		return md5(date('YmdHis').uniqid(true, true).mt_rand()) . $ext;
	}

	/**
	 * 数组回调
	 * @param	array		$data		一个数组
	 * @param	callback	$callback	回调函数
	 * @param	[type]		$args		额外参数(第三项)
	 * @param	[type]		$index		内部指针, 不要传参
	 * @return	array					处理后数组
	 */
	function arrayCallBack($data, $callback, $args=null, $index=null){
		if(is_array($data)){
			foreach($data as $key => $value){
				$data[$key] = arrayCallBack($value, $callback, $args, $key);
			}
		}else{
			$data = call_user_func($callback, $data, $index, $args);
		}
		return $data;
	}


	/**
	 * json编码(支持GBK)
	 * @param	[type]	$value	值
	 * @return	string			json
	 */
	function jsonEncode($value){
		if(PHP_VERSION < 5.4)
			return json_encode(arrayCallBack($value, function($v){
				return setEncoding($v);
			}));
		else
			return json_encode($value, JSON_UNESCAPED_UNICODE);
	}

	/**
	 * json解码(支持GBK)
	 * @param	string	$json	json
	 * @param	boolean	$assoc	返回方式(true: array, false: object)
	 * @return	array			结果
	 */
	function jsonDecode($json, $assoc=false){
		return json_decode(setEncoding($json), $assoc);
	}

	/**
	 * 将字符串设置为指定编码
	 * @param	string	$str	字符串
	 * @param	string	$out	编码类型
	 * @return	string			结果
	 */
	function setEncoding($str, $out='UTF-8'){
		if(is_numeric($str))
			return $str;
		return mb_convert_encoding($str, $out, array('UTF-8', 'ASCII', 'GBK', 'GB2312', 'Unicode', 'ISO-8859-1', 'ISO-8859-2', 'ISO-8859-3', 'ISO-8859-4', 'ISO-8859-5', 'ISO-8859-6', 'ISO-8859-7', 'ISO-8859-8', 'ISO-8859-9', 'ISO-8859-10', 'ISO-8859-13', 'ISO-8859-14', 'ISO-8859-15', 'ISO-8859-16', 'Windows-1251', 'Windows-1252', 'Windows-1254', 'JIS', 'EUC-JP', 'EUCJP-WIN', 'SJIS-WIN'));
	}

	/**
	 * Unicode编码
	 * @param	string	$value	值
	 * @return	string			结果
	 */
	function unicodeEncode($value){
		return str_replace('\"', '"', trim(jsonEncode($value), '"'));
	}

	/**
	 * Unicode解码
	 * @param	string	$value	值
	 * @return	string			结果
	 */
	function unicodeDecode($value){
		$object = jsonDecode('{"str":"' . str_replace('"', '\"', $value) . '"}');
		return $object->str;
	}

	/**
	 * 获取客户端IP地址
	 * @return	string
	 */
	function getIP(){
		$local = '127.0.0.1';
		if(!empty($_SERVER['HTTP_CLIENT_IP'])){
			return is_ip($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : $local;
		}elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
			return is_ip($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $local;
		}else{
			return is_ip($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : $local;
		}
	}

	/**
	 * Ajax信息反馈
	 * @param	array	$data	返回信息
	 */
	function ajaxReturn($data){
		if(!headers_sent())
			header('Content-type: application/json; charset=' . C('DOC_CHARSET'));
		echo jsonEncode($data);
		exit;
	}

	/**
	 * 删除字符串左边指定内容
	 * @param	string	$str	字符串
	 * @param	string	$value	欲删除内容
	 * @param	boolean	$str	绝对删除
	 * @return	string
	 */
	function trim_left($str, $value=' ', $absolute=false){
		if($absolute && ($str==$value))
			return $str;
		if(substr($str, 0, $l=strlen($value)) == $value)
			return substr($str, $l);
		else
			return $str;
	}

	/**
	 * 删除字符串右边指定内容
	 * @param	string	$str	字符串
	 * @param	string	$value	欲删除内容
	 * @param	boolean	$str	绝对删除
	 * @return	string
	 */
	function trim_right($str, $value=' ', $absolute=false){
		if($absolute && ($str==$value))
			return $str;
		if(substr($str, -($l=strlen($value))) == $value)
			return substr($str, 0, -$l);
		else
			return $str;
	}

	/**
	 * 获取根目录地址
	 * @return	string
	 */
	function getRootPath(){
		$str = str_repeat('../', count(explode('/', MD_PATH_INFO)) - 1);
		return ($str ? $str : './');
	}

	/**
	 * in_array 不区分大小写
	 * @param	string	$value	比较值
	 * @param	array	$array	查找值组
	 * @return	boolean
	 */
	function in_array_case($value, $array){
		return in_array(strtolower($value), array_map('strtolower', (array)$array));
	}

	/**
	 * curl模拟提交
	 * @param	string			$url		网址
	 * @param	array/string	$opt		提交参数
	 * @param	string			&$header	取回的头信息
	 * @param	string			$redirect	是否重定向
	 * @param	boolean			$ssl		验证https证书
	 * @return	[type]						返回信息
	 */
	function curl($url, $opt='GET', &$header=null, $redirect=true, $ssl=false){

		//初始化
		$ch = curl_init($url);

		//配置设置
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $ssl);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $ssl);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $redirect);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		#返回结果
		curl_setopt($ch, CURLOPT_HEADER, true);				#显示协议头

		if(is_array($opt)){

			//转小写
			$opt = array_change_key_case($opt, CASE_LOWER);

			//POST
			if(isset($opt['type']) && strtoupper($opt['type'])=='POST'){
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, (isset($opt['data']) ? $opt['data'] : ''));
			}

			//User-Agent
			if(array_key_exists('ua', $opt))
				curl_setopt($ch, CURLOPT_USERAGENT, $opt['ua']);

			//Header
			if(array_key_exists('header', $opt)){
				curl_setopt($ch, CURLOPT_HTTPHEADER, (array)$opt['header']);
			}

			//Cookie
			if(array_key_exists('cookie', $opt))
				curl_setopt($ch, CURLOPT_COOKIE, $opt['cookie']);

			//Referer
			if(array_key_exists('referer', $opt))
				curl_setopt($ch, CURLOPT_REFERER, $opt['referer']);

		}else{

			//仅POST
			if(strtoupper((string)$opt) == 'POST')
				curl_setopt($ch, CURLOPT_POST, true);

		}

		$result = curl_exec($ch);

		if(curl_errno($ch)){
			$result = curl_error($ch);
		}else{

			//获取头长度
			$length = curl_getinfo($ch, CURLINFO_HEADER_SIZE);

			//取出头信息
			$header = substr($result, 0, $length);

			//去掉头信息
			$result = substr($result, $length);

		}

		//释放
		curl_close($ch);

		return $result;

	}

	/**
	 * 递归创建目录
	 * @param	string	$dirName	目录
	 * @param	int		$auth		权限
	 * @return	bool
	 */
	function createDir($path, $auth=0777){
		$path = rtrim(str_replace('\\', '/', $path), '/');
		if(is_dir($path)) return true;
		$dir = explode('/', $path);
		$i = 0; $str = '';
		foreach ($dir as $value){
			$str .= $value . '/';
			is_dir($str) || (@mkdir($str, $auth, true) && ++$i);
		}
		return $i ? $i : is_dir($path);
	}

