<?php

	class Socket{

		protected $sock, $number=0;

		/**
		 * 实例化
		 */
		public function __construct(){
			$this->sock = socket_create(AF_INET, SOCK_STREAM, getprotobyname('tcp'));
			$this->sock || error('Create socket error.');
		}

		/**
		 * 连接
		 * @param	string		$address	地址
		 * @param	integer		$port		端口
		 * @return	boolean
		 */
		public function connect($address, $port=80){
			if(socket_connect($this->sock, $address, $port)){
				++$this->number;
				return true;
			}else{
				return false;
			}
		}

		/**
		 * 写入
		 * @param	[type]	$data	数据
		 * @return	[type]		失败返回false
		 */
		public function write($data){
			return socket_write($this->sock, $data, strlen($data));
		}

		/**
		 * 读取
		 * @return	[type]
		 */
		public function read(){
			return socket_read($this->sock, 4096);
		}

		/**
		 * 获取错误
		 * @return	string
		 */
		public function error(){
			return socket_strerror(socket_last_error());
		}

		/**
		 * 关闭
		 */
		public function close(){
			socket_close($this->sock);
		}

	}

