<?php

	/**
	 * 麦迪标签库类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	class Taglib{

		//标签库列表
		public static $list = array();

		//临时储存变量
		public static $temp = array();

		/**
		 * 标签解析
		 * @param	string	$code	HTML代码
		 * @return	string
		 */
		static public function parse($code){

			//系统标签
			$system = array(
				'if'		=>	array(
					'close'		=>	true,
					'param'		=>	array('value'),
					'function'	=>	function($attr, $content){
						return '<?php if(' . $attr['value'] . '): ?>' . $content . '<?php endif; ?>';
					}
				),
				'else'		=>	array(
					'close'		=>	false,
					'function'	=>	function(){
						return '<?php else: ?>';
					}
				),
				'elseif'	=>	array(
					'close'		=>	false,
					'param'		=>	array('value'),
					'function'	=>	function($attr){
						return '<?php elseif(' . $attr['value'] . '): ?>';
					}
				),
				'foreach'	=>	array(
					'close'		=>	true,
					'param'		=>	array('array', 'key', 'value'),
					'function'	=>	function($attr, $content){
						return '<?php foreach(' . $attr['array'] . ' as ' . (empty($attr['key']) ? '' : $attr['key'].' => ') . $attr['value'] . '): ?>' . $content . '<?php endforeach; ?>';
					}
				),
			);

			foreach($system as $tag => self::$temp['info']){

				//匹配模式
				$pattern = '/\<'.preg_quote($tag).(isset(self::$temp['info']['param']) ? '\s+(.*?)' : '\s*').(self::$temp['info']['close'] ? '' : '\/').'\>'.(self::$temp['info']['close'] ? '([\s\S]*?)\<\/'.preg_quote($tag).'\>' : '').'/';

				$code = preg_replace_callback($pattern, function($m){

					//包含参数
					if(isset(Taglib::$temp['info']['param'])){

						$param = preg_replace_callback('/(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_$\x7f-\xff\[\]\\\'\"\.]*)/', function($s){
							return Custom::parseVar($s[1]);
						}, Taglib::getTagAttrs($m[1]));
						$str = call_user_func(Taglib::$temp['info']['function'], $param, isset($m[2]) ? $m[2] : '');

					}else{

						$str = call_user_func(Taglib::$temp['info']['function']);

					}

					return $str;

				}, $code);

			}
			

			self::$temp = array();
			return self::parseUser($code);

		}

		/**
		 * 用户标签解析
		 * @param	string	$code	HTML代码
		 * @return	string
		 */
		static public function parseUser($code){

			foreach(self::$list as $lib){

				self::$temp['obj'] = Custom::call('\\Taglib\\'.$lib, 'class');

				foreach(self::$temp['obj']->tags as self::$temp['tag'] => self::$temp['info']){

					//匹配模式
					$pattern = '/\<'.preg_quote($lib).':'.preg_quote(self::$temp['tag']).(isset(self::$temp['info']['param']) ? '\s+(.*?)' : '\s*').(self::$temp['info']['close'] ? '' : '\/').'\>'.(self::$temp['info']['close'] ? '([\s\S]*?)\<\/'.preg_quote($lib).':'.preg_quote(self::$temp['tag']).'\>' : '').'/';

					$code = preg_replace_callback($pattern, function($m){

						//包含参数
						if(isset(Taglib::$temp['info']['param'])){

							$param = preg_replace_callback('/(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_$\x7f-\xff\[\]\\\'\"\.]*)/', function($s){
								return Custom::parseVar($s[1]);
							}, Taglib::getTagAttrs($m[1]));
							$str = Taglib::$temp['obj']->{'_'.Taglib::$temp['tag']}($param, isset($m[2]) ? $m[2] : null);

						}else{

							$str = Taglib::$temp['obj']->{'_'.Taglib::$temp['tag']}();

						}

						return $str;

					}, $code);

				}

			}

			self::$temp = array();
			return $code;

		}

		/**
		 * 获取标签属性值
		 * @param	string	$code	参数代码
		 * @return	array			参数组
		 */
		static public function getTagAttrs($code){
			$xml = '<tpl><tag '.$code.' /></tpl>';
			$xml = simplexml_load_string($xml);
			if(!$xml) error('Xml tag error.');
			$xml = (array)($xml->tag->attributes());
			$array = array_change_key_case($xml['@attributes']);
			return $array;
		}

	}

