<?php

	/**
	 * 麦迪PHP框架(MDPHP)
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.2
	 */

	/**
	 * 设置框架版本
	 */
	define('MD_VERSION', 1.2);

	/**
	 * 设置必要常量
	 */
	define('APP_PATH', APP_NAME . '/');
	define('MD_ROOT', rtrim(str_replace('\\', '/', __DIR__), '/') . '/');
	define('MD_PATH', MD_ROOT . APP_PATH);

	/**
	 * 自动加载
	 */
	import('$->Library->Practic');
	spl_autoload_register(function($className){
		//格式化
		$className = substr($className, ($n=strrpos($className, '\\'))===false ? 0 : ++$n);
		//判断类型
		if(defined('MD_CTR')){
			switch(true){
				case file_exists($file=MD_PATH_COMMON.MD_CTR.'/'.$className.'.php'):
					import($file, '');
				return;
				case file_exists($file=MD_PATH_COMMON.$className.'.php'):
					import($file, '');
				return;
			}
		}
		import('$->Library->'.$className);
	});

	/**
	 * 设定错误和异常处理
	 */
	register_shutdown_function('MDPHP\Custom::fatalError');
	set_error_handler('MDPHP\Custom::errorHandler');
	set_exception_handler('MDPHP\Custom::appException');

	/**
	 * 记录开始执行时间
	 */
	MDPHP\Custom::$workTime['start'] = microtime(true);

	/**
	 * 基本配置
	 */
	$MDPHP_CONFIG = array(

		'LAYER_V'		=>	'View',				//视图目录
		'LAYER_A'		=>	'Common',			//公共目录
		'LAYER_C'		=>	'Controller',		//控制器目录
		'LAYER_R'		=>	'Cache',			//缓存文件夹
		'LAYER_P'		=>	'Plugin',			//插件目录
		'LAYER_T'		=>	null,				//__TMPL__

		'TMPL_SUFFIX'	=>	'.html',			//模版后缀
		'DOC_CHARSET'	=>	'utf-8',			//文档编码
		'LEFT_DLMTER'	=>	'{',				//模板标识符左
		'RIGHT_DLMTER'	=>	'}',				//模板标识符右

		'CACHE'			=>	array(				//缓存
			'TYPE'		=>	'file',				//类型
			'GZIP'		=>	true,				//压缩处理
			'EXPIRE'	=>	60,					//有效期(单位: 秒)
		),

		'DB_CONFIG'		=>	array(
			'TYPE'		=>		'mysqli',		//数据库类型
			'HOST'		=>		'',				//服务器地址
			'NAME'		=>		'',				//数据库名
			'USER'		=>		'',				//用户名
			'PWD'		=>		'',				//密码
			'PORT'		=>		3306,			//端口
			'PREFIX'	=>		'md_',			//数据库表前缀
			'DEBUG'		=>		true,			//调试
			'CHARSET'	=>		'utf8',			//数据库编码模式
			'PCONNECT'	=>		false,			//持久连接
		),

		'Language'		=>	array(
			'Module_Not_Exist'			=>	'该模块不存在: %s',
			'Template_Not_Exist'		=>	'该模板不存在: %s',
			'Controller_Not_Exist'		=>	'该控制器不存在: %s',
			'Action_Not_Exist'			=>	'该动作不存在: %s',
			'Not_Load_DB'				=>	'无法与数据库服务器建立连接: %s',
			'Not_Load_DBTab'			=>	'无法打开指定的数据表: %s',
			'Not_Load_Plugin'			=>	'无法加载插件: %s',
			'Not_Compile_Template'		=>	'无法编译模板: %s<br>请检查权限或文件夹是否正常',
			'Plugin_Method_Not_Exist'	=>	'%s 插件中不存在 %s 事件',
		),

		'URL_ROUTER'		=>	false,			//路由
		'URL_ROUTE_RULES'	=>	array(),		//路由配置

		'COOKIE'			=>	array(			//Cookie配置
			'PREFIX'	=>	'md_',				//前缀
			'EXPIRE'	=>	3600,				//有效期
			'PATH'		=>	'/',				//路径
			'DOMAIN'	=>	'',					//有效域名
			'SECURE'	=>	false,				//安全传输
			'HTTPONLY'	=>	'',					//httponly设置
		),

		'SESSION'			=>	array(			//SESSION配置
			'START'		=>	true,				//自动开启
		),

		'URL'		=>	array(
			'PARAM'		=>	0,					//传参方式(0.普通; 1.PATH)
			'PSEUDO'	=>	true,				//伪静态
		),

		'COMPRESS'	=>	array(
			'HTML'	=>	false,					//HTML压缩(若出现错位等不兼容问题, 关闭即可)
			'GZIP'	=>	false,					//GZIP压缩
			'LEVEL'	=>	9,						//压缩等级(0-9, 越大越占CPU)
		),

		'DEFAULT'	=>	array(
			'MODULE'		=>	'Index',		//默认模块
			'CONTROLLER'	=>	'index',		//默认控制器
			'ACTION'		=>	'index',		//默认方法
			'TIMEZONE'		=>	'PRC',			//默认时区
		),

	);

	/**
	 * 初始配置
	 */
	C($MDPHP_CONFIG);

	/**
	 * 设置编码类型
	 */
	header('Content-Type:text/html; charset=utf-8');

	/**
	 * 导入类库
	 * @param	string	$path	路径
	 * @param	string	$ext	扩展名
	 * @return	boolean
	 */
	function import($path, $ext='.php'){
		static $_importFiles=array();
		//特殊目录
		switch($path{0}){
			case '@':		//Plugin目录
				$path = MD_PATH_PLUGIN . substr($path, 1);
			break;
			case '$':		//根目录
				$path = MD_ROOT . substr($path, 3);
			break;
		}
		//目录处理
		$path = str_replace('->', '/', $path);
		$path .= (file_exists($path.$ext) ? $ext : '/public'.$ext);
		//重复检测
		if(isset($_importFiles[$path]))
			return true;
		if(file_exists($path)){
			require $path;
			$_importFiles[$path] = true;
			return true;
		}else{
			return false;
		}
	}

	MDPHP\Custom::start();
