<?php

/*
*	Copyright liq330
*	http://www.veryide.com/
*
*	$Url: http://blog.csdn.net/liq330/archive/2008/01/10/2032804.aspx ,v1.1 19:01 2009-4-22 Leilei $
*/


class ImageReport{
   var $Image;//ͼƬ

   var $ImageName;//
   var $ImageType;//
   
   var $ImageWidth;//ͼƬ
   var $ImageHeight;//ͼƬ
   

   var $BgImage;//ͼƬ
   var $BgR;//ɫRֵ
   var $BgG;//ɫGֵ
   var $BgB;//ɫBֵ

   var $FontSize;//С
   var $FontColor;//ɫ

   var $ItemArray;//
   var $ItemInterval;//ļ
   var $XName;//x
   var $YName;//y
   var $isScale;//Ƿʾ̶ֵ
   var $margin;//߾

   //
   var $font = 'vrinda.ttf';    
   
    function ImageReport(){
    
		if(ini_get("safe_mode")){
			$self = realpath('.')."/";
		}else{
			putenv('GDFONTPATH=' . realpath('.'));
		}
		
        return ;
    }

   //ͼƬϢ
   function setImage($ImageName,$ImageType,$ImageWidth=500,$ImageHeight=400)
   {
        $this->ImageName  =$ImageName;
     $this->ImageType  =$ImageType;
     $this->ImageWidth =$ImageWidth;
     $this->ImageHeight=$ImageHeight;
   }
   
   //
   function setItem($ItemArray,$ItemInterval="20",$XName="",$YName="",$isScale=true)
   {
        $this->ItemArray    =$ItemArray;
     $this->ItemInterval =$ItemInterval;
     $this->XName        =$XName;
     $this->YName        =$YName;
     $this->isScale      =$isScale;
   }
   
   //ͼƬ
   function setBg($BgR="235",$BgG="255",$BgB="255",$BgImage="")
   {
        $this->BgR     =$BgR;
     $this->BgG     =$BgG;
     $this->BgB     =$BgG;
     $this->BgImage =$BgImage;
   }
   
   //
   function setFont($FontSize,$FontPath="")
   {
     $this->FontSize  =$FontSize;
     $this->margin    =$FontSize*2+5;
     
     if($FontPath){
		$this->font    = $FontPath;
     }
     //$this->FontColor =$FontColor;
   }

   //
   function drawReport()
   {
     //
     $this->Image=imagecreatetruecolor($this->ImageWidth,$this->ImageHeight);
     //䱳ɫ
     $background=ImageColorAllocate($this->Image,$this->BgR,$this->BgG,$this->BgB);
          
     //ɫ
     ImageFilledRectangle($this->Image,0,0,$this->ImageWidth,$this->ImageHeight,$background);

     //ͼƬ
     if(!empty($this->BgImage))
     {
        $this->drawLogo();
     }
      //,ͬͼƬ
     switch($this->ImageType)
     {
         case "1":
           $this->drawColumn();
           break;
         case "2":
           $this->drawCurve();
           break;
         case "3":
           $this->drawCircle();
           break;
         default:
             break;
     }

   }
   
   //״ͼ
   function drawColumn()
   {
     //û
     $this->drawTitle();
     //û
     $this->drawXY();

     //ȡ
     $num=count($this->ItemArray);
     //ȡеֵ
     //ֵ
     $max=$this->getArrayMax($this->ItemArray);
    

     for($i=0;$i<count($this->ItemArray);$i++)
     {
        //ɫ
        srand((double)microtime()*1000000);  
        $R=Rand(50,200);   
        $G=Rand(50,200);
        $B=Rand(50,200);
      
        $color=ImageColorAllocate($this->Image,$R,$G,$B);
        
        $yColor=ImageColorAllocate($this->Image,$R-10,$G-10,$B-10);
        //߶
        
        $height=(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i]["value"])/$max;

        //
        ImageFilledRectangle($this->Image,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$height+$this->FontSize-5-$this->margin,$this->margin+$this->ItemInterval*(2*$i+2),$this->ImageHeight-$this->margin,$color);
        //ϵӰ
        imagefilledarc($this->Image, $this->margin+$this->ItemInterval*(2*$i+3/2), $this->ImageHeight-$height+$this->FontSize-5-$this->margin,$this->ItemInterval, $this->margin/2, 0, 360, $yColor, IMG_ARC_PIE);
        
        //дֵ
        imagestring($this->Image,$this->FontSize,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$height+$this->FontSize-5-$this->margin-$this->FontSize-10,$this->ItemArray[$i]["value"],$color);
        
        //ɫ
        $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 

        //дļֵ
        imagettftext($this->Image,$this->FontSize-2,0,$this->margin+$this->ItemInterval*(2*$i+1),$this->ImageHeight-$this->margin+$this->FontSize+2,$color,$this->font,$this->ItemArray[$i]["key"]);
     }
     //ûLOGO
    // $this->drawLogo();

   }
   //ͼ
   function drawCurve()
   {
     //û
     $this->drawTitle();
     //û
     $this->drawXY(true);
     
     //ֵ
     $max=$this->getArrayMax($this->ItemArray);
     
     //ɫ
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
     //̶ȵɫ
     $bgSColor=ImageColorAllocate($this->Image,$this->BgR-10,$this->BgG-10,$this->BgB-10);
     //ɫ

     $linkColor=ImageColorAllocate($this->Image,51,51,153);
  

     //X
     ImageLine($this->Image,$this->margin,$this->margin+$this->FontSize+5,$this->ImageWidth-$this->margin,$this->margin+$this->FontSize+5,$color);
     //Y
     ImageLine($this->Image,$this->ImageWidth-$this->margin,$this->margin+$this->FontSize+5,$this->ImageWidth-$this->margin,$this->ImageHeight-$this->margin+2,$color);
     
     $tdCount=count($this->ItemArray);
     $tdWidth=($this->ImageWidth-$this->margin*2)/$tdCount;
    
     for($i=0;$i<$tdCount-1;$i++){
        //߶
        $startHeight=(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i]["value"])/$max;
        //߶
        $endHeight  =(($this->ImageHeight-$this->margin*2-$this->FontSize-5)*$this->ItemArray[$i+1]["value"])/$max;
        //X̶   
        ImageLine($this->Image,($i+1)*$tdWidth+$this->margin,$this->margin+$this->FontSize+6,($i+1)*$tdWidth+$this->margin,$this->ImageHeight-$this->margin,$bgSColor);
        //
        ImageLine($this->Image,$i*$tdWidth+$this->margin,$this->ImageHeight-$startHeight+$this->FontSize-5-$this->margin,($i+1)*$tdWidth+$this->margin,$this->ImageHeight-$endHeight+$this->FontSize-5-$this->margin,$linkColor);
     }

     //̶ȵֵ
     for($i=0;$i<$tdCount;$i++)
     {
        //ʾֵ 
        //ImageString($this->Image,5,$i*$tdWidth+$this->margin,$this->ImageHeight-$this->margin+1,$this->ItemArray[$i]["key"],$color);
        //
        imagettftext($this->Image,$this->FontSize,0,$i*$tdWidth+$this->margin,$this->ImageHeight-$this->margin+1+10,$color,$this->font,$this->ItemArray[$i]["key"]);
     }

   } 

   //ͼ
   function drawCircle()
   {
      //һĽǶ
      $degree=0;
      //ʼĽǶ
      $e=0;
      //ڱɫ
      $colorArray;
      //ڱ濪ʼǶȵ
      $startDegree;
      //ڱǶȵ
      $endDegree;
      
      //εĿ
      $width=($this->ImageWidth-$this->margin*2)-200;

         //ȡ
      $num=count($this->ItemArray);
      //û
      $this->drawTitle();
      //֮
      $total=0;
      
      //֮
      for($i=0;$i<$num;$i++)
      {
        $total+=$this->ItemArray[$i]["value"];
      }

      //ĸֵ浽
      for($i=0;$i<count($this->ItemArray);$i++)
      {
        //ɫ
        srand((double)microtime()*1000000);  

        $R=Rand(50,200);   
        $G=Rand(50,200);   
        $B=Rand(50,200);   
 
        //ɫ
        $colorArray[$i]["R"]=$R;
        $colorArray[$i]["G"]=$G;
        $colorArray[$i]["B"]=$B;
        
        //һĽǶ
        //echo $this->ItemArray[$i]["value"];
        //exit;
        $degree=$this->ItemArray[$i]["value"]/$total*360;
        $startDegree[$i]=$e;
        $endDegree[$i]=$e+$degree;
        $e+=$degree;
      }

       $j=$width/4+$this->margin+35;
       $mJ=$j-15;
       //Ӱ
       for ($j;$j >$mJ; $j--)
       {  
         for($i=0;$i<$num;$i++)
         {
          $color=ImageColorAllocate($this->Image,$colorArray[$i]["R"]-10,$colorArray[$i]["G"]-10,$colorArray[$i]["B"]-10);
          imagefilledarc($this->Image, $width/2+$this->margin, $j, $width, $width/2, $startDegree[$i], $endDegree[$i], $color, IMG_ARC_PIE);
         }
       }
       //ұߵıʶ
      for($i=0;$i<$num;$i++)
      {
        //ȡɫ
        $color=ImageColorAllocate($this->Image,$colorArray[$i]["R"],$colorArray[$i]["G"],$colorArray[$i]["B"]);
        
        //
        imagefilledarc($this->Image, $width/2+$this->margin, $width/4+$this->margin+20, $width, $width/2, $startDegree[$i], $endDegree[$i], $color, IMG_ARC_PIE);
        

        //˵ϱ߾
        $top=$this->margin+20+$i*10;
        //ұߵľ
        ImageFilledRectangle($this->Image,$width+$this->margin+20,$top+($i*10),$width+$this->margin+30,$top+($i*10)+10,$color);
        //ɫΪɫ 
        $fontColor=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB);
        
        //ұߵ˵ 
        $rightStr=$this->ItemArray[$i]["key"].": ".$this->ItemArray[$i]["value"]." (".round($this->ItemArray[$i]["value"]*100/$total,2)."%)";
        //ImageString($this->Image,10,$width+$this->margin+35,$top+($i*10)-3,$rightStr,$fontColor);
        imagettftext($this->Image, $this->FontSize,0,$width+$this->margin+35,$top+($i*10)+8,$fontColor,$this->font,$rightStr);
        
      }
      //ո
      unset($colorArray,$startDegree,$endDegree);

   }

   //ʾͼƬ
   function showImage($ImageSavePath="")
   {
      // echo $ImageSavePath;
       //exit;
       if(empty($ImageSavePath))
       {
         ImagePNG($this->Image);  
       }
       else
       {
         ImagePNG($this->Image,$ImageSavePath);       
       }
      
       ImageDestroy($this->Image); 
   } 

   //
   function drawTitle()
   {
     //ɫ
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
  
     //Ӱɫ
    # $black = imagecolorallocate($this->Image, 0, 0, 0);
     
     //Ŀ
     $fontWidth=strlen($this->ImageName)*($this->FontSize)-strlen($this->ImageName)*2;

     //ֵӰ
    # imagettftext($this->Image, $this->FontSize+3,0,$this->ImageWidth/2-$fontWidth/2+1,$this->FontSize+11,$black,$this->font,$this->ImageName);
     
     //
     imagettftext($this->Image, $this->FontSize+3,0,$this->ImageWidth/2-$fontWidth/2,$this->FontSize+10,$color,$this->font,$this->ImageName);
     
     //
    # imageline($this->Image,$this->ImageWidth/2-$fontWidth/2-20,$this->FontSize+12,$this->ImageWidth/2-$fontWidth/2+1+$fontWidth+20,$this->FontSize+12,$color);
   }
   
   //LOGO
   function drawLogo()
   {

      list($w,$h,$type) = getimagesize($this->BgImage);
      
      $source;
      switch($type)
      {
          //ͼƬGIF
         case 1:
          $source=imagecreatefromgif($this->BgImage);
          break;
          //ͼƬjPG
         case 2:
          $source = imagecreatefromjpeg($this->BgImage);
          break;
          //ͼƬPNG
         case 3:
          $source = imagecreatefrompng($this->BgImage);
      }
  
       imagecopymerge($this->Image,$source,0,0,0,0,$w,$h,20);
   } 

   //
   function drawXY($bgScale=false)
   {
        //ֵ
     $max=$this->getArrayMax($this->ItemArray);
     
     //ɫ
     $color=ImageColorAllocate($this->Image,255-$this->BgR,255-$this->BgG,255-$this->BgB); 
     //̶ȵɫ
     $bgSColor=ImageColorAllocate($this->Image,$this->BgR-10,$this->BgG-10,$this->BgB-10);

     //X
     ImageLine($this->Image,$this->margin,$this->ImageHeight-$this->margin+2,$this->ImageWidth-$this->margin,$this->ImageHeight-$this->margin+2,$color);
     //Y
     ImageLine($this->Image,$this->margin,$this->margin+$this->FontSize+5,$this->margin,$this->ImageHeight-$this->margin+2,$color);
       
          
     //Ӱɫ
     $black = imagecolorallocate($this->Image, 0, 0, 0);
     
      //YֵӰ
     imagettftext($this->Image, $this->FontSize, 90, $this->FontSize+2, intval($this->ImageHeight/2)-1, $black, $this->font, $this->YName);
     //Y
     imagettftext($this->Image, $this->FontSize, 90, $this->FontSize+2, intval($this->ImageHeight/2), $color, $this->font, $this->YName);
    
      //XֵӰ
     imagettftext($this->Image, $this->FontSize,0,intval($this->ImageWidth/2)-1,$this->ImageHeight-$this->FontSize+5,$black,$this->font,$this->XName);
     //X
     imagettftext($this->Image, $this->FontSize,0,intval($this->ImageWidth/2),$this->ImageHeight-$this->FontSize+5,$color,$this->font,$this->XName);
    
      
     //0
     imagettftext($this->Image,8,90,$this->margin/2+$this->FontSize,$this->ImageHeight-$this->margin,$color,$this->font,"0");
     //ֵ
    // imagettftext($this->Image, $this->FontSize,90,$this->margin/2+7,$this->margin+20,$black,$font,$max);
     
     //ݵʵʸ߶
     $height=$this->ImageHeight-$this->margin*2-($this->FontSize+5);
     //ÿһ̶ȵֵ
     $scale=intval($height/10);
    

     for($i=0;$i<10;$i++)
     {
       //̶,˱̶
       if($bgScale)
       {
         ImageLine($this->Image,$this->margin+1,$this->margin+$i*$scale+$this->FontSize+5+$i,$this->ImageWidth-$this->margin,$this->margin+$i*$scale+$this->FontSize+5+$i,$bgSColor);
       }
       else
       {
         ImageLine($this->Image,$this->margin-2,$this->margin+$i*$scale+$this->FontSize+5+$i,$this->margin,$this->margin+$i*$scale+$this->FontSize+5+$i,$color);
       }
       //̶ϵֵ
       if($this->isScale)
       {
        $num=round($max-$max/10*$i,1);
        imagettftext($this->Image, 7,90,$this->margin/2+$this->FontSize,$this->margin+$i*$scale+15+$this->FontSize,$color,$this->font,$num);
       }
     }
     //δ̶ֵ,ֵ
     if(!$this->isScale)
     {
        imagettftext($this->Image, 7,90,$this->margin/2+$this->FontSize,$this->margin+15+$this->FontSize,$color,$this->font,$max);
     }

   }
   
   //ȡеֵ
   function getArrayMax($Array)
   {
     $temp=0;
        for($i=0;$i<count($Array);$i++)
     {
         if($temp<$Array[$i]["value"])
         {
             $temp=$Array[$i]["value"];
         }
     }
     return $temp;
	}
}
?>