<?php

/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*
*	$Id: veryide.function.php,v2.0 14:01 2009-03-31 Leilei $
*/

//stripos
if(!function_exists('stripos')) {
	function stripos($haystack, $needle, $offset = 0) {
		return strpos(strtolower($haystack), strtolower($needle), $offset);
	}
}

function unescape($str) { 
         $str = rawurldecode($str); 
         preg_match_all("/%u.{4}|&#x.{4};|&#d+;|.+/U",$str,$r); 
         $ar = $r[0]; 
         foreach($ar as $k=>$v) { 
                  if(substr($v,0,2) == "%u") 
                           $ar[$k] = iconv("UCS-2","GBK",pack("H4",substr($v,-4))); 
                  elseif(substr($v,0,3) == "&#x") 
                           $ar[$k] = iconv("UCS-2","GBK",pack("H4",substr($v,3,-1))); 
                  elseif(substr($v,0,2) == "&#") { 
                           $ar[$k] = iconv("UCS-2","GBK",pack("n",substr($v,2,-1))); 
                  } 
         } 
         return join("",$ar); 
} 


//ϲ·
function readpath($path="") { 
	if ($path==""||!is_string($path)) return ; // ----0x0007---- · 
	
	$old = $path;
	$path = explode("/", $path); // ָ· 
	$cur_path = array(""); 
	
	for ($i=0,$j=count($path);$i<$j;$i++) {
		
		if ($path[$i]=="..") array_pop($cur_path); 
		elseif ($path[$i]=="."||$path[$i]==str_repeat(".", strlen($path[$i]))) continue; // õ·ַ .  ....  
		else array_push($cur_path, $path[$i]); 
		
	} 
	$path = implode("/", $cur_path);
	
	//HTTP·
	$path = str_replace('/http:/','http://',$path);
	$path = str_replace('/https:/','https://',$path);
	
	unset($cur_path);
	
	return $path.($old[strlen($old)-1]=="/"?"/":""); 
} 

//ǰĿ¼Եַ
function uripath(){
	if(isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == 'on'){
		$uri = 'https://';
	}else{
		$uri = 'http://';
	}
	
	$uri .= $_SERVER['SERVER_NAME'];
	
	if($_SERVER['SERVER_PORT'] != 80){
		$uri .= ':'.$_SERVER['SERVER_PORT'];
	}
	
	$uri .= dirname($_SERVER['SCRIPT_NAME']).'/';
	
	return $uri;
}


//chrַתhtml
function chrToHTML($Str){
	$Str = str_Replace(CHR(10), "<br />",$Str);
	$Str = str_Replace(CHR(32), " ",$Str);
	$Str = str_Replace(CHR(9), "",$Str);
	$Str = str_Replace(CHR(34),"&quot;",$Str);
	$Str = str_Replace(CHR(39),"&#39;",$Str);
	$Str = str_Replace(CHR(13), "",$Str);
	$Str = str_Replace(CHR(10)&CHR(10), "<p>",$Str);
	
	return $Str;
}

//ʽǩ
function FormatTag($tag,$url,$target,$space){

	$tag=str_replace(","," ",$tag);
	$tag_list=explode(" ",$tag);
	$tag_url="";
	for($i=0;$i<count($tag_list);$i++){
		$tag_url.='<a href="'.$url.urlencode($tag_list[$i]).'" target="'.$target.'">'.$tag_list[$i].'</a>';
		
		if($i<count($tag_list)){
			$tag_url.=$space;
		}
	}
	return $tag_url;
}

//ַ
Function UnFilterHtml($Str){
	$Str = str_Replace( "<br/>",CHR(10) ,$Str);
	$Str = str_Replace( "<br />", chr(10),$Str);
	$Str = str_Replace( "", CHR(13),$Str);
	$Str = str_Replace( "&#39;",CHR(39),$Str);
	$Str = str_Replace( "&quot;",CHR(34),$Str);
	$Str = str_Replace( "&nbsp;", CHR(9),$Str);
	$Str = str_Replace( "&nbsp;", CHR(32),$Str);
	$Str = str_Replace( "&lt;", "<",$Str);	
	$Str = str_Replace( "&gt;", ">",$Str);    						
	$Str = str_Replace( "&amp;","&",$Str);
	$Str = str_Replace("&acute","'",$Str);
	$Str = str_Replace("&#44",",",$Str);
	return $Str;
}
	
//ַ
Function FilterHtml($str){
    $str = str_Replace("'", "&acute;",$str);
    //'Str = Replace(Str,",","&#44")
    return $str;
}

//ʱ
function DateAdd ($interval, $number, $date) { 
	$date_time_array = getdate($date); 
	$hours = $date_time_array["hours"]; 
	$minutes = $date_time_array["minutes"]; 
	$seconds = $date_time_array["seconds"]; 
	$month = $date_time_array["mon"]; 
	$day = $date_time_array["mday"]; 
	$year = $date_time_array["year"]; 
	
	switch ($interval) { 
		case "yyyy": $year =$number; break; 
		case "q": $month =($number*3); break; 
		case "m": $month =$number; break; 
		case "y": 
		case "d": 
		case "w": $day =$number; break; 
		case "ww": $day =($number*7); break; 
		case "h": $hours =$number; break; 
		case "n": $minutes =$number; break; 
		case "s": $seconds =$number; break; 
	} 
	$timestamp = mktime($hours ,$minutes, $seconds,$month ,$day, $year); 
	return $timestamp;
} 


//ڱȽϺ 
function FormatDateDiff($d1,$d2=""){
	
	if(!is_numeric($d1)) $d1=strtotime($d1); 
	if(!is_numeric($d2)) $d2=strtotime($d2);
	
	$s=$d2-$d1;

	if( floor($s / 31104000)>0 ){
	
		$str=floor($s / 31536000)." ";
	}else{
		
		if( floor($s / 2592000)>0 ){
			$str=floor($s / 2592000)." ";
		}else{
			if( floor($s / 86400)>0 ){
				$str=floor($s / 86400)." ";
			}else{
				if( floor($s / 3600)>0 ){
					$str=floor($s / 3600)." Сʱ";
				}else{
					if( floor($s / 60)>0 ){
						$str=floor($s / 60)." ";
					}else{
						$str=$s ." ";
					}
				}
			}
		}
	}
	 
	return $str; 
}

function DateDiff($interval,$date1,$date2){
	$timedifference=$date2-$date1;
	switch($interval){
		case   "w":$retval=ceil($timedifference/604800);break;
		case   "d":$retval=ceil($timedifference/86400);break;
		case   "h":$retval=ceil($timedifference/3600);break;
		case   "n":$retval=ceil($timedifference/60);break;
		case   "s":$retval=$timedifference;break;
	}
	return $retval;
}

//ȡURL(ֻļʾ)
function FormatURL($url,$len){
	$str_len = strlen($url);
	if($str_len>$len){
		$str=substr($url,0,$len/2);
		$str.="...";
		$str.=substr($url,$str_len-$len/2,$len/2);
	}else{
		$str=$url;
	}
	return $str;
}

//ȡ
function GetQuery($key){
	$str=$_POST[$key];
	if($str==""){
		$str=$_GET[$key];
	}
	$str = str_replace("'", "",trim($str));
	$str = str_replace(Chr(34), "" ,$str);
	$str = str_replace(";", "",$str);
	return $str;
}

//ȡֵ
function GetNumber($key,$default){
	$num=$_POST[$key];
	if($num==""){
		$num=$_GET[$key];
	}
	
	$num=StrToNumber($num,$default);
	return $num;
}

//תΪֵ
function StrToNumber($str,$default){
	$num=$str;

	if(settype($num,"integer") && $str !=''){
		settype($num,"integer");
	}else{
		$num=$default;
	}
		
	return $num;
}

//Ľȡ2ֽڽȡģʽ
function cn_substr($str,$slen,$startdd=0){
	$restr = "";
	$c = "";
	$str_len = strlen($str);
	if($str_len < $startdd+1) return "";
	if($str_len < $startdd + $slen || $slen==0) $slen = $str_len - $startdd;
	$enddd = $startdd + $slen - 1;
	for($i=0;$i<$str_len;$i++)
	{
		if($startdd==0) $restr .= $c;
		else if($i > $startdd) $restr .= $c;
		
		if(ord($str[$i])>0x80){
			if($str_len>$i+1) $c = $str[$i].$str[$i+1];
			$i++;
		}
		else{	$c = $str[$i]; }

		if($i >= $enddd){
			if(strlen($restr)+strlen($c)>$slen) break;
			else{ $restr .= $c; break; }
		}
	}
	if($restr != $str) $restr.="...";
	return $restr;
}
function cn_midstr($str,$start,$len){
	return cn_substr($str,$slen,$startdd);
}

	
//ȡַ
function utf_substr($str,$len,$flag=true){
	if(!$str) return "";

	$src=$str;
	
	for($i=0;$i<$len;$i++){
		$temp_str=substr($str,0,1);
		if(ord($temp_str) > 127){
			$i++;
			if($i<$len)
			{
			$new_str[]=substr($str,0,3);
			$str=substr($str,3);
			}
		}else{
			$new_str[]=substr($str,0,1);
			$str=substr($str,1);
		}
	}
	
	$new_str=join($new_str);
	
	if( $new_str!==$src && $flag){
		$new_str.="...";
	}
	return $new_str;
}

//IP
function HideIP($ip){
	$iparray = explode('.', $ip);
	return $iparray[0].".".$iparray[1].".*."."*";
}

//ص绰
function HidePhone($ip){

	if(strlen($ip)<6) return $ip;

	$str = substr($ip,0,strlen($ip)-4);
	$str = str_pad($str, strlen($ip) , "*");
	return $str;
}


//صʼ
function HideEmail($ip){

	if(strlen($ip)<6) return $ip;

	$at = strpos($ip,"@");
	if($at){
		$str = substr($ip,0,$at-4)."***";
		$str .= substr($ip,$at);
		
		return $str;
	}else{
		return $ip;
	}
}

//ȡIP
function GetIP(){
	if(!empty($_SERVER["HTTP_CLIENT_IP"])) $cip = $_SERVER["HTTP_CLIENT_IP"];
	else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) $cip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	else if(!empty($_SERVER["REMOTE_ADDR"])) $cip = $_SERVER["REMOTE_ADDR"];
	else $cip = "޷ȡ";
	return $cip;
}

//õǰĽűַ
function GetCurUrl(){
	if(!empty($_SERVER["REQUEST_URI"])){
		$scriptName = $_SERVER["REQUEST_URI"];
		$nowurl = $scriptName;
	}else{
		$scriptName = $_SERVER["PHP_SELF"];
		if(empty($_SERVER["QUERY_STRING"])) $nowurl = $scriptName;
		else $nowurl = $scriptName."?".$_SERVER["QUERY_STRING"];
	}
	return $nowurl;
}

//õǰļ
function GetCurFile(){
	$scriptName = split("/",$_SERVER["PHP_SELF"]);		
	return $scriptName[count($scriptName)-1];
}

//ȫתΪ
function GetAlabNum($fnum){
	$nums = array("","","","","","","","","","");
	$fnums = "0123456789";
	for($i=0;$i<=9;$i++) $fnum = str_replace($nums[$i],$fnums[$i],$fnum);
	$fnum = ereg_replace("[^0-9\.]|^0{1,}","",$fnum);
	if($fnum=="") $fnum=0;
	return $fnum;
}

function Text2Html($txt){
	$txt = str_replace("  ","",$txt);
	$txt = str_replace("<","&lt;",$txt);
	$txt = str_replace(">","&gt;",$txt);
	$txt = preg_replace("/[\r\n]{1,}/isU","<br/>\r\n",$txt);
	return $txt;
}

//HTML
function ClearHtml($str){
	$str = str_replace('<','&lt;',$str);
	$str = str_replace('>','&gt;',$str);
	return $str;
}

 //ȡļдС
function GetFolderSize( $d ) {
  $dir=dir($d); $size=0;
  while (false !== $e = $dir->read()) { if ($e[0] == '.') {continue;} $c_dir=$d.'/'.$e; if(is_dir($c_dir)) $size=$size+GetFolderSize($c_dir); else $size=$size+filesize($c_dir); } $dir->close(); return $size;
}

//ػļС
function GetFileSize($size,$t){
	$str="";
	switch ($t){
		case "byte":
			$size=$size;
			break;
		case "kb":
			$size=$size*1024;
			break;
		case "mb":
			$size=$size*1024*1000;
		case "gb":
			$size=$size*1024*1024*1000;			
	}
		
	if($size/1024/1024/1024>1){
		$str=round($size/1024/1024/1024,2)." GB";
	}elseif($size/1024/1024>1){
		$str=round($size/1024/1024,2)." MB";
	}elseif($size/1024>1){
		$str=round($size/1024,2)." KB";
	}else{
		$str=$size." Byte";
	}
	return $str;
}

//õļչ
function GetFileExt($file){
	//չ
	$new_array=explode(".",$file);
	$ext=strtolower($new_array[count($new_array)-1]);
	return $ext;
}


//·صǰ
function GetDay($e_y,$e_m,$e_d){
	if (($e_m==4 || $e_m==6 || $e_m==9 || $e_m==11) && $e_d>30){
		$e_d=30;
	}
	
	$e_mod=$e_y % 4;
	if ($e_mod>0 && $e_d>28 && $e_m==2){
		$e_d=28;
	}
	return $e_d;	
}


//ȡҳ
function GetPage($page){
	$page=GetQuery($page);
	$page=StrToNumber($page,0);
	if($page<1){
		$page=1;
	}
	return $page;
}

function GetPageLink($page,$row_count,$page_size,$url,$style){	
	//ҳ
	$page_count=ceil($row_count/$page_size);
	
	$page_link="<div class='".$style."'>";

	//һҳ
	if($page<1){
		$page=1;
	}elseif ($page>$page_count){
		$page=$page_count;
	}
	
	//
	$page_group=floor(($page-1)/$page_size);

	//ʼͽ
	$start=$page_group*$page_size+1;
	if($row_count==0){
		$start=0;
	}
	$end=($page_group+1)*$page_size;
	if($end>$page_count){
		$end=$page_count;
	}
	
	//echo "group:".$page_group."----start:".$start."----end:".$end;
	
	if($page!=1 && $start>$page_size){
		$page_link.='<a href="'.$url.'1" title="1ҳ">1</a>';
		if($page_count>$start-1 && $start>1){
			$page_link.='<a href="'.$url.($start-1).'" title="һ,'.$i.'ҳ">'.($start-1).'</a>';
		}
		$page_link.='...';
	}
	
	for($i=$start;$i<=$end;$i++){
		if($i==$page){
			$page_link.='<strong>'.$i.'</strong>';
		}else{
			$page_link.='<a href="'.$url.$i.'" title="'.$i.'ҳ">'.$i.'</a>';
		}		
	}
	
	if($page!=$page_count){
		$page_link.='...';
		if($page_count>=$end+1){
			$page_link.='<a href="'.$url.($end+1).'" title="һ,'.$i.'ҳ">'.($end+1).'</a>';
		}
		$page_link.='<a href="'.$url.$page_count.'" title="ĩҳ">'.$page_count.'</a>';
	}
	$page_link.="<span>ҳ:$page/".$page_count." ".$page_size."/ҳ,".$row_count." </span></div>";
	return $page_link;
}

//CSS
function getcssname($cssdir) {
	global $veryide_charset;

	$css = sreadfile($cssdir);
	if($css) {
		preg_match("/\[name\](.+?)\[\/name\]/i", $css, $mathes);
		if(!empty($mathes[1])){
			$name = $mathes[1];
		
			require_once(dirname(__FILE__)."/veryide.verify.php");
			
			if(is_gb2312($name) && $veryide_charset=="utf-8"){
				$name = iconv("gbk" ,$veryide_charset, $name);
			}
			
			if(is_utf8($name) && $veryide_charset=="gbk"){
				$name = iconv("utf-8" ,$veryide_charset, $name);
			}
		}
		
	} else {
		$name = 'No name';
	}
	return $name;
}

//ȡļ
function sreadfile($filename) {
	$content = '';
	if(function_exists('file_get_contents')) {
		@$content = file_get_contents($filename);
	} else {
		if(@$fp = fopen($filename, 'r')) {
			@$content = fread($fp, filesize($filename));
			@fclose($fp);
		}
	}
	return $content;
}

//ļ
function createFile($Path,$FileName,$Content){
	$handle = @fopen($Path.$FileName,'w');
	@fwrite($handle, $Content);
	@fclose($handle);
}

//ļ
function createFolder($path){

	if (!file_exists($path)){
		//ѭĿ¼
		createFolder(dirname($path));    
		mkdir($path,0777);
		chmod($path,0777);
	}
	
	return $path;
}

//ɾļ
function deleteFolder($dir){
	$path=$dir;
	if(substr($dir,-1) != '/') $dir .= '/';
	if(is_dir($dir)) {
		if ($dp = opendir($dir)) {
			while (($file=readdir($dp)) !== false) {
				if (is_dir($dir.$file) && $file!='.' && $file!='..') {
					deleteFolder($dir.$file);
				}else {
				if (!is_dir($dir.$file)) {
					if(!@unlink($dir.$file)){
						return false;
					}
				}
				}
			}
			closedir($dp);
			
			if(!@rmdir($dir)){
				return false;
			}
		}
	}
	return true;
}

//ȡַָ
function GetRndStr($length){
	$hash = "";
	$chars = "ABCDEFGHIJKLMNPQRSTUVWXYZ123456789abcdefghijklmnpqrstuvwxyz";
	$max = strlen($chars) - 1;
	mt_srand((double)microtime() * 1000000);
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

?>