<?php

/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*
*	$Id: veryide.verify.php,v1.0 08:52 2008-8-22 Leilei $
*/


//email
function isEmail($str){
	return preg_match("/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/", $str);
}

//ַ
function isHttp($str){
	return preg_match("/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"])*$/", $str);
}

//qq
function isQQ($str){
	return preg_match("/^[1-9]\d{4,8}$/", $str);
}

//ʱ
function isZip($str){
	return preg_match("/^[1-9]\d{5}$/", $str);
}

//֤
function isIDCard($str){
	return preg_match("/^\d{15}(\d{2}[A-Za-z0-9])?$/", $str);
}

//Ƿ
function isChinese($str){
	return ereg("^[".chr(0xa1)."-".chr(0xff)."]+$",$str);
}

//ǷӢ
function isEnglish($str){
	return preg_match("/^[A-Za-z]+$/", $str);
}

//Ƿֻ
function isMobile($str){
	return preg_match("/^((\(\d{3}\))|(\d{3}\-))?1\d{10}$/", $str);
}

//Ƿ绰
function isPhone($str){
	return preg_match("/^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$/",$str);
}

//ǷзǷַ
function isSafe($str){
	return (preg_match("/^(([A-Z]*|[a-z]*|\d*|[-_\~!@#\$%\^&\*\.\(\)\[\]\{\}<>\?\/\\/\'\"]*)|.{0,5})$|\s/", $str) != 0);
}

//ǷΪϷû
function isName($str){
	$pos = preg_match("/[\/\\:*\"'?<>|;,%\^]+/", $str);

	if($pos){
		return false;
	}else{
		return true;
	}
}

//ǷΪϷ
function isPassword($str){
	return preg_match("/^(\w){6,20}$/", $str);
}

//ǷΪIPַ
function isIP($str){
	return preg_match("/^[0-9.]{1,20}$/", $str);
}

function is_utf8($str) {
    $c=0; $b=0;
    $bits=0;
    $len=strlen($str);
    for($i=0; $i<$len; $i++){
        $c=ord($str[$i]);
        if($c > 128){
            if(($c >= 254)) return false;
            elseif($c >= 252) $bits=6;
            elseif($c >= 248) $bits=5;
            elseif($c >= 240) $bits=4;
            elseif($c >= 224) $bits=3;
            elseif($c >= 192) $bits=2;
            else return false;
            if(($i+$bits) > $len) return false;
            while($bits > 1){
                $i++;
                $b=ord($str[$i]);
                if($b < 128 || $b > 191) return false;
                $bits--;
            }
        }
    }
    return true;
}

function is_gb2312($str){
	for($i=0; $i<strlen($str); $i++) {
			$v = ord( $str[$i] );
			if( $v > 127) {
					if( ($v >= 228) && ($v <= 233) )
					{
							if( ($i+2) >= (strlen($str) - 1)) return true;  // not enough characters
							$v1 = ord( $str[$i+1] );
							$v2 = ord( $str[$i+2] );
							if( ($v1 >= 128) && ($v1 <=191) && ($v2 >=128) && ($v2 <= 191) ) // utf
									return false;
							else
									return true;
					}
			}
	}
	return true;
}

?>