/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.effect.js v2.1 22:30 2009-6-23 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

/*
	筛选表格
	
	替换 VeryIDE.Table
	
	参数：
		table		表格对象或ID
		fun			匿名修理函数
	
	返回：
		tr			行对象
		event		event对象
*/
		
VeryIDE.Table=function(table,fun){
	
	if(typeof table == 'string') table = $(table);
	var tr = table.getElementsByTagName("tr");
	
	for(var i=0;i<tr.length;i++){
		//未找到选择框
		if( !tr[i].getElementsByTagName("input")[0] ){
			continue;	
		}
		
		tr[i].onmousedown = function(e){
			fun(this,event);
		}
		
	}
	
}

/*
	操作消息
	用于页面操作反馈
	
	替换 VeryIDE.Message
	
	参数：
		id			信息框ID
		class		附加的样式名称
		html		信息框内容
		time		显示时间,秒
*/
VeryIDE.Message=function(id,Class,html,time){
	if(!html) return false;
	if(isNaN(time)) time=1;
	
	var obj=$(id);
	if(!obj){
		obj=document.createElement("DIV");
		obj.id = id;
		obj.className = Class;
		
		document.body.appendChild(obj);
	}else{
		obj.style.display="";
	}
	obj.innerHTML=html;
	
	var doc=VeryIDE.getDocument();
	
	obj.style.left = (doc.scrollWidth-obj.offsetWidth)/2 + "px";
	obj.style.top  = doc.scrollTop + (doc.clientHeight/2) - (obj.offsetHeight/2) + "px";
	
	window.setTimeout(function(){
		obj.style.display="none";
	},1000*time);
}

/*
	小纸条/小提示
	用于页面任何位置
	替代	VeryIDE.ShowSelect
	
	参数：
		e			event,定位参照对象
		p			parent,优先作为定位参照对象
		box		菜单ID或对象
		html		box为ID时接受传入,非null将会写入内容
		
		object	关闭纸条的对象
		evt		关闭纸条的事件名称[ 'mouseout'|'click' 等等 ]
		mx		修正X位置
		my		修正Y位置
*/
		
VeryIDE.Tips=function(e,p,box,html,object,evt,mx,my){

	var div=getObject(box);
	
	mx = mx ? mx : 0;
	my = my ? my : 0;
	
	//box 为名称时自动创建
	if(typeof box=="string" && html && !div){
	
		var div=document.createElement("div");
			div.id=box;
			document.body.appendChild(div);

	}else{
		div.style.display="";
	}
	
	if(html != null) div.innerHTML=html;
	
	//判断定位参照对象
	if(p){
		var pos=new getPosition(p);
		
		var x = pos.left;
		var y = pos.top;
	}else{
	
		var doc = VeryIDE.getDocument();
		
		var e = e || window.event;
		var x = (e.clientX || e.pageX)+doc.scrollLeft;
		var y = (e.clientY || e.pageY)+doc.scrollTop;
	}
	
	if(div.style.display==""){
	
		//定位
		with(div.style){
			left=x+mx+"px",
			top=y+my+"px",
			position="absolute"
		}
		
		//绑定事件,隐藏Box
		if(object && evt){
			addObjectEvent(object,evt,
				function(e){
					
					var e = e || window.event;
					var target=e.target||e.srcElement;
					if(target!=p || object==target){
						div.style.display="none";
					}
					
				}
			);
		}
		
		if(!isNaN(object)){
				
			window.setTimeout(function(){
				div.style.display="none";
			},1000*object);

		}
		
	}
}

/*
	淡入淡出幻灯片
	原作者：王晓斌 (http://www.13100.net/?action=show&id=40)
	
	方法：
		Add(o)					添加HTML对象
		Play(n)					开始播放幻灯片 [n 默认页索引,不能为空]
		onChange(n)			回调函数,返回当前页索引
		
	属性：
		Speed					图片淡入淡出的速度(默认10)[毫秒]
		Timer						图片切换的时间(默认2000)[毫秒]
*/
VeryIDE.FadeBox=function() {
    this.Speed = 10;
    this.Timer = 2000;
    this.Alpha = 100;
    this.iCounter = 0;
    this.iCurrent = 0;
    this.iClock = null;
    this.Images = new Array();
	
	//添加
    this.Add = function(o) {
        this.Images[this.iCounter]=o;
        this.iCounter++;
    }
	
	var self=this;
	
	//播放时调用
	this.onChange= function(){
		
	}
	
	//淡入
    this.FadeIn = function() {
		var obj=this.Images[this.iCurrent];
		var style= "filter:alpha(opacity="+ parseInt(this.Alpha++) +");-moz-opacity:"+ (this.Alpha++/100) +";opacity:"+ (this.Alpha++/100) +";";
        
		obj.style.cssText=style;
		obj.setAttribute("style",style);		
		
        if (this.Alpha >= 100) {
            window.clearInterval(this.iClock);
            this.iClock = null;
            this.Play();
            this.onChange(this.iCurrent);
        }
    }
	
	//淡出
    this.FadeOut = function() {
		var obj=this.Images[this.iCurrent];
		var style= "filter:alpha(opacity="+ parseInt(this.Alpha--) +");-moz-opacity:"+ (this.Alpha--/100) +";opacity:"+ (this.Alpha--/100) +";";
        
		obj.style.cssText=style;
		obj.setAttribute("style",style);		
	
        if (this.Alpha <= -10) {
            window.clearInterval(this.iClock);
            this.iClock = null;
			
			//隐藏当前
			this.Images[this.iCurrent].style.display="none";
			
			//显示下一页
			if(this.iCurrent+1==this.Images.length){
				this.iCurrent=0;
			}else{
				this.iCurrent++;
			}
			
			//初始下一页
			var obj=this.Images[this.iCurrent];
			var style= "filter:alpha(opacity=1);-moz-opacity:0.01;opacity:0.01;display:;";
			obj.style.cssText=style;
			obj.setAttribute("style",style);		

			this.iClock = setInterval(function(){self.FadeIn();},this.Speed);
        }
    }
	
	//下一个
    this.PlayNext = function() {
        this.iClock = setInterval(function(){self.FadeOut();},this.Speed);
    }
	
	//播放
    this.Play = function(n) {
		if(typeof(n)=="number"){
			//初始化
			for(var i=0;i<this.iCounter;i++){
				this.Images[i].style.display="none";
			}
			
			this.iCurrent=n;
			
			//默认页
			this.Images[n].style.display="";
		}

		setTimeout(function(){self.PlayNext();},this.Timer);
    }
}


/*
	选项卡/滑动门
	
	方法：
		Add(o,t)					添加卡片 [o 选项对象] [t 卡片对象]
		TabClass(a,d)			选项样式 [a 响应时样式] [d 未响应样式]
		BoxClass(a,d)			容器样式 [a 响应时样式] [d 未响应样式]
		Play(t)					播放第几张卡片 [t 卡片索引,从0开始]
		Auto(s)					自动播放选项卡 [s 毫秒后自动播放下一张卡片]
		onChange(n)			回调函数,返回当前页索引
		
	参数：
		e							侦听事件 [click | mouseover]
*/
VeryIDE.TabOption=function(e){
	this.Event = e;
	this.Cur=-1;
	this.Inter=null;
	this.Speed=0;
	
	this.Array = new Array();
	this.TClass = ["",""];
	this.BClass = ["",""];
	
	//选项卡样式
	this.TabClass=function(a,d){
		 this.TClass=[a,d];
	}

	//内容卡样式
	this.BoxClass=function(a,d){
		 this.BClass=[a,d];
	}

	//添加新选项卡
	this.Add=function(o,t){
		if(o && t){
			this.Array[this.Array.length]=[o,t];
		}
	}
	
	//选项卡改动时调用
	this.onChange= function(){
		
	}

	//选项卡改动
	this.Change=function(tab){
		for(var n=0; n< this.Array.length ;n++){
			this.Array[n][0].className=this.TClass[1];
			
			//附加Class
			if(this.BClass[0] || this.BClass[1]){
				this.Array[n][1].className=this.BClass[1];
			}else{
				this.Array[n][1].style.display="none";
			}
		}
		
		var obj=this.Array[tab][0];
		obj.className=this.TClass[0];
		
		var box=this.Array[tab][1];
		
		//附加Class
		if(this.BClass[0] || this.BClass[1]){
			box.className=this.BClass[0];
		}else{
			box.style.display="";
		}
		
		//暂停播放
		if(this.Inter){
			var self=this;
			box.onmouseover=function(){
				clearInterval(self.Inter);
			}
			box.onmouseout=function(){
				self.Auto(self.Speed);
			}
		}
		
		this.Cur=tab;
		this.onChange(tab);
	}

	//播放选项卡
	this.Play=function(t){
		for(var n=0; n< this.Array.length ;n++){
		
			var obj=this.Array[n][0];
			var self=this;
			(function(){    
				var tab=n;
				obj["on"+self.Event]=function(){
					self.Change(tab);
					clearInterval(self.Inter);
				}
				obj["onmouseout"]=function(){
					self.Auto(self.Speed);
				}
			})();

		}
		
		if(t<=this.Array.length-1){
			this.Change(t);
		}else{
			this.Change(0);
		}
	}
	
	//自动播放
	this.Auto=function(s){
		if(s){
			this.Speed=s;
			var self=this;
			
			this.Inter=window.setInterval(function(){
				if((self.Cur+1)<=self.Array.length-1){
					self.Cur++;
					self.Change(self.Cur);
				}else{
					self.Change(0);
				}
			},s);
		}
	}
}

/*
	显示窗口/iframe
		
	参数：
		id					容器ID
		title				标题名称
		url					页面URL地址
		width				页面宽,可用%
		height				页面高,可用%
		options				选项,JSON数据
*/
VeryIDE.Window=function(id,title,url,width,height,options){
	
	if(typeof options!="object") var options={};
	
	var doc=VeryIDE.getDocument();
	
	var tid=id+"-title";
	var obj=$(id);
	
	if(options.lock){
		var bid=id+"-bg";
		var css="position:absolute;background:#666;filter:alpha(opacity=20);-moz-opacity:0.2;opacity:0;z-index:"+VeryIDE.layer+"; top:0;left:0;";
		var bg=$(bid);
	}
	
	if(!obj){
		
		if(options.lock){
			//bg
			bg=document.createElement("DIV");
			bg.id=bid;
			bg.setAttribute("style",css);
			bg.style.cssText=css;
			document.body.appendChild(bg);
			
			bg.style.height=doc.scrollHeight+"px";
			bg.style.width="100%";
		}

		//box
		obj=document.createElement("DIV");
		obj.id=id;
		document.body.appendChild(obj);
	}else{
		obj.style.display="";
	}
	
	var str='<div id="'+tid+'" class="title"><span class="text">'+title+'</span><span class="close" onclick="delElement(\''+id+'\');delElement(\''+bid+'\');" alt="关  闭">关闭</span></div>'
		
	if(width.toString().indexOf("%")>-1) width=doc.scrollWidth*(parseInt(width)/100);
	if(height.toString().indexOf("%")>-1) height=doc.scrollHeight*(parseInt(height)/100);
	
	if(width>doc.scrollWidth){
		width=doc.scrollWidth-100;
		height+=30;
	}
	
	if(height>doc.scrollHeight){
		height=doc.scrollHeight-100;
		width+=30;
	}
	
	str+='<div class="box"><iframe id="'+id+'-iframe" name="'+id+'-iframe" width="'+width+'" height="'+height+'" frameborder="0" src="' + url + '" /></div>';
		
	obj.innerHTML= str;
	
	var top=doc.scrollTop+(doc.clientHeight/2)-(obj.offsetHeight/2);
	if(top<0){
		top=20;
		
	}
	
	var left=(doc.clientWidth-obj.offsetWidth)/2;
	if(left<0){
		left=20;
	}
	
	obj.style.left=left+"px";
	obj.style.top=top+"px";
	obj.style.zIndex=VeryIDE.layer;
	
	//绑定ESC到关闭
	addKeyEvent(27,function(){
		delElement(id);
		delElement(bid);
	});
			
	addObjectEvent(document,"keyup",function(event){
		addKeyEvent.Listener(event);
	});	
	
	
	//未加载 Drag 组件
	if(!VeryIDE.script["drag"]) return false;


	//拖动支持
	var drag=$(tid);
	Drag.init(drag, obj);
	drag.onmouseover=function(){
		this.style.cursor="move";
	}
	drag.onmouseout=function(){
		this.style.cursor="default";
	}
	drag.root.onDragStart = function() {
		VeryIDE.layer++;
		obj.style.zIndex=VeryIDE.layer;
	}
}

/*
	显示错误/alert
		
	参数：
		id					容器ID
		title				标题名称
		html				HTML代码
		options				选项,JSON数据
*/
VeryIDE.Alert=function(id,title,html,options){
	
	if(typeof options!="object") var options={button:true};
	
	var tid=id+"-title";
	var bid=id+"-bg";
	
	var css="position:absolute;background:#666;filter:alpha(opacity=20);-moz-opacity:0.2;z-index:"+VeryIDE.layer+"; top:0;left:0;";
	
	var obj=$(id);
	var bg=$(bid);
	
	if(!obj){
		
		//bg
		bg=document.createElement("DIV");
		bg.id=bid;
		bg.setAttribute("style",css);
		bg.style.cssText=css;
		bg.innerHTML='<iframe style="position:absolute; z-index:-1;width:100%;height:100%; filter:alpha(opacity=0);-moz-opacity:0;opacity:0;" frameborder="0" src="about:blank"></iframe>';
		document.body.appendChild(bg);

		//box
		obj=document.createElement("DIV");
		obj.id=id;
		document.body.appendChild(obj);

	}else{
		obj.style.display="";
	}
  
	var doc=VeryIDE.getDocument();
	bg.style.height=doc.scrollHeight+"px";
	bg.style.width="100%";
  
	//这里使用双引号(在 VeryIDE.Alert(\''+id+'\') 处)会导致语法错误
	var html='<div id="'+tid+'" class="title">'+title+'</div><div class="box">' + html + '</div>';
  
	if(options.button){
		html+='<div class="bar"><input type="button" id="'+id+'-button" onclick="delElement(\''+bid+'\');delElement(\''+id+'\');" value="关  闭" /></div>';
	}

	obj.innerHTML= html;
	
	obj.style.left	=	(doc.scrollWidth-obj.offsetWidth)/2+"px";
	obj.style.top	=	doc.scrollTop+(doc.clientHeight/2)-(obj.offsetHeight/2)+"px";
	obj.style.zIndex=	VeryIDE.layer+1;

	//focus
	if(options.button){
		$(id+'-button').focus();
	}
	
	//未加载 Drag 组件
	if(!VeryIDE.script["drag"]) return false;

	var drag=$(tid);
	Drag.init(drag, obj);
	drag.onmouseover=function(){
		this.style.cursor="move";
	}
	
	drag.onmouseout=function(){
		this.style.cursor="default";
	}
	
	drag.root.onDragStart = function(x, y) {
		VeryIDE.layer++;
		obj.style.zIndex=VeryIDE.layer;
		obj.style.filter="alpha(opacity=60)";
		obj.style.opacity=0.6;
	}
	
	drag.root.onDragEnd = function(x, y) {
		obj.style.filter="alpha(opacity=100)";
		obj.style.opacity=1;
	}
}

/*state*/
VeryIDE.script["effect"]=true;