/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.form.js,v3 20:44 2009-6-22 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

/* 
  表单遍历检查（那些具有自定义属性的元素）
  示例:
  onsubmit="return VeryIDE_VerifyForm(this,function(i){alert(i);});"
  onsubmit="return VeryIDE.VerifyForm(this,null);"
  
  form		表单对象
  fun		回调函数,返回错误信息(string)
*/

VeryIDE.VerifyForm=function(form,fun){
	var i;
	var len = form.elements.length;
	for (i=0; i<len; i++){
	
		var inpElm   = form.elements[i];
		var name  = inpElm.getAttribute("chk_name");
		var val = inpElm.value;
	
	 	/* 非自定义属性的元素不予理睬 */
		if (!name) continue;
		
		/* 校验当前元素 */
		if (VeryIDE.VerifyInput(inpElm,fun)==false){
			return false;
		}
	}
	
	return true;
}

/*
  检查表单元素
  此函数配合 VeryIDE.VerifyForm 而使用
  **************

  表单元素自定义属性,可以用在input,select,textarea等元素上:

  chk_name			元素别名  		    *不为空时才校验其值*
  
  **********************************************************
  			以下属性值可为"yes"或"no", "no" 不强制(值可为空,不为空时检查), "yes" 为强制检查
  
  chk_null	    	为空检查
  chk_minsize	  	字符最小长度
  chk_maxsize	  	字符最大长度
  chk_number	  	数字类址属性
  chk_password  	密码类型属性,会自动chk_safe属性                	
  chk_safe		 	安全字符检查
  chk_ip		    IP地址型属性
  chk_email		  	邮箱地属性
  chk_card		  	身份证号属性
  chk_tel		    电话号码属性
  chk_mobile	  	手机号码属性
  chk_date	 	  	时间日期属性
  chk_regex	 	  	正则表达式
*/

VeryIDE.VerifyInput=function(input,fun){
	var err="";
	var name	= input.getAttribute("chk_name");
	var val		= input.value;
	var type	= input.type;
	var id		= input.id;
	
	//单行多行检查
	if(type=="text" || type=="textarea" || type=="password" || type=="hidden"){
	
		/* 密码校验 */
		if(type=="password"){
		
			var chkpwd=input.getAttribute("chk_password");
			if ($(chkpwd) && $(chkpwd).value != val ){
				err = name+" 输入有误！";
			}
			
			input.setAttribute("chk_safe","yes");
			input.setAttribute("chk_null","yes");
		}
		
		/* 相同性校验 */
		var chkvalue=input.getAttribute("chk_value");
		if (chkvalue && $(chkvalue).value!=val){
			err = name+" 输入有误！";
		}
		
		/* 非空校验 */
		var chknull=input.getAttribute("chk_null");
		if (chknull=="yes" && isEmpty(val)){
			err = name+" 不能为空";
		}
	
		/* 长度校验 */
		var minsize=input.getAttribute("chk_minsize");
		if (val.long() < parseInt(minsize)){
			err = name+" 未到最小长度"+minsize;
		}
		
		var maxsize=input.getAttribute("chk_maxsize");
		if (val.long() > parseInt(maxsize)){
			err = name+" 超出最大长度"+maxsize;
		}
		
		/*字符安全性检测*/
		var chksafe=input.getAttribute("chk_safe");
		if ( (chksafe=="yes" && !isSafe(val)) || (chksafe=="no" && !isEmpty(val) && !isSafe(val)) ){
			err = name+" 存在非法字符！";
		}
		
		/*E-mail地址合法性检测*/
		var chkemail=input.getAttribute("chk_email");
		if ( (chkemail=="yes" && !isEmail(val)) || (chkemail=="no" && !isEmpty(val) && !isEmail(val)) ){
			err = name+" 输入有错！";
		}	
		
		/* IP地址合法性检测 */
		var chkip=input.getAttribute("chk_ip");
		if ( (chkip=="yes" && !isIP(val)) || (chkip=="no" && !isEmpty(val) && !isIP(val)) ){
			err = name+" 输入有错！";
		}

		/* 数据类型校验 */
		var chknum=input.getAttribute("chk_number");
		if ( (chknum=="yes" && isNaN(val)) || (chknum=="no" && !isEmpty(val) && isNaN(val)) ){
			err = name+" 值应该全为数字";
		}

		/* 身份证号校验 */
		var chkIDCard=input.getAttribute("chk_card");
		if ( (chkIDCard=="yes" && !isIDCard(val)) || (chkIDCard=="no" && !isEmpty(val) && !isIDCard(val)) ){
			err = name +" 输入错误";
		}
		
		/* 电话号码校验 */
		var chkTel=input.getAttribute("chk_tel");
		if ( (chkTel=="yes" && !isTel(val)) || (chkTel=="no" && !isEmpty(val) && !isTel(val)) ){
			err = name +" 输入错误";
		}	

		/* 手机号码校验 */
		var chkMobile=input.getAttribute("chk_mobile");
		if ( (chkMobile=="yes" && !isMobil(val)) || (chkMobile=="no" && !isEmpty(val) && !isMobil(val)) ){
			err = name +" 输入错误";
		}

		/* 时间日期校验 */
		var chkDate=input.getAttribute("chk_date");
		if ( (chkDate=="yes" && !isDate(val.Trim())) || (chkDate=="no" && !isEmpty(val) && !isDate(val.Trim())) ){
			err = name +" 输入错误";
		}

		/* 正则表达式校验 */
		var chkRegex=input.getAttribute("chk_regex");
		if ( chkRegex && val ){
			var re = new RegExp(chkRegex);
			if( !re.test(val) ){
				err = name +" 格式不匹配";
			}	
		}
		
	}else{		
		/* 其它类型检查 */
		switch(type){
			case "select-one":
				var obj=getSelect(id);
				if(!obj.value){
					err = "请选择 "+ name ;
				}
			break;
			
			case "radio":
				var obj=getRadio(input.name);
				if(!obj.value){
					err = "请选择 "+ name ;
				}
			break;
		}	
	}
	
	if(err){
		
		if (type !="hidden" ){
			input.focus();
		}

		if(typeof fun=="function"){
      		fun(err);
		}else{
      		alert(err);
		}
	
		return false;
	}

	return true;	
}

/*state*/
VeryIDE.script["form"]=true;