/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.interface.js,v2.5 22:19 2009-6-21 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

/*
	评分系统 
	原作者：王晓斌 (http://www.13100.net/?action=show&id=2)

	函数：
		CreateVote(Max,Def)               创建平分星星数量 Max为总共多少星星，Def为默认分数
		AddContent(sNA)                   添加平分内容sNA
		GradeVoteImage1                   星星图片一
		GradeVoteImage2                   星星图片二
*/
VeryIDE.GradeVote=function(nID) {
	this.PrefixID=nID;
	this.VoteMaxStar=1;
	this.VoteCounter=1;
	this.VoteContent=new Array();
	this.GradeVoteImage1="";
	this.GradeVoteImage2="";

	this.AddContent=function (sNA) {
	  this.VoteContent["_"+this.VoteCounter]=sNA;
	  this.VoteCounter++;
	}

	/*保存评分*/
	this.SaveVote=function(obj){
	  this.SaveInput=obj;
	}

	/*创建评分星星*/
	this.CreateVote=function (MaxStar,DefaultStar) {

	  /*创建容器*/
	  document.write('<div id="'+this.PrefixID+'GradeVoteArea">&nbsp;</div><div id="'+this.PrefixID+'GradeVoteScore">请您评分</div>');
	  
	  /*银河系*/
	  var box=document.getElementById(this.PrefixID+"GradeVoteArea");
		  box.innerHTML='';

	  var i=1,j=1;
	  var VoteImgHTML="";
	  this.VoteMaxStar=MaxStar;
	  for (i=1;i<=MaxStar;i++) {
			  
		  var img=document.createElement("img");
			  img.id=this.PrefixID+"_GradeVoteID"+i;
			  img.setAttribute("rel",i);
			  img.style.border="0";
			  img.src=(j<=DefaultStar ? this.GradeVoteImage1 : this.GradeVoteImage2);
			  
			  var self=this;
			  img.onclick=function(){
				self.VoteSubmit(this.getAttribute("rel"));
			  }
			  
			  img.onmouseover=function(){
				self.HitVote(this.getAttribute("rel"));
				this.alt=self.VoteScoreContent(this.getAttribute("rel"));
			  }
			  
			  img.onmouseout=function(){
				var vote=self.SaveInput.value;
				if(vote){
				  self.HitVote(vote);
				}
			  }
		  
		   box.appendChild(img);
		 
		  j++;
	  }
	  
	}

	/*评分等级内容*/
	this.VoteScoreContent=function (sID) {
	  var VoteContent=this.VoteContent["_"+sID];
	  if (VoteContent=="undefined" || VoteContent==null) VoteContent="Not defined!!";
	  return VoteContent;
	}

	/*鼠标放到星星上*/
	this.HitVote=function (sID) {
	  var i=1;
	  for (i=1;i<=sID;i++) {
			  document.getElementById(this.PrefixID+"_GradeVoteID"+i).src=this.GradeVoteImage1;
	  }
	  document.getElementById(this.PrefixID+"GradeVoteScore").innerHTML=this.VoteScoreContent(sID);
	  sID++;
	  for (i=sID;i<=this.VoteMaxStar;i++) {
			  document.getElementById(this.PrefixID+"_GradeVoteID"+i).src=this.GradeVoteImage2;
	  }
	}

	/*提交评分*/
	this.VoteSubmit=function (sID) {
	  this.SaveInput.value=sID;
	}
}

//根据option的pid属性,过虑Select
function filterSelect(obj,pid,name){
	var old=$(obj+"_old");	
	if(!old){
		old=$(obj).cloneNode(true);
		old.id=obj+"_old";
		old.style.display="none";
		document.body.appendChild(old);
	}
	
	var New=$(obj);
	if(name){
		New.length=1;
	}else{
		New.length=0;	
	}
	
	var len = old.length;
	for(var i=0;i<len;i++){
		if(pid==old[i].getAttribute("pid")){
			New[New.length]=new Option(old[i].text,old[i].value);
		}	
	}
	New.style.display="";
}


/*
函数名称:	VerySelect_Float
函数作用:	创建浮动菜单选项(链接)
参数说明:	id			新菜单的ID
			Class		菜单引用的CSS类
			PClass		菜单父级的父级CSS类,用于装饰
			url			基础URL地址(不变的部分)
			value		参数(变动的部分)
			disabled	需要禁用项的值
*/
VeryIDE.FloatSelect=function(id,Class,PClass,url,value,disabled){
	document.write('<div id="'+id+'_div" onMouseOver="VeryIDE.FloatSelect.Action('+"'"+id+"'"+','+"'block'"+');" onMouseOut="VeryIDE.FloatSelect.Action('+"'"+id+"'"+','+"'none'"+');"></div>');
	
	var v_obj=$(id+'_div'),s_value , li;
	v_obj.parentNode.className+=" "+PClass;
	
	var VoP=new getPosition(v_obj);
	var _obj=document.createElement("ul");
	_obj.id=id;
	_obj.className=Class;
	var _value=value.split("|");
	for(var i=0;i<_value.length;i++){
		s_value=_value[i].split(":");
		li=document.createElement("li");
		if(s_value[1]!=disabled){
			li.innerHTML="<a href='"+url+s_value[1]+'&amp;jump='+encodeURIComponent(location.href)+"' title='"+s_value[0]+"'>"+s_value[0]+"</a>";
		}else{
			li.innerHTML=s_value[0];
			v_obj.innerHTML=s_value[0];
		}
		_obj.appendChild(li);
	}
	v_obj.appendChild(_obj);
	_obj.style.top=VoP.top;
	_obj.style.left=VoP.left;
	_obj.style.display="none";
}

VeryIDE.FloatSelect.Action=function(id,dis){
	var _obj=$(id);
	if(dis=="none"){
		_obj.style.display="none";
	}else{
		var v_obj=$(id+'_div')
		var VoP=new getPosition(v_obj);
		_obj.style.top=VoP.top;
		_obj.style.left=VoP.left;
		_obj.style.display="block";
	}
}

/*
	拖拉对象尺寸
	handle		按钮对象
	control		控制对象
	option		选项
*/
VeryIDE.Reszie=function(handle,control,option){
	
	if(typeof option!="object") var option={x:true,y:true};
	
	this._handle=handle;
	this._control=control;
	
	var self=this;
	
	this.callback=function(w,h){
		window.status='width:'+w+'px height:'+h+'px ';
	}
	this.onrelse=function(){
		
	}
	
	this.start=function(){
		this.drag();
	},
	
	this.drag=function(){
		var pos = getPosition(this._control);
		var left = pos.left-16;
		var top = pos.top+pos.height-16;
		var width = pos.width;
		
		var css="position:absolute;cursor:nw-resize;left:"+(left+width)+"px;top:"+top+"px";
		
		this._handle.style.cssText=css;
		this._handle.setAttribute("style",css);
		this._handle.unselectable="on";
		
		this._handle.onmousedown = function(){ self.event();}
	},

	this.event=function(){
		
		document.onmousemove = function(e){

			if(self._control){
				var x = 0;
				var y = 0;
				
				try{
					var doc = document.documentElement;
				}catch (e){
					var doc = document.body;
				}
				
				var e = e || window.event;
				var x  = (e.clientX || e.pageX) + doc.scrollLeft;
				var y  = (e.clientY || e.pageY) + doc.scrollTop;
		
				var pos=getPosition(self._control);
				var w = x-pos.left;
				var h = y-pos.top;
				
				if(w<80 || h<80) return false;
				
				self._control.style.width  = w+"px";   
				self._control.style.height = h+"px";   
				
				self.drag();
				self.callback(w,h);
			}   
		}   

		document.onmouseup = function(e){   
			//self._control=null;
			document.onmousemove=null;			
		}   
	}
	
}

/*
	滚动表头
	thead	表头对象
*/
VeryIDE.Thead=function(thead){
	var thead=getObject(thead);
		
	var pos=getPosition(thead);
	var doc=VeryIDE.getDocument();
	
	var top=0;
	if(pos.attr["top"]){
		top=pos.attr["top"].value;
	}else{
		top=pos.top;
		thead.setAttribute("top",pos.top);
	}
	
	if(doc.scrollTop>=top){
		thead.style.top			=	(doc.scrollTop)+'px';
		thead.style.position		=	'absolute';
	}else{
		thead.style.top			=	'0px';
		thead.style.position		=	'relative';
	}
}

VeryIDE.setCommand=function(cmd,fun){

	switch(cmd){
		case "addFavorite":
			if(!window.netscape){
				window.external.addFavorite(location.href,document.title);
				VeryIDE.showMessage("谢谢您收藏此页面！<br />收藏后可以从收藏夹中点击访问。",fun);
			}else{
				window.sidebar.addPanel(document.title,location.href,"");
				VeryIDE.showMessage("谢谢您将此页面加入书签！<br />加入后可以从书签中点击访问。",fun);
			}
		break;
		case "setHomepage":
			if(!window.netscape){
				//new link
				obj=document.createElement("a");
				obj.setAttribute("href","javascript:void(0);");
				document.body.appendChild(obj);

				obj.style.behavior='url(#default#homepage)';
				obj.sethomepage(location.href);
			}else{
				try{
					netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
				}catch(e){  
				  VeryIDE.showMessage("此操作被浏览器拒绝！<br />请在浏览器地址栏输入“about:config”并回车<br />然后将[signed.applets.codebase_principal_support]设置为'true'",fun);  
				}
				var prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
				prefs.setCharPref('browser.startup.homepage',location.href);
			}
			VeryIDE.showMessage("谢谢您将此页面设为主页！<br />下次便会自动访问此页。",fun);
			if(VeryIDE.isMaxthon){
				VeryIDE.showMessage("傲游浏览器用户请在地址栏输入“max:config?page=startup”并回车<br />然后在“启动”中设置“主页”地址",fun);
			}
		break;
		}
	
	return void(0);
}

VeryIDE.copyText=function(meintext,fun){
	if (window.clipboardData){
		window.clipboardData.setData("Text", meintext);
	}
	else if (window.netscape){ 
		try{  
			netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");  
		}catch (e){ 
			throw new SecurityException(SecurityException.ERROR,"");
		}
		
		var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
		if (!clip) return;

		var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
		if (!trans) return;
		
		trans.addDataFlavor('text/unicode');
		
		var str = new Object();
		var len = new Object();
		
		var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
		
		var copytext=meintext;
		
		str.data=copytext;
		
		trans.setTransferData("text/unicode",str,copytext.length*2);
		
		var clipid=Components.interfaces.nsIClipboard;
		if (!clip) return false;
		
		clip.setData(trans,null,clipid.kGlobalClipboard);
		
	}
	VeryIDE.showMessage("已经复制如下信息到剪贴板:<br />" + meintext,fun);
	return false;
}

/*state*/
VeryIDE.script["interface"]=true;