/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.library.js,v2 22:12 2009-4-13 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

function $(obj){return document.getElementById(obj);}
function $N(obj){return document.getElementsByName(obj);}
function $T(obj){return document.getElementsByTagName(obj);}
function $V(str){document.write(str);}

//class为*的所有元素
document.getElementsByClassName = function() {
  var children = document.getElementsByTagName('*') || document.all;
  var elements = new Array();
  var len = children.length;

  for (var i = 0; i < len; i++) {
    var child = children[i];
    var classNames = child.className.split(' ');
    for (var j = 0; j < classNames.length; j++) {
    	for (var k = 0; k < arguments.length; k++) {	
			if (classNames[j] == arguments[k]) {
        		elements.push(child);
       			break;
      		}
      }
    }
  }
  
  return elements;
}

//ID以*开头的所有元素
document.getElementsByPrefix = function(prefix) {
	var children = document.getElementsByTagName('*') || document.all;
	var elements = new Array();
	var len = children.length;

	for (var i = 0; i < len; i++) {
	var child = children[i];
	var eid = child.id;
	if(eid&&eid.indexOf(prefix)>-1)
		elements.push(child);
	}

	return elements;
}

//body load
function addLoadEvent(func) {
	var oldonload = window.onload;
	if (typeof window.onload != 'function') {
		window.onload = func;
	}else {
		window.onload = function() {
			oldonload();
			func();
		}
	}
}

//object event
function addObjectEvent(ele,evt,func){
	var oldonevent = ele['on'+evt];
	if (typeof ele['on'+evt] != 'function') {
		ele['on'+evt] = func;
	} else {
		ele['on'+evt] = function(event) {
			oldonevent(event);
			func(event);
		}
	}
}

//key event
function addKeyEvent(key,func){
	if(!VeryIDE.tmpKey){
		VeryIDE.tmpKey=[];
	}
	
	VeryIDE.tmpKey["k"+key]=func;
}

//注册按键事件
addKeyEvent.Listener=function(e,test){
	var event=e||window.event;
	if(VeryIDE.tmpKey["k"+event.keyCode]){
		VeryIDE.tmpKey["k"+event.keyCode](event);
	}
	if(test){
		alert(event.keyCode);
	}
}

/*
	获取对象
	o	对象ID
	s	[可选]子对象标签名
*/
function getObject(o,s){
	if(typeof(o)!="object"){
		var o=$(o);
	}
	
	if(s){
		var a=new Array();
		var c=o.childNodes;
		for(var i=0;i<c.length;i++){
			var n=c[i];
			if(!!n.tagName && n.tagName.toLowerCase()==s){
				a.push(n);
			}
		}
		return a
	}
	
	return o;
}

String.prototype.Trim = function(){
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
String.prototype.LTrim = function(){
    return this.replace(/(^\s*)/g, "");
}
String.prototype.Rtrim = function(){
    return this.replace(/(\s*$)/g, "");
}
String.prototype.isInChinese = function() { 
  return (this.length != this.replace(/[^\x00-\xff]/g,"**").length); 
} 

//返回字符串字节数
String.prototype.long = function(){
	var i;
	var l = this.length;
	var len;
	len = 0;
	for (i=0;i<l;i++){
		if (this.charCodeAt(i)>255) 
			len+=2; 
		else 
			len++;
	}
	return len;
}

Array.prototype.push = function(value) {
	this[this.length] = value;
	return this.length;
}

//检查在数组内是否存在某值
function inArray(a,v) {
	var l = a.length;
	for(var i=0; i<=l; i++) {
		if(a[i]==v) return true;
	}
	return false;
}

/*查找页面Meta*/     
function getMeta(name,att){
	metatags = document.getElementsByTagName("meta"); 
	for (cnt = 0; cnt < metatags.length; cnt++){                   
		if(metatags[cnt].getAttribute("name")==name){
			if(!att){
				return metatags[cnt];
			}else{
				return metatags[cnt].getAttribute(att);
			}
		}else{
			return null;
		}
	}
}

//加载新脚本
function loadScript(src,target){
	if(!target){ 
		var root=$T("HEAD")[0];
	}else{
		var root=getObject(target);
	}
	
	var script=document.createElement("script");
	script.type="text/javascript";
	script.src=src;
	
	var code=arguments[2];
	if(code){
		script.charset=code;
	}
	
	root.appendChild(script);
}

//取得文件名
function getSelf(url){
	if(!url){
		var url=location.href;
	}
	var arr=url.split("/"); 
	var cur=arr[arr.length-1]; 
	return cur; 
}

//对象绝对属性
function getPosition(obj){	
	var obj=getObject(obj);

	var width=obj.offsetWidth; 
	var height=obj.offsetHeight;  
	var attr=obj.attributes;
	
	var top=obj.offsetTop;  
	var left=obj.offsetLeft;  
	while(obj=obj.offsetParent){  
		top+=obj.offsetTop;  
		left+=obj.offsetLeft;
	}

	return {width:width, height:height, top:top, left:left, attr:attr};
}

//获取Select对象值
function getSelect(obj){
	var obj=getObject(obj);
	
	var value="";
	var text="";
	var index="";
	var attr="";
	
	if(obj.length>0){
		value=obj[obj.selectedIndex].value;
		text=obj[obj.selectedIndex].text;
		index=obj.selectedIndex;
		attr=obj[obj.selectedIndex].attributes;
	}
	
	return {value:value, index:index, text:text, length:obj.length, attr:attr};
}

//获取Radio对象值
function getRadio(obj){
	var obj=$N(obj);
	var len = obj.length;
	
	var value="";
	var index=null;
	
	for(var i=0;i<len;i++){
		if(obj[i].checked==true){
			index=i;
			value=obj[i].value;
			break;
		}
	}
	
	return {value:value, index:index, length:len};
}


/*
	设置Select状态
	obj		目标对象
	v			值
*/
function setSelect(obj,v){
	var obj=$(obj);
	var len = obj.length;
	for(var i=0;i<len;i++){
		if(obj[i].value == v){
			obj.selectedIndex=i;
			break;
		}
	}
}

/*
	设置Radio状态
	obj		目标对象
	v			值
*/
function setRadio(o,v){		
	var obj=$N(o);
	var len = obj.length;
	for(var i=0;i<len;i++){
		if(obj[i].value == v){
			obj[i].checked=true;
			break;
		}
	}
}

/*
	设置CheckBox状态
	obj		目标对象
	v			值
*/
function setCheckBox(obj,v){
	var obj=$N(obj);

	if(obj[0]){
		var len = obj.length;
		for(var i=0;i<len;i++){
			if(obj[i].value==v){
				obj[i].checked=true;
			}else{
				obj[i].checked=false;
			}
		}
	}else{
		obj=$(obj);
		if(obj.value==v){
			obj.checked=true;
		}else{
			obj[i].checked=false;
		}
	}
}

//禁用对象
function setDisabled(obj,b){	
	var obj=getObject(obj);
	if (obj){
		obj.disabled=b;
	}else{
		return false;
	}
}

/*
	设置对象Class
	obj		目标对象
	Class		Class名称
	Type		更新方式(+ 累加, - 移除,默认为直接设置)
*/
function setClass(obj,Class,Type){
	var obj=getObject(obj);
	if(obj){
		switch(Type){
			case "+":
				obj.className+=" "+Class;
			break;
			
			case "-":
				obj.className=obj.className.replace(Class,"");
			break;
			
			case "":
				obj.className=Class;
			break;
		}
	}
}

/*
	新建连续选项
	obj	select对象
	s		开始数值
	e		结束数值
	n		更新方式(true 清空 select,false 累加 select)
*/
function setOption(obj,s,e,n){
	var obj=getObject(obj);
	if(n){obj.length=0;}
	
	for(var i=s;i<(e+1);i++){
		obj.options[obj.length] = new Option(i,i); 
	}
}

/*
	设置对象值
	o	对象
	v	值
	s	方式
*/
function setValue(o,v,s){		
	var o=getObject(o);
	
	if(!o) return false;
	
	switch(s){
		case 'insert':
			if(o.value.indexOf(v)>-1){
				o.value = o.value.replace(v,'');
			}else{
				o.value += v;
			}
			
		break;
		
		case 'add':
		case '':
		default:
			o.value += v;
		break;
	}
}

//删除对象
function delElement(obj){
	var obj=getObject(obj);
	if(obj){
		obj.parentNode.removeChild(obj);
	}else{
		return false;
	}
}

//确认操作
function getConfirm(info){
	if(!confirm(info)){return false}
}

function htmlDecode(s) {
	return (s == null)?s:s.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&").replace(/&quot;/g,"\"");
}
function htmlEncode(s) {
	return (s == null)?s:s.replace(/&/g,"&amp;").replace(/\"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
}

//过滤js
function stripScript(s) {
	return s.replace(/<script.*?>.*?<\/script>/ig, '');
}

//显示隐藏对象
function showHide(obj){
	var obj=getObject(obj);
	if(obj){
		if(obj.offsetHeight==0||obj.style.display== "none") {obj.style.display = "block";}else{obj.style.display = "none";}
	}
}

/*
	新窗口打开链接
	a	rel="_blank"
*/
function _blank(){
	var anchors = document.getElementsByTagName("A");
	var len = anchors.length;
	for (var i=0; i<len; i++) {
		var anchor = anchors[i];
		if (anchor.getAttribute("href") && anchor.getAttribute("rel") == "_blank"){
			anchor.target = "_blank";
		}
	}
}

/*
	获取URL参数
	n		名称
	url		URL链接
*/
function getQuery(n,url){
	if(!url){
		var url=location.href;
	}
	
	var v = '';
	var o = url.indexOf(n+"=");
	if (o != -1){
		o += n.length + 1 ;
		e = url.indexOf("&", o);
		if (e == -1){
			e = url.length;
		}
		v = unescape(url.substring(o, e));
	}
	
	//seo
	if(!v){
		var o = url.indexOf(n+"-");
		if (o != -1){
			o += n.length + 1 ;
			e = url.indexOf("-", o);
			if (e == -1){
				e = url.length;
			}
			v = unescape(url.substring(o, e));
		}
	}
	
	return v;
}

/*
	获取随机字符
	len		长度 
	upper	是否允许大写字母 
	lower	是否允许小写字母 
	num		是否允许数字
*/
function getRnd(len,upper,lower,num){
	var a=new Array(); 
	var b=new Array(""); 
	var c=new Array(""); 
	var e=""; 

	a[0]= ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];
	a[1]= ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
	a[2]= ["0","1","2","3","4","5","6","7","8","9"]; 

	if(upper){c=b.concat(a[0]);}
	if(lower){c=b.concat(a[1]);}
	if(num){c=b.concat(a[1]);}

	for (var i=0;i<len;i++){ 
		e+=c[Math.round(Math.random()*(c.length-1))] 
	}
	return e; 
}


/*
	获取Cookie
	name	名称
	sub		子键
*/
function getCookie(name,sub){
	var str="";
	var arr = document.cookie.replace(/%25/g,"%").replace(/%5F/g,"_").match(new RegExp("(^| )"+name+"=([^;]*)(;|$)"));
	if(arr !=null){
		try{
			str=decodeURIComponent(arr[2]);
		}catch(e){
			str=arr[2];
		}
	}
	
	if(sub){
		if(str){
			var nSub = str.indexOf(sub+"=");
		}else{
			var nSub =-1
		}
		
		if(nSub != -1){
			var nSubValueEnd = str.indexOf("&", nSub);
			if(nSubValueEnd == -1)
			nSubValueEnd = str.length;
			var sSubValue = str.substring(nSub + sub.length+1, nSubValueEnd);
			str=sSubValue;
		}else{
			str="";
		}
	}
	return str;
}

/*
	保存Cookie
	key		名称
	value		值
	days		多少天有效
	domain	域
*/
function setCookie(key,value,days,domain,path){
	var cookies=key.replace("_","%5F") + "=" + encodeURIComponent(value)+ "; ";
	if (days){
		var dExpire = new Date();
		dExpire.setTime(dExpire.getTime()+parseInt(days*24*60*60*1000));
		cookies += "expires=" + dExpire.toGMTString()+ "; ";
	}
	domain ? cookies += "domain="+domain+";" : "";
	path ? cookies += "path="+path+";" : "/";
	document.cookie = cookies;
}

/*state*/
VeryIDE.script["library"]=true;