/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.manager.js,v2 18:48 2008-10-03 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

VeryIDE.Manager={
	
	/*用户信息*/
	id:"",
	name:"",
	rank:"",
	skin:"",
	
	/*已知文件*/
	files:["acrobat","asp","avi","bin","bmp","chm","dll","doc","exe","fla","gzip","htm","html","ico","ini","iso","jad","jar","gif","jpg","jpeg","ms","mbk","mdb","mid","mp","msi","ms-project","msstyles","mtf","pdf","png","ppt","psd","rar","reg","rm","sis","skn","swf","tar","thm","torrent","ttc","ttf","txt","wmv","xls","xml","zip"],
	
	/*Action路径*/
	action	: "api/",
	corpImageAuto		: "api/api.imagecut.query.php",
	corpImageWindow	: "api/api.imagecut.php",
	
	/*Session检查间隔*/
	interval	: 30000,
	
	/*编辑模式*/
	editMode: false,

	inti:"",
	fun:null,

	start:function(){	
	
	},
	
	/*重新登录*/
	getLogin:function(){
		VeryIDE.Window('window','请重新登录 VeryIDE','veryide.login.php?action=logout','800','300',false);
	},
	
	getBox:function(){
		return window.frames["column"];
	},
	
	/*站点信息*/
	showSite:function(){
		$V("<strong><a href='"+VeryIDE.web+"' title='"+VeryIDE.site+"' target='_blank'>"+VeryIDE.site+"</a></strong>");
		
		if(VeryIDE.domain){
			$V("<span><a href='http://www.veryide.com/?product="+VeryIDE.product+"&version="+VeryIDE.version+"&build="+VeryIDE.build+"&from="+encodeURIComponent(location.href)+"' title='VeryIDE' target='_blank'>VeryIDE</a><br /><a href='"+VeryIDE.web+"' title='"+VeryIDE.web+"' target='_blank'>"+VeryIDE.domain+"</a></span>");
		}
	},
	
	/*页面标题*/
	setTitle:function(){
		window.parent.document.title=document.title+" - "+VeryIDE.site+" - Powered By VeryIDE";
	},
	
	/*URL Hash*/
	setHash:function(url){
		parent.location.hash="view-"+encodeURIComponent(url);
	},
	
	/*页面消息*/
	showMessage:function(str,url){
		if(!str) return false;
		
		var obj=$("message");
		var doc=VeryIDE.getDocument();
		if(!obj){
			obj=document.createElement("DIV");
			obj.id="message";
			document.body.appendChild(obj);
		}else{
			obj.style.display="";
		}
		obj.innerHTML=str;
		obj.style.left=(doc.scrollWidth-obj.offsetWidth)/2+"px";
		obj.style.top=doc.scrollTop+(doc.clientHeight/2)-(obj.offsetHeight/2)+"px";
		
		window.setTimeout(function(){
			obj.style.display="none";
			if(url){
				location.href=url;
			}
		},3000);
	},
	
	/*设置皮肤*/
	setSkin:function(s){
		function _setStyle(win){
			var i, links;
			links = win.document.getElementsByTagName("link");
			for(i=0; links[i]; i++) {
				if(links[i].getAttribute("rel").indexOf("style") != -1  && links[i].getAttribute("title")=="VeryIDE") {
					links[i].href=VeryIDE.folder.skin+"skin"+s+"/style.css";
				}
			}
		}
		
		_setStyle(window);
		_setStyle(parent.window);
	},
	
	/*验证登录*/
	checkLogin:function(){
		var _User=$("username").value;
		var _Pass=$("password").value;
		var _Code=$("safecode").value;
		
		if(!_User || !_Pass || !_Code){
			parent.VeryIDE.Alert("warning","用户登录","<strong>登录信息出错！</strong><br />请检查您输入的用户名、密码以及验证码是否正确！");		
			return false;
		}else{
			$("password").value=hex_md5(_Pass);
			parent.window.setTimeout(parent.VeryIDE_CheckStart,50);
			return true;
		}
		
	},
		
	/*编辑模式*/	
	setMode:function(mode){
		parent.VeryIDE.Manager.editMode=mode;	
	},
	
	/*退出登录*/
	exitLogin:function(){
		if(VeryIDE.Manager.editMode){
			if(confirm("您的操作尚未结束，离开或刷新页将会放弃所作的操作。\n\n是否同意放弃保存操作？")){
				VeryIDE.Manager.setMode(false);
			}else{
				return;
			}
		}		
		
		if(confirm("确认要退出登录吗?")){
			$("v_state").innerHTML="<span class='key'>"+$("v_user").innerHTML+"</span>，欢迎下次再来！";
			document.title="VeryIDE 用户注销";
			
			//chk
			clearInterval(VeryIDE.tmpInval);
			
			VeryIDE.Manager.getBox().location.href="veryide.login.php?action=exit";			
		}
	},
	
	setProfile:function(){
		if(VeryIDE.Manager.editMode){
			if(confirm("您的操作尚未结束，离开或刷新页将会放弃所作的操作。\n\n是否同意放弃保存操作？")){
				VeryIDE.Manager.setMode(false);
			}else{
				return;
			}
		}
		VeryIDE.Manager.getBox().location.href="veryide.profile.php?people=me&action=edit";
	},
	
	/**/
	pageLoad:function(){
		VeryIDE.Manager.setMode(false);
		
		//loading
		$("loading").style.display="none";
	
		//links
		var links=$T("a");		
		for(var i=0;i<links.length;i++){
		
			var link=links[i];
			
			//hash
			var hash=link.getAttribute("ext-hash");
			if(hash){
				link.onclick=function(){
					VeryIDE.Manager.setHash(getSelf(this.href));
				}
			}
		}
		
		//form
		var forms=$T("form");
		var leng=forms.length;
		for(var i=0;i<leng;i++){
			var form=forms[i];
		
			//Verify form
			if(form.getAttribute("verify")=="true"){
				form.onsubmit=function(){
					var result= VeryIDE.VerifyForm(this,function(i){
            			//parent.VeryIDE.Alert("warning","提交信息出错","详细错误信息：<br /><b>"+i+"</b>");
            			VeryIDE.Manager.showMessage("<b>"+i+"</b>","");
					});
					
					if(result){
						VeryIDE.Manager.setMode(false);	
					}
					
					return result;
				}
			}
		
			//editMode
			if(form.getAttribute("mode")=="edit"){
				form.onkeydown=function(){
					VeryIDE.Manager.setMode(true);
				}
			}
			
			//form focus
			if(i==0){
				var len=form.elements.length;
				for(var n=0;n<len;n++){
					var obj=form.elements[n];
					if(obj.type=="text" && obj.style.display!="none"){
						obj.focus();
						break;
					}
				}
			}
		}
		
		//fun
		if(typeof(VeryIDE.Manager.fun)=="function"){
			VeryIDE.Manager.fun();
		}
		
		//upload
		if(typeof(VeryIDE.Upload.List)=="object"){
			for(var i=0;i<VeryIDE.Upload.List.length;i++){
				VeryIDE.Upload.Move(VeryIDE.Upload.List[i]);
			}
		}
		
		//title
		VeryIDE.Manager.setTitle();
	}
}

VeryIDE.Manager.start();


//Session Check
function VeryIDE_SECheck(action,value,fun){	
	var ajax = new sack(VeryIDE.Manager.action);
	ajax.method = "GET";
	ajax.setVar({
		"new":Math.random(),"&action":action,"&value":value
	});
	ajax.onError = function (){
		alert(ajax.response)
	}
	
	ajax.onCompletion = function (){	
		fun(ajax.responseXML,ajax.response);
	}
	ajax.send("");
}

/*
函数名称:	VerySelect_Set
函数作用:	根据Select数据设置其他对象
参数说明:	obj			select对象
			ObjList		目标对象列表
			Space		使用的分隔符
			Type		值来源(可选项:text , value)
*/
function VeryIDE_SetSelect(obj,ObjList,Space,Type){
	var v,os,vs,t,o;
	v=getSelect(obj).value	
	if(Type=="text"){v=getSelect(obj).text}
	if(!v){return false;}
	os=ObjList.split(Space);
	vs=v.split(Space);
	for(var i=0;i<os.length;i++){
		if(os[i]!=''){
			o=$N(os[i])[0]
			if(!o){o=$(os[i]);}
			t=o.type;
			switch(t){
				case "text"	:			o.value=vs[i];				break;
				case "hidden":		o.value=vs[i];				break;
				case "select-one":	setSelect(os[i],vs[i]);	break;
				case "radio":			setSelect(os[i],vs[i]);	break;
				case "textarea":		o.value=vs[i];				break;
			}	
		}	
	}
}

//后台菜单链接处理
function VeryIDE_GetMenu(obj,url){		
	if(url){
		var u=url.toLowerCase();
		if(u.indexOf("mailto:")==0 || u.indexOf("http://")==0 || u.indexOf("https://")==0 || u.indexOf("ftp://")==0){
			window.open(u,'VeryIDE_Window');
		}else{
		
			if(VeryIDE.Manager.editMode){
				if(confirm("您的操作尚未结束，离开或刷新页将会放弃所作的操作。\n\n是否同意放弃保存操作？")){
					VeryIDE.Manager.setMode(false);
				}else{
					return;
				}
			}
		
			window.frames["column"].location.href=url;
			//hash
			VeryIDE.Manager.setHash(url);
		}
	}
	
	var li=$("menu-link").getElementsByTagName("li");
	var len = li.length;
	for(var i=0;i<len;i++){
		var Tag_a=li[i].getElementsByTagName("a")[0]
		if(Tag_a){
			li[i].className='';
		}
	}

	obj.blur();
	var li=obj.parentNode;
	li.className='active';
	var ul=li.parentNode;
	if(ul.previousSibling && ul.previousSibling.nodeName !="#text"){
		if(ul.tagName=="UL"){
			ul.style.display="block";
		}
	}
}


/******************************************************/

function VeryIDE_Hello(){
	var hour = new Date().getHours();
	if (hour < 4) {
		hello = "夜深了，";
	}else if (hour < 7) {
		hello = "早安，";
	}else if (hour < 9) {
		hello = "早上好，"; 
	}else if (hour < 12) {
		hello = "上午好，";
	}else if (hour < 14) {
		hello = "中午好，";
	}else if (hour < 17) {
		hello = "下午好，";
	}else if (hour < 19) {
		hello = "您好，";
	}else if (hour < 22) {
		hello = "晚上好，";
	}else {
		hello = "夜深了，";
	}
	$V(hello);
}

function VeryIDE_GetDate(){
	var rnd = getRnd(10,true,true,false);
	$V("<span id='"+rnd+"' class='text-key'>Loading...</span>");
	
	setInterval(function(){
		var holiday="";
		
		var calendar = new Date();
		var day = calendar.getDay();
		var month = calendar.getMonth();
		var date = calendar.getDate();
		var year = calendar.getFullYear();
		month++;
		
		//母亲节
		var _date=new Date("May 0 "+year);
		if(_date.getDay()==0){
			var _n=14
		}else{
			var _n=14-_date.getDay();
		}
		
		if ((month == 1) && (date == 1)) holiday ="元旦";
		if ((month == 2) && (date == 14)) holiday ="情人节";
		if ((month == 3) && (date == 15)) holiday ="消费者权益日";
		if ((month == 3) && (date == 8)) holiday ="妇女节";
		if ((month == 4) && (date == 1)) holiday ="愚人节";
		if ((month == 3) && (date == 12)) holiday ="植树节 孙中山逝世纪念日";
		if ((month == 5) && (date == 1)) holiday ="国际劳动节";
		if ((month == 5) && (date==_n) && day==0) holiday ="母亲节";
		if ((month == 5) && (date == 4)) holiday ="青年节";
		if ((month == 6) && (date == 1)) holiday ="国际儿童节";
		if ((month == 7) && (date == 1)) holiday ="香港回归纪念日";
		if ((month == 9) && (date == 10)) holiday ="中国教师节";
		if ((month == 9) && (date == 18)) holiday ="九·一八事变纪念日";
		if ((month == 9) && (date == 28)) holiday ="孔子诞辰";
		if ((month == 10) && (date == 6)) holiday ="老人节";
		if ((month == 12) && (date == 20)) holiday ="澳门回归纪念";
		if ((month == 12) && (date == 24)) holiday ="平安夜"; 
		if ((month == 12) && (date == 25)) holiday ="圣诞节"; 
	
		$(rnd).innerHTML=new Date().toLocaleString()+' 星期'+'日一二三四五六'.charAt(new Date().getDay())+" "+holiday;
	},1000);
}


//Setting Nav
function VeryIDE_Setting(url,set){
	var url=url.toLowerCase();
	url=url.substr(url.lastIndexOf("/")+1);
	var link=$("setting").getElementsByTagName("A");
	var len = link.length;
	for(var i=0;i<len;i++){
		var link_href=link[i].href.toLowerCase();
		var link_rel=link[i].getAttribute("rel");
		if(link_href.indexOf(url)>-1 || (link_rel && link_rel.toLowerCase().indexOf(url)>-1) ){
			if(set){
				link[i].parentNode.className="active";
			}else{
				link[i].parentNode.className="";
			}
			continue;
		}
	}
}

function VeryIDE_SetBy(o,d){
	var obj=$(o);
	if(obj){
		obj=obj.getElementsByTagName("A")[0];
		var style="background:url("+VeryIDE.folder.images+"by_"+d+") right center no-repeat;padding-right:20px;"
		obj.setAttribute("style",style);
		obj.style.cssText=style;
	}
}
	

function setState(url){
	location.href=url+'&url='+location.href;	
}

//全选_反选_全不选
function selCheckBox(o,v,t){
	var obj=$N(o);
	var len = obj.length;
	var s="";
	if(v!="anti"){
		for(var i=0;i<len;i++){
			obj[i].checked=v;
			if(obj[i].checked){s+=obj[i].value+",";}
		}
	}else{
		for(var i=0;i<len;i++){
			if(obj[i].checked){
				obj[i].checked=false;
			}else{
				obj[i].checked=true;
				s+=obj[i].value+",";
			}
		}
	}
	if(t){
		$(t).value=s;
	}
}

//打开CheckBox中的ID
function openCheckBox(o){
	var obj=$N(o);
	var len = obj.length;
	var link;
	for(var i=0;i<len;i++){
		if(obj[i].checked){			
			link=$("url-"+obj[i].value);
			if(link){				
				window.open(link.href,"");
			}			
		}
	}
}

//将连续的CheckBox值写入input
function selCBValue(obj,list){
	var o=$(list);
	if(obj.checked){
		o.value+=obj.value+",";
	}else{
		o.value=o.value.replace(obj.value+",","");	
	}
}

//提交动作
function formPost(form,action){
	if($("list").value){
		$("action").value=action;
		$("url").value=location.href;
		$(form).submit();
	}else{
		if (typeof VeryIDE.Message == 'function') {
			VeryIDE.Message("message","","请选择需要操作的记录！");
		}else{
			VeryIDE.Manager.showMessage("请选择需要操作的记录！",null)
		}
	}	
}

/*state*/
VeryIDE.script["manager"]=true;