/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.ubb.js,v1.5 21:38 2009-5-16 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

/** Load Calendar Style*/
var root=document.getElementsByTagName("HEAD")[0];

var style=document.createElement("link");
	style.rel="stylesheet";
	style.type="text/css";
	style.href=VeryIDE.root+"/resources/style/ubb.css";
	
	root.appendChild(style);


/**********/

		
VeryIDE.UBB={

	drag:null,
	
	load:function(obj,cfg){
	
		if(!cfg) cfg=new Array();
	
		var html='<div class="ubb">';
		
		//菜单
		var array=["字体","font","fontface","大小","size","format","颜色","color","color"];
		for(var i=0;i<array.length;i+=3){
			if(inArray(cfg,array[i+1]) || cfg.length==0){
				html+='<img src="images/spacer.gif" alt="'+array[i]+'" class="ubb-img img-'+array[i+1]+'" unselectable="on" onclick="VeryIDE.Tips(event,this,$(\''+array[i+2]+'\'),null,document,\'click\');" />';
			}
		}
		
		//字体
		html+='<div id=fontface class="ubb-menu" style="display:none;"><ul>';
		var array=["Arial","Arial Black","Impact","Verdana","宋体","黑体","楷体_GB2312","幼圆","Microsoft YaHei"];
		for(var i=0;i<array.length;i++){
			html+='<li><a onclick="VeryIDE.UBB.face(\''+obj+'\',\''+array[i]+'\');" style="font-family:'+array[i]+'" unselectable="on" onfocus="this.blur();">'+array[i]+'</a></li>';
		}
		html+='</ul></div>';
		
		//字号
		html+='<div id=format class="ubb-menu" style="display:none;"><ul>';
		for(var i=1;i<=6;i++){
			html+='<li><a onclick="VeryIDE.UBB.size(\''+obj+'\',\''+i+'\');" unselectable="on" onfocus="this.blur();"><font size="'+i+'" unselectable="on">'+i+'</font></a></li>';
		}
		html+='</ul></div>';
		
		//颜色
		html+='<div id=color class="ubb-menu ubb-color" style="display:none;"><ul>';
		var array=["黑色","black","灰色","gray","茶色","maroon","红色","red","紫色","purple","紫红","fuchsia","绿色","green","亮绿","lime","橄榄","olive","黄色","yellow","深蓝","teal","蓝色","blue","浅绿","aqua","粉红","pink","橙色","orange","褐色","brown"];
		for(var i=0;i<array.length;i+=2){
			html+='<li><a onclick="VeryIDE.UBB.color(\''+obj+'\',\''+array[i+1]+'\');" style="color:'+array[i+1]+'" unselectable="on">'+array[i]+'</a></li>';
		}
		html+='</ul></div>';
		
		//修饰
		var array=["加粗","bold","斜体","italic","下划线","under","左对齐","left","居中","center","右对齐","right"];
		for(var i=0;i<array.length;i+=2){
			if(inArray(cfg,array[i+1]) || cfg.length==0){
				html+='<img src="images/spacer.gif" alt="'+array[i]+'" class="ubb-img img-'+array[i+1]+'" onclick="VeryIDE.UBB.'+array[i+1]+'(\''+obj+'\')" />';
			}
		}
		
		//功能
		var array=["链接","link","图片","image","FLASH","flash","视频","video","音乐","mp3","引用","quote","仅会员浏览","hidden","代码片段","code","转换复制的HTML","html"];
		for(var i=0;i<array.length;i+=2){
			if(inArray(cfg,array[i+1]) || cfg.length==0){
				html+='<img src="images/spacer.gif" alt="'+array[i]+'" class="ubb-img img-'+array[i+1]+'"  onclick="VeryIDE.UBB.'+array[i+1]+'(\''+obj+'\')" />';
			}
		}
		
		//缩放
		var array=["最佳尺寸/原始尺寸","zoom","放大输入框","zoomin","缩小输入框","zoomout","帮助文档","help"];
		for(var i=0;i<array.length;i+=2){
			if(inArray(cfg,array[i+1]) || cfg.length==0){
				html+='<img src="images/spacer.gif" alt="'+array[i]+'" class="ubb-img img-'+array[i+1]+'"  onclick="VeryIDE.UBB.'+array[i+1]+'(\''+obj+'\')" />';
			}
		}
		
		//统计
		if(inArray(cfg,"stat") || cfg.length==0){
			html+='<span id="'+obj+'_stat" class="ubb-stat"></span>';
			addLoadEvent(function(){
				var self = obj;
				$(obj).onkeyup=function(){
					$(obj+'_stat').innerHTML="字数:"+this.value.long();
				}
			});
		}
		
		html+='</div>';
		$V(html);
		
		//zoom
		addLoadEvent(function(){
		
			var img = document.createElement("img");
				 img.id=obj+"_zoom";
				 img.src="images/ui/shape_group.png";
				 img.title="收缩文本框大小";
				 img.unselectable="on";
				 
				 img.onmousedown=function(){
					VeryIDE.UBB.dragEvent(obj);
				 }
			
			document.body.appendChild(img);
			
			VeryIDE.UBB.dragPosition(obj);
		});
	},
	
	dragPosition:function(obj){
			var pos = getPosition(obj);
			var left = pos.left-16;
			var top = pos.top+pos.height-16;
			var width = pos.width;		
			var css="position:absolute;cursor:pointer;left:"+(left+width)+"px;top:"+top+"px";
			
			var img=$(obj+"_zoom");
				 img.style.cssText=css;
				 img.setAttribute("style",css);
	},
	
	dragEvent:function(o){
		VeryIDE.UBB.drag=$(o);
		
		document.onmousemove = function(e){

			var obj=VeryIDE.UBB.drag;
			if(obj){
				var x = 0;
				var y = 0;
				
				try{
					var doc = document.documentElement;
				}catch (e){
					var doc = document.body;
				}
				
				var e = e || window.event;
				var x  = (e.clientX || e.pageX) + doc.scrollLeft;
				var y  = (e.clientY || e.pageY) + doc.scrollTop;
		
				var pos=getPosition(obj);
				var w = x-pos.left;
				var h = y-pos.top;
				
				if(w<80 || h<80) return false;
				
				obj.style.width  = w+"px";   
				obj.style.height = h+"px";   
				
				VeryIDE.UBB.dragPosition(o);
			}   
		}   

		document.onmouseup = function(e){   
			VeryIDE.UBB.drag=null;
			
			document.onmousemove=null;
		}   
	},
		
	face:function(obj,sel){
		var s="[face="+sel+"]文字";
		var e="[/face]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	size:function(obj,sel){
		var s="[size="+sel+"]文字";
		var e="[/size]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	code:function(obj,sel){
		var s="[code]代码";
		var e="[/code]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	color:function(obj,sel){
		var s="[color="+sel+"]彩色字";
		var e="[/color]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	bold:function(obj){
		var s="[B]粗体字";
		var e="[/B]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	italic:function(obj){
		var s="[I]斜体字";
		var e="[/I]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	under:function(obj){
		var s="[U]下划线";
		var e="[/U]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	left:function(obj){
		var s="[align=left]左对齐";
		var e="[/align]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	center:function(obj){
		var s="[align=center]居中";
		var e="[/align]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	right:function(obj){
		var s="[align=right]右对齐";
		var e="[/align]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	link:function(obj){
		var t = prompt("请输入链接要显示的文字,只能包含中文,英文字母,或中英文混合","请点击这里");
		if(!t) return;
		var url = prompt("请输入URL地址","http://");
		
		if(!url)return;
		
		$(obj).value+=(!t)?"[url]"+url+"[\/url]":"[url="+url+"]"+t+"[\/url]";
		$(obj).focus();
	},
	
	flash:function(obj){
		var a = prompt("请输入Flash的URL地址","http://");
		if(!a) return;
		if(!/^http/.test(a)) {alert("URL地址格式不对");return;}
		var b = prompt("请输入Flash高度和宽度","350,200");
		var c = "[flash="+b+"]"+a+"[\/flash]";

		$(obj).value += c;
		$(obj).focus();
	},
	
	mp3:function(obj){
		var a = prompt("请输入音频文件的URL地址","http://");
		if(!a) return;
		if(!/^http/.test(a)) {alert("URL地址格式不对");return;}
		var b = prompt("请输入音频文件播放器高度和宽度","220,40");
		var c = "[mp3="+b+"]"+a+"[\/mp3]";

		$(obj).value += c;
		$(obj).focus();
	},
	
	hidden:function(obj){
		var s="[hidden]会员内容";
		var e="[/hidden]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	image:function(obj){
		var a = prompt("请输入图片的URL地址","http://");
		if(!a) return;
		if(!/^http/.test(a)) {alert("URL地址格式不对");return;}
		var c = "[img]"+a+"[\/img]";

		$(obj).value += c;
		$(obj).focus();
	},
	
	video:function(obj){
		var autostart = "true";
		var a = prompt("请输入视频文件地址","");
		if(a == null || a == "" || a == '')
		return;
		
		var b = prompt("请输入视频文件显示大小","400,250");
		if(b == null || b == "" || b == ''){
			b = "400,250";
		}
		
		var c = prompt("请输入是否自动播放,默认为自动播放(yes自动，no不自动播放）","yes");
		if(c != "yes"){
			autostart = "false";
		}
		var strvideo = "[embed="+b+","+autostart+"]"+a+"[/embed]";

		$(obj).value += strvideo;
		$(obj).focus();
	},
	
	quote:function(obj){
		var s="[quote]引用内容";
		var e="[/quote]";
		
		VeryIDE.UBB.insert(obj,s,e);
	},
	
	zoom:function(obj){
		var o=$(obj);

		if(o.scrollHeight > o.offsetHeight){
			o.style.height = o.scrollHeight+"px";
		}else{
			o.style.height = "auto";	
		}
		
		VeryIDE.UBB.dragPosition(obj);
	},
	
	zoomin:function(obj){
		$(obj).rows+=5;
		
		VeryIDE.UBB.dragPosition(obj);
	},
	
	zoomout:function(obj){
		if($(obj).rows>=10){
			$(obj).rows-=5;
		}
		
		VeryIDE.UBB.dragPosition(obj);
	},
	
	help:function(obj){
		var doc = VeryIDE.getDocument();
		parent.VeryIDE.Window('window','VeryIDE Help','veryide.help.php#ubb',doc.clientWidth-20,'430',{});
	},
	
	html:function(obj){
		
		var ifr=obj+"_iframe";
		
		if(!$(ifr)){
			var box=document.createElement('iframe');
				box.id=ifr;
				box.name=ifr;
				box.style.width="0px";
				box.style.height="0px";
				box.style.border="0";
				document.body.appendChild(box);
				
			var box=window.frames[ifr].document;
				box.designMode="On";
				box.open();
				box.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\
				<html xmlns=\"http://www.w3.org/1999/xhtml\">\
				<head>\
				<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\
				<title>测试</title>\
				</head>\
				<body >\</body>\
				</html>");
				
				box.close();
		}
		
		var box=window.frames[ifr].document;
			
			box.execCommand("SelectAll",false,null);
			box.execCommand("Delete",false,null);
			try {
				box.execCommand("paste",false,null);
			} catch (e) {
				alert("Sorry!\n\n当前浏览器暂不支持粘贴操作");
				return false;
			}
			
			var str=box.body.innerHTML
			if(str){
				str = str.replace(/\r/g,"");
				str = str.replace(/on(load|click|dbclick|mouseover|mousedown|mouseup)="[^"]+"/ig,"");
				str = str.replace(/<script[^>]*?>([\w\W]*?)<\/script>/ig,"");
				str = str.replace(/<a[^>]+href="([^"]+)"[^>]*>(.*?)<\/a>/ig,"\n[url=$1]$2[/url]\n");
				str = str.replace(/<font[^>]+color=([^ >]+)[^>]*>(.*?)<\/font>/ig,"\n[color=$1]$2[/color]\n");
				str = str.replace(/<img[^>]+src="([^"]+)"[^>]*>/ig,"\n[img]$1[/img]\n");
				str = str.replace(/<([\/]?)b>/ig,"[$1b]");
				str = str.replace(/<([\/]?)strong>/ig,"[$1b]");
				str = str.replace(/<([\/]?)u>/ig,"[$1u]");
				str = str.replace(/<([\/]?)i>/ig,"[$1i]");
				str = str.replace(/&nbsp;/g," ");
				str = str.replace(/&amp;/g,"&");
				str = str.replace(/&quot;/g,"\"");
				str = str.replace(/&lt;/g,"<");
				str = str.replace(/&gt;/g,">");
				str = str.replace(/<br>/ig,"\n");
				str = str.replace(/<[^>]*?>/g,"");
				str = str.replace(/\[url=([^\]]+)\]\n(\[img\]\1\[\/img\])\n\[\/url\]/g,"$2");
				str = str.replace(/\n+/g,"\n");
				
				$(obj).value += str;
				
			}else{
				alert('无需转换的HTML内容');	
			}
		
	},
	
	insert:function(obj,s,e){
		/*
		$(obj).value += s + e;
		$(obj).focus();
		return false;
		*/
		if ((document.selection)&&(document.selection.type == "Text")){
			var range = document.selection.createRange();
			var ch_text = range.text;
			range.text = s + ch_text + e;
		}else{
		
			$(obj).value += s + e;
			return false;
		}
		$(obj).focus();
	}
}

/*state*/
VeryIDE.script["ubb"]=true;