/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.upload.js,v2.5 13:27 2009-07-01 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

//VeryIDE.Upload
VeryIDE.Upload=function(ObjV,Value,Size,ImageSize,Type,Args){		
	var Obj=$(ObjV);
	if (Obj || $(ObjV+"_Iframe") || $(ObjV+"_Form") || $(ObjV+"_Span") || $(ObjV+"_Config") || $(ObjV+"_Path")){
		parent.VeryIDE.Alert("warning","文件上传","<span class='key'>已经存在 VeryIDE UpLoad 实例: </span><span class='no'>"+ObjV+" </span>");
	}else{
		
		$V('<span id="'+ObjV+'_Span"></span>');
		$V('<span id="'+ObjV+'_Config">');
			//返回文件名
			$V('<input id="'+ObjV+'_Config_Value" type="hidden" value="'+Value+'" />');								
			//返回文件大小
			$V('<input id="'+ObjV+'_Config_Size" type="hidden" value="'+Size+'" />');									
			//允许文件类型
			$V('<input id="'+ObjV+'_Config_Type" type="hidden" value="'+Type+'" />');	
											
			//****上面必选项**下面设置项******
			
			//显示输入框(true|false)
			$V('<input id="'+ObjV+'_Config_Input" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Input")+'" />');		
			//允许文件返回(true|false)		
			$V('<input id="'+ObjV+'_Config_Back" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Back")+'" />');				
			//允许新上传(true|false)
			$V('<input id="'+ObjV+'_Config_New" type="hidden" value="'+VeryIDE.Upload.Read(Args,"New")+'" />');
			//自动重命名(true|false)
			$V('<input id="'+ObjV+'_Config_NewName" type="hidden" value="'+VeryIDE.Upload.Read(Args,"NewName")+'" />');
			//自动切图(true|false)
			$V('<input id="'+ObjV+'_Config_AutoCorp" type="hidden" value="'+VeryIDE.Upload.Read(Args,"AutoCorp")+'" />');
			//切图保存为新图
			$V('<input id="'+ObjV+'_Config_CopyCorp" type="hidden" value="'+VeryIDE.Upload.Read(Args,"CopyCorp")+'" />');
			//目标图片宽
			$V('<input id="'+ObjV+'_Config_Width" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Width")+'" />');
			//目标图片高
			$V('<input id="'+ObjV+'_Config_Height" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Height")+'" />');
			//图片尺寸
			$V('<input id="'+ObjV+'_Config_ImageSize" type="hidden" value="'+ImageSize+'" />');						
			//图片预览
			$V('<input id="'+ObjV+'_Config_Preview" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Preview")+'" />');
			//图片插入到FCK
			$V('<input id="'+ObjV+'_Config_InsertFCK" type="hidden" value="'+VeryIDE.Upload.Read(Args,"InsertFCK")+'" />');
			//图片插入到UBB
			$V('<input id="'+ObjV+'_Config_InsertUBB" type="hidden" value="'+VeryIDE.Upload.Read(Args,"InsertUBB")+'" />');
			//回调函数
			$V('<input id="'+ObjV+'_Config_Callback" type="hidden" value="'+VeryIDE.Upload.Read(Args,"Callback")+'" />');
			//文件域扩展属性
			var _Property=VeryIDE.Upload.Read(Args,"Property");
			$V('<input id="'+ObjV+'_Config_Property" type="hidden" value="'+encodeURIComponent(_Property.substr(1,_Property.length-2))+'" />');

		$V('</span>');
		
		if(Value==""){
			if(typeof(VeryIDE.Upload.List)!="object"){
				VeryIDE.Upload.List=new Array();
				VeryIDE.Upload.List[0]=ObjV;
			}else{
				VeryIDE.Upload.List[VeryIDE.Upload.List.length]=ObjV;
			}
			VeryIDE.Upload.Select(ObjV);
		}else{
			VeryIDE.Upload.Save(ObjV);
		}
	}
}

//分析设置
VeryIDE.Upload.Read=function(arg,key){
  var v='';
  var args=arg.split(",")
  var key=key+"="
  var beginPosition;
  for(i=0;i<args.length;i++){
    beginPosition = args[i].indexOf(key)
    if(beginPosition > -1){
      v=args[i].substring(beginPosition + key.length);
      break;
    }
  }
  return v;
}

//读取设置
VeryIDE.Upload.Config=function(obj){
	this.Value=$(obj+"_Config_Value").value;
	this.ImageSize=$(obj+"_Config_ImageSize").value;
	this.Type=$(obj+"_Config_Type").value;
	this.Size=$(obj+"_Config_Size").value;
	
	this.Input=$(obj+"_Config_Input").value;
	this.Back=$(obj+"_Config_Back").value;
	this.New=$(obj+"_Config_New").value;
	
	this.NewName=$(obj+"_Config_NewName").value;
	this.AutoCorp=$(obj+"_Config_AutoCorp").value;
	this.CopyCorp=$(obj+"_Config_CopyCorp").value;
	this.Height=$(obj+"_Config_Height").value;
	this.Width=$(obj+"_Config_Width").value;
	
	this.Preview=$(obj+"_Config_Preview").value;
	this.InsertFCK=$(obj+"_Config_InsertFCK").value;
	this.InsertUBB=$(obj+"_Config_InsertUBB").value;
	this.Callback=$(obj+"_Config_Callback").value;
	
	this.Property=decodeURIComponent($(obj+"_Config_Property").value);
}

//文件已保存
VeryIDE.Upload.Save=function(ObjV){	
	var cfg=new VeryIDE.Upload.Config(ObjV);
	
	var Fobj=$(ObjV+"_Form");
	if(Fobj){
		delElement($(ObjV+"_Form"));
	}
	
	var _html='<input type="hidden" name="'+ObjV+'_ImageSize" id="'+ObjV+'_ImageSize" value="'+cfg.ImageSize+'" />';
	
	var icon=VeryIDE.folder.icon+'/190.png';
	var type=cfg.Value.split(".")[cfg.Value.split(".").length-1];
	if(inArray(VeryIDE.Manager.files,type)){
		icon = VeryIDE.folder.images+"files/"+type+".gif";
	}
	
	_html+='<input type="hidden" name="'+ObjV+'" id="'+ObjV+'" value="'+cfg.Value+'" '+cfg.Property+' />'+'<img src="'+icon+'" align="absmiddle" /> <a href="'+cfg.Value+'" target="_blank">'+cfg.Value+'</a>  -  ';
	
	if(cfg.ImageSize || cfg.Size){
		var str='';
		if(cfg.ImageSize){
			str+='图片尺寸:<br />'+cfg.ImageSize.replace(/\*/g,'px * ')+'px';
		}
		if(cfg.Size){
			str+='<br />文件大小:<br />'+Math.round(parseFloat(cfg.Size)/1024)+' KB';
		}
	
		_html+=' <span class="upload" title="查看详细文件信息" onclick="parent.VeryIDE.Alert(&quot;warning&quot;,&quot;文件详细信息&quot;,&quot;'+str+'&quot;);")"><img src="'+VeryIDE.folder.icon+'/186.png" align="absmiddle" /> ';
		
		if(cfg.ImageSize){
			_html+=cfg.ImageSize.replace(/\*/g,'px * ')+'px';
		}
		
		if(cfg.Size){
			_html+=' - '+Math.round(parseFloat(cfg.Size)/1024)+' KB - ';
		}
		_html+=' </span>';
	}
	
	if(cfg.New=="true"){
		_html+='<span class="upload" onclick="VeryIDE.Upload.New(&quot;'+ObjV+'&quot;);"  title="添加新文件"><img src="'+VeryIDE.folder.icon+'103.png" align="absmiddle" /> 新文件</span> - ';
	}
	
	_html+='<span class="upload" onclick="VeryIDE.Upload.Delete(&quot;'+ObjV+'&quot;,&quot;'+cfg.Value+'&quot;);" title="删除这个文件"><img src="'+VeryIDE.folder.icon+'/150.png" align="absmiddle" /> 删除</span><img src="'+VeryIDE.folder.images+'spacer.gif" height="20" width="1" />';
	_html+='<input type="hidden" name="'+cfg.Type+'_Type" id="'+cfg.Type+'_Type" value="'+cfg.Type+'" />';
	
	if(cfg.Width && cfg.Height && cfg.ImageSize){
		_html+=' <span class="upload" title="处理图片" onclick="VeryIDE.Upload.ImageCorpWindow(&quot;'+ObjV+'&quot;)"><img src="'+VeryIDE.folder.icon+'/086.png" align="absmiddle" /> 处理</span>';
	}
	$(ObjV+"_Span").innerHTML=_html;
	
	if(cfg.Preview && $(cfg.Preview)){$(cfg.Preview).src=cfg.Value;}
	
	if(cfg.Callback){
		var _width  =0;
		var _height =0;
		if(cfg.ImageSize){
			_width  =cfg.ImageSize.split('*')[0];
			_height =cfg.ImageSize.split('*')[1];
		}

		eval(cfg.Callback+'({"file":cfg.Value,"size":cfg.Size,"width":_width,"height":_height,"type":cfg.Type})');
	}
}

//文件选择
VeryIDE.Upload.Select=function(ObjV){
	var cfg=new VeryIDE.Upload.Config(ObjV);

	var _html="";
	if(cfg.Input=="true"){
		_html='<input type="text" name="'+ObjV+'" id="'+ObjV+'" value="" size="48" '+cfg.Property+' /> ';
	}else{
		_html='<input type="hidden" name="'+ObjV+'" id="'+ObjV+'" value="" '+cfg.Property+' />';
	}
	
	_html+='<span class="upload" id="Add_'+ObjV+'" title="添加一个新文件"><img src="'+VeryIDE.folder.icon+'103.png" alt="" align="absmiddle" /> 添加文件</span>';
	
	if(cfg.Width){
		_html+=' - <span class="upload" onclick="parent.VeryIDE.Alert(&quot;warning&quot;,&quot;文件上传&quot;,&quot;上传图片最佳尺寸:<br />'+cfg.Width+'px * '+cfg.Height+'px &quot;);",{})"><img src="'+VeryIDE.folder.icon+'preview.gif" align="absmiddle" /> '+cfg.Width+'px * '+cfg.Height+'px </span>';
	}
	
	if(cfg.Back=="true"){
		_html+=' - <span onclick="javascript:VeryIDE.Upload.Back(&quot;'+ObjV+'&quot;)" class="upload" title="使用最近一次上传的文件"><img src="'+VeryIDE.folder.icon+'128.png" align="absmiddle" /> 最近上传</span>';
	}
	
	var type=cfg.Type.replace(/;/g,", ");
	_html+=' - <span class="upload" title="查看详细上传支持格式" onclick="parent.VeryIDE.Alert(&quot;warning&quot;,&quot;文件上传&quot;,&quot;支持上传如下格式:<br />'+type+'&quot;);",{})"><img src="'+VeryIDE.folder.icon+'152.png" align="absmiddle" /> 支持格式</span>';
	
	//VeryIDE.debug
	if(VeryIDE.debug){
		_html+='<iframe width="400" height="200" frameborder="0" name="'+ObjV+'_Iframe" id="'+ObjV+'_Iframe" src="about:blank"></iframe>';
	}else{
		_html+='<iframe width="0" height="0" frameborder="0" name="'+ObjV+'_Iframe" id="'+ObjV+'_Iframe" src="about:blank"></iframe>';	
	}
	$(ObjV+"_Span").innerHTML=_html;
	
	//alert(_html);

	var F=document.createElement("form");
	with(F){
		id=ObjV+"_Form";name=ObjV+"_Form";style.padding="0px";style.margin="0px";style.position="absolute";style.width="80px";		style.overFlow="hidden";target=ObjV+'_Iframe';method="post";enctype="multipart/form-data";action="";
	}
	
	var oForm=$T("form");
	if(oForm.length>0){
		oForm[0].parentNode.insertBefore(F,oForm[0])
	}else{
		document.body.insertBefore(F,$T("body")[0].firstChild);
	}
	
	var _form="<input onchange='VeryIDE.Upload.Check(&quot;"+ObjV+"&quot;)' hidefocus type='file' ";
	
	_form+="style='filter:alpha(opacity=0);-moz-opacity:0;opacity:0;margin-left:-10px!important;margin-left:-15px;width:60px;cursor:pointer;' ";
	_form+="name='FileValue'id='"+ObjV+"_FileValue'  size='1' />";
	_form+='<input name="FileObj" id="'+ObjV+'_FileObj" type="hidden" value="'+ObjV+'" />';
	_form+='<input name="FileType" id="'+ObjV+'_FileType" type="hidden" value="'+cfg.Type+'" />';
	_form+='<input name="NewName" id="'+ObjV+'_NewName" type="hidden" value="'+cfg.NewName+'" />';
	$(ObjV+"_Form").innerHTML=_form;
	VeryIDE.Upload.Move(ObjV);
	if(cfg.Preview && $(cfg.Preview)){$(cfg.Preview).src="";}
	
	window.setTimeout(
		function(){
			VeryIDE.Upload.Move(ObjV);
			if(cfg.Preview && !$(ObjV).value ){
				$(cfg.Preview).src="";
			}
		},2000
	  );
}

/*修正表单位置*/
VeryIDE.Upload.Move=function(ObjV){
	if($("Add_"+ObjV)){
		var o=new getPosition("Add_"+ObjV);
		$(ObjV+"_Form").style.top=o.top-2+"px";
		$(ObjV+"_Form").style.left=o.left+"px";
	}
}

//重新上传文件
VeryIDE.Upload.New=function(ObjV){		
	if(confirm("您确认从新上传一个文件吗？\n\n现有的记录将会丢失！")){
		VeryIDE.Upload.Select(ObjV);
	}
}

//文件删除
VeryIDE.Upload.Delete=function(ObjV,Value){
	var cfg=new VeryIDE.Upload.Config(ObjV);
	
	//外部文件处理
	var u=Value.toLowerCase();
	if(u.indexOf("mailto:")==0 || u.indexOf("http://")==0 || u.indexOf("https://")==0 || u.indexOf("ftp://")==0){
		if(confirm("您确认消除文本: "+Value+" ？\n\n消除的文本将会丢夫！")){
			$(ObjV+"_Config_Value").value="";
			VeryIDE.Upload.Select(ObjV);
		}
		return true;
	}	
	
	if(confirm("您确认从服务器删除 "+Value+" ？\n\n删除的文件将无法恢复！")){
		var XmlURL=VeryIDE.Manager.action;
		
		var ajax = new sack(XmlURL);
		ajax.method = "GET";
		ajax.setVar({
			"action":"file-delete","&file":Value,"&input":ObjV,"&new":cfg.CopyCorp,"&rnd":Math.random()
		});
		ajax.onError = function (){
			alert(ajax.response)
		}
		
		ajax.onCompletion = function (){
			var response	=	ajax.responseXML;
			var result		=	response.getElementsByTagName('result')[0].firstChild.data;
			var error		=	response.getElementsByTagName('error')[0].firstChild.data;
			
			switch(error){
				case "not":
					$(ObjV+"_Config_Value").value="";
					VeryIDE.Upload.Select(ObjV);
				break;
				
				case "login":
					parent.VeryIDE.Alert("warning","文件上传",parent.VeryIDE.loginBox);
				break;
				
				case "config":
					parent.VeryIDE.Alert("warning","文件上传","您的操作已经取消！<br />您当前没有权限删除文件！");
				break;
				
				case "file":
					parent.VeryIDE.Alert("warning","文件上传","未找到目标文件！<br />文件是否已经通过其它方式被删除了？<br />您还可以 <a href='javascript:VeryIDE.Alert(&quot;warning&quot;);VeryIDE.Manager.getBox().VeryIDE.Upload.New(&quot;"+ObjV+"&quot;);void(0);'>重新上传文件</a>");
				break;
				
			}
			
		}
		ajax.send("");
	}
}

//文件返回
VeryIDE.Upload.Back=function(ObjV){		
	var cfg=new VeryIDE.Upload.Config(ObjV);
	if(cfg.Back=="true"){
		var XmlURL=VeryIDE.Manager.action;
		
		var ajax = new sack(XmlURL);
		ajax.method = "GET";
		ajax.setVar({
			"action":"file-back","&input":ObjV,"&type":cfg.Type,"&_new":Math.random()
		});
		ajax.onError = function (){
			alert(ajax.response)
		}
		
		ajax.onCompletion = function (){
			var response	=  ajax.responseXML;
			var result		=	response.getElementsByTagName('result')[0].firstChild.data;
			var error		=	response.getElementsByTagName('error')[0].firstChild.data;
			
			switch(error){
				case "not":
					var FileV=response.getElementsByTagName('name')[0].firstChild.data;
					var _Size=response.getElementsByTagName('size')[0].firstChild.data;
					
					//图片尺寸
					var isImageSize=response.getElementsByTagName('imagesize');
					var _ImageSize="";
					
					if(isImageSize[0]){
						_ImageSize=isImageSize[0].firstChild.data;
					}
					
					$(ObjV+"_Config_Value").value=FileV;
					$(ObjV+"_Config_Size").value=_Size;					
					$(ObjV+"_Config_ImageSize").value=_ImageSize;
					VeryIDE.Upload.Save(ObjV);
					
				break;
				
				case "login":
					parent.VeryIDE.Alert("warning",parent.VeryIDE.loginBox);
				break;
				
				case "config":
					parent.VeryIDE.Alert("warning","文件上传","您的操作已经取消！<br />您当前没有权限返回文件！");
				break;
				
				case "file":
					parent.VeryIDE.Alert("warning","文件上传","未找到文件<br />在文件数据库中未找到相匹配的文件！");
				break;
				
			}
			
		}
		ajax.send("");
	}
}

//文件上传成功
VeryIDE.Upload.Ok=function(ObjV,Value,Size,ImageSize){	

	$(ObjV+"_Config_Value").value=Value;
	$(ObjV+"_Config_Size").value=Size;
	$(ObjV).value=Value;
	$(ObjV+"_Config_ImageSize").value=ImageSize;
	
	var cfg=new VeryIDE.Upload.Config(ObjV);
	
	if(cfg.Width && cfg.Height){
		if(cfg.AutoCorp=='true'){
			VeryIDE.Upload.ImageCorpAuto(ObjV);
		}else{
			VeryIDE.Upload.Save(ObjV);
			VeryIDE.Upload.ImageCorpWindow(ObjV);
		}
	}else{
		VeryIDE.Upload.Save(ObjV);
	}
	
	VeryIDE.Upload.InputLock(ObjV,false);
	
	//插入FCK
	if(cfg.InsertFCK && $(cfg.InsertFCK)){
		InsertHTML(cfg.InsertFCK,'<img src="'+VeryIDE.root+cfg.Value+'" />');
	}
	
	//插入UBB
	if(cfg.InsertUBB && $(cfg.InsertUBB)){
		$(cfg.InsertUBB).value+='[IMG]'+VeryIDE.root+cfg.Value+'[/IMG]';
	}
}

//切图
VeryIDE.Upload.ImageCorpAuto=function(ObjV){
	var imgCorp=VeryIDE.Manager.corpImageAuto;
	
	var cfg=new VeryIDE.Upload.Config(ObjV);
	var _Ext=cfg.Value.replace(/.*\./,"").toLowerCase();
	
	if(_Ext=="jpg" || _Ext=="gif" || _Ext=="jpeg" || _Ext=="png" || _Ext=="bmp"){
	
		var ajax = new sack(imgCorp);
		ajax.method = "GET";
		ajax.setVar({
			"file":encodeURIComponent(cfg.Value),"&action":"corp","&new":cfg.CopyCorp,"&width":cfg.Width,"&height":cfg.Height,"&rnd":Math.random()
		});
		ajax.onError = function (){
			alert(ajax.response)
		}
		ajax.onCompletion = function (){
			//window.open(ajax.url());
			var response  = ajax.responseXML;
			var error=response.getElementsByTagName('error')[0].firstChild.data;
			switch(error){
				case "session":
					parent.VeryIDE.Alert("warning","文件上传",parent.VeryIDE.loginBox);
				break;
				
				case "file":
					parent.VeryIDE.Alert("warning","文件上传","切图操作失败！<br />未找到图片文件，请检查文件地址是否正确")	;
				break;
				
				case "image":
					parent.VeryIDE.Alert("warning","文件上传","切图操作失败！<br />所选文件不是有效的图片格式")	;
				break;
				
				case "not":
					if(cfg.Preview && $(cfg.Preview)){$(cfg.Preview).src+=+"?"+Math.random();}
				break;
			}
			VeryIDE.Upload.Save(ObjV);	//返回文件
		}
		ajax.send("");
	}else{
		parent.VeryIDE.Alert("warning","文件上传","无法对目标文进行切割！<br />当前文件类型为：."+_Ext+"<br />可以切割的文件类型有：<span class='key'>.jpeg .jpg .gif .png .bmp</span>")	;
		VeryIDE.Upload.Save(ObjV);	//返回文件	
	}
}

//手动切图
VeryIDE.Upload.ImageCorpWindow=function(ObjV){
	var cfg=new VeryIDE.Upload.Config(ObjV);

	var imgCorp=VeryIDE.Manager.corpImageWindow;
	var window='window';
	
	if(cfg.Width && cfg.Height && cfg.ImageSize){
		var _sz=cfg.ImageSize.split("*");
		var _url=imgCorp+'?img='+cfg.Value+'&amp;window='+window+'&amp;img_width='+_sz[0]+'&amp;img_height='+_sz[1]+'&amp;corp_width='+cfg.Width+'&amp;corp_height='+cfg.Height;
		
		parent.VeryIDE.Window('window','处理图片',_url,(parseInt(_sz[0])),(parseInt(_sz[1])+30),false);
	}
	
}

//错误处理
VeryIDE.Upload.Error=function(ObjV,s,i){
	switch(s){
		case 1:
			parent.VeryIDE.Alert("warning","文件上传","上传失败！<br />没有选择需要上传的文件！");
		break;
		
		case 2:
			parent.VeryIDE.Alert("warning","文件上传","上传失败！<br />上传的文件超出系统的限制。");
		break;
		
		case 3:
			parent.VeryIDE.Alert("warning","文件上传",parent.VeryIDE.loginBox);
		break;
		
		case 4:
			parent.VeryIDE.Alert("warning","文件上传",i);
		break;
	}
	//返回开始
	VeryIDE.Upload.InputLock(ObjV,false);
	$(ObjV+"_Form").reset();
}

//上传检查
VeryIDE.Upload.Check=function(ObjV){
	var cfg=new VeryIDE.Upload.Config(ObjV);
	var FileValue=$(ObjV+'_FileValue').value;
	var FileType=cfg.Type;
	var _Up=false;
	
	FileValue=FileValue.replace(/.*\./,"").toLowerCase();
	
	if(FileValue){
		if(FileType.indexOf(";")>-1){
			FileType=FileType.toLowerCase();
			var TypeList=FileType.split(";");
			for(var i=0;i<TypeList.length;i++){
				if(TypeList[i]==FileValue)	{
					_Up=true;break;
				}
			}
		}else{
			if(FileValue==FileType)	{_Up=true;}
		}
		
		if(_Up){
			$(ObjV+"_Form").action=VeryIDE.root+"veryide.upload.php";
			VeryIDE.Upload.InputLock(ObjV,true);
			$(ObjV+"_Form").submit();
		}else{
			parent.VeryIDE.Alert("warning","文件上传","请选择正确的文件类型！<br />支持的文件类型："+FileType+"<br />当前文件类型为："+FileValue,'Alert');
			VeryIDE.Upload.InputLock(ObjV,false);
			$(ObjV+"_Form").reset();
		}
	}
}

//uploading...
VeryIDE.Upload.InputLock=function(ObjV,lock){
	var form=$(ObjV);
	
	//输入框是否只读
	form.readonly=lock;
	
	//提交按钮是否可用
	while(form=form.parentElement){
		if(form.tagName=="FORM"){
			
			var len = form.elements.length;
			for (i=0; i<len; i++){
				var inpElm   = form.elements[i];
				var inpType  = inpElm.getAttribute("type");
				
				if(inpType=="submit"){
					
					if(inpElm.value != "文件上传中.."){
						inpElm.defaultValue = inpElm.value;
					}
					
					if(lock){
						inpElm.value="文件上传中..";
					}else{
						inpElm.value=inpElm.defaultValue;
					}
					
					inpElm.disabled=lock;
					
					break;
				}
			}
			
			break;
		}
	}
}

/*state*/
VeryIDE.script["upload"]=true;