/*
*	Copyright VeryIDE,2007-2009
*	http://www.veryide.com/
*	
*	$Id: veryide.xml.js,v1.2 22:17 2009-6-21 leilei $
*/

if(typeof VeryIDE!='object'){
	var VeryIDE={script:[]}
}

/*
	XSL 转换 XML
	XmlURL	xml文件地址
	XslURL	xsl文件地址
	
	IE	返回  string
	FF	返回  object
 */
VeryIDE.XSLTProcessor=function(XmlURL,XslURL){

	this.xmlURL=XmlURL;
	this.xslURL=XslURL;
	
	this.error="";
	this.resultType="";
	
	this.XSLTSupported=function(){
		if(!window.ActiveXObject){
			try{
				var xmlHttp = window.XMLHttpRequest; 
				var xslProc = window.XSLTProcessor;
				return true;
			}catch(e){
				this.error=e;
				return false;
			}
		}else{
			try{
				var xmlDom = new ActiveXObject('Microsoft.XMLDOM');
				return true;
			}catch(e){
				this.error=e;
				return false;
			}
		}
	}
	
	this.result=function(){
		
		if(this.XSLTSupported()){
			if(!window.ActiveXObject){
				var xmlDoc = document.implementation.createDocument("","",null);
				var xslDoc = document.implementation.createDocument("","",null);
				xmlDoc.async = false;
				xslDoc.async = false;
				xmlDoc.load(this.xmlURL);
				xslDoc.load(this.xslURL);
				var xslProc = new XSLTProcessor();
				xslProc.importStylesheet(xslDoc);
				try{
					this.resultType="object";
					return xslProc.transformToFragment(xmlDoc, document);
				}catch(e){
					this.error=e;
					return null;
				}
			}else{
				var xmlDoc = new ActiveXObject('MSXML2.DOMDocument');
				var xslDoc = new ActiveXObject('MSXML2.DOMDocument');
				xmlDoc.async = false;
				xslDoc.async = false;
				xmlDoc.load(this.xmlURL);
				xslDoc.load(this.xslURL);
				//xmlDoc.documentElement.transformNode(xslDoc)
				try{
					this.resultType="string";
					return xmlDoc.transformNode(xslDoc);
				}catch(e){
					this.error=e;
					return null;
				}
			}
		}else{
			return null;
		}
	}
}

/*state*/
VeryIDE.script["xml"]=true;