<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
*/

!defined('IN_MUDDER') && exit('Access Denied');

class model_datacall extends Base_db {
	
	//public:
	var $cachedir = '';
	var $table = '';
	
	//public:
	function model_datacall($cachedir) {
		parent::__construct();
		$this->cachedir = MUDDER_ROOT . $cachedir . DS;
		$this->table = $this->dbpre . 'datacall';
	}
	
	function & find($where, $orderby, $start=0, $offset=0) {
		$result = array(0,array());
		$total = $this->db->get_value("SELECT COUNT(*) FROM $this->table WHERE $where");
		if($total) {
			$result[0] = $total;
			$limit =  !$start && !$offset ? "" : "LIMIT $start, $offset";
			$result[1] = $this->db->get_all("SELECT * FROM $this->table WHERE $where ORDER BY callid DESC $limit");
		}
		return $result;
	}
	
	function & read($callid, $parse = false) {
		$result = $this->db->get_one("SELECT * FROM $this->table WHERE callid='$callid'");
		if($result && $parse) {
			$result['expression'] = unserialize($result['expression']);
			if($result['calltype'] == 'fun') {
				$result['expression']['params'] = '';
				if(is_array($result['expression'])) foreach($result['expression'] as $key => $val) {
					if(empty($val)) continue;
					if(in_array($key, array('cachetime','row','order'))) continue;
					$datacall['expression']['params'] .= $split.$key.'='.$val;
					$split = "\r\n";
				}
			}
		}
		return $result;
	}
	
	function refresh($callids) {
		$this->deleteCache($callids);
	}

    function find_for_name($name, $selfid=0) {
        $where = "name='$name'";
        if($selfid) $where .= " AND callid!='$selfid'";
        $detail = $this->db->get_one("SELECT * FROM $this->table WHERE $where");
        return $detail;
    }
	
	function post($data, $type, $callid = 0) {
		if($callid) {
			$datacall = $this->read($callid);
			empty($datacall) and $this->redirect('Ŀڡ', 'stop');
		}
        $data['name'] = trim($data['name']);
		empty($data['name']) and $this->redirect('δдƣ뷵д');
        $this->find_for_name($data['name'], $callid) and $this->redirect('Ѵڣ뷵д');
        strpos($data['name'], ' ') and $this->redirect('Ʋпո뷵д');
		$callid = $this->createDatacall($data, $type, $callid);
		$this->updateCache();
		return $callid;
	}
	
	function delete($callids) {
		if(is_array($callids)) {
			$ids = "'".implode("','", $callids)."'";
			$this->db->query("DELETE FROM $this->table WHERE callid IN($ids)");
		}
		$this->deleteCache($callids);
		$this->updateCache();
	}

	function updateCache() {
	    $query = $this->db->query("SELECT * FROM $this->table WHERE closed=0 ORDER BY callid");
	    $result = array();
	    while($row = $this->db->fetch_array($query)) {
	        $row['expression'] = empty($row['expression'])?'':unserialize($row['expression']);
	        $result[$row['callid']] = $row;
	    }
	    $contents = "\$_datacall = ".arrayeval($result).";";
		write_cache('datacall', $contents);
	}
	
	function import($content) {
		global $_VERSION;
		if(!$content) return ;
		$content = str_replace("\r\n", "\r", $content);
		$list = explode("\n", $content);
		if($list[0] != 'MODOER DATACALL EXPORT FILE') {
			$this->redirect('ԲϴĲһЧĵļ');
		} elseif($list[1] != "VERSION:".$_VERSION['version']) {
			$this->redirect('Բϴĵļ뵱ǰİ汾һ¡');
		}elseif(empty($list[2])) {
			$this->redirect('Բϴĵļûݡ');
		}
		$list = explode("\n", base64_decode($list[2]));
		if(empty($list) || count($list)<=1) $this->redirect('Բϴĵļ');
		$sql = "INSERT INTO $this->table ($list[0]) VALUES (%s)";
		unset($list[0]);
		$this->db->query("TRUNCATE TABLE $this->table");
		foreach ($list as $val) {
			if(trim($val)=='') continue;
			$this->db->query(sprintf($sql, $val));
		}
		$this->deleteCache();
		$this->updateCache();
		return count($list);
	}
	
	function export() {
		global $_VERSION;
		$content = "MODOER DATACALL EXPORT FILE\n";
		$content .= "VERSION:$_VERSION[version]\n";
		$content .= base64_encode($this->exportSQL());
		ob_end_clean();
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-cache, must-revalidate');
		header('Pragma: no-cache');
		header('Content-Encoding: none');
		header('Content-Length: '.strlen($content));
		header('Content-Disposition: attachment; filename=modoer_datacall.txt');
		header('Content-Type: '.(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') ? 'application/octetstream' : 
			'application/octet-stream'));
		echo $content;
		exit();
	}

	//private:
	function createDatacall($post, $type, $callid = 0) {
	    $post['calltype'] = $type;
	    if($type == 'sql') {
	        $post['fun'] = 'sql';
	        foreach($post['expression'] as $key => $val) {
	            $post['expression'][$key] = str_replace("\'","'",$val);
	        }
	    } elseif($type == 'fun') {
	        $params = explode("\r\n", preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $post['expression']['params']));
	        foreach($params as $val) {
	            list($key, $value) = explode('=', $val);
	            $post['expression'][$key] = str_replace("\'","'",$value);
	        }
	        unset($params, $post['expression']['params']);
	        $post['hash'] = cacheIdentifier($post['expression']);
	    } else {
	        return;
	    }
	    $post['expression'] = addslashes(serialize($post['expression']));
	    $post['hash'] = cacheIdentifier($post['expression']);

	    if($callid > 0) {
	        $post['callid'] = $callid;
	        $this->db->update_new($this->table, "", $post, 1);
	        // ɾ/ЧĻ
	        deleteDatacallCache($callid);
	    } else {
	        $this->db->insert_new($this->table, $post);
	        $callid = $this->db->insert_id();
	    }
	    return $callid;
	}

	function deleteCache($callids='') {
		if(is_numeric($callids)) $callids = array($callids);
		if(!is_array($callids) && !is_numeric($callids)) return;
		$directory = $this->cachedir;
		if(@$handle = opendir($directory)) {
			$deletefiles = array();
			while (false !== ($file = readdir($handle))) {
				if($file == "." || $file == "..") continue;
				if($force) {
					$deletefiles[] = $file;
				} elseif(is_array($callids) && !empty($callids)) {
					foreach($callids as $callid) {
						if(empty($callid)) continue;
						$pattern = "cache_".$callid."_[0-9a-z]+\\.php";
						if(preg_match('/^'.$pattern.'$/i', $file)) {
							$deletefiles[] = $file;
						}
					}
				} else if(is_numeric($callids) && preg_match("/^cache_".$callids."_[0-9a-z]+\\.php$/i", $file)) {
					$deletefiles[] = $file;
				} else if(preg_match("/^cache_[0-9]+_[0-9a-z]+\\.php$/i", $file)) {
					$deletefiles[] = $file;
				}
			}
			closedir($handle);
		}
		if($deletefiles) {
			foreach($deletefiles as $file) {
				@unlink($directory.$file);
			}
		}
	}

	function exportSQL() {
		$content = '';
		$columns = $this->db->get_all("SHOW COLUMNS FROM $this->table");
		$split = '';
		foreach ($columns as $val) {
			$content .= $split . $val['Field'];
			$split = ',';
		}
		$content .= "\n";
		$query = $this->db->query("SELECT * FROM $this->table ORDER BY callid");
		while ($value = $this->db->fetch_array($query)) {
			$split = '';
			foreach ($value as $_key => $_val) {
				$content .= $split . "'".addslashes($_val)."'";
				$split = ',';
			}
			$content .= "\n";
		}
		$content = str_replace("\\\"","\"",$content);
		return $content;
	}
}
?>