<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
*/
<?php
class dbtable extends Base_db {

    /**
     * ݱ
     * @var string
     */
    var $tablename = '';
    /**
     * 
     */
    var $pk = null;
    /**
     * ֶб
     * @var array()
     */
	var $field = array();
    /**
     * һμµֶϢ
     * @var array()
     */
    var $set = array();
    /**
     * һθ»ɾֶ
     * @var array()
     */
    var $where = array();

    function Table($tablename='',$dbpre='') {
    	global $dbpre;
		parent::__construct();
		if($tablename) {
			$this->setTable($tablename,$dbpre);
		}
    }

    /**
     * ò
     * @param string $tablename
     */
	function setTable($tablename, $dbpre='') {
		$this->tablename = ($dbpre ? $dbpre : $this->dbpre) . $tablename;
	}

    /**
     * ѯݿ
     * @param string $select ѯֶ
     * @param array $where ѯ
     * @param string $orderby 
     * @param int $start ȡʼλ
     * @param int $offset ȡ˭
     * @return array
     */
	function & get($select='*',$where=array(),$orderby="",$start=0,$offset=10) {
		$query = $this->_find($select, $where, $orderby, $start, $offset);
		$result = array();
		while ($row = $this->db->fetch_array($query)) {
			$result[] = $row;
		}
		return $result;
	}

	function & getOne($select='*',$where=array(),$orderby="",$start=0) {
		$query = $this->_find($select,$where,$orderby,$start,1);
		$result = $this->db->fetch_array($query);
		return $result;
	}

	function & getValue($field,$where=array(),$orderby="",$start=0) {
		$query = $this->_find($field,$where,$orderby,$start,1);
		$result = $this->db->result($query,0);
		return $result;
	}
	
	function & getAll($where=array(),$orderby="",$start=0, $offset=10) {
		$result = $this->find($select='*', $where, $orderby, $start, $offset);
		return $result;
	}

    function getCount($where) {
        return $this->findOne('COUNT(*)', $where);
    }

    function insert($insert,$returnInsertID=TRUE,$replace=FALSE) {
		$this->set = $insert;
        if(!is_array($insert) || empty($insert)) {
			return;
		}
		$sqlSet = $sqlSet = $this->_SqlSet($insert);
		$this->_insertBefore();
		$this->db->query(($replace ? "REPLACE" : "INSERT") . " $this->tablename SET $sqlSet");
		$insertID = $returnInsertID ? $this->db->insert_id() : '';
		$this->_insertAfter();
		if($insertID) return $insertID;
	}

	function update($set,$where) {
		$this->set = $set;
        $this->where = $where;
        if(!is_array($set) || empty($set)) {
			return;
		}
		$sqlSet = $this->_SqlSet($set);
		$sqlWhere = '1=1';
		if(is_array($where) && count($where) > 0) {
			$sqlWhere = $this->_SqlWhere($where);
		}

		$this->_updateBefore();
		$this->db->query("UPDATE $this->tablename SET $sqlSet WHERE $sqlWhere");
		$this->_updateAfter();
	}

	function delete($where=array()) {
        $this->where = $where;
		$sqlWhere = '1=1';
		$split = '';
		if(is_array($where) && count($where) > 0) {
			$sqlWhere = $this->_SqlWhere($where);
		}

		$this->_deleteBefore();
		$this->db->query("DELETE FROM $this->tablename WHERE $sqlWhere");
		$this->_deleteAfter();
	}
	
	function isArray($array) {
		return is_array($array) || !empty($array);
	}
	
	function & setFiledValue($update = FALSE) {
		$insert = array();
		if(!$this->isArray($this->field)) return $insert;
		foreach ($this->field as $key => $val) {
			if($val['default'] === "__TIMESTAMP__") {
				$val['default'] = $this->timestamp;
			}
			if($val['pk']) continue;
			if(!isset($_POST[$key])) {
				if($update) continue;
				$insert[$key] = $val['default'];
			} else {
				$value = '';
				switch ($val['type']) {
					case 'float':
						$value = (float)$_POST[$key];
						break;
					case 'int':
						$value = (int)$_POST[$key];
						break;
					case 'text':
						$value = html_special_chars_ex(nl_textarea($_POST[$key]));
					case 'html':
						$value = strip_safe($_POST[$key]);
					default:
						$value = html_special_chars_ex($_POST[$key]);
				}
				$insert[$key] = $value;
			}
		}
		return $insert;
	}

	function & _find($select='*',$where=array(),$orderby="",$start=0,$offset=10) {
		$sqlWhere = '1=1';
		if(is_array($where) && count($where) > 0) {
			$sqlWhere = $this->_SqlWhere($where);
		}
		$orderby = $orderby ? 'ORDER BY '.$orderby : '';
		$limit = $offset ? "LIMIT $start,$offset" : ($start ? "LIMIT $start" : "");
		$result = $this->db->query("SELECT $select FROM $this->tablename WHERE $sqlWhere $orderby
            $limit");
		return $result;
	}

	function _insertBefore() {}

	function _insertAfter() {}

	function _updateBefore() {}

	function _updateAfter() {}

	function _deleteBefore() {}

	function _deleteAfter() {}

	function _SqlWhere(& $where) {
		$sqlWhere = $split = '';
		foreach ($where as $key => $val) {
			if(is_array($val)) {
				$sqlWhere .= $split . "$key IN (".Misc::simplode($val).")";
            } elseif(substr($val, 0, 5) == 'LIKE ') {
                $sqlWhere .= $split . "$key $val ";
            } elseif(preg_match("/^BETWEEN\s+.+\sAND\s+.+$/",$val)) {
            	$sqlWhere =$split . "($key $val) ";
			} else {
				$sqlWhere .= $split . "$key='$val'";
			}
			$split = 'AND ';
		}
        reset($where);
		return $sqlWhere;
	}

	function _SqlSet(& $set) {
		$sqlSet = $split = '';
		foreach ($set as $key => $val) {
			if(preg_match("/^([0-9]+)([\+\-]{2})$/", $val, $match)) {
				$sqlSet .= $split . "$key=$key" . ($match[2] == '++' ? '+' : '-') .  (int)$match[1];
			} else {
				$sqlSet .= $split . "$key='$val'";
			}
			$split = ',';
		}
        reset($set);
		return $sqlSet;
	}
}
?>