<?php
/**
* ͨú
* @author moufer<moufer@163.com>
* @copyright (C)2001-2007 Moufersoft
*/
!defined('IN_MUDDER') && exit('Access Denied');

function add_slashes($string) {
    if(is_array($string))
        foreach($string as $key => $val) $string[$key] = add_slashes($val); 
    else
        $string = is_string($string) ? addslashes($string) : $string;
    return $string;
}

function add_cs_lashes($string) {
    return $string ? addcslashes($string, '\'\\') : '';
}

function authcode($string, $operation = 'DECODE') {
    $string = $operation == 'DECODE' ? base64_decode($string) : base64_encode($string);
    return $string;
}

function new_intval($number) {
    if(is_array($number))
        foreach($number as $key => $val) $number[$key] = new_intval($val); 
    else
        return intval($number);
    return $number;
}

function strip_slashes($string) {
    if(is_array($string))
        foreach($string as $key => $val) $string[$key] = strip_slashes($val); 
    else
        $string = is_string($string) ? stripslashes($string) : $string;
    return $string;
}

function html_special_chars($string) {
    if(is_array($string))
        foreach($string as $key => $val) $string[$key] = html_special_chars($val); 
    else
        $string = is_string($string) ? htmlspecialchars($string, ENT_QUOTES) : $string;
    return $string;
}

function html_special_chars_ex($string) {
    if(is_array($string))
        foreach($string as $key => $val) $string[$key] = html_special_chars_ex($val); 
    else
        $string = is_string($string) ? htmlspecialchars(trim(stripslashes($string)), ENT_QUOTES) : $string;
    return $string;
}

function strip_sql($string) {
    global $pattern_arr, $replace_arr;
    return is_array($string) ? array_map('strip_sql', $string) : preg_replace($pattern_arr, $replace_arr, $string);
}

function strip_order($string) {
    $string = preg_replace('/.?select.+from.+/i', '', $string);
    $string = preg_replace("/.?delete.+from.+/i", "", $string);
    $string = preg_replace("/.?update.+set.+/i", "", $string);
    $string = preg_replace("/.?select.+union.+/i", "", $string);
    return $string;
}

function strip_textarea($string) {
    $search_arr = array(" ","\t");
    $replace_arr = array("&nbsp;","&nbsp;&nbsp;&nbsp;&nbsp;");
    return nl2br(str_replace($search_arr, $replace_arr, html_special_chars($string)));
}

function unite_textarea($string) {
    return trim(preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $string));
}

function nl_textarea($string) {
    return trim(preg_replace("/(\r\n|\n\r|\n|\r)/", "\r\n", $string));
}

function strip_safe($string) {
    $search_arr = array("/(javascript|jscript|js|vbscript|vbs|about):/i","/on(mouse|exit|error|click|dblclick|key|load|unload|change|move|submit|reset|cut|copy|select|start|stop)/i","/<script([^>]*)>/i","/<iframe([^>]*)>/i","/<frame([^>]*)>/i","/<link([^>]*)>/i","/@import/i");
    $replace_arr = array("\\1\n:","on\n\\1","&lt;script\\1&gt;","&lt;iframe\\1&gt;","&lt;frame\\1&gt;","&lt;link\\1&gt;","@\nimport");
    $string = preg_replace($search_arr, $replace_arr, $string);
    $string = str_replace("&#", "&\n#", $string);
    return $string;
}

function sql_quote($value) { 
    $value = stripslashes($value); 
    //check if this function exists 
    if(function_exists("mysql_real_escape_string")) { 
        $value = mysql_real_escape_string($value);
    } else {
        //for PHP version < 4.3.0 use addslashes
        $value = addslashes($value);
    }
    return $value;
}

function cfloat($float) {
    $num = (float)$float;
    return $num;
}

function set_cookie($var, $value, $life = 0, $prefix = 1) {
    global $timestamp, $cookiepre, $cookiepath, $cookiedomain, $_SERVER;
    $life = $life ? ($timestamp + $life) : 0;
    $secure = $_SERVER['SERVER_PORT'] == '443' ? 1 : 0;
    $var = ($prefix ? $cookiepre : '').$var;
    return setcookie($var, $value, $life, $cookiepath, $cookiedomain, $secure);
}

function get_cookie($var) {
    global $cookiepre;
    $var = $cookiepre.$var;
    return isset($_COOKIE[$var]) ? $_COOKIE[$var] : false;
}

function del_cookie($var, $prefix = 1) {
    global $cookiepre;
    if(is_array($var)){
        foreach($var as $val) set_cookie($val, '', -360000, $prefix);
    } else {
        set_cookie($var, '', -360000, $prefix);
    }
}

function clear_cookie() {
    del_cookie(array("uid", "username", "email", "hash", "logintime", "remembertime", "seccode"));
}

// ƶΨһʶ
function cacheIdentifier($params) {
    return substr(md5(serialize($params)),0,8);
}

// ⻺
function check_cache($cachefile, $life = -1) {
    global $timestamp;
    if(file_exists($cachefile)) {
        return $life < 0 || $timestamp - @filemtime($cachefile) < $life;
    } else {
        return false;
    }
}

// ȡ
function read_cache($cachefile, $mode = 'i') {
    if(!file_exists($cachefile)) return false;
    return $mode == 'i' ? include $cachefile : file_get_contents($cachefile);
}

// д뻺
function write_cache($cachename, $cachedata = '', $extra = '', $mod='', $cachedir = '') {
    global $timestamp;

    $cachedir = $cachedir ? MUDDER_ROOT . $cachedir : MUDDER_CACHEDIR;
    if(!$extra) {
        $filename = 'cache_'.$cachename.'.php';
    } elseif($extra == 'js') {
        $filename = $cachename.'.js';
    }
    if(!is_dir($cachedir)) {
        @mkdir($cachedir, 0777);
    }
    $cachefile = $cachedir.$filename;
    if($fp = @fopen($cachefile, 'wb')) {
        if(!$extra && !$mod) {
            @fwrite($fp, "<?php\r\n//Mudder cache file\r\n//Created on ".date('Y-m-d H:i:s', $timestamp)."\r\n\r\n!defined('IN_MUDDER') && exit('Access Denied');\r\n\r\n".$cachedata."\r\n\r\n?>");
        } elseif($extra == 'js') {
            @fwrite($fp, "//Mudder cache file\r\n//Created on ".date('Y-m-d H:i:s', $timestamp)."\r\n\r\n".$cachedata."\r\n");
        } elseif($mod == 'return') {
            @fwrite($fp, "<?php \r\n!defined('IN_MUDDER') && exit('Access Denied');\r\nreturn $cachedata; \r\n?>");
        }
        @fclose($fp);
        @chmod($cachefile, 0777);
    } else {
        echo 'Can not write to '.$cachename.' cache files, please check directory ./data/cache/ .';
        exit;
    }
}

function arrayeval($array, $level = 0) {

    if(!is_array($array)) {
        return "'".$array."'";
    }
    if(is_array($array) && function_exists('var_export')) {
        return var_export($array, true);
    }
    $space = '';
    for($i = 0; $i <= $level; $i++) {
        $space .= "\t";
    }
    $evaluate = "array (\n\r";
    $comma = $space;
    if(is_array($array)) {
        foreach($array as $key => $val) {
            $key = is_string($key) ? '\''.add_cs_lashes($key).'\'' : $key;
            $val = !is_array($val) && (!preg_match("/^\-?[0-9]\d*$/", $val) || strlen($val) > 12) ? '\''.add_cs_lashes($val, '\'\\').'\'' : $val;
            if(is_array($val)) {
                $evaluate .= "$comma$key => ".arrayeval($val, $level + 1);
            } else {
                $evaluate .= "$comma$key => $val";
            }
            $comma = ",\n\r$space";
        }
    }
    $evaluate .= "\n\r$space)";
    return $evaluate;
}

// ͨ
function datacallname($name) {
    global $_datacall;
    foreach($_datacall as $val) {
        if($val['name'] == $name) {
            $callid = $val['callid'];
            break;
        }
    }
    if(!$callid) return '';
    return datacall($callid);
}

// ݵ
function datacall($callid) {
    global $_datacall,$_modules;
    $query = $_datacall[$callid];
    if(empty($query)) return '';
    if(empty($_modules[$query['module']])) return '';
    if($query['calltype']=='sql') {
        $fun = 'datacall_sql';
    } else {
        $fun = 'query_'.$query['fun'];
    }
    $s_var = $query['var'];
    if(empty($s_var)) return '';
    $var = '_QUERY['."\$_datacall['$callid']['var']".']';
    $array = "\$_datacall['$callid']['expression']";
    $restr = "{eval\r\n";
    $restr .= "\$$var = $fun($callid,$array);\r\n\$tmp_template_url = \$template_url;}\r\n";
    $restr .= "{if !empty(\$$var)}\r\n";
    $restr .= "{template \$_datacall['$callid']['tplname'],'1_datacall','./templates/datacall'}\r\n";
    $restr .= "{else}\r\n";
    $restr .= "{template \$_datacall['$callid']['empty_tplname'],'1_datacall','./templates/datacall'}\r\n";
    $restr .= "{/if}\r\n";
    $restr .= "{eval \$template_url = \$tmp_template_url;}\r\n";
    return $restr;
}

// SQLݵ
function datacall_sql($callid, $params) {
    global $db,$dbpre,$_config;

    $params = parseGlobal($params);
    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(file_exists($cachefile) && check_cache($cachefile, $params['cachetime'])) {
        return read_cache($cachefile);
    }
    $result = array();
    $params['from'] = str_replace("{dbpre}", $dbpre, $params['from']);
    $params['where'] = !trim($params['where']) ? '1=1' : $params['where'];
    $params['orderby'] = !trim($params['orderby']) ? '' : " ORDER BY ".$params['orderby'];
    $sql = "SELECT " . $params['select'] . " FROM " . $params['from'] . " WHERE " . $params['where'] . " " . $params['other'] . $params['orderby'] . " LIMIT " . $params['limit'];

    $query = $db->query($sql);
    while($row=$db->fetch_array($query)) {
        $result[] = $row;
    }

    $db->free_result($query);
    if($params['cachetime'] > 0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }
    return $result;
}

// ıʽȡһַӦΪȫֱֵ
function parseGlobal(& $params) {
    if(!is_array($params)||count($params)==0) return $params;
    $gbls = array();
    foreach($params as $key => $val) {
        $match = array();
        if(preg_match_all('/\{\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]+)\}/i', $val, $match)) {
            foreach($match[1] as $_val) {
                if(!in_array($_val, $gbls)) {
                    global $$_val;
                    $gbls[] = $_val;
                    $params[$key] = str_replace('{$'.$_val.'}', $$_val, $params[$key]);
                }
            }
        }
    }
    unset($match,$gbls,$val,$key);
    return $params;
}

function log_read() {
    // do nothing
}

function log_write($file, $log) {
    global $timestamp, $_DCACHE;
    $yearmonth = gmdate('Ym', $timestamp);
    $logdir = MUDDER_ROOT.'./cache/logs/';
    $logfile = $logdir.$yearmonth.'_'.$file.'.php';
    if(@filesize($logfile) > 2048000) {
        $dir = opendir($logdir);
        $length = strlen($file);
        $maxid = $id = 0;
        while($entry = readdir($dir)) {
            if(strexists($entry, $yearmonth.'_'.$file)) {
                $id = intval(substr($entry, $length + 8, -4));
                $id > $maxid && $maxid = $id;
            }
        }
        closedir($dir);

        $logfilebak = $logdir.$yearmonth.'_'.$file.'_'.($maxid + 1).'.php';
        @rename($logfile, $logfilebak);
    }
    if($fp = @fopen($logfile, 'a')) {
        @flock($fp, 2);
        $log = is_array($log) ? $log : array($log);
        foreach($log as $tmp) {
            fwrite($fp, "<?PHP exit;?>\t".str_replace(array('<?', '?>'), '', $tmp)."\n");
        }
        fclose($fp);
    }
}

function trimmed_title($text, $limit=12, $ext='') {
    if ($limit) {
        $val = csubstr($text, 0, $limit);
        return $val[1] ? $val[0].$ext : $val[0];
    } else {
        return $text;
    }
}

function csubstr($text, $start=0, $limit=12) {
    global $charset;
    if (function_exists('mb_substr')) {
        $more = (mb_strlen($text, $charset) > $limit) ? true : false;
        $text = mb_substr($text, 0, $limit, $charset);
        return array($text, $more);
    } elseif (function_exists('iconv_substr')) {
        $more = (iconv_strlen($text) > $limit) ? true : false;
        $text = iconv_substr($text, 0, $limit, $charset);
        return array($text, $more);
    } elseif (strtolower($charset) == "utf-8") {
        preg_match_all("/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/", $text, $ar);
        if(func_num_args() >= 3) {
            if (count($ar[0])>$limit) {
                $more = true;
                $text = join("",array_slice($ar[0],0,$limit))."...";
            } else {
                $more = false;
                $text = join("",array_slice($ar[0],0,$limit));
            }
        } else {
            $more = false;
            $text = join("",array_slice($ar[0],0));
        }
        return array($text, $more);
    } else {
        $fStart = 0;
        $fStart = $fStart * 2; 
        $limit = $limit * 2; 
        $strlen = strlen($text); 
        for ( $i = 0; $i < $strlen; $i++ ) { 
            if ($i >= $fStart && $i < ($fStart + $limit ) ) { 
                if (ord(substr($text, $i, 1)) > 129) $tmpstr .= substr($text, $i, 2); 
                else $tmpstr .= substr($text, $i, 1); 
            } 
            if (ord(substr($text, $i, 1)) > 129 ) $i++; 
        } 
        $more = strlen($tmpstr) < $strlen; 
        return array($tmpstr, $more);
    }
}

function newdate($date, $format='Y-m-d', $dnum=2, $dunit='') {
    global $timestamp;
    $date == 'NOW'||!$date ? $timestamp : $date;
    $date = is_numeric($date) ? $date : (!$date ? $timestamp : strtotime($date));
    $date = ($date == -1 || !$date) ? $timestamp : $date;
    if($format != 'w2style') {
        return date($format, $date);
    } else {
        $tm = $timestamp - $date;
        $num = 0;
        if($tm < 60) {
            $num = $tm;
            $unit = '';
        } elseif($tm < 3600) {
            $num = floor($tm / 60);
            $unit = '';
        } elseif($tm < 3600*24) {
            $num = floor($tm / 3600);
            $unit = 'Сʱ';
        } elseif($tm < 3600*24*30) {
            $num = floor($tm / (3600*24));
            $unit = '';
        } elseif($tm < 3600*24*30*365) {
            $num = floor($tm / (3600*24*30));
            $unit = '';
        }
        if($dnum<=$num && $dunit==$unit) {
            return date('Y-m-d H:i', $date);
        }
        return $num > 0 ? $num.$unit.'ǰ' : date('Y-m-d', $date);
    }
}

function isemail($email) {
    return strlen($email) > 6 && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email);
}

function getIP() {
    //IPַ
    $onlineip = null;
    $onlineipmatches = array();
    if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
        $onlineip = getenv('HTTP_CLIENT_IP');
    } elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
        $onlineip = getenv('HTTP_X_FORWARDED_FOR');
    } elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
        $onlineip = getenv('REMOTE_ADDR');
    } elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] &&
        strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
        $onlineip = $_SERVER['REMOTE_ADDR'];
    }
    $onlineip = addslashes($onlineip);
    @preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
    $onlineip = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
    unset($onlineipmatches);
    return $onlineip;
}

function getCookie() {
    global $cookiepre;
    $prelen = strlen($cookiepre);
    $result = array();
    foreach($_COOKIE as $key => $value) {
        if(substr($key, 0, $prelen) == $cookiepre){
            $var = substr($key, $prelen);
            $result[$var] = $value;
        }
    }
    return $result;
}

function formhash($uid, $username, $password) {
    global $_config;
    return substr(md5($_config['authkey'].$uid.$username.$password), 8, 8);
}

function cdc2dbc($number){
    $search_arr = array('','','','','','','','','','');
    $replace_arr = array('0','1','2','3','4','5','6','7','8','9');
    return str_replace($search_arr, $replace_arr, $number);
}

function return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val{strlen($val)-1});
    switch($last) {
        case 'g':
             $val *= 1024;
        case 'm':
             $val *= 1024;
        case 'k':
             $val *= 1024;
    }
    return $val;
}

function string_length($string, $min, $max) {
    return strlen($string) >= $min && strlen($string) <= $max;
}

function filter_htmltag($string) {
    return preg_replace("/(<\/?[a-zA-Z0-9\s\/]+>)/is", "", $string);
}

function strposex($haystack, $needle, $offset = 0) {
    return !(strpos($haystack, $needle, $offset) === false);
}

function random($length) {
    PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
    $hash = '';
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $max = strlen($chars) - 1;
    for($i = 0; $i < $length; $i++) {
        $hash .= $chars[mt_rand(0, $max)];
    }
    return $hash;
}

function multi($num, $perpage, $curpage, $mpurl, $anchor = '') {
    $multipage = '';
    $mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
    if($num > $perpage) {
        $page = 10;
        $offset = 5;
        $pages = @ceil($num / $perpage);
        if($page > $pages) {
            $from = 1;
            $to = $pages;
        } else {
            $from = $curpage - $offset;
            $to = $curpage + $page - $offset - 1;
            if($from < 1) {
                $to = $curpage + 1 - $from;
                $from = 1;
                if(($to - $from) < $page && ($to - $from) < $pages) {
                    $to = $page;
                }
            } elseif($to > $pages) {
                $from = $curpage - $pages + $to;
                $to = $pages;
                if(($to - $from) < $page && ($to - $from) < $pages) {
                    $from = $pages - $page + 1;
                }
            }
        }
        $multipage = ($curpage - $offset > 1 && $pages > $page ? '<a href="'.$mpurl.'page=1'.$anchor.'" class="p_redirect">&lt;&lt;</a>' : '').($curpage > 1 ? '<a href="'.$mpurl.'page='.($curpage - 1).$anchor.'" class="p_redirect">&lt;</a>' : '');
        for($i = $from; $i <= $to; $i++) {
            $multipage .= $i == $curpage ? '<span class="p_curpage">'.$i.'</span>' : '<a href="'.$mpurl.'page='.$i.$anchor.'" class="p_num">'.$i.'</a>';
        }
        $multipage .= ($curpage < $pages ? '<a href="'.$mpurl.'page='.($curpage + 1).$anchor.'" class="p_redirect">&gt;</a>' : '').($to < $pages ? '<a href="'.$mpurl.'page='.$pages.$anchor.'"class="p_redirect">&gt;&gt;</a>' : '');
        $multipage = $multipage ? '<div class="p_bar"><span class="p_info">'.$num.'</span>'.$multipage.'</div>' : '';
    }
    return $multipage;
}

function multi_w($count, $offset, $page, $mpurl, $anchor = '') {
    $multipage = '';
    $mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';

    $start = ($page-1) * $offset;
    if($start > 1) $multipage .= '<a href="'.$mpurl.'page='.($page-1).'" class="p_redirect">&lt;</a>';
    if($count > 0) $multipage .=  '<span class="p_info">' . ($start + 1) . '~' . ($start + $count) . '</span>';
    if($count >= $offset) $multipage .= '<a href="'.$mpurl.'page='.($page + 1).'" class="p_redirect">&gt;</a>';
    $multipage = $multipage ? '<div class="p_bar">'.$multipage.'</div>' : '';
    return $multipage;
}

function template($file, $templateid='', $tpldir='', $update=FALSE) {
    global $_config, $_templates, $template_dir, $template_url;

    $templateid = $templateid ? $templateid : ($_DCOOKIE['templateid'] ?
        $_DCOOKIE['templateid'] : $_config['templateid']);

    if($templateid != '1' && !isset($_templates['main'][$templateid])) {
        $templateid = '1';
    }

    $template_dir = $_templates['main'][$templateid]['directory'];
    if(substr($template_dir,-1,1) != '/') {
        $template_dir .= '/';
    }

    $template_url = get_url() . substr($template_dir,2);

    $tpldir = $tpldir ? $tpldir : $template_dir;
    $tpldir = substr($tpldir,-1,1) == '/' ? substr($tpldir,0,-1) : $tpldir;

    $cachedir = './data/templates';
    $ext = empty($_config['tplext']) ? '.htm' : $_config['tplext'];
    
    $tplfile = MUDDER_ROOT.$tpldir.'/'.$file.$ext;
    $objfile = MUDDER_ROOT.$cachedir.'/'.$templateid.'_'.$file.'.tpl.php';

    if($update || !file_exists($tplfile) || (@filemtime($tplfile) > @filemtime($objfile))) {
        require_once MUDDER_ROOT.'./include/template.func.php';
        parse_template($file, $templateid, $tpldir, $cachedir, $ext);
    }
    return $objfile;
}

function template_plugin($file) {
    global $pluginmodule;
    $pluginmodule['directory'] = './plugins/'.$pluginmodule['directory'].'templates';
    return template($file, "1_plugin_{$pluginmodule['module']}" ,$pluginmodule['directory']);
}

function spacestyle($file, $space_styleid, $styledir = '') {
    global $_config, $_templates;

    $space_styleid = array_key_exists($space_styleid, $_templates['space']) ? $space_styleid : ($_config['space_styleid'] ? $_config['space_styleid'] : '2');

    $styledir = $styledir ? $styledir : ($_templates['space'][$space_styleid]['directory'] ? $_templates['space'][$space_styleid]['directory'] : './templates/space/default');
    $styledir = substr($styledir,-1,1) == '/' ? substr($styledir,0,-1) : $styledir;

    $cachedir = './data/templates';
    $space_styleid = 'space_'.$space_styleid;

    $ext = empty($_config['tplext']) ? '.htm' : $_config['tplext'];

    $stylefile = MUDDER_ROOT.$styledir.'/'.$file.$ext;
    $objfile = MUDDER_ROOT.$cachedir.'/'.$space_styleid.'_'.$file.'.tpl.php';
    if(!file_exists($objfile) || (@filemtime($stylefile) > @filemtime($objfile))) {
        require_once MUDDER_ROOT.'./include/template.func.php';
        parse_template($file, $space_styleid, $styledir, $cachedir, $ext);
    }
    return $objfile;
}

function itemstyle($file, $styleid) {
    global $_config, $_templates, $itemstyle_url;

    $itemstyle_dir = $_templates['item'][$styleid]['directory'];
    if(substr($itemstyle_dir,-1,1) != '/') {
        $itemstyle_dir .= '/';
    }
    $itemstyle_url = get_url() . substr($itemstyle_dir,2);

    $cachedir = './data/templates';
    $item_styleid = 'item_'.$styleid;
    $ext = empty($_config['tplext']) ? '.htm' : $_config['tplext'];

    $tplfile = MUDDER_ROOT.$itemstyle_dir.'/'.$file.$ext;
    $objfile = MUDDER_ROOT.$cachedir.'/'.$styleid.'_'.$file.'.tpl.php';

    if(!file_exists($objfile) || (@filemtime($tplfile) > @filemtime($objfile))) {
        require_once MUDDER_ROOT.'./include/template.func.php';
        $tpldir = substr($itemstyle_dir,-1,1) == '/' ? substr($itemstyle_dir,0,-1) : $itemstyle_dir;
        parse_template($file, $styleid, $tpldir, $cachedir, $ext);
    }
    return $objfile;
}

function output() {
    global $_config, $_modules, $MOD;
    $output = ob_get_contents();
    ob_end_clean();
    if($_config['rewrite_oldv_ersion']) {
        //ϰ汾ģα̬ʵ
        require_once MUDDER_ROOT . 'include/rewrite.inc.php';
    }
    $_config['gzipcompress'] ? @ob_start('ob_gzhandler') : ob_start();
    echo $output;
    exit;
}

function footer($templateid='', $tpldir='', $extra='') {
    global $db, $mudder_starttime, $_config, $_VERSION, $no_body, $fullalways;
    $fullalways = 1;
    if($_config['debug']){
        $mtime = explode(' ', microtime());
        $totaltime = number_format(($mtime[1] + $mtime[0] - $mudder_starttime), 6);
        $gzip = $_config['gzipcompress'] ? 'enabled' : 'disabled';
        $sitedebug = 'Processed in '.$totaltime.' second(s), '.$db->query_num.' queries, Gzip '.$gzip;
    }
    if($extra == 'space') {
        require_once spacestyle('footer', $templateid, $tpldir);
    } elseif($extra == 'item') {
        require_once itemstyle('footer', $templateid, $tpldir);
    } else {
        require_once template('modoer_footer', $templateid, $tpldir);
    }
    output();
}

function redirect($msg, $url = 'javascript:history.go(-1);', $min = '3') {
    global $charset, $in_ajax;
    if($in_ajax) {
        dialog('ʾ', $msg);
    } elseif(defined("IN_ADMIN")) {
        cpmsg($msg);
    } else {
        require_once template('modoer_redirect');
        output();
    }
}

//ajax ʾ
function dialog($caption, $msg, $extra = '') {
    global $_config,$forward;
    $caption = html_special_chars(trim($caption));
    $msg = trim($msg);
    $search = array('"',"\r\n","\r","\n","\n\r");
    $replace = array('\\"',"{LF}","{LF}","{LF}","{LF}");
    echo '{ caption:"'.$caption.'",message:'.'"'.str_replace($search,$replace,$msg).'"';
    if($extra == 'login') { 
        $url = get_url('member','login.php',array('forward'=>$forward),'',1);
        echo ',extra:"'.$extra.'",url:"'.$url.'" }';
    } elseif($extra == 'mdialog') {
        echo ',extra:"mdialog" }';
    } else {
        echo '}';
    }
    output();
}

// $rewriteǷʹ$rewriteܣfalseǿƲʹãtrueϵͳĬģʽ // δʵ
function location($url, $rewrite = true) {
    global $_config;
    header('Location:' . $url);
}

function check_submit($var, $allowget = 0) {
    if(empty($GLOBALS[$var])) return false;
    if($allowget || ($_SERVER['REQUEST_METHOD'] == 'POST' && (empty($_SERVER['HTTP_REFERER']) ||
            preg_replace("/https?:\/\/([^\:\/]+).*/i", "\\1", $_SERVER['HTTP_REFERER']) == preg_replace("/([^\:]+).*/", "\\1", $_SERVER['HTTP_HOST'])))) {
        return true;
    } else {
        if(defined('IN_ADMIN') && SCRIPTNAV == 'admincp') {
            cpmsg('ЧύΪ');
        } else {
            redirect('ЧύΪ');
        }
    }
}

function diex($msg) {
    global $_config;
    include MUDDER_ROOT.'include/diex.php';
    exit(0);
}

function check_ipaccess($checkip, $accessips) {
    if($accessips && is_array($accessips)) {
        return in_array($checkip, $accessips);
    } else {
        return false;
    }
}

function validKey($id) {
    return is_numeric($id) and $id > 0;
}

function upexpleve($subject, $action='update') {
    global $_config, $db, $dbpre, $user;
    $exp_type = array(
        'reg',
        'addshop',
        'updateshop',
        'addreview',
        'addrespond',
        'addpicture',
        'deletereview',
        'deleterespond',
        'deletepicture',
    );
    if(in_array($subject, $exp_type)) {
        $uppoint = intval(addslashes($_config['expleve'][$subject]['point']));
        $upcoin = intval(addslashes($_config['expleve'][$subject]['coin']));
        $set = "`point`=`point`+$uppoint, `coin`=`coin`+$upcoin";
        $uid = intval($user->uid);
        $sql = "UPDATE {$dbpre}members SET $set WHERE uid='$uid'";
        if($action == 'sqlstr') return $sql;
        elseif($action == 'sqlset') return $set;
        elseif($action == 'update' && $uppoint != 0 && $upcoin != 0) $db->update($sql);
    }
}

function dblimit($page, $offset) {
    if(!$offset || $offset < 1) $offset = 10;
    return array((($page-1) * $offset),$offset);
}

if(!function_exists('http_build_query')) {
   function http_build_query($data, $prefix=null, $sep='', $key='') {
       $ret = array();
           foreach((array)$data as $k => $v) {
               $k    = urlencode($k);
               if(is_int($k) && $prefix != null) {
                   $k    = $prefix.$k;
               }
               if(!empty($key)) {
                   $k    = $key."[".$k."]";
               }

               if(is_array($v) || is_object($v)) {
                   array_push($ret,http_build_query($v,"",$sep,$k));
               }
               else {
                   array_push($ret,$k."=".urlencode($v));
               }
           }
       if(empty($sep)) {
           $sep = ini_get("arg_separator.output");
       }
       return implode($sep, $ret);
   }
}

function create_http_query($array, $pathinfo=FALSE,$check_rewritecompatible=TRUE) {
    global $_config;
    if($check_rewritecompatible) {
        foreach($array as $key => $val) {
            if($_config['rewritecompatible']) {
                $array[$key] = rawurlencode($val);
            }
        }
    }
    $param = str_replace('&amp;', '&', http_build_query($array));
    if($pathinfo) {
        return str_replace(array('&','='), '/', $param);
    }
    return $param;
}

if(!function_exists('file_get_contents')) {
    function file_get_contents($file) {
        if(!@$fp = fopen($file, 'r')) {
            show_error("Could not open file " . (DEBUG?"($file)":"") . "!");
        }
        $content = fread($fp, filesize($file));
        fclose($fp);
        return $content;
    }
}

if(!function_exists('file_put_contents')) {
    function file_put_contents($file, $content) {
        if(!@$fp = fopen($file, 'w')) {
            show_error("The specified file " . (DEBUG?"($file)":"") . "may not exist!");
        }
        flock($fp, 2);
        fwrite($fp, $content, strlen($content));
        fclose($fp);
    }
}

function get_limit($page, $offset) {
    if(!$offset || $offset < 1) $offset = 10;
    return (($page-1) * $offset).', '.$offset;
}

function get_start($page, $offset) {
    if(!$offset || $offset < 1) $offset = 10;
    return ($page-1) * $offset;
}

function get_face($face) {
    global $_config;
    $face = html_special_chars(stripslashes($face));
    if(strpos($face, '|')){
        $param = implode('|', $face);
        $path = $_config['siteurl'].'images/faces/'.$param[1];
    }else{
        $path = $_config['siteurl'].'images/faces/'.$face;
    }
    return $path;
}

// size => source, small, big
function get_picture($folder, $filename, $size='source') {
    global $_config;
    $prefix_arr = array(
        'source' => '',
        'small' => 's_',
        'big' => 'g_'
    );
    $size = array_key_exists($size, $prefix_arr) ? $size : 'source';
    return $_config['siteurl'].'uploads/pictures/'.$folder.'/'.$prefix_arr[$size].$filename;
}

function get_userrank($point,$returnId = false) {
    global $_userranks, $_usergroups;
    if($_userranks) foreach($_userranks as $rankid => $rank) {
        if($point >= $rank['point']){
            return $returnId ? $rankid : $rank['rankname'];
        }
    } else {
        return -1 ? $rankid : 'unknowable';
    }
    return 0 ? $rankid : 'member';
}

function get_item_suitplace($panelcode) {
    global $_panel_config;
    return $_panel_config[$panelcode]['suitplaces'];
}

function get_item_review($panelcode) {
    global $_panel_config;
    return $_panel_config[$panelcode]['review'];
}

function get_module_url($module,$param='url') {
    global $_modules;
    if(isset($_modules[$module])) {
        return $_modules[$module][$param];
    } else {
        return '';
    }
}

function get_menu($flag) {
    global $_menus, $_modules;
    if(!isset($_menus[$flag])) return array();
    $folder = $menu = array();
    foreach ($_menus[$flag] as $value) {
        if($value['isclosed']) continue;
        if($value['isfolder']) {
            $folder[$value['menuid']] = $value['title'];
        } elseif(!$value['module'] || isset($_modules[$value['module']])) {
            $menu[$value['parentid']][] = $value;
        }
    }
    return array($folder,$menu);
}

function get_url($module='modoer',$scriptname='',$param='',$au='',$full=FALSE) {
    global $_modules, $MOD, $_config, $fullalways;

    static $instance = array();
    if(!defined("IN_ADMIN")) {
        $cmod =& $MOD;
    }
    $url = '';
    if($fullalways || $full) $full = TRUE;
    $fullrooturl = isset($_modules[$module]) ? $_modules[$module]['url'] : $_config['siteurl'];
    $rooturl = isset($_modules[$module]) ? ($_modules[$module]['directory'].'/') : '';
    if(isset($cmod) && $cmod['flag'] == $module) {
        $urlpre = $full ? $fullrooturl : '';
    } elseif(isset($cmod)) {
        $urlpre = $full ? $fullrooturl : '../' . $rooturl;
    } else {
        $urlpre = $full ? $fullrooturl : $rooturl;
    }
    if(is_array($param) && $param) {
        $paramstr = $scriptname . '?' . create_http_query($param);
    } elseif(is_string($param) && $param) {
        $paramstr = $scriptname .'?' . $param;
    } else {
        $paramstr = $scriptname;
    }

    //α̬
    if($_config['rewrite'] && isset($_modules[$module])) {
        if(!isset($instance[$module])) {
            $instance[$module] = @read_cache(MUDDER_ROOT.$rooturl.'include/inc_rewrite.php');
        }
        if(!empty($instance[$module]) && is_array($instance[$module])) {
            foreach($instance[$module] as $value) {
                $paramstr = preg_replace("/$value[patterns]$/i", $value['replacement'], $paramstr);
            }
        }
    }

    $au && $austr = '#' . $au;
    return $urlpre . $paramstr . $austr;
}

function url($pathinfo, $au='', $fullurl=FALSE) {

    /* pathinfo exp 
       shop/cate/cd/1001/areacode/1001/streetcode/100101/order/finer/type/normal/offset/20
       ---- ---- -------------------------------------------------------------------------
         |   |_________                             |
         |             |                            |
    |         | |              |          |                  |
    | ģʶ | | ļȥ׺ |          | (/ֵ) |
    |_________| |______________|          |__________________|
    */

    if(strtolower(substr($pathinfo,0,4)) == 'http') {
        return $pathinfo;
    }

    $info = explode("/", $pathinfo);
    if(empty($info)) {
        $module = "modoer";
        $script = "";
    } elseif(count($info) == 1) {
        $module = $info[0];
        $script = "";
    } else {
        $module = $info[0];
        $script = $info[1] . ".php";
        $params = array();
        if(count($info) > 2) {
            for($i=2; $i<count($info); $i++) {
               $params[$info[$i]] = $info[++$i]; 
            }
        }
    }
    
    return get_url($module, $script, $params, $au, $fullurl);
}

function dimplode($array) {
    return "'" . implode("','", $array) . "'";
}

/*
 * Modoer 淶뺯ǰ汾಻ʹãģ鿪ʹ
 */
function load_class($classname, $module='modoer', $instance=FALSE, $static=FALSE, $param = NULL) {
    global $_modules;
    static $instances = array();
    
    $path = '';
    if(isset($_modules[$module])) {
        $path = $_modules[$module]['directory'].DS;
    }
    $cexp = explode('_', $classname);
    $dirext = array(
        'mod' => 'model',
        'lib' => 'lib',        
        'ctl' => 'controller',
        'helper' => 'helper',
    );

    if(in_array($cexp[0], array_keys($dirext))) {
        $path .= $dirext[$cexp[0]];
    } else {
        $path .= 'include';
    }
    unset($cexp[0]);
    $filename = MUDDER_ROOT . $path . DS . implode('_', $cexp) . '.php';

    if(!class_exists($classname)) {
        require($filename);
    }

    /*
    if($instance) {
        if($static) {
            if(!in_array($classname, $instances)) {
                if($param != NULL) {
                    $instances[$classname] = new $classname($param);
                } else {
                    $instances[$classname] = new $classname();
                }
            }
            return & $instances[$classname];
        }
        if($param != NULL) {
            return new $classname($param);
        } else {
            return new $classname();
        }
    }
    */
}

if (!function_exists('json_encode')) {
    function json_encode($value) {
        static $instance = array();
        if (!isset($instance[0])) {
            require_once(MUDDER_ROOT . 'include/json.class.php');
            $instance[0] =& new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
        }
        return $instance[0]->encode($value);
    }
}

if (!function_exists('json_decode')) {
    function json_decode($jsonString) {
        static $instance = array();
        if (!isset($instance[0])) {
            require_once(MUDDER_ROOT . 'include/json.class.php');
            $instance[0] =& new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
        }
        return $instance[0]->decode($jsonString);
    }
}

function vp($var) {
    echo "<div style=\"border:1px solid #ddd;background:#F7F7F7;padding:5px 10px;\">\r\n";
    echo "<pre style=\"font-family:Arial,Vrinda;font-size:14px;\">\r\n";
    var_dump($var);
    echo "\r\n</pre>\r\n";
    echo "</div>";
}

function pr($var) {
    echo "<div style=\"border:1px solid #ddd;background:#F7F7F7;padding:5px 10px;\">\r\n";
    echo "<pre style=\"font-family:Arial,Vrinda;font-size:14px;\">\r\n";
    print_r($var);
    echo "\r\n</pre>\r\n";
    echo "</div>";
}
?>