DROP TABLE IF EXISTS modoer_activity;
CREATE TABLE modoer_activity (
  aid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) NOT NULL DEFAULT '0',
  username varchar(16) NOT NULL DEFAULT '',
  year smallint(4) unsigned NOT NULL DEFAULT '0',
  month smallint(2) unsigned NOT NULL DEFAULT '0',
  reviews int(5) unsigned NOT NULL DEFAULT '0',
  fristreviews int(5) unsigned NOT NULL DEFAULT '0',
  flowers int(5) unsigned NOT NULL DEFAULT '0',
  addshops int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (aid),
  KEY uid (uid),
  KEY datetime (year,month),
  KEY stat (reviews,fristreviews,flowers),
  KEY username (username)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_admin;
CREATE TABLE modoer_admin (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  adminname varchar(24) NOT NULL DEFAULT '',
  password varchar(32) NOT NULL DEFAULT '',
  email varchar(60) NOT NULL DEFAULT '',
  admintype tinyint(3) NOT NULL DEFAULT '0',
  is_founder char(1) NOT NULL DEFAULT 'N',
  logintime int(10) NOT NULL DEFAULT '0',
  loginip varchar(20) NOT NULL DEFAULT '',
  logincount int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  UNIQUE KEY adminname (adminname)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_adminsessions;
CREATE TABLE modoer_adminsessions (
  adminid mediumint(8) unsigned NOT NULL DEFAULT '0',
  ip char(16) NOT NULL DEFAULT '',
  dateline int(10) NOT NULL DEFAULT '0',
  errorcount tinyint(1) NOT NULL DEFAULT '0'
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_ads;
CREATE TABLE modoer_ads (
  adid smallint(5) NOT NULL AUTO_INCREMENT,
  callid smallint(5) unsigned NOT NULL DEFAULT '0',
  subject varchar(60) NOT NULL DEFAULT '',
  adtype tinyint(3) unsigned NOT NULL DEFAULT '1',
  begintime int(10) NOT NULL DEFAULT '0',
  endtime int(10) NOT NULL DEFAULT '0',
  content mediumtext NOT NULL,
  code mediumtext NOT NULL,
  isclosed tinyint(1) NOT NULL DEFAULT '0',
  attr varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (adid)
) TYPE=MyISAM;

INSERT INTO modoer_ads VALUES ('1','28','ҳ߹','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:9:\"img_title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:10:\"AD[250x60]\";}','AD[250x60]','0','1');
INSERT INTO modoer_ads VALUES ('2','29','ҳ','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:9:\"img_title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:10:\"AD[658x60]\";}','AD[658x60]','0','1');
INSERT INTO modoer_ads VALUES ('3','30','ҳ468x60','4','1224172800','2000000000','a:12:{s:10:\"font_title\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:9:\"font_href\";s:0:\"\";s:9:\"img_title\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:9:\"img_width\";s:0:\"\";s:10:\"img_height\";s:0:\"\";s:8:\"img_href\";s:0:\"\";s:9:\"flash_src\";s:0:\"\";s:11:\"flash_width\";s:0:\"\";s:12:\"flash_height\";s:0:\"\";s:4:\"code\";s:10:\"AD[468x60]\";}','AD[468x60]','0','1');

DROP TABLE IF EXISTS modoer_announcements;
CREATE TABLE modoer_announcements (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  title varchar(200) NOT NULL DEFAULT '',
  orders smallint(5) NOT NULL DEFAULT '0',
  content mediumtext NOT NULL,
  author varchar(50) NOT NULL DEFAULT '',
  pageview int(10) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  available tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_areacode;
CREATE TABLE modoer_areacode (
  aid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  areaname varchar(16) NOT NULL DEFAULT '',
  default_mappoint varchar(50) NOT NULL DEFAULT '',
  areacode varchar(8) NOT NULL DEFAULT '',
  areasort tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (aid),
  UNIQUE KEY areacode (areacode,areasort)
) TYPE=MyISAM AUTO_INCREMENT=9;

INSERT INTO modoer_areacode VALUES ('1','','12156014,2987257','10','1');
INSERT INTO modoer_areacode VALUES ('2','','','1001','2');
INSERT INTO modoer_areacode VALUES ('3','һ㳡','','100101','3');
INSERT INTO modoer_areacode VALUES ('4','','','1002','2');
INSERT INTO modoer_areacode VALUES ('5','','','1003','2');
INSERT INTO modoer_areacode VALUES ('6','׹㳡','','100201','3');
INSERT INTO modoer_areacode VALUES ('7','̲','','100301','3');
INSERT INTO modoer_areacode VALUES ('8','۴','','1004','2');

DROP TABLE IF EXISTS modoer_articleclass;
CREATE TABLE modoer_articleclass (
  classid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  classname varchar(20) NOT NULL DEFAULT '',
  displayorder smallint(5) NOT NULL DEFAULT '0',
  articlenum mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (classid)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_articleclass VALUES ('1','ĬϷ','1','0');

DROP TABLE IF EXISTS modoer_articledata;
CREATE TABLE modoer_articledata (
  articleid mediumint(8) unsigned NOT NULL DEFAULT '0',
  content longtext NOT NULL,
  PRIMARY KEY (articleid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_articles;
CREATE TABLE modoer_articles (
  articleid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  classid smallint(5) unsigned NOT NULL DEFAULT '0',
  shopid mediumint(8) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  att tinyint(1) NOT NULL DEFAULT '0',
  uid MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0',
  author varchar(20) NOT NULL DEFAULT '',
  subject varchar(60) NOT NULL DEFAULT '',
  keywords varchar(100) NOT NULL DEFAULT '',
  pageview mediumint(8) unsigned NOT NULL DEFAULT '0',
  digg mediumint(8) NOT NULL DEFAULT '0',
  copyfrom varchar(200) NOT NULL DEFAULT '',
  introduce mediumtext NOT NULL,
  status tinyint(1) NOT NULL DEFAULT '1',
  checker varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (articleid),
  KEY classid (classid),
  KEY shopid (shopid),
  KEY dateline (dateline),
  KEY digg (digg)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_bcastr;
CREATE TABLE modoer_bcastr (
  bcastr_id smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  available tinyint(1) NOT NULL DEFAULT '1',
  itemtitle varchar(100) NOT NULL DEFAULT '',
  link varchar(255) NOT NULL DEFAULT '',
  item_url varchar(255) NOT NULL DEFAULT '',
  orders smallint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (bcastr_id)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_bcastr VALUES ('1','1','Modoerϵͳ','http://www.modoer.com/','/uploads/bcastr/default.jpg','0');

DROP TABLE IF EXISTS modoer_cardapply;
CREATE TABLE modoer_cardapply (
  applyid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL,
  username varchar(20) NOT NULL,
  linkman varchar(20) NOT NULL,
  tel varchar(20) NOT NULL,
  mobile varchar(20) NOT NULL DEFAULT '',
  address varchar(255) NOT NULL DEFAULT '',
  postcode varchar(10) NOT NULL,
  num smallint(5) unsigned NOT NULL DEFAULT '1',
  coin int(10) NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL,
  status tinyint(1) unsigned NOT NULL DEFAULT '1',
  comment text NOT NULL,
  checker varchar(30) NOT NULL,
  checktime int(10) NOT NULL DEFAULT '0',
  checkmsg text NOT NULL,
  PRIMARY KEY (applyid),
  KEY uid (uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_carddiscounts;
CREATE TABLE modoer_carddiscounts (
  shopid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  cardsort enum('both','largess','discount') NOT NULL DEFAULT 'discount',
  discount decimal(4,1) NOT NULL DEFAULT '0.0',
  largess varchar(100) NOT NULL DEFAULT '',
  exception varchar(255) NOT NULL DEFAULT '',
  addtime int(10) unsigned NOT NULL DEFAULT '0',
  available tinyint(1) NOT NULL DEFAULT '1',
  finer tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (shopid),
  KEY shopid (available,cardsort,discount,addtime),
  KEY discount (discount,available),
  KEY finer (finer,available)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_classcode;
CREATE TABLE modoer_classcode (
  cid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  classname varchar(16) NOT NULL DEFAULT '',
  classcode varchar(4) NOT NULL DEFAULT '',
  classsort tinyint(1) NOT NULL DEFAULT '0',
  total int(10) unsigned NOT NULL DEFAULT '0',
  config text NOT NULL,
  classorder smallint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  UNIQUE KEY classcode (classcode)
) TYPE=MyISAM AUTO_INCREMENT=3;

INSERT INTO modoer_classcode VALUES ('1','ʳ͹','10','1','0','a:19:{s:6:\"review\";a:4:{s:5:\"sort1\";s:4:\"ζ\";s:5:\"sort2\";s:4:\"\";s:5:\"sort3\";s:4:\"\";s:5:\"sort4\";s:6:\"Լ۱\";}s:7:\"mapmark\";i:1;s:7:\"catemap\";i:1;s:12:\"catemap_time\";i:5000;s:13:\"catemap_level\";i:0;s:9:\"itemapply\";i:1;s:17:\"itemapply_licence\";i:0;s:9:\"listorder\";s:9:\"sumreview\";s:12:\"tplname_list\";s:9:\"shop_cate\";s:14:\"tplname_detail\";s:10:\"shop_index\";s:13:\"avgprice_need\";i:0;s:16:\"suitplace_enable\";i:1;s:10:\"suitplaces\";s:48:\"Գ\r\nͥۻ\r\nԼ\r\nѾ۲\r\n\";s:9:\"scoretype\";i:10;s:12:\"decimalpoint\";i:1;s:13:\"meta_keywords\";s:46:\"ʳ͹,PHPDP,Moufer,modoer,̼ҵ,̵\";s:16:\"meta_description\";s:34:\"phpԴModoer๦ܵϵͳ,mudder\";s:9:\"video_url\";s:0:\"\";s:10:\"alowupload\";N;}','0');
INSERT INTO modoer_classcode VALUES ('2','','1001','2','0','','2');

DROP TABLE IF EXISTS modoer_config;
CREATE TABLE modoer_config (
  variable varchar(32) NOT NULL DEFAULT '',
  value text NOT NULL,
  PRIMARY KEY (variable)
) TYPE=MyISAM;

INSERT INTO modoer_config VALUES ('adminipaccess','');
INSERT INTO modoer_config VALUES ('auditing','a:5:{s:7:\"addshop\";s:1:\"0\";s:9:\"addreview\";s:1:\"0\";s:10:\"addrespond\";s:1:\"0\";s:13:\"uploadpicture\";s:1:\"0\";s:8:\"auditing\";i:0;}');
INSERT INTO modoer_config VALUES ('rewritecompatible','0');
INSERT INTO modoer_config VALUES ('titlesplit',',');
INSERT INTO modoer_config VALUES ('censoruser','**\r\n*Ա*\r\nadmin*');
INSERT INTO modoer_config VALUES ('closenote','վ...Ժ...');
INSERT INTO modoer_config VALUES ('closereg','0');
INSERT INTO modoer_config VALUES ('debug','1');
INSERT INTO modoer_config VALUES ('default_city','10');
INSERT INTO modoer_config VALUES ('dpdetail_reviewnumber','5');
INSERT INTO modoer_config VALUES ('dpnewreviewnumber','');
INSERT INTO modoer_config VALUES ('dpreviewnumber','10');
INSERT INTO modoer_config VALUES ('dpreview_respondnumber','10');
INSERT INTO modoer_config VALUES ('dpshopnumber','10');
INSERT INTO modoer_config VALUES ('existsemailreg','0');
INSERT INTO modoer_config VALUES ('expleve','a:10:{s:3:\"reg\";a:2:{s:5:\"point\";i:1;s:4:\"coin\";i:2;}s:7:\"addshop\";a:2:{s:5:\"point\";i:20;s:4:\"coin\";i:5;}s:10:\"updateshop\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:2;}s:9:\"addreview\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:3;}s:10:\"addrespond\";a:2:{s:5:\"point\";i:3;s:4:\"coin\";i:0;}s:10:\"addpicture\";a:2:{s:5:\"point\";i:8;s:4:\"coin\";i:2;}s:10:\"deleteshop\";a:2:{s:5:\"point\";i:20;s:4:\"coin\";i:5;}s:12:\"deletereview\";a:2:{s:5:\"point\";i:10;s:4:\"coin\";i:2;}s:13:\"deleterespond\";a:2:{s:5:\"point\";i:3;s:4:\"coin\";i:0;}s:13:\"deletepicture\";a:2:{s:5:\"point\";i:8;s:4:\"coin\";i:2;}}');
INSERT INTO modoer_config VALUES ('gzipcompress','0');
INSERT INTO modoer_config VALUES ('headhtml','');
INSERT INTO modoer_config VALUES ('icpno','');
INSERT INTO modoer_config VALUES ('meta_description','phpԴ๦ܵϵͳ');
INSERT INTO modoer_config VALUES ('meta_keywords','php,mudder,ϵͳ');
INSERT INTO modoer_config VALUES ('newreview_classcode','10');
INSERT INTO modoer_config VALUES ('picture_thumb','a:2:{s:5:\"small\";a:2:{s:5:\"width\";i:88;s:6:\"height\";i:67;}s:3:\"big\";a:2:{s:5:\"width\";i:124;s:6:\"height\";i:94;}}');
INSERT INTO modoer_config VALUES ('picture_upload_size','600');
INSERT INTO modoer_config VALUES ('salutatory','1');
INSERT INTO modoer_config VALUES ('siteclose','0');
INSERT INTO modoer_config VALUES ('sitename','Modoerϵͳ');
INSERT INTO modoer_config VALUES ('space','a:8:{s:11:\"recordguest\";i:1;s:9:\"spacename\";s:0:\"\";s:13:\"spacedescribe\";s:0:\"\";s:13:\"index_reviews\";i:5;s:12:\"index_gbooks\";i:5;s:7:\"reviews\";i:10;s:6:\"gbooks\";i:10;s:7:\"friends\";i:10;}');
INSERT INTO modoer_config VALUES ('subname','PHP๦ܵϵͳ');
INSERT INTO modoer_config VALUES ('templateid','1');
INSERT INTO modoer_config VALUES ('templatemenu','0');
INSERT INTO modoer_config VALUES ('useripaccess','');
INSERT INTO modoer_config VALUES ('watermark','0');
INSERT INTO modoer_config VALUES ('mspaceid','1');
INSERT INTO modoer_config VALUES ('space_styleid','0');
INSERT INTO modoer_config VALUES ('jstransfer','1');
INSERT INTO modoer_config VALUES ('jsaccess','');
INSERT INTO modoer_config VALUES ('default_panel','10');
INSERT INTO modoer_config VALUES ('inputlimit','a:2:{s:6:\"review\";a:2:{s:3:\"min\";i:20;s:3:\"max\";i:1000;}s:7:\"respond\";a:2:{s:3:\"min\";i:5;s:3:\"max\";i:300;}}');
INSERT INTO modoer_config VALUES ('seccode','a:5:{s:5:\"login\";i:0;s:8:\"registry\";i:0;s:9:\"newreview\";i:0;s:7:\"newshop\";i:0;s:10:\"adminlogin\";i:0;}');
INSERT INTO modoer_config VALUES ('search','a:4:{s:5:\"limit\";i:0;s:6:\"maxspm\";i:0;s:10:\"maxresults\";i:5000;s:9:\"cachelife\";i:3600;}');
INSERT INTO modoer_config VALUES ('shopthumb','1');
INSERT INTO modoer_config VALUES ('rewrite','0');
INSERT INTO modoer_config VALUES ('classorder','total');
INSERT INTO modoer_config VALUES ('thumbdisplay','fixed');
INSERT INTO modoer_config VALUES ('video','a:2:{s:5:\"width\";i:258;s:6:\"height\";i:200;}');
INSERT INTO modoer_config VALUES ('googlesearch','a:2:{s:6:\"enable\";i:1;s:7:\"website\";s:10:\"modoer.com\";}');
INSERT INTO modoer_config VALUES ('detail_allthumb_enable','1');
INSERT INTO modoer_config VALUES ('detail_allthumb_sort','big');
INSERT INTO modoer_config VALUES ('salutatory_msg','ã$username\r\n\r\nǳModoerϵͳʾվ\r\n\r\nModoerŶ\r\n$time');
INSERT INTO modoer_config VALUES ('item_styleid','0');
INSERT INTO modoer_config VALUES ('tplext','.htm');
INSERT INTO modoer_config VALUES ('showregrule','1');
INSERT INTO modoer_config VALUES ('regrule','עЭ');
INSERT INTO modoer_config VALUES ('ban_ip','');
INSERT INTO modoer_config VALUES ('jscachelife','600');

DROP TABLE IF EXISTS modoer_coupons;
CREATE TABLE modoer_coupons (
  couponid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) NOT NULL DEFAULT '0',
  username varchar(30) NOT NULL DEFAULT '',
  thumb varchar(255) NOT NULL DEFAULT '',
  picture varchar(255) NOT NULL DEFAULT '',
  starttime int(10) NOT NULL DEFAULT '0',
  endtime int(10) NOT NULL DEFAULT '0',
  subject varchar(100) NOT NULL DEFAULT '',
  des varchar(50) NOT NULL DEFAULT '',
  content text NOT NULL,
  effect1 mediumint(8) unsigned NOT NULL DEFAULT '0',
  flag tinyint(1) unsigned NOT NULL DEFAULT '1',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  pageview int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (couponid),
  KEY shopid (shopid),
  KEY uid (uid),
  KEY dateline (dateline)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_datacall;
CREATE TABLE modoer_datacall (
  callid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  module varchar(60) NOT NULL DEFAULT '',
  calltype varchar(60) NOT NULL DEFAULT '',
  name varchar(50) NOT NULL DEFAULT '',
  fun varchar(60) NOT NULL DEFAULT '',
  var varchar(60) NOT NULL DEFAULT '',
  expression text NOT NULL,
  tplname varchar(200) NOT NULL DEFAULT '',
  empty_tplname varchar(200) NOT NULL DEFAULT '',
  closed tinyint(1) unsigned NOT NULL DEFAULT '0',
  hash varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (callid)
) TYPE=MyISAM AUTO_INCREMENT=1001;

INSERT INTO modoer_datacall VALUES ('1','shop','fun','ҳ_µ','reviews','review','a:4:{s:9:\"cachetime\";s:3:\"600\";s:3:\"row\";s:1:\"3\";s:5:\"order\";s:13:\"posttime DESC\";s:8:\"showitem\";s:1:\"1\";}','index_reviews','empty_li','0','fae7b7b9');
INSERT INTO modoer_datacall VALUES ('2','coupon','fun','Żȯ_Żȯ','coupon','coupon_hot','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.effect1 DESC\";s:0:\"\";s:0:\"\";}','coupon_hot_li','empty_li','0','185ee4fd');
INSERT INTO modoer_datacall VALUES ('3','coupon','fun','Żȯ_·','coupon','coupon_new','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:15:\"c.dateline DESC\";s:0:\"\";s:0:\"\";}','coupon_new_li','empty_li','0','a06ee56a');
INSERT INTO modoer_datacall VALUES ('4','coupon','fun','Żȯ_','coupon','coupon_other_hot','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.effect1 DESC\";s:0:\"\";s:0:\"\";}','coupon_other_li','empty_li','0','185ee4fd');
INSERT INTO modoer_datacall VALUES ('5','article','fun','ҳ_Ѷ_Ƽ','article','articles','a:4:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','index_article_li','empty_li','0','f22c72d6');
INSERT INTO modoer_datacall VALUES ('6','article','fun','ҳ_Ѷ_ע','article','articles','a:4:{s:9:\"cachetime\";s:4:\"3100\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:9:\"digg DESC\";s:4:\"digg\";s:1:\"1\";}','index_article_li','empty_li','0','3033649c');
INSERT INTO modoer_datacall VALUES ('7','article','fun','ҳ_Ѷ_','article','articles','a:4:{s:9:\"cachetime\";s:4:\"1200\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:0:\"\";N;}','index_article_li','empty_li','0','2e2240c3');
INSERT INTO modoer_datacall VALUES ('8','shop','fun','ҳ_','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"20\";s:5:\"order\";s:12:\"reviews DESC\";s:4:\"rand\";s:2:\"10\";}','index_item_li','empty_li','0','9fda696e');
INSERT INTO modoer_datacall VALUES ('9','shop','fun','ҳ_','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:12:\"addtime DESC\";s:0:\"\";N;}','index_item_li','empty_li','0','317c307b');
INSERT INTO modoer_datacall VALUES ('10','shop','fun','ҳ_Ƽ','items','items','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:10:\"finer DESC\";s:5:\"finer\";s:1:\"1\";}','index_item_finer_li','empty_li','0','f7c7d9d5');
INSERT INTO modoer_datacall VALUES ('11','card','fun','ҳ_Ա','cards','cards','a:4:{s:9:\"cachetime\";s:4:\"2000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"c.addtime DESC\";s:0:\"\";N;}','index_item_card_li','empty_li','0','1c7b3994');
INSERT INTO modoer_datacall VALUES ('12','member','fun','Ա_ר','members','members','a:4:{s:9:\"cachetime\";s:4:\"1000\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:10:\"point DESC\";s:7:\"groupid\";s:2:\"10\";}','member_face_li','empty_li','0','486cebf2');
INSERT INTO modoer_datacall VALUES ('13','member','fun','Ա_¼','members','members','a:4:{s:9:\"cachetime\";s:3:\"800\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:12:\"regdate DESC\";s:7:\"groupid\";s:2:\"10\";}','member_face_li','empty_li','0','2f8ddd92');
INSERT INTO modoer_datacall VALUES ('14','member','fun','Ա_ԾԱ','members','members','a:4:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:1:\"9\";s:5:\"order\";s:14:\"m.reviews DESC\";s:6:\"active\";s:1:\"1\";}','member_face_li','empty_li','0','ef749339');
INSERT INTO modoer_datacall VALUES ('15','member','fun','Ա_Ƹ','members','members','a:4:{s:9:\"cachetime\";s:4:\"2000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:9:\"coin DESC\";s:7:\"groupid\";s:2:\"10\";}','member_smallface_li','empty_li','0','8f6034fd');
INSERT INTO modoer_datacall VALUES ('16','space','sql','ҳ_˿ռ','sql','spaces','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:13:\"{dbpre}spaces\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:12:\"pageview>\'0\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:13:\"pageview DESC\";s:5:\"limit\";s:4:\"0,10\";}','index_space_li','empty_li','0','0539c971');
INSERT INTO modoer_datacall VALUES ('17','exchange','sql','ҳ_һƷ','sql','gifts','a:7:{s:9:\"cachetime\";s:4:\"3000\";s:4:\"from\";s:12:\"{dbpre}gifts\";s:6:\"select\";s:38:\"giftid,name,price,num,thumb,salevolume\";s:5:\"where\";s:11:\"available=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"displayorder\";s:5:\"limit\";s:3:\"0,3\";}','index_gitf_div','empty_li','0','2a6486d6');
INSERT INTO modoer_datacall VALUES ('18','exchange','sql','ҽ_¶һ_ۺ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"6000\";s:4:\"from\";s:15:\"{dbpre}exchange\";s:6:\"select\";s:30:\"exchangeid,uid,giftid,giftname\";s:5:\"where\";s:17:\"status IN (1,2,3)\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:17:\"exchangetime DESC\";s:5:\"limit\";s:4:\"0,10\";}','exchange_new_li','empty_li','0','f0298c38');
INSERT INTO modoer_datacall VALUES ('19','exchange','sql','ҽ_Ŷһ_ۺ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"8000\";s:4:\"from\";s:12:\"{dbpre}gifts\";s:6:\"select\";s:28:\"giftid,name,salevolume,thumb\";s:5:\"where\";s:28:\"salevolume>0 AND available=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:15:\"salevolume DESC\";s:5:\"limit\";s:4:\"0,10\";}','exchange_hot_li','empty_li','0','ad0c6c32');
INSERT INTO modoer_datacall VALUES ('20','shop','sql','ҳ_űǩ','sql','tags','a:7:{s:9:\"cachetime\";s:5:\"10000\";s:4:\"from\";s:11:\"{dbpre}tags\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:20:\"closed=0 AND total>0\";s:5:\"other\";s:16:\"GROUP BY tagname\";s:7:\"orderby\";s:10:\"total DESC\";s:5:\"limit\";s:4:\"0,20\";}','index_tag_li','empty_li','0','a51f8e9f');
INSERT INTO modoer_datacall VALUES ('21','shop','sql','ͷ_','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"7200\";s:4:\"from\";s:18:\"{dbpre}searchindex\";s:6:\"select\";s:34:\"max(searchid) as searchid, keyword\";s:5:\"where\";s:7:\"total>0\";s:5:\"other\";s:16:\"GROUP BY keyword\";s:7:\"orderby\";s:8:\"searchid\";s:5:\"limit\";s:3:\"0,5\";}','header_hotsearch','empty','0','50af0baf');
INSERT INTO modoer_datacall VALUES ('40','shop','fun','cateҳ','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:14:\"pageviews DESC\";s:9:\"panelcode\";s:5:\"{$cd}\";}','shop_cate_hotshop_li','empty_li','0','a7773092');
INSERT INTO modoer_datacall VALUES ('41','shop','fun','ϸҳ_ϢĻԱб','uplog','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"posttime DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','shop_detail_uplog_li','empty','0','93cf3f08');
INSERT INTO modoer_datacall VALUES ('39','shop','sql','cateҳŷ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"8000\";s:4:\"from\";s:16:\"{dbpre}classcode\";s:6:\"select\";s:29:\"cid,classname,classcode,total\";s:5:\"where\";s:57:\"(classcode BETWEEN \'{$pcd}00\' AND \'{$pcd}99\') AND total>0\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:10:\"total DESC\";s:5:\"limit\";s:4:\"0,10\";}','shop_cate_hotclass_li','empty_li','0','4b3821cc');
INSERT INTO modoer_datacall VALUES ('28','ads','sql','ҳ߹','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'1\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','327f5b96');
INSERT INTO modoer_datacall VALUES ('30','ads','sql','ҳ468x60','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'3\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','a492875a');
INSERT INTO modoer_datacall VALUES ('29','ads','sql','ҳ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"5000\";s:4:\"from\";s:10:\"{dbpre}ads\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:8:\"adid=\'2\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:4:\"adid\";s:5:\"limit\";s:3:\"0,1\";}','ad_div','empty_ad_div','0','5349a93f');
INSERT INTO modoer_datacall VALUES ('46','article','fun','б_ĿƼ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_list_li','empty_li','0','f6e3dd49');
INSERT INTO modoer_datacall VALUES ('47','links','fun','б_Ŀ·','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"3000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:7:\"classid\";s:10:\"{$classid}\";}','article_list_li','empty_li','0','e5b715f5');
INSERT INTO modoer_datacall VALUES ('45','article','fun','ϸҳ_Ѷ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"4000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','shop_cate_article_li','empty_li','0','a6172bec');
INSERT INTO modoer_datacall VALUES ('44','shop','fun','ϸҳ_','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:1:\"5\";s:5:\"order\";s:12:\"reviews DESC\";s:10:\"streetcode\";s:13:\"{$streetcode}\";}','shop_detail_shop_li','empty_li','0','8b97a09b');
INSERT INTO modoer_datacall VALUES ('42','shop','fun','ϸҳ_ȫֵб','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"50\";s:5:\"order\";s:12:\"reviews DESC\";s:8:\"shopname\";s:11:\"{$shopname}\";}','shop_detail_shop_li','empty_li','0','63163f44');
INSERT INTO modoer_datacall VALUES ('43','shop','fun','ϸҳ_ͬ','items','mydata','a:4:{s:9:\"cachetime\";s:4:\"8500\";s:3:\"row\";s:1:\"5\";s:5:\"order\";s:12:\"reviews DESC\";s:9:\"panelcode\";s:14:\"$sameclasscode\";}','shop_detail_shop_li','empty_li','0','8fb15040');
INSERT INTO modoer_datacall VALUES ('48','article','fun','б_Ŀ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"6000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:7:\"classid\";s:10:\"{$classid}\";}','article_list_li','empty_li','0','4598f822');
INSERT INTO modoer_datacall VALUES ('49','article','fun','б_Ƽ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_list_li','empty_li','0','f6e3dd49');
INSERT INTO modoer_datacall VALUES ('50','article','fun','б_·','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"4000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:0:\"\";s:0:\"\";}','article_list_li','empty_li','0','e18b9f4b');
INSERT INTO modoer_datacall VALUES ('51','article','fun','б_','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:0:\"\";s:0:\"\";}','article_list_li','empty_li','0','6473141e');
INSERT INTO modoer_datacall VALUES ('52','article','fun','_ƼѶ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"6000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:3:\"att\";s:1:\"1\";}','article_detail_list_li','empty_li','0','db09f991');
INSERT INTO modoer_datacall VALUES ('53','article','fun','_Ѷ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"8000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:0:\"\";s:0:\"\";}','article_detail_list_li','empty_li','0','f94d2a2f');
INSERT INTO modoer_datacall VALUES ('54','article','fun','Ѷ_','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"5000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"pageview DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','article_list_li','empty_li','0','0dc2d6d2');
INSERT INTO modoer_datacall VALUES ('55','article','fun','Ѷ_Ѷ','article','mydata','a:4:{s:9:\"cachetime\";s:4:\"7000\";s:3:\"row\";s:2:\"10\";s:5:\"order\";s:13:\"dateline DESC\";s:6:\"shopid\";s:9:\"{$shopid}\";}','article_detail_list_li','empty_li','0','92854581');
INSERT INTO modoer_datacall VALUES ('56','shop','sql','ҳ_ϴ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:15:\"{dbpre}pictures\";s:6:\"select\";s:40:\"pid,shopid,title,folder,filename,addtime\";s:5:\"where\";s:8:\"status=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"addtime DESC\";s:5:\"limit\";s:3:\"0,5\";}','index_item_newpic','empty','0','758f50ca');
INSERT INTO modoer_datacall VALUES ('57','coupon','sql','Żȯ_̲','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:14:\"{dbpre}coupons\";s:6:\"select\";s:1:\"*\";s:5:\"where\";s:47:\"shopid=\'{$shopid}\' AND endtime>UNIX_TIMESTAMP()\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:8:\"dateline\";s:5:\"limit\";s:4:\"0,10\";}','coupon_shop_li','empty_li','0','8f742ad0');
INSERT INTO modoer_datacall VALUES ('58','shop','sql','бҳ__ȥ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:65:\"{dbpre}shopeffect se LEFT JOIN {dbpre}shops s ON(se.shopid=s.sid)\";s:6:\"select\";s:25:\"s.shopname,s.subname,se.*\";s:5:\"where\";s:57:\"effect1>0 AND classcode BETWEEN \'{$pcd}00\' AND \'{$pcd}99\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"effect1 DESC\";s:5:\"limit\";s:4:\"0,10\";}','shop_cate_effect1_li','empty_li','0','294428bd');
INSERT INTO modoer_datacall VALUES ('59','shop','sql','бҳ__ȥ','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:65:\"{dbpre}shopeffect se LEFT JOIN {dbpre}shops s ON(se.shopid=s.sid)\";s:6:\"select\";s:25:\"s.shopname,s.subname,se.*\";s:5:\"where\";s:57:\"effect2>0 AND classcode BETWEEN \'{$pcd}00\' AND \'{$pcd}99\'\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:12:\"effect2 DESC\";s:5:\"limit\";s:4:\"0,10\";}','shop_cate_effect2_li','empty_li','0','13ae1945');
INSERT INTO modoer_datacall VALUES ('60','card','sql','Ա_','sql','mydata','a:7:{s:9:\"cachetime\";s:4:\"1000\";s:4:\"from\";s:16:\"{dbpre}cardapply\";s:6:\"select\";s:43:\"applyid,uid,username,num,dateline,checktime\";s:5:\"where\";s:8:\"status=1\";s:5:\"other\";s:0:\"\";s:7:\"orderby\";s:14:\"checktime DESC\";s:5:\"limit\";s:4:\"0,10\";}','card_newapply_li','empty_li','0','c1505847');

DROP TABLE IF EXISTS modoer_exchange;
CREATE TABLE modoer_exchange (
  exchangeid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  giftid mediumint(8) unsigned NOT NULL DEFAULT '0',
  giftname varchar(200) NOT NULL DEFAULT '',
  price int(10) unsigned NOT NULL DEFAULT '0',
  number int(10) unsigned NOT NULL DEFAULT '1',
  status tinyint(1) NOT NULL DEFAULT '1',
  status_extra varchar(255) NOT NULL DEFAULT '',
  exchangetime int(10) NOT NULL DEFAULT '0',
  contact mediumtext NOT NULL,
  checker varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (exchangeid),
  KEY uid (uid,status),
  KEY giftid (giftid,giftname,status),
  KEY status (status,exchangetime),
  KEY number (number,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_favorites;
CREATE TABLE modoer_favorites (
  fid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  addtime int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (fid),
  KEY shopid (shopid),
  KEY addtime (addtime),
  KEY uid (uid,addtime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_flowers;
CREATE TABLE modoer_flowers (
  fid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  reviewid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (fid),
  KEY reviewid (reviewid),
  KEY uid (uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_friends;
CREATE TABLE modoer_friends (
  fid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  fuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  fusername varchar(16) NOT NULL DEFAULT '',
  addtime int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (fid),
  KEY addtime (addtime,uid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_gbooks;
CREATE TABLE modoer_gbooks (
  gid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  gbuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  gbusername varchar(16) NOT NULL DEFAULT '',
  content text NOT NULL,
  posttime int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (gid),
  KEY uid (uid,posttime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_getpassword;
CREATE TABLE modoer_getpassword (
  getpwid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  secode varchar(8) NOT NULL DEFAULT '',
  posttime int(10) NOT NULL DEFAULT '0',
  status tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (getpwid),
  KEY secode (secode,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_gifts;
CREATE TABLE modoer_gifts (
  giftid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  name varchar(200) NOT NULL DEFAULT '',
  available tinyint(1) NOT NULL DEFAULT '0',
  displayorder tinyint(3) NOT NULL DEFAULT '0',
  description text NOT NULL,
  price int(10) unsigned NOT NULL DEFAULT '0',
  num int(10) unsigned NOT NULL DEFAULT '0',
  thumb varchar(255) NOT NULL DEFAULT '',
  picture varchar(255) NOT NULL DEFAULT '',
  salevolume int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (giftid),
  KEY available (available)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_guestbook;
CREATE TABLE modoer_guestbook (
  guestbookid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  id mediumint(8) NOT NULL,
  idtype varchar(10) NOT NULL,
  username varchar(20) NOT NULL,
  uid mediumint(9) unsigned NOT NULL,
  dateline int(10) unsigned NOT NULL,
  content text NOT NULL,
  reply text NOT NULL,
  replytime int(10) NOT NULL,
  PRIMARY KEY (guestbookid),
  KEY id (id,idtype)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_itemapply;
CREATE TABLE modoer_itemapply (
  applyid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(20) NOT NULL DEFAULT '',
  status tinyint(1) unsigned NOT NULL DEFAULT '2',
  applyname varchar(100) NOT NULL DEFAULT '',
  contact varchar(255) NOT NULL DEFAULT '',
  pic varchar(255) NOT NULL DEFAULT '',
  content mediumtext NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  checker varchar(30) NOT NULL DEFAULT '',
  returned text NOT NULL,
  PRIMARY KEY (applyid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_membereffect;
CREATE TABLE modoer_membereffect (
  id mediumint(8) unsigned NOT NULL DEFAULT '0',
  idtype varchar(15) NOT NULL DEFAULT '',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(20) NOT NULL DEFAULT '',
  dateline int(10) NOT NULL DEFAULT '0',
  effect1 tinyint(1) unsigned NOT NULL DEFAULT '0',
  effect2 tinyint(1) unsigned NOT NULL DEFAULT '0',
  KEY id (id,idtype)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_members;
CREATE TABLE modoer_members (
  uid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  email varchar(60) NOT NULL DEFAULT '',
  password varchar(32) NOT NULL DEFAULT '',
  username varchar(16) NOT NULL DEFAULT '',
  face varchar(32) NOT NULL DEFAULT 'noface.gif',
  point int(10) NOT NULL DEFAULT '0',
  coin int(10) NOT NULL DEFAULT '0',
  newmsg smallint(5) unsigned NOT NULL DEFAULT '0',
  regdate int(10) unsigned NOT NULL DEFAULT '0',
  logintime int(10) unsigned NOT NULL DEFAULT '0',
  loginip varchar(16) NOT NULL DEFAULT '',
  logincount mediumint(8) unsigned NOT NULL DEFAULT '0',
  groupid smallint(2) NOT NULL DEFAULT '1',
  addshops int(10) unsigned NOT NULL DEFAULT '0',
  reviews int(10) unsigned NOT NULL DEFAULT '0',
  responds int(10) unsigned NOT NULL DEFAULT '0',
  flowers int(10) unsigned NOT NULL DEFAULT '0',
  pictures int(10) unsigned NOT NULL DEFAULT '0',
  favorites int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (uid),
  UNIQUE KEY username (username),
  KEY email (email),
  KEY groupid (groupid),
  KEY point (point),
  KEY coin (coin)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_menus;
CREATE TABLE modoer_menus (
  menuid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  parentid smallint(5) unsigned NOT NULL DEFAULT '0',
  module varchar(30) NOT NULL,
  isclosed tinyint(1) NOT NULL DEFAULT '0',
  groupname varchar(30) NOT NULL,
  isfolder tinyint(1) unsigned NOT NULL DEFAULT '0',
  clicks int(10) unsigned NOT NULL DEFAULT '0',
  title varchar(100) NOT NULL DEFAULT '',
  scriptnav varchar(60) NOT NULL DEFAULT '',
  mkey varchar(60) NOT NULL DEFAULT '',
  url varchar(255) NOT NULL DEFAULT '',
  icon varchar(60) NOT NULL DEFAULT '',
  listorder smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (menuid)
) TYPE=MyISAM AUTO_INCREMENT=37;

INSERT INTO modoer_menus VALUES ('7','0','','0','website','0','0','MODOER','','','http://bbs.modoer.com/','menu_modoer.gif','9');
INSERT INTO modoer_menus VALUES ('6','0','','0','website','0','0','{exchange-name}','exchange','','exchange','menu_exchange.gif','8');
INSERT INTO modoer_menus VALUES ('5','0','','0','website','0','0','{coupon-name}','coupon','','coupon','menu_service.gif','7');
INSERT INTO modoer_menus VALUES ('4','0','','0','website','0','0','{card-name}','card','','card','menu_card.gif','6');
INSERT INTO modoer_menus VALUES ('3','0','','0','website','0','0','ʳ͹','shop-cate-10','','shop/cate/cd/10','menu_eat.gif','3');
INSERT INTO modoer_menus VALUES ('2','0','','0','website','0','0','{article-name}','article','','article','menu_article.gif','2');
INSERT INTO modoer_menus VALUES ('1','0','','0','website','0','0','ҳ','index','','{SITE}','menu_home.gif','1');
INSERT INTO modoer_menus VALUES ('12','0','','0','member','1','0','','','impk','','','1');
INSERT INTO modoer_menus VALUES ('13','0','','0','member','1','0','̼','','imowner','','','2');
INSERT INTO modoer_menus VALUES ('14','12','shop','0','member','0','0','ҵĵ','','reviews','shop/member/ac/reviews','','1');
INSERT INTO modoer_menus VALUES ('15','12','shop','0','member','0','0','ҵĻӦ','','responds','shop/member/ac/responds','','2');
INSERT INTO modoer_menus VALUES ('16','12','shop','0','member','0','0','ӵ','','addshops','shop/member/ac/addshops','','3');
INSERT INTO modoer_menus VALUES ('17','12','shop','0','member','0','0','ӵͼƬ','','pictures','shop/member/ac/pictures','','4');
INSERT INTO modoer_menus VALUES ('18','12','shop','0','member','0','0','ҵղؼ','','favorites','shop/member/ac/favorites','','5');
INSERT INTO modoer_menus VALUES ('19','12','member','0','member','0','0','ҵĶ','','pm','member/index/ac/pm','','6');
INSERT INTO modoer_menus VALUES ('20','12','member','0','member','0','0','ҵĺ','','friends','member/index/ac/friends','','7');
INSERT INTO modoer_menus VALUES ('21','12','space','0','member','0','0','ҵ԰','','gbook','space/member/ac/gbook','','8');
INSERT INTO modoer_menus VALUES ('23','12','exchange','0','member','0','0','ҶһƷ','','exchange','exchange/member/ac/exchange','','10');
INSERT INTO modoer_menus VALUES ('24','13','shop','0','member','0','0','ҵ','','myitems','shop/member/ac/myitems','','1');
INSERT INTO modoer_menus VALUES ('25','13','article','0','member','0','0','Ѷ','','itemarticles','article/member/ac/itemarticles','','2');
INSERT INTO modoer_menus VALUES ('26','0','','0','member','1','0','Ϣ','','myinfo','','','3');
INSERT INTO modoer_menus VALUES ('27','26','member','0','member','0','0','ҵ','','myset','member/index/ac/myset','','1');
INSERT INTO modoer_menus VALUES ('28','26','space','0','member','0','0','˿ռ','','space','space/member/ac/space','','2');
INSERT INTO modoer_menus VALUES ('29','26','member','0','member','0','0','ͷ','','face','member/index/ac/face','','3');
INSERT INTO modoer_menus VALUES ('36','12','ucenter','1','member','0','0','ֶһ','','credits','ucenter/member/ac/credits','','11');

DROP TABLE IF EXISTS modoer_modules;
CREATE TABLE modoer_modules (
  moduleid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  flag varchar(30) NOT NULL DEFAULT '',
  iscore tinyint(1) NOT NULL DEFAULT '0',
  name varchar(60) NOT NULL DEFAULT '',
  directory varchar(100) NOT NULL DEFAULT '',
  disable tinyint(1) unsigned NOT NULL DEFAULT '0',
  config text NOT NULL,
  version varchar(60) NOT NULL DEFAULT '',
  releasetime date NOT NULL DEFAULT '0000-00-00',
  reliant varchar(255) NOT NULL DEFAULT '',
  author varchar(255) NOT NULL DEFAULT '',
  introduce text NOT NULL,
  siteurl varchar(255) NOT NULL DEFAULT '',
  email varchar(255) NOT NULL DEFAULT '',
  copyright varchar(255) NOT NULL DEFAULT '',
  checkurl varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (moduleid)
) TYPE=MyISAM AUTO_INCREMENT=16;

INSERT INTO modoer_modules VALUES ('3','member','1','Ա','member','0',' ','1.1','2008-09-30','','Moufer Studio',' ','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('4','shop','1','̵','shop','0',' ','1.1','2008-09-30','','Moufer Studio',' ','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('5','space','1','˿ռ','space','0','a:11:{s:11:\"recordguest\";s:1:\"1\";s:9:\"spacename\";s:19:\"$usernameĸ˿ռ\";s:13:\"spacedescribe\";s:10:\"Ҫ\";s:13:\"index_reviews\";s:1:\"5\";s:12:\"index_gbooks\";s:1:\"5\";s:7:\"reviews\";s:2:\"10\";s:6:\"gbooks\";s:2:\"10\";s:7:\"friends\";s:2:\"10\";s:5:\"gbook\";s:1:\"1\";s:11:\"gbook_guest\";s:1:\"1\";s:13:\"gbook_seccode\";s:1:\"1\";}','1.1','2008-09-30','','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('6','card','1','Ա','card','0','a:10:{s:5:\"apply\";s:1:\"1\";s:12:\"applyseccode\";s:1:\"0\";s:10:\"applylimit\";s:8:\"userrank\";s:10:\"userrankid\";s:1:\"2\";s:5:\"point\";i:56;s:4:\"coin\";i:20;s:8:\"applynum\";i:3;s:8:\"applydes\";s:50:\"дύʱʾԱ˵\";s:13:\"meta_keywords\";s:10:\"ٴ,sdf\";s:16:\"meta_description\";s:26:\"ǶԷͻܵ㷺Ǹ\";}','1.0','2008-09-01','shop','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('7','exchange','0','ҽ','exchange','0','a:6:{s:11:\"thumb_width\";s:3:\"124\";s:12:\"thumb_height\";s:2:\"94\";s:7:\"seccode\";i:1;s:7:\"rewrite\";s:1:\"0\";s:13:\"meta_keywords\";s:4:\"һ\";s:16:\"meta_description\";s:12:\"һҳ\";}','1.0','2008-09-01','','Moufer Studio','','http://www.modoer.com','moufer@163.com','Moufer Studio','');
INSERT INTO modoer_modules VALUES ('8','coupon','1','Żȯ','coupon','0','a:9:{s:5:\"check\";s:1:\"1\";s:9:\"watermark\";s:1:\"0\";s:11:\"thumb_width\";s:2:\"72\";s:12:\"thumb_height\";s:2:\"47\";s:7:\"seccode\";s:1:\"1\";s:7:\"rewrite\";s:1:\"0\";s:7:\"listnum\";s:2:\"10\";s:13:\"meta_keywords\";s:8:\"ҽ\";s:16:\"meta_description\";s:8:\"ҽҳ\";}','1.0','2008-10-03','shop','moufer','Żȯģ','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/coupon.php');
INSERT INTO modoer_modules VALUES ('9','article','0','Ѷ','article','0','a:7:{s:9:\"ownernews\";s:1:\"1\";s:17:\"ownernews_classid\";s:1:\"1\";s:15:\"ownernews_check\";s:1:\"0\";s:7:\"listnum\";s:2:\"10\";s:7:\"rewrite\";s:1:\"0\";s:13:\"meta_keywords\";s:4:\"\";s:16:\"meta_description\";s:8:\"ҳ\";}','1.0','2008-09-18','','moufer','ŷƷ/Ϣ','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/article.php');
INSERT INTO modoer_modules VALUES ('11','links','0','','links','0','a:5:{s:13:\"meta_keywords\";s:8:\"\";s:16:\"meta_description\";s:12:\"ҳ\";s:8:\"num_logo\";s:2:\"10\";s:8:\"num_char\";s:2:\"20\";s:10:\"open_apply\";s:1:\"1\";}','1.0','2008-09-18','','moufer','ģ','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/links.php');
INSERT INTO modoer_modules VALUES ('12','ads','0','','ads','0','','1.0','2008-10-12','','moufer','վ','http://www.modoer.com','moufer@163.com','Moufer Studio','http://www.modoer.com/info/module/ads.php');

DROP TABLE IF EXISTS modoer_mylinks;
CREATE TABLE modoer_mylinks (
  linkid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  title varchar(40) NOT NULL DEFAULT '',
  link varchar(100) NOT NULL DEFAULT '',
  logo varchar(100) NOT NULL DEFAULT '',
  des varchar(255) NOT NULL DEFAULT '',
  displayorder int(8) NOT NULL DEFAULT '0',
  ischeck tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (linkid)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_mylinks VALUES ('1','Modoerϵͳ','http://www.modoer.com','','Modoer һվϵͳ PHP+MYSQL ƣȫԴ','0','1');

DROP TABLE IF EXISTS modoer_pictures;
CREATE TABLE modoer_pictures (
  pid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(16) NOT NULL DEFAULT '',
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  title varchar(60) NOT NULL DEFAULT '',
  folder varchar(16) NOT NULL DEFAULT '',
  filename varchar(20) NOT NULL DEFAULT '',
  width smallint(5) unsigned NOT NULL DEFAULT '0',
  height smallint(5) unsigned NOT NULL DEFAULT '0',
  size int(10) unsigned NOT NULL DEFAULT '0',
  comments varchar(60) NOT NULL DEFAULT '',
  sort tinyint(1) NOT NULL DEFAULT '0',
  browse int(10) NOT NULL DEFAULT '0',
  tags varchar(60) NOT NULL DEFAULT '',
  addtime int(10) NOT NULL DEFAULT '0',
  status tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (pid),
  KEY uid (uid),
  KEY shopid (shopid),
  KEY title (title)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_plugins;
CREATE TABLE modoer_plugins (
  plugin_id smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  module varchar(30) NOT NULL DEFAULT '',
  available tinyint(1) NOT NULL DEFAULT '1',
  orders smallint(5) NOT NULL DEFAULT '0',
  directory varchar(60) NOT NULL DEFAULT '',
  name varchar(100) NOT NULL DEFAULT '',
  menu text NOT NULL,
  actionlist text NOT NULL,
  config text NOT NULL,
  tablenames text NOT NULL,
  version varchar(15) NOT NULL DEFAULT '',
  author varchar(100) NOT NULL DEFAULT '',
  copyright varchar(200) NOT NULL DEFAULT '',
  description varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (plugin_id)
) TYPE=MyISAM AUTO_INCREMENT=3;

INSERT INTO modoer_plugins VALUES ('1','bcastr','1','0','bcastr/','ͼƬֻ','a:2:{s:12:\"bcastrconfig\";s:8:\"\";s:12:\"bcastrmanage\";s:8:\"ͼƬ\";}','N;','a:1:{s:6:\"config\";s:54:\"0xFF0000|1|0xFAFAFA|65|0xFFFFFF|0xFF8040||6|2|1|_blank\";}','bcastr','1.0','moufer','Moufer Studio','һͼƬֻ');
INSERT INTO modoer_plugins VALUES ('2','announcement','1','0','announcement/','վ','a:1:{s:19:\"announcement_manage\";s:8:\"\";}','a:2:{s:5:\"index\";a:2:{s:9:\"needlogin\";b:0;s:5:\"admin\";b:0;}s:4:\"list\";a:2:{s:9:\"needlogin\";b:0;s:5:\"admin\";b:0;}}','N;','announcements','1.0','moufer','Moufer Studio','򵥵վ');

DROP TABLE IF EXISTS modoer_pmsgs;
CREATE TABLE modoer_pmsgs (
  pmid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  senduid mediumint(8) unsigned NOT NULL DEFAULT '0',
  recvuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  content mediumtext NOT NULL,
  subject varchar(60) NOT NULL DEFAULT '',
  posttime int(10) NOT NULL DEFAULT '0',
  new tinyint(1) NOT NULL DEFAULT '1',
  delflag tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (pmid),
  KEY senduid (senduid,posttime),
  KEY recvuid (recvuid,posttime),
  KEY new (new,recvuid,posttime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_reports;
CREATE TABLE modoer_reports (
  reportid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  reviewid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(16) NOT NULL DEFAULT '',
  email varchar(60) NOT NULL DEFAULT '',
  sort tinyint(1) NOT NULL DEFAULT '0',
  reportcontent mediumtext NOT NULL,
  disposal tinyint(1) NOT NULL DEFAULT '2',
  posttime int(10) NOT NULL DEFAULT '0',
  disposaltime int(10) NOT NULL DEFAULT '0',
  reportremark mediumtext NOT NULL,
  PRIMARY KEY (reportid),
  KEY uid (uid,username,email),
  KEY posttime (posttime),
  KEY reviewid (reviewid,sort)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_responds;
CREATE TABLE modoer_responds (
  rid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  reviewid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(20) NOT NULL DEFAULT '',
  content text NOT NULL,
  posttime int(10) NOT NULL DEFAULT '0',
  status tinyint(1) NOT NULL DEFAULT '1',
  ip varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (rid),
  KEY uid (uid,status),
  KEY reviewid (reviewid,status)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_reviews;
CREATE TABLE modoer_reviews (
  rid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(20) NOT NULL DEFAULT '',
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  sort1 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort2 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort3 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort4 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort5 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort6 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort7 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sort8 tinyint(1) unsigned NOT NULL DEFAULT '0',
  sumsort smallint(2) unsigned NOT NULL DEFAULT '0',
  avgprice int(10) unsigned NOT NULL DEFAULT '0',
  enjoy tinyint(1) unsigned NOT NULL DEFAULT '0',
  content text NOT NULL,
  posttime int(10) NOT NULL DEFAULT '0',
  isupdate tinyint(1) NOT NULL DEFAULT '0',
  flower int(8) unsigned NOT NULL DEFAULT '0',
  respond int(8) unsigned NOT NULL DEFAULT '0',
  shoptags varchar(60) NOT NULL DEFAULT '',
  producttags varchar(60) NOT NULL DEFAULT '',
  suitplacetags varchar(60) NOT NULL DEFAULT '',
  status tinyint(1) NOT NULL DEFAULT '1',
  ip varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (rid),
  KEY posttime (posttime,status),
  KEY uid (uid,status,posttime),
  KEY flower (flower,status),
  KEY respond (respond,status),
  KEY shopid (shopid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_searchindex;
CREATE TABLE modoer_searchindex (
  searchid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  keyword varchar(200) NOT NULL DEFAULT '',
  searchstring text NOT NULL,
  useip varchar(15) NOT NULL DEFAULT '',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  expiration int(10) unsigned NOT NULL DEFAULT '0',
  total int(10) unsigned NOT NULL DEFAULT '0',
  ids text NOT NULL,
  PRIMARY KEY (searchid),
  KEY keyword (keyword)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shopeffect;
CREATE TABLE modoer_shopeffect (
  shopid mediumint(8) unsigned NOT NULL,
  effect1 int(10) unsigned NOT NULL DEFAULT '0',
  effect2 int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (shopid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shopfield;
CREATE TABLE modoer_shopfield (
  shopid mediumint(8) unsigned NOT NULL,
  tel1 varchar(20) NOT NULL,
  tel2 varchar(20) NOT NULL,
  mobile varchar(20) NOT NULL,
  address varchar(255) NOT NULL,
  video varchar(255) NOT NULL,
  website varchar(255) NOT NULL,
  bus varchar(60) NOT NULL,
  parking varchar(60) NOT NULL,
  store_hours varchar(255) NOT NULL,
  content text NOT NULL,
  PRIMARY KEY (shopid)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shops;
CREATE TABLE modoer_shops (
  sid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  shopname varchar(40) NOT NULL DEFAULT '',
  subname varchar(40) NOT NULL DEFAULT '',
  templateid smallint(5) unsigned NOT NULL DEFAULT '0',
  classcode varchar(10) NOT NULL DEFAULT '',
  areacode varchar(4) NOT NULL DEFAULT '',
  streetcode varchar(6) NOT NULL DEFAULT '',
  avgsort decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort1 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort2 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort3 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort4 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort5 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort6 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort7 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  sort8 decimal(4,2) unsigned NOT NULL DEFAULT '0.00',
  avgprice int(10) unsigned NOT NULL DEFAULT '0',
  enjoy int(10) unsigned NOT NULL DEFAULT '0',
  reviews int(10) unsigned NOT NULL DEFAULT '0',
  guestbook int(10) unsigned NOT NULL DEFAULT '0',
  pictures int(10) unsigned NOT NULL DEFAULT '0',
  pageviews int(10) unsigned NOT NULL DEFAULT '1',
  ownerid mediumint(8) unsigned NOT NULL DEFAULT '0',
  owner varchar(20) NOT NULL DEFAULT '',
  adduid mediumint(8) unsigned NOT NULL DEFAULT '0',
  addname varchar(20) NOT NULL DEFAULT '',
  addtime int(10) NOT NULL DEFAULT '0',
  firstuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  firstname varchar(20) NOT NULL DEFAULT '',
  finer tinyint(1) NOT NULL DEFAULT '0',
  coupons int(10) NOT NULL DEFAULT '0',
  mappoint varchar(60) NOT NULL DEFAULT '',
  thumb varchar(100) NOT NULL DEFAULT '',
  status tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (sid),
  KEY cate (classcode,areacode,status),
  KEY adduid (adduid,status,addtime),
  KEY firstuid (firstuid,status,addtime),
  KEY ownerid (ownerid,status,addtime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_shoptags;
CREATE TABLE modoer_shoptags (
  tagname varchar(20) NOT NULL DEFAULT '',
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  reviewid mediumint(8) unsigned NOT NULL DEFAULT '0',
  tagsort enum('shop','product','suitplace') NOT NULL DEFAULT 'shop',
  KEY reviewid (reviewid),
  KEY shopid (shopid,tagsort),
  KEY tagname (tagname,tagsort)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_spaces;
CREATE TABLE modoer_spaces (
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  space_styleid smallint(3) NOT NULL DEFAULT '0',
  spacename varchar(30) NOT NULL DEFAULT '',
  spacedescribe varchar(50) NOT NULL DEFAULT '',
  pageview int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (uid),
  KEY pageviews (pageview)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_tags;
CREATE TABLE modoer_tags (
  tagid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  tagname varchar(20) NOT NULL DEFAULT '',
  closed tinyint(1) NOT NULL DEFAULT '0',
  total int(10) unsigned NOT NULL DEFAULT '0',
  panelcode varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (tagid),
  KEY total (total,panelcode),
  KEY closed (closed,panelcode),
  KEY tagname (tagname,panelcode)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_templates;
CREATE TABLE modoer_templates (
  templateid smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  name varchar(20) NOT NULL DEFAULT '',
  directory varchar(100) NOT NULL DEFAULT '',
  copyright varchar(45) NOT NULL DEFAULT '',
  tpltype varchar(15) NOT NULL DEFAULT '',
  bind tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (templateid)
) TYPE=MyISAM AUTO_INCREMENT=2;

INSERT INTO modoer_templates VALUES ('1','Ĭģ','./templates/main/default','Moufer Studio','main','1');
INSERT INTO modoer_templates VALUES ('2','ݲн','./templates/item/yifei','768.cc','item','0');

DROP TABLE IF EXISTS modoer_travelers;
CREATE TABLE modoer_travelers (
  tid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  tuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  tusername varchar(16) NOT NULL DEFAULT '',
  addtime int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (tid),
  KEY uid (uid,addtime),
  KEY tuid (tuid,addtime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_upshops;
CREATE TABLE modoer_upshops (
  upid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  shopid mediumint(8) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(16) NOT NULL DEFAULT '',
  email varchar(60) NOT NULL DEFAULT '',
  upcontent mediumtext NOT NULL,
  disposal tinyint(1) NOT NULL DEFAULT '2',
  posttime int(10) NOT NULL DEFAULT '0',
  upremark mediumtext NOT NULL,
  disposaltime int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (upid),
  KEY shopid (shopid,posttime),
  KEY uid (uid,username,email,posttime)
) TYPE=MyISAM;

DROP TABLE IF EXISTS modoer_usergroups;
CREATE TABLE modoer_usergroups (
  groupid smallint(6) NOT NULL AUTO_INCREMENT,
  grouptype enum('member','special','system') DEFAULT 'member',
  groupname char(16) DEFAULT NULL,
  PRIMARY KEY (groupid)
) TYPE=MyISAM AUTO_INCREMENT=11;

INSERT INTO modoer_usergroups VALUES ('1','system','ο');
INSERT INTO modoer_usergroups VALUES ('2','system','ֹ');
INSERT INTO modoer_usergroups VALUES ('3','system','ֹ');
INSERT INTO modoer_usergroups VALUES ('10','member','עԱ');

DROP TABLE IF EXISTS modoer_userranks;
CREATE TABLE modoer_userranks (
  rankid smallint(6) NOT NULL AUTO_INCREMENT,
  rankname char(24) NOT NULL DEFAULT '',
  point mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (rankid)
) TYPE=MyISAM AUTO_INCREMENT=4;

INSERT INTO modoer_userranks VALUES ('1','','0');
INSERT INTO modoer_userranks VALUES ('2','м','200');
INSERT INTO modoer_userranks VALUES ('3','߼','500');

DROP TABLE IF EXISTS modoer_words;
CREATE TABLE modoer_words (
  id smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  keyword varchar(255) NOT NULL DEFAULT '',
  expression varchar(255) NOT NULL DEFAULT '',
  admin varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (id)
) TYPE=MyISAM;