<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id 5 2008 Sun Oct 05 18:41:54 CST 2008 18:41:54 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

require(MUDDER_ROOT.$_modules['shop']['directory'].'/include/fun_common.php');
if(!function_exists('postItem')) {
    require_once(MUDDER_ROOT.$_modules['shop']['directory'].'/include/fun_item.php');
}
if(!function_exists('getReview')) {
    require_once(MUDDER_ROOT.$_modules['shop']['directory'].'/include/fun_review.php');
}
if(!function_exists('postRespond')) {
    require_once(MUDDER_ROOT.$_modules['shop']['directory'].'/include/fun_respond.php');
}

function randRresult(&$data,$rand) {
    $rand = min(count($data), $rand);
    $rks = array_rand($data, $rand);
    if(!is_numeric($rks)) {
        foreach($rks as $val) {
            $result[$val] = $data[$val];
        }
    } else {
        $result[] = $data[$rks];
    }
    return $result;
}

function & query_items($callid,$params) {
    global $db, $dbpre, $_config;

    $params = parseGlobal($params);
    if(empty($params)) return array();
    extract($params);

    $rand = intval($rand);
    
    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(file_exists($cachefile) && check_cache($cachefile, $cachetime)) {
        $crs = read_cache($cachefile);
        if($rand > 0 && !empty($crs)) {
            $result = count($crs) > 1 ? randRresult($crs, $rand) : $crs;
        } else {
            $result = $crs;
        }
        unset($crs);
        return $result;
    }

    $result = array();
    $select = "sid,shopname,subname,classcode,areacode,streetcode,reviews,pictures,pageviews,addtime,mappoint,thumb";
    if($showpoint) $select .= ",sumreview,sumsort1,sumsort2,sumsort3,sumsort4,sumsort5,sumsort6,sumsort7,sumsort8,avgprice,enjoy";
    if($showfield) $select .= ",sf.*";

    $where = array();
    $where[] = "status IN (1,3,4,5)";
    if(is_numeric($sid)) $where[] = "sid='$sid'";
    if($shopname) {
        $shopname = addslashes(stripslashes($shopname));
        $where[] = "shopname='$shopname'";
    }
    $panelcode = substr($panelcode,0,2);
	if(preg_match("/[0-9]+/", $classcode)) {
		if(strlen($classcode)==2) {
			$where[] = "(classcode>'{$classcode}00' AND classcode<='{$classcode}99')";
		} elseif(strlen($classcode)==4) {
			$where[] = "classcode='$classcode'";
		}
    } elseif(preg_match("/[0-9]{2}/", $panelcode)) {
        $where[] = "(classcode>'{$panelcode}00' AND classcode<='{$panelcode}99')";
    }

    if(strlen($streetcode) == 6) {
        $where[] = "streetcode='$streetcode'";
    } elseif(strlen($areacode) == 4) {
        $where[] = "areacode='$areacode'";
    }

    if(is_numeric($pictures) && $pictures > 0) $where[] = "pictures>='$pictures'";
    if(is_numeric($reviews) && $reviews > 0) $where[] = "reviews>='$reviews'";
    if(is_numeric($pageviews) && $pageviews > 0) $where[] = "pageviews>='$pageviews'";
    if(is_numeric($adduid) && $adduid > 0) $where[] = "adduid='$adduid'";
    if(is_numeric($firstuid) && $firstuid > 0) $where[] = "adduid='$firstuid'";
    if(is_numeric($finer) && $finer > 0) $where[] = "finer>='$finer'";
    if(is_numeric($effect1) && $effect1 > 0) $where[] = "effect1>='$effect1'";
    if(is_numeric($effect2) && $effect2 > 0) $where[] = "effect2='$effect2'";
    if(is_numeric($mappoint) && $mappoint) $where[] = "mappoint!=''";

    if($video) $where[] = "video!=''";
    if($website) $where[] = "website!=''";
    
    $where = implode(" AND ", $where);
    $order = strip_order($order);
    $orderby = $order ? "ORDER BY $order" : '';
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';

    $from = "{$dbpre}shops";
    if($address||$video||$website||$showfield) {
        $from .= " s JOIN {$dbpre}shopfield sf ON(s.sid=sf.shopid)";
    }
    $query = $db->query("SELECT * FROM $from WHERE $where $orderby $limit");
    if($db->num_rows($query) <= 0) {
        $result = array();
    } else {
        while($row = $db->fetch_array($query)) {
            $result[] = itemToArray($row);
        }
        $db->free_result($query);
    }

    if($cachetime >0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }

    if($rand>0 && !empty($result)) {
        $result = randRresult($result,$rand);
    }

   return $result;
}

// ѯ̵ĸ¼¼
function query_uplog($callid,$params) {
    global $db, $dbpre, $_config;

    $params = parseGlobal($params);
    if(empty($params)) return array();
    extract($params);
    if(!is_numeric($shopid) || $shopid <= 0) return array();

    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT . $_config['datacall_dir'] . 'cache_' . $cachename . '.php';

    if(file_exists($cachefile) && check_cache($cachefile, $cachetime)) {
        return read_cache($cachefile);
    }

    $result = array();
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';
    $query = $db->query("SELECT uid,username,posttime FROM {$dbpre}upshops WHERE shopid='$shopid' AND disposal=1 ORDER BY posttime $limit");
    while($row = $db->fetch_array($query)) {
        $result[] = itemToArray($row);
    }
    $db->free_result($query);

    if($cachetime >0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }

   return $result;
}

function query_reviews($callid,$params) {
    global $db, $dbpre, $_config;

    $params = parseGlobal($params);
    if(empty($params)) return array();
    extract($params,EXTR_OVERWRITE);

    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_ROOT.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(file_exists($cachefile) && check_cache($cachefile, $cachetime)) {
        return read_cache($cachefile);
    }

    $result = $where = array();

    $from = "{$dbpre}reviews r LEFT JOIN {$dbpre}members m ON(r.uid=m.uid)";
    $select = "r.*,m.username,m.face,m.reviews as member_reviews,m.flowers as member_flowers,m.point,m.coin";
    if($showitem) {
        $from .= "LEFT JOIN {$dbpre}shops s ON(r.shopid=s.sid)";
        $select .= ",s.shopname,s.subname,s.areacode,s.classcode,mappoint";
        if($showitemfield) {
            $from .= "LEFT JOIN {$dbpre}shopfield sf ON(s.sid=sf.shopid)";
            $select .= ",sf.address,sf.mobile,sf.tel1,sf.tel2";
        }
    }
    $where[] = "r.status=1";
    if($showitem && $panelcode = substr($panelcode, 0, 2)) {
        $where[] = "s.classcode BETWEEN '{$panelcode}00' AND '{$panelcode}99'";
    }

    (is_numeric($posttime) && $posttime > 0) && $where[] = "r.posttime > UNIX_TIMESTAMP() - $posttime";
    (is_numeric($shopid) && $shopid) && $where[] = "r.shopid = '$shopid'";
    (is_numeric($uid) && $uid) && $where[] = "m.uid = '$uid'";
    (is_numeric($flower) && $flower > 0) && $where[] = "r.flower >= '$flower'";
    (is_numeric($respond) && $respond > 0) && $where[] = "r.respond >= '$respond'";
    (is_numeric($enjoy) && $enjoy > 0) && $where[] = "r.enjoy >= '$enjoy'";
    $mappoint && $where[] = "s.mappoint <> ''";

    $where = implode(" AND ", $where);
    $order = strip_order($order);
    $orderby = $order = strip_order($order) ? "ORDER BY $order" : '';
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';

    $query = $db->query("SELECT $select FROM $from WHERE $where $orderby $limit");
    if($db->num_rows($query) <= 0) return array();

    while($row = $db->fetch_array($query)) {
        $row['member'] = array(
            'uid' => $row['uid'],
            'username' => $row['username'],
            'face' => $row['face'],
            'reviews' => $row['member_reviews'],
            'flowers' => $row['member_flowers'],
            'point' => $row['point'],
            'coin' => $row['coin'],
        );
        $row['item'] = array(
            'sid' => $row['shopid'],
            'shopname' => $row['shopname'],
            'subname' => $row['subname'],
            'classcode' => $row['classcode'],
            'streetcode' => $row['streetcode'],
            'address' => $row['address'],
            'mobile' => $row['mobile'],
            'tel1' => $row['tel1'],
            'tel2' => $row['tel2'],
        );
        $tmp = reviewToArray($row);
        $tmp['shop'] =& $tmp['item'];
        $result[] = $tmp;
    }
    $db->free_result($query);

    if($cachetime > 0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }

   return $result;
}

function query_itemtag($callid,$params) {
    global $db, $dbpre, $_config;

    $params = parseGlobal($params);
    if(empty($params)) return array();
    if(!is_numeric($shopid) || $shopid <= 0) return array();

    $cachename = sprintf("%d_%s", $callid,cacheIdentifier($params));
    $cachefile = MUDDER_CACHEDIR.$_config['datacall_dir'].'cache_'.$cachename.'.php';

    if(file_exists($cachefile) && check_cache($cachefile, $cachetime)) {
        return read_cache($cachefile);
    }

    $result = array();
    $where = "shopid='$shopid' AND tagsort='$tagsort'";
    $orderby = "ORDER BY total DESC";
    $limit = ($row=intval($row)) ? "LIMIT 0,$row" : 'LIMIT 0,10';
    $query = $db->query("SELECT tagname,count(tagname) as total,tagsort FROM {$dbpre}shoptags WHERE $where GROUP BY tagname $orderby $limit");
    if(!function_exists('tagToArray')) {
        require_once(MUDDER_ROOT.'./include/tag.func.php');
    }
    while($row = $db->fetch_array($query)) {
        $result[] = tagToArray($row);
    }
    $db->free_result($query);

    if($cachetime >0) {
        write_cache($cachename, arrayeval($result), '', 'return', $_config['datacall_dir']);
    }
   return $result;
}
?>