<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
*/
class guestbook extends Base_db {
    
    var $table = 'guestbook';
    var $idtypes = array();
    var $sizelimit = array(
        'min' => 5,
        'max' => 300,
    );
    
    function guestbook() {
        parent::__construct();
        $this->table = $this->dbpre . $this->table;
    }

    function addIdtype($typename,$table,$pkid,$indexfield) {
        $this->idtypes[$typename] = array(
            'table' => $table,
            'pkid' => $pkid,
            'indexfield' => $indexfield,
        );
    }

    function post($data) {
        if(!function_exists('filterWords')) require_once(MUDDER_ROOT."include/mycode.func.php");
        if(!$data['content'] = filterWords(html_special_chars($data['content']))) {
            redirect('Բδд');
        }  elseif(strlen($data['content']) < $this->sizelimit['min'] || strlen($data['content']) > $this->sizelimit['max']) {
            redirect(''.$this->sizelimit['min'].' - '.$this->sizelimit['max'].'ַ');
        }
        if($data['guestbookid']) {
            $guestbookid = $data['guestbookid'];
            unset($data['guestbookid']);
            $this->db->update_new($this->table,"guestbookid='$guestbookid'",$data);
            return $guestbookid;
        } else {
            if(!$data['username'] = html_special_chars_ex($data['username'])) {
                redirect('Բδдǳ');
            } elseif(!$type = $this->idtypes[$data['idtype']]) {
                redirect('Բδ֪IDTYPE');
            }
            $this->db->insert_new($this->table,$data);
            $this->db->query("UPDATE $type[table] SET $type[indexfield]=$type[indexfield]+1 WHERE $type[pkid]='$data[id]'");
            return $this->db->insert_id();
        }
    }

    function edit($guestbookid, $data) {
        $data['content'] = html_special_chars($data['content']);
        $data['reply'] = html_special_chars($data['reply']);
        $data['replytime'] = $this->timestamp;
        $this->db->update_new($this->table,"guestbookid='$guestbookid'",$data);
    }

    function reply($data, $alow_replay_uids=array()) {
        if($data['guestbookid']<1) redirect('Բ𣬲');
        if(!function_exists('filterWords')) require_once(MUDDER_ROOT."include/mycode.func.php");
        if(!$data['reply'] = filterWords(html_special_chars($data['reply']))) {
            redirect('Բδдظݡ');
        }
        $guestbookid = $data['guestbookid'];
        unset($data['guestbookid']);
        $gb = $this->read($guestbookid);
        if(empty($gb)) redirect('ԲĶ󲻴ڻɾ');
        if(!defined('IN_ADMIN') && !in_array($gb['id'],$alow_replay_uids)) {
            redirect('ԲĲȨ޲㡣');
        }
        $this->db->update_new($this->table,"guestbookid='$guestbookid'",$data);
        return $gb;
    }

    function load($id,$idtype,$start,$offset) {
        $where = array();
        if($id) $where[] = "id='$id'";
        if($idtype) $where[] = "idtype='$idtype'";
        $where = empty($where) ? '' : "WHERE " . implode(" AND ",$where);
        return $this->db->get_all("SELECT * FROM $this->table $where ORDER BY dateline DESC LIMIT $start,$offset");
    }

    function read($guestbookid) {
        return $this->db->get_one("SELECT * FROM $this->table WHERE guestbookid='$guestbookid'");
    }

    function delete($guestbookids, $opuid=0, $alow_replay_uids=array()) {
        if(is_numeric($guestbookids) && $guestbookids > 0) {
            $guestbookids = array($guestbookids);
        }
        $ids = "'".implode("','",$guestbookids)."'";
        $query = $this->db->query("SELECT guestbookid,uid,id,idtype FROM $this->table WHERE guestbookid IN ($ids)");
        $delids = $result = array();
        while($value = $this->db->fetch_array($query)) {
            if(!defined("IN_ADMIN") && !in_array($value['id'], $alow_replay_uids) && (!$value['uid'] && $value['uid']!=$opuid)) {
                redirect('ԲĲȨ޲㡣');
            }
            $delids[] = $value['guestbookid'];
            if($type = $this->idtypes[$value['idtype']]) {
                $this->db->query("UPDATE $type[table] SET $type[indexfield]=$type[indexfield]-1 WHERE $type[pkid]='$value[id]'");
            }
            $result = $value;
        }
        if($delids) {
            $ids = "'".implode("','",$delids)."'";
            $this->db->query("DELETE FROM $this->table WHERE guestbookid IN ($ids)");
        }
        return $result;
    }

}
?>