<?php

/***************************************************************************

 adminfunctions.php
 -------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the License which can be found within the
 *	zipped package.
 *
 ***************************************************************************/

//include ($GLOBALS["rootdp"].'include/debuglib.php');

function admhdr($charset='')
{
	if ($charset == '') { $charset = $GLOBALS["gsCharset"]; }
	?>
	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html dir="<?php echo $GLOBALS["gsDirection"]; ?>">
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $charset; ?>">
	<?php
	if ($GLOBALS["gsAdminStyle"] != '') {
		?>
		<LINK HREF="<?php echo $GLOBALS["rootdp"].$GLOBALS["style_home"].$GLOBALS["gsAdminStyle"]; ?>/vs.css" REL=STYLESHEET TYPE="text/css">
		<?php
	} else {
		include ($GLOBALS["rootdp"]."include/style.php");
	}
} // function admhdr()


function framecheck()
{
	?>
	<script language="JavaScript" type="text/javascript">
		<!-- Begin
		if (parent.location.href == self.location.href){
			window.location.href='index.php';
		}
		//  End -->
	</script>
	<?php
} // framecheck()


function adminheader($framedpage=True)
{
	admhdr($GLOBALS["gsCharset"]);
	if ($framedpage) { framecheck(); }
	?>
	</head>
	<?php
} // function adminheader()



function adminformheader($charset='')
{
	global $EZ_SESSION_VARS;

	if ($charset == '') { $charset = $GLOBALS["gsCharset"]; }
	admhdr($charset);
	framecheck();
	?>
	<script language="JavaScript" type="text/javascript">
		<!-- Begin
		function putFocus(formInst, elementInst) {
			if (document.forms.length > 0) {
				document.forms[formInst].elements[elementInst].focus();
			}
		}
		//  End -->
	</script>

	<?php
	if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
		if (isset($EZ_SESSION_VARS["WYSIWYG_Version"])) {
			$WYSIWYG_Version = str_replace(' ','',$EZ_SESSION_VARS["WYSIWYG_Version"]);
		} else {
			$WYSIWYG_Version = str_replace(' ','',$GLOBALS["WYSIWYG_Version"]);
		}
		if ($WYSIWYG_Version == '') { $WYSIWYG_Version = '3Beta'; }
		$langlookup	= array (	zh		=> "b5",		da		=> "da",		de		=> "de",
								en		=> "en",		es		=> "es",		fi		=> "fi",
								fr		=> "fr",		en_uk	=> "gb",		it		=> "it",
								ja		=> "ja-euc",	ja-jis	=> "ja-jis",	ja-sjis	=> "js-sjis",
								ja-utf8	=> "ja-utf8",	nb		=> "nb",		nl		=> "nl",
								pl		=> "pl",		pt		=> "pt-br",		ro		=> "ro",
								ru		=> "ru",		se		=> "se",		vn		=> "vn",
								cz		=> "cz" );

		$langref = $GLOBALS["gsLanguage"];
		if ($langlookup[$langref] == '') { $langref = $GLOBALS["gsDefault_language"]; }
		if ($langlookup[$langref] == '') { $langref = 'en'; }
		?>
		<script language="JavaScript" type="text/javascript">
			<!-- Begin
			_editor_url = "<?php echo $GLOBALS["rootdp"]; ?>include/htmlarea<?php echo $WYSIWYG_Version; ?>/";
			//  End -->
		</script>

		<?php
		if (($WYSIWYG_Version == '2') || ($WYSIWYG_Version == '2Modified')) {
			?>
			<script language="JavaScript" type="text/javascript">
				<!-- Begin
				var win_ie_ver = parseFloat(navigator.appVersion.split("MSIE")[1]);
				if (navigator.userAgent.indexOf('Mac') >= 0) { win_ie_ver = 0; }
				if (navigator.userAgent.indexOf('Windows CE') >= 0) { win_ie_ver = 0; }
				if (navigator.userAgent.indexOf('Opera') >= 0) { win_ie_ver = 0; }
				if (win_ie_ver >= 5.5) {
					document.write('<scr' + 'ipt type="text/javascr' + 'ipt" src="' +_editor_url+ 'editor.js"></scr' + 'ipt>');
				} else {
					document.write('<scr'+'ipt>function editor_generate() { return false; }</scr'+'ipt>');
				}

				function initEditor() {
					return true;
				}
			//  End -->
			</script>

			<?php
		} else {
			?>
			<script type="text/javascript" src="<?php echo $GLOBALS["rootdp"]; ?>include/htmlarea<?php echo $WYSIWYG_Version; ?>/htmlarea.js"></script>
			<script type="text/javascript" src="<?php echo $GLOBALS["rootdp"]; ?>include/htmlarea<?php echo $WYSIWYG_Version; ?>/dialog.js"></script>
			<script type="text/javascript" src="<?php echo $GLOBALS["rootdp"]; ?>include/htmlarea<?php echo $WYSIWYG_Version; ?>/lang/<?php echo $langref; ?>.js"></script>
			<style type="text/css">@import url(<?php echo $GLOBALS["rootdp"]; ?>include/htmlarea<?php echo $WYSIWYG_Version; ?>/htmlarea.css)</style>

			<script type="text/javascript">
				<?php
				if ($GLOBALS["WYSIWYG_TableManager"] == 'Y') {
					?>
					HTMLArea.loadPlugin("TableOperations");
					<?php
				}
				if ($GLOBALS["WYSIWYG_SpellChecker"] == 'Y') {
					?>
					HTMLArea.loadPlugin("SpellChecker");
					<?php
				}
			?>
			</script>

			<script type="text/javascript" defer="1">
				<!-- Begin
					function initEditor() {
						<?php
						$textareas = $GLOBALS["textareas"];
						for ($i=0, $max=count($textareas); $i<$max; $i++) {
							$val = array_pop($textareas);
							?>
							var editor_<?php echo $val; ?> = new HTMLArea("<?php echo $val; ?>");
							<?php
							if ($GLOBALS["WYSIWYG_TableManager"] == 'Y') {
								?>
									editor_<?php echo $val; ?>.registerPlugin("TableOperations");
								<?php
							}
							if ($GLOBALS["WYSIWYG_SpellChecker"] == 'Y') {
								?>
									editor_<?php echo $val; ?>.registerPlugin("SpellChecker");
								<?php
							}
							?>
							editor_<?php echo $val; ?>.generate();
							<?php
						}
						?>
						return true;
					}
				//  End -->
			</script>
			<?php
		}
	}
} // function adminformheader()


function adminformopen($firstfield)
{
	global $HTTP_SERVER_VARS, $EZ_SESSION_VARS;

	if ($GLOBALS["specialedit"] == True) {
		?>
		<body leftmargin=0 topmargin=0 marginwidth="0" marginheight="0" class="mainback" onLoad="putFocus('MaintForm','<?php echo $firstfield; ?>');" onUnload="closeChildWindows()">
		<?php
	} else {
		?>
		<body leftmargin=0 topmargin=0 marginwidth="0" marginheight="0" class="mainback">
		<?php
	}
	?>
	<center>
	<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr><td align=center>
				<form name="MaintForm" action="<?php echo $HTTP_SERVER_VARS["PHP_SELF"]; ?>" method="POST" enctype="multipart/form-data">
				<table border="0" width="100%" cellspacing="3" cellpadding="3">
	<?php
} // function adminform()


function adminformclose()
{
	global $EZ_SESSION_VARS, $HTTP_POST_VARS;

	if ($HTTP_POST_VARS["authorid"] == '') { $HTTP_POST_VARS["authorid"] = $EZ_SESSION_VARS["UserID"]; }
					?>
					<input type="hidden" name="ezSID" value="<?php echo $GLOBALS["ezSID"]; ?>">
					<input type="hidden" name="authorid" value="<?php echo $HTTP_POST_VARS["authorid"]; ?>">
					<input type="hidden" name="submitted" value="yes">
					<input type="hidden" name="page" value="<?php echo $HTTP_POST_VARS["page"]; ?>">
					<input type="hidden" name="sort" value="<?php echo $HTTP_POST_VARS["sort"]; ?>">
				</table>
				</form>
		</td></tr>
	</table>
	</center>
	<?php
	if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
		if (isset($EZ_SESSION_VARS["WYSIWYG_Version"])) {
			$WYSIWYG_Version = str_replace(' ','',$EZ_SESSION_VARS["WYSIWYG_Version"]);
		} else {
			$WYSIWYG_Version = str_replace(' ','',$GLOBALS["WYSIWYG_Version"]);
		}
		if ($WYSIWYG_Version == '') { $WYSIWYG_Version = '3Beta'; }

		if (($WYSIWYG_Version == '2') || ($WYSIWYG_Version == '2Modified')) {
			$textareas = $GLOBALS["textareas"];
			for ($i=0, $max=count($textareas); $i<$max; $i++) {
				$val = array_pop($textareas);
				?>
				<script language="javascript1.2" defer>editor_generate('<?php echo $val; ?>')</script> 
				<?php
			}
		} else {
			?>
			<script language="javascript1.2" type="text/javascript">
				<!-- Begin
					initEditor();
				//  End -->
			</script> 
			<?php
		}
	}
	?>
	</body>
	</html>
	<?php
} // function adminformclose()


function admintitle($colspan,$title)
{
	?>
	<body leftmargin=0 topmargin=0 marginwidth="0" marginheight="0" class="mainback">
	<center>
	<table border="0" width="100%" cellspacing="3" cellpadding="3">
	<?php
	adminformtitle($colspan,$title);
} // function admintitle()


function adminformtitle($colspan,$title)
{
	?>
	<tr class="headercontent">
		<td colspan="<?php echo $colspan; ?>" align="center" class="header">
			<b><?php echo $title; ?></b>
		</td>
	</tr>
	<?php
} // adminformtitle()


function adminbuttontest($directory,$filename,$language,$alttext,$border,$default)
{
	$button = lsimagehtmltag($directory,$filename,$language,$alttext,$border);
	if ($button == '') {
		$button = lsimagehtmltag($GLOBALS["style_home"],$default,$language,$alttext,$border);
	}
	return $button;
}  // adminbuttontest()

function adminbuttons($tView,$tAddNew,$tEdit,$tDelete)
{
	global $EzAdmin_Style;

	// Generate image tags for the different images that appear on the page
	if ($GLOBALS["gsDirection"] == 'rtl') {
		$GLOBALS["iFirst"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["LastIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tFirstPage"],0,'last_button.gif');
		$GLOBALS["iPrev"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["NextIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tPrevPage"],0,'next_button.gif');
		$GLOBALS["iNext"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["PrevIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tNextPage"],0,'prev_button.gif');
		$GLOBALS["iLast"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["FirstIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tLastPage"],0,'first_button.gif');
	} else {
		$GLOBALS["iFirst"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["FirstIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tFirstPage"],0,'first_button.gif');
		$GLOBALS["iPrev"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["PrevIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tPrevPage"],0,'prev_button.gif');
		$GLOBALS["iNext"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["NextIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tNextPage"],0,'next_button.gif');
		$GLOBALS["iLast"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["LastIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tLastPage"],0,'last_button.gif');
	}
	$GLOBALS["iAddNew"]	= adminbuttontest($GLOBALS["icon_home"],'addnew_button.gif',$GLOBALS["gsLanguage"],$tAddNew,0,'addnew_button.gif');
	$GLOBALS["iView"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["ViewIcon"],$GLOBALS["gsLanguage"],$tView,0,'view_button.gif');
	$GLOBALS["iEdit"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["EditIcon"],$GLOBALS["gsLanguage"],$tEdit,0,'edit_button.gif');
	$GLOBALS["iDelete"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["DeleteIcon"],$GLOBALS["gsLanguage"],$tDelete,0,'del_button.gif');
	$GLOBALS["iBlank"]	= imagehtmltag($GLOBALS["icon_home"],'blank.gif','',0,'');
	$GLOBALS["iUp"]		= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["UpIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tMoveUp"],0,'up.gif');
	$GLOBALS["iDown"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["DownIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tMoveDown"],0,'down.gif');
	$GLOBALS["iSort"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["SortIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tSort"],0,'sort.gif');
	$GLOBALS["iCSort"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["CurrentSortIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tSort"],0,'current_sort.gif');

	$GLOBALS["tAddNew"] = $tAddNew;
} // function adminbuttons()


function RenderPageList($nCPage,$nPages,$pLink,$linkmod='')
{
	global $HTTP_GET_VARS;

	$pagelist .= '&nbsp;&nbsp;'.$GLOBALS["tPage"].' ';
	$pagelist .= '<select name="page" class="paging" onChange="submit();">';
	for ($i=0; $i<$nPages; $i++) {
		$j = $i+1;
		$pagelist .= "<option";
		if (intval($nCPage)==$j) { $pagelist .= " selected"; }
		$pagelist .= ' value="'.$i.'">'.$j.'</option>';
	}
	$pagelist .= '</select>';
	$pagelist .= ' '.$GLOBALS["tOf"].' '.$nPages.'&nbsp;&nbsp;';
	$pagelist .= '<input type="hidden" name="ezSID" value="'.$GLOBALS["ezSID"].'">';
	$pagelist .= '<input type="hidden" name="sort" value="'.$HTTP_GET_VARS["sort"].'">';
	if ($linkmod != '') {
		$parms = explode('&',$linkmod);
		for ($i=0, $max=count($parms); $i<$max; $i++) {
			$parmset = array_pop($parms);
			$parm = explode('=',$parmset);
			$parmname = $parm[0];
			$parmval = $parm[1];
			if ($parmname != '') { $pagelist .= '<input type="hidden" name="'.$parmname.'" value="'.$parmval.'">'; }
		}
	}
	return $pagelist;
} // function RenderPageList()


function adminHdFt($form,$colspan,$nCurrentPage,$nPages,$linkmod)
{
	global $HTTP_GET_VARS;

	$pLink = BuildLink('m_'.$form.'.php').'&sort='.$HTTP_GET_VARS["sort"];
	$fLink = BuildLink('m_'.$form.'form.php').'&sort='.$HTTP_GET_VARS["sort"];
	$hlink = '<a href="'.$fLink.'&page='.$nCurrentPage.$linkmod.'" title="'.$GLOBALS["tAddNew"].'" '.BuildLinkMouseOver($GLOBALS["tAddNew"]).'>';
	echo '<form name="PagingForm" action="'.$pLink.'" method="GET">';
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<table height="100%" width="100%" cellspacing="0" cellpadding="0">
				<tr><?php
					if ($GLOBALS["canadd"] === True) {
						?><td align="<?php echo $GLOBALS["left"]; ?>" valign="bottom"><?php
						echo displaybutton('addbutton',$form,$GLOBALS["tAddNew"].'...',$hlink);
						?></td><?php
					}
					?>
					<td align="<?php echo $GLOBALS["right"]; ?>" valign="bottom">
						<?php
						$first = $GLOBALS["iFirst"];
						if ($nCurrentPage != 0) { $first = '<a href="'.$pLink.$linkmod.'&page=0" '.BuildLinkMouseOver($GLOBALS["tFirstPage"]).'>'.$first.'</a>'; }
						echo '&nbsp;';
						$prev = $GLOBALS["iPrev"];
						$prevpage = $nCurrentPage - 1;
						if ($nCurrentPage != 0) { $prev = '<a href="'.$pLink.$linkmod.'&page='.$prevpage.'" '.BuildLinkMouseOver($GLOBALS["tPrevPage"]).'>'.$prev.'</a>'; }
						$nCPage = $nCurrentPage + 1;
						$pageref .= RenderPageList($nCPage,$nPages,'m_'.$form.'.php',$linkmod);
						$next = $GLOBALS["iNext"];
						$nextpage = $nCurrentPage + 1;
						if ($nCurrentPage + 1 != $nPages) { $next = '<a href="'.$pLink.$linkmod.'&page='.$nextpage.'" '.BuildLinkMouseOver($GLOBALS["tNextPage"]).'>'.$next.'</a>'; }
						echo '&nbsp;';
						$last = $GLOBALS["iLast"];
						$lastpage = $nPages - 1;
						if ($nCurrentPage + 1 != $nPages) { $last = '<a href="'.$pLink.$linkmod.'&page='.$lastpage.'" '.BuildLinkMouseOver($GLOBALS["tLastPage"]).'>'.$last.'</a>'; }
						echo $first.'&nbsp;'.$prev.$pageref.$next.'&nbsp;'.$last;
						?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<?php
	echo '</form>';
} // function adminHdFt()


function adminlistitem($width,$title,$align='',$order='')
{
	global $HTTP_SERVER_VARS, $HTTP_GET_VARS;

	if ($align == 'r') { $talign = $GLOBALS["right"];
	} elseif ($align == 'c') { $talign = 'center';
	} else { $talign = $GLOBALS["left"]; }
	?>
	<th width="<?php echo $width; ?>%"<?php if ($align != '') { echo ' align="'.$talign.'"'; } ?> valign="bottom" class="content">
		<b><?php echo $title; ?></b><?php
		if ($order != '') {
			$href = $HTTP_SERVER_VARS["PHP_SELF"];
			if ($HTTP_SERVER_VARS["QUERY_STRING"] != '') { $href .= '?'.$HTTP_SERVER_VARS["QUERY_STRING"]; } else { $href .= '?'; }
			if (strpos($href,'&sort=') === False) {
				$href = $href.'&sort='.$order;
			} else {
				$href = str_replace('&sort='.$HTTP_GET_VARS["sort"],'&sort='.$order, $href);
			}
			if ($order == $HTTP_GET_VARS["sort"]) {
				echo '&nbsp;&nbsp;'.$GLOBALS["iCSort"];
			} else {
				echo '&nbsp;&nbsp;<a href="'.$href.'" '.BuildLinkMouseOver($GLOBALS["tSort"]).'>'.$GLOBALS["iSort"].'</a>';
			}
		}
		?>
	</th>
	<?php
} // function adminlistitem()


function admineditcheck($linkref,$varname,$value,$userid)
{
	global $HTTP_GET_VARS, $EZ_SESSION_VARS;

	$fLink = BuildLink('m_'.$linkref.'.php');
	if ($GLOBALS["canedit"] == False) {
		if ($userid == $EZ_SESSION_VARS["UserID"]) {
			if (isset($HTTP_GET_VARS["filtergroupname"])) {
				// Owner Edit privileges
				?>
				<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
				<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
			} else {
				?>
				<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
				<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
			}
		} else {
			if ($GLOBALS["canview"] == False) {
				// No privileges
				echo $GLOBALS["iBlank"];
			} else  {
				// View only privileges
				if (isset($HTTP_GET_VARS["filtergroupname"])) {
					?>
					<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tView"]); ?>>
					<?php echo $GLOBALS["iView"]; ?></a>&nbsp;<?php
				} else {
					?>
					<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tView"]); ?>>
					<?php echo $GLOBALS["iView"]; ?></a>&nbsp;<?php
				}
			}
		}
	} else {
		// Full Edit privileges
		if (isset($HTTP_GET_VARS["filtergroupname"])) {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
			<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
		} else {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
			<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
		}
	}
} // function admineditcheck()


function admineditcheck2($linkref,$varname1,$value1,$varname2,$value2,$userid)
{
	global $HTTP_GET_VARS, $EZ_SESSION_VARS;

	$fLink = BuildLink('m_'.$linkref.'.php');
	if ($GLOBALS["canedit"] == False) {
		if ($userid == $EZ_SESSION_VARS["UserID"]) {
			// Owner Edit privileges
			if (isset($HTTP_GET_VARS["filtergroupname"])) {
				?>
				<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
				<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
			} else {
				?>
				<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
				<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
			}
		} else {
			if ($GLOBALS["canview"] == False) {
				// No privileges
				echo $GLOBALS["iBlank"];
			} else {
				// View only privileges
				if (isset($HTTP_GET_VARS["filtergroupname"])) {
					?>
					<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tView"]); ?>>
					<?php echo $GLOBALS["iView"]; ?></a>&nbsp;<?php
				} else {
					?>
					<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tView"]); ?>>
					<?php echo $GLOBALS["iView"]; ?></a>&nbsp;<?php
				}
			}
		}
	} else {
		// Full Edit privileges
		if (isset($HTTP_GET_VARS["filtergroupname"])) {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
			<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
		} else {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tEdit"]); ?>>
			<?php echo $GLOBALS["iEdit"]; ?></a>&nbsp;<?php
		}
	}
} // function admineditcheck2()


function admintranslatecheck($linkref,$varname1,$value1,$varname2,$value2)
{
	global $HTTP_GET_VARS;

	$fLink = BuildLink('m_'.$linkref.'.php');
	if ($GLOBALS["cantranslate"] == False) {
		// No privilege
		echo $GLOBALS["iBlank"];
	} else {
		// Add privilege
		if (isset($HTTP_GET_VARS["filtergroupname"])) {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tTranslate"]); ?>>
			<?php echo $GLOBALS["iTranslate"]; ?></a>&nbsp;<?php
		} else {
			?>
			<a href="<?php echo $fLink; ?>&<?php echo $varname1; ?>=<?php echo $value1; ?>&<?php echo $varname2; ?>=<?php echo $value2; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tTranslate"]); ?>>
			<?php echo $GLOBALS["iTranslate"]; ?></a>&nbsp;<?php
		}
	}
} // admintranslatecheck()


function admindeletecheck($linkref,$varname,$value)
{
	global $HTTP_GET_VARS;

	if ($GLOBALS["candelete"] == False) {
		// No privilege
		echo $GLOBALS["iBlank"];
	} else {
		// Delete privilege
		if (isset($HTTP_GET_VARS["filtergroupname"])) {
			?>
			<a href="javascript:<?php echo $linkref; ?>('<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>');" <?php echo BuildLinkMouseOver($GLOBALS["tDelete"]); ?>>
			<?php echo $GLOBALS["iDelete"]; ?></a><?php
		} else {
			?>
			<a href="javascript:<?php echo $linkref; ?>('<?php echo $varname; ?>=<?php echo $value; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>');" <?php echo BuildLinkMouseOver($GLOBALS["tDelete"]); ?>>
			<?php echo $GLOBALS["iDelete"]; ?></a><?php
		}
	}
} // function admindeletecheck()


function adminmovecheck($direction,$linkref,$varname,$value)
{
	global $HTTP_GET_VARS;

	if ($GLOBALS["canedit"] == False) {
		// No privilege
		echo $GLOBALS["iBlank"];
	} else {
		// Move privilege
		if (isset($HTTP_GET_VARS["filtergroupname"])) {
			?>
			<a href="javascript:<?php echo $linkref; ?>('<?php echo $varname; ?>=<?php echo $value; ?>&direction=<?php echo $direction; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>');"<?php
		} else {
			?><a href="javascript:<?php echo $linkref; ?>('<?php echo $varname; ?>=<?php echo $value; ?>&direction=<?php echo $direction; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>');"<?php
		}
		if ($direction == 'up') {
			echo BuildLinkMouseOver($GLOBALS["tMoveUp"]).'>'.$GLOBALS["iUp"].'</a>';
		} else {
			echo BuildLinkMouseOver($GLOBALS["tMoveDown"]).'>'.$GLOBALS["iDown"].'</a>';
		}
	}
} // function adminmovecheck()


function adminformsavebar($colspan,$cancelref,$convertcharset=False)
{
	global $HTTP_GET_VARS, $HTTP_POST_VARS;

	if ($HTTP_POST_VARS["page"] == '') { $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"]; }
	if ($HTTP_POST_VARS["sort"] == '') { $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"]; }

	$tSave	= charsetText($GLOBALS["tSave"],$convertcharset,$GLOBALS["gsCharset"]);
	$tReset  = charsetText($GLOBALS["tReset"],$convertcharset,$GLOBALS["gsCharset"]);
	$tCancel = charsetText($GLOBALS["tCancel"],$convertcharset,$GLOBALS["gsCharset"]);
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<?php
			if ($GLOBALS["specialedit"] == True) {
				// Save privilege
				?>
				<input type="submit" value="<?php echo $tSave; ?>" name="submit">&nbsp;
				<input type="reset" value="<?php echo $tReset; ?>" name="reset">&nbsp;
				<?php
			}
			?>
			<input type="button" value="<?php echo $tCancel; ?>" onClick="javascript:document.location.href='<?php echo BuildLink($cancelref); ?>&page=<?php echo $HTTP_POST_VARS["page"]; ?>&sort=<?php echo $HTTP_POST_VARS["sort"]; ?>&filterlangname=<?php echo $HTTP_POST_VARS["LanguageCode"]; ?>'" name="cancel">
		</td>
	</tr>
	<?php
} // function adminformsavebar()


function fadminformsavebar($colspan,$cancelref)
{
	global $HTTP_GET_VARS, $HTTP_POST_VARS;

	if ($HTTP_POST_VARS["page"] == '') { $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"]; }
	if ($HTTP_POST_VARS["sort"] == '') { $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"]; }
	if ($HTTP_POST_VARS["filtergroupname"] == '') { $HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"]; }
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<?php
			if ($GLOBALS["specialedit"] == True) {
				// Save privilege
				?>
				<input type="submit" value="<?php echo $GLOBALS["tSave"]; ?>" name="submit">&nbsp;
				<input type="reset" value="<?php echo $GLOBALS["tReset"]; ?>" name="reset">&nbsp;
				<?php
			}
			?>
			<input type="button" value="<?php echo $GLOBALS["tCancel"]; ?>" onClick="javascript:document.location.href='<?php echo BuildLink($cancelref); ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_POST_VARS["sort"]; ?>&filtergroupname=<?php echo $HTTP_GET_VARS["filtergroupname"]; ?>&filterlangname=<?php echo $HTTP_POST_VARS["LanguageCode"]; ?>'" name="cancel">
		</td>
	</tr>
	<?php
} // function fadminformsavebar()


function adminhelpmsg($colspan)
{
	?>
	<tr class="headercontent">
		<td colspan="<?php echo $colspan; ?>">
			<?php echo $GLOBALS["tDetails"].'<br /><br />'.$GLOBALS["tHelpText"]; ?>
		</td>
	</tr>
	<?php
} // function adminhelpmsg()


function adminsubheader($colspan, $subheader)
{
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<?php echo '<b>'.$subheader.'</b>'; ?>
		</td>
	</tr>
	<?php
} // function adminsubheader()


function FieldHeading($field,$fieldfocus)
{
	$fieldtextkey = 't'.$field;
	$fieldhelpkey = 'h'.$field;
	?>
	<td valign="top" class="content">
	<?php
	if (isset($GLOBALS[$fieldhelpkey])) {
		?>
		<span style="cursor:help">
		<?php
		if ($GLOBALS["specialedit"] == True) {
			?><a OnClick='FieldHelp("<?php echo BuildLink('help.php'); ?>&form=<?php echo $GLOBALS["form"]; ?>&field=<?php echo $field; ?>", "<?php echo $fieldfocus; ?>");' tabindex="<?php echo $GLOBALS["tabindex"]; ?>"><?php
		}
		?>
		<b><?php echo $GLOBALS[$fieldtextkey]; ?>:</b></a></span><?php
	} else {
		?><b><?php echo $GLOBALS[$fieldtextkey]; ?>:</b><?php
	}
	?>
	</td>
	<?php
	$GLOBALS["tabindex"]++;
} // function FieldHeading()


function testPopupIcon($filespec)
{
	if ($GLOBALS["gsAdminStyle"] != '') {
		$fname = $GLOBALS["rootdp"].$GLOBALS["style_home"].$GLOBALS["gsAdminStyle"]."/images/".$filespec;
		if (file_exists($fname) != true) {
			$fname = $GLOBALS["rootdp"].$GLOBALS["style_home"].$filespec;
			if (file_exists($fname) != true) { $fname = ''; }
		}
	} else {
		$fname = $GLOBALS["rootdp"].$GLOBALS["style_home"].$filespec;
		if (file_exists($fname) != true) { $fname = ''; }
	}
	return $fname;
} // function testPopupIcon()


function adminimagedisplay($FieldName,$ImageFileName,$ShowMessage)
{
	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('imagepicker.gif');
		if ($fname != '') {
			?>&nbsp;<a name="<?php echo $FieldName; ?>_images"><a href="#<?php echo $FieldName; ?>_images" <?php echo BuildLinkMouseOver('ImagePicker'); ?> onclick="ImagePicker('<?php echo $FieldName; ?>');"><img src="<? echo $fname; ?>" alt="ImagePicker" border=0></a><?php
		} else {
			?>&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('ImagePicker'); ?> OnClick="javascript:ImagePicker('<?php echo $FieldName; ?>');"><?php
		}
	}
	if ($ImageFileName != "") {
		?><br /><a href="javascript:ShowImage('<?php echo $GLOBALS["rootdp"].$GLOBALS["image_home"].$ImageFileName; ?>');" <?php echo BuildLinkMouseOver($ShowMessage)?> class="small">
		<?php echo $ShowMessage; ?></a>
		<?php
	}
} // function adminimagedisplay()


function admincolourdisplay($FieldName)
{
	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('colourpicker.gif');
		if ($fname != '') {
			?>&nbsp;<a name="<?php echo $FieldName; ?>_colours"><a href="#<?php echo $FieldName; ?>_colours" <?php echo BuildLinkMouseOver('ColourPicker'); ?> onclick="ColorPicker('<?php echo $FieldName; ?>');"><img src="<? echo $fname; ?>" alt="ColourPicker" border=0></a><?php
		} else {
			?>&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('ColourPicker'); ?> onclick="ColorPicker('<?php echo $FieldName; ?>');"><?php
		}
	}
} // function admincolourdisplay()


function adminmoduledisplay($FieldName)
{
	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('modulepicker.gif');
		if ($fname != '') {
			?>&nbsp;<a name="<?php echo $FieldName; ?>_modules"><a href="#<?php echo $FieldName; ?>_modules" <?php echo BuildLinkMouseOver('ModulePicker'); ?> onclick="ModulePicker('<?php echo $FieldName; ?>');"><img src="<? echo $fname; ?>" alt="ModulePicker" border=0></a><?php
		} else {
			?>&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('ModulePicker'); ?> onclick="ModulePicker('<?php echo $FieldName; ?>');"><?php
		}
	}
} // function adminmoduledisplay()


function admintagdisplay($FieldName)
{
	global $EZ_SESSION_VARS;

	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('tagpicker.gif');
		if ($fname != '') {
			?>&nbsp;<a name="<?php echo $FieldName; ?>_tags"><a href="#<?php echo $FieldName; ?>_tags" <?php echo BuildLinkMouseOver('User TagPicker'); ?> onclick="TagPicker('<?php echo $FieldName; ?>');"><img src="<? echo $fname; ?>" alt="User TagPicker" border=0></a><?php
		} else {
			?>&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('User TagPicker'); ?> onclick="TagPicker('<?php echo $FieldName; ?>','<?php echo $EZ_SESSION_VARS["WYSIWYG"]; ?>');"><?php
		}
	}
} // function admintagdisplay()


function admintagdisplay2($FieldName)
{
	global $EZ_SESSION_VARS;

	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('tagpicker2.gif');
		if ($fname != '') {
			?>&nbsp;<a name="<?php echo $FieldName; ?>_tags2"><a href="#<?php echo $FieldName; ?>_tags2" <?php echo BuildLinkMouseOver('ezContents TagPicker'); ?> onclick="TagPicker2('<?php echo $FieldName; ?>','<?php echo $EZ_SESSION_VARS["WYSIWYG"]; ?>');"><img src="<? echo $fname; ?>" alt="ezContents TagPicker" border=0></a><?php
		} else {
			?>&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('ezContents TagPicker'); ?> onclick="TagPicker2('<?php echo $FieldName; ?>','<?php echo $EZ_SESSION_VARS["WYSIWYG"]; ?>');"><?php
		}
	}
} // function admintagdisplay2()


function ColourField($fieldname,$fieldvalue)
{
	echo '<input style="background-color: '.$fieldvalue.'" onChange="changeColor(this,this.value)" type="text" name="'.$fieldname.'" id="'.$fieldname.'" size="16" value="'.$fieldvalue.'" maxlength="16"'.$GLOBALS["fieldstatus"].'>';
	admincolourdisplay($fieldname);
} // function ColourField()


function admindatedisplay($FieldName,$DisplayDate='',$DefaultDate='')
{
	if (trim($DisplayDate) == '' ) { $DisplayDate = $DefaultDate; }
	if (trim($DisplayDate) == '' ) { $DisplayDate = sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")); }

	echo '<select size="1" name="'.$FieldName.'Day"'.$GLOBALS["fieldstatus"].'>';
	BuildDays(substr($DisplayDate, 8, 2));
	echo '</select>';
	echo '<select size="1" name="'.$FieldName.'Month"'.$GLOBALS["fieldstatus"].'>';
	BuildMonths(substr($DisplayDate, 5, 2));
	echo '</select>';
	echo '<select size="1" name="'.$FieldName.'Year"'.$GLOBALS["fieldstatus"].'>';
	BuildYears(substr($DisplayDate, 0, 4));
	echo '</select>';

	if ($GLOBALS["specialedit"] == True) {
		$fname = testPopupIcon('datepicker.gif');
		if ($fname != '') {
			?>&nbsp;&nbsp;<a name="<?php echo $FieldName; ?>_dates"><a href="#<?php echo $FieldName; ?>_dates" <?php echo BuildLinkMouseOver('DatePicker'); ?> onclick="DatePicker('<?php echo $FieldName; ?>',document.MaintForm.<?php echo $FieldName; ?>Month.value,document.MaintForm.<?php echo $FieldName; ?>Year.value);"><img src="<? echo $fname; ?>" alt="DatePicker" border=0></a><?php
		} else {
			?>&nbsp;&nbsp;<input type="button" value="..." <?php echo BuildLinkMouseOver('DatePicker'); ?> onclick="DatePicker('<?php echo $FieldName; ?>',document.MaintForm.<?php echo $FieldName; ?>Month.value,document.MaintForm.<?php echo $FieldName; ?>Year.value);"><?php
		}
	}
} // function admindatedisplay()


function adminHTMLAreadisplay($FieldName,$FieldLabel,$FieldValue,$PrevFieldName,$colspan=1)
{
	global $EZ_SESSION_VARS;

	if ((isset($GLOBALS["textareas"])) && (in_array($FieldName,$GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
		FieldHeading($FieldLabel,$PrevFieldName); ?>
		<td valign="top" colspan="<?php echo $colspan; ?>" class="content">
		<textarea id="<?php echo $FieldName; ?>" name="<?php echo $FieldName; ?>" style="width:540; height:240"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $FieldValue; ?></textarea>
		<?php
	} else {
		FieldHeading($FieldLabel,$FieldName); ?>
		<td valign="top" colspan="<?php echo $colspan; ?>" class="content">
		<?php EditButtons($FieldLabel,$FieldName); ?>
		<textarea rows="8" id="<?php echo $FieldName; ?>" name="<?php echo $FieldName; ?>" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($FieldValue); ?></textarea>
		<?php
	}
	admintagdisplay($FieldName);
	admintagdisplay2($FieldName);
	echo '</td>';
} // function adminHTMLAreadisplay()

function BuildDays($nDaySelected)
{
	for ($i=1; $i<=31; $i=$i+1) {
		echo "<option";
		if (intval($nDaySelected)==$i) { echo " selected"; }
		echo " value=\"".$i."\">".$i."</option>".chr(13);
	}
} // function BuildDays()


function BuildMonths($nMonthSelected)
{
	$Months = $GLOBALS["tMonth_Array"];
	for ( $sMonth = 1; $sMonth <= 12; $sMonth++ ) {
		$s = "";
		if ($sMonth == $nMonthSelected) $s = " selected";
		echo '<option value="'.$sMonth.'"'.$s.'>'.$Months[$sMonth].'</option>';
	}
} // function BuildMonths()


function BuildYears($nYearSelected)
{
	for ($i=2000; $i<=2050; $i=$i+1) {
		echo "<option";
		if (intval($nYearSelected) == $i) { echo " selected"; }
		echo " value=\"".$i."\">".$i."</option>".chr(13);
	}
} // function BuildYears()


function UpdateSetting($value,$name)
{
	$strQuery = "UPDATE ".$GLOBALS["eztbSettings"]." SET settingvalue='".$value."' WHERE settingname='".$name."'";
	$result = dbExecute($strQuery,true);

	$strQuery = "SELECT cssentry FROM ".$GLOBALS["eztbSettings"]." WHERE settingname='".$name."' AND cssentry = 'Y'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rcheck = dbRowsReturned($result);
	if ($rcheck != 0) {
		dbFreeResult($result);
		return true;
	}
	dbFreeResult($result);
	return false;
} // function UpdateSetting()


function bRecordExists($table,$field,$value,$ref)
{
	global $HTTP_POST_VARS;

	$strQuery = "SELECT ".$ref." FROM ".$GLOBALS[$table]." WHERE ".$field."='".$value."' AND language='".$GLOBALS["gsLanguage"]."'";
	if ($HTTP_POST_VARS[$ref] != '') {
		$strQuery .= " AND ".$ref." <> ".$HTTP_POST_VARS[$ref];
	}
	$result = dbRetrieve($strQuery,true,0,0);
	$rcheck = dbRowsReturned($result);
	if ($rcheck != 0) {
		dbFreeResult($result);
		return true;
	}
	dbFreeResult($result);
	return false;
} // function bRecordExists()


function GetSpecialData($ModuleName)
{
	$GLOBALS["scTable"] = $GLOBALS["scCatTable"] = "";

	$strQuery = "SELECT * FROM ".$GLOBALS["eztbSpecialcontents"]." WHERE scname='".$ModuleName."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rs			= dbFetch($result);
	if ($rs["scname"] == $ModuleName) {
		$GLOBALS["scTable"] = $rs["scdb"];
		if ($rs["scuseprefix"] == 'Y') { $GLOBALS["scTable"] = $GLOBALS["eztbPrefix"].$GLOBALS["scTable"]; }
		$GLOBALS["scTitle"]				= $rs["sctitle"];
		$GLOBALS["scValidate"]			= $rs["scvalid"];
		$GLOBALS["scLoginRequired"]		= $rs["screg"];
		$GLOBALS["scUsergroups"]		= $rs["usergroups"];
		$GLOBALS["subTextDisplay"]		= $rs["stextdisplay"];
		$GLOBALS["subText"]				= $rs["stext"];
		$GLOBALS["subGraphicDisplay"]	= $rs["sgraphicdisplay"];
		$GLOBALS["subGraphic"]			= $rs["sgraphic"];
		$GLOBALS["scUseCategories"]		= $rs["scusecategories"];
		$GLOBALS["scOrderBy"]			= $rs["orderby"];
		$GLOBALS["scPostedBy"]			= $rs["showpostedby"];
		$GLOBALS["scPostedDate"]		= $rs["showposteddate"];
		$GLOBALS["scPerPage"]			= $rs["perpage"];
		if ($GLOBALS["scUseCategories"] == 'Y') {
			$GLOBALS["scCatTable"] = $GLOBALS["scTable"].'categories';
		}
	}
	dbFreeResult($result);

} // function GetSpecialData()


function CssTag($tagname,$colour,$font,$fontsize,$fontstyle='',$bgtype='',$background='',$backgroundrepeat='')
{
	$csstagstr = chr(10).$tagname.chr(10);
	$csstagstr .= '{'.chr(10);
	if ($fontsize != '') { $csstagstr .= '	FONT-SIZE: '.$fontsize.';'.chr(10); }
	if ($colour != "") {
		$csstagstr .= '	COLOR: ';
		if (is_numeric($colour)) { $csstagstr .= '#'; }
		$csstagstr .= $colour.';'.chr(10);
	}
	if ($font != '') { $csstagstr .= '	FONT-FAMILY: '.$font.';'.chr(10); }
	if ($fontstyle != '') { $csstagstr .= '	TEXT-DECORATION: '.$fontstyle.';'.chr(10); }
	if ($bgtype == 'IMAGE') {
		if ($background != '') {
			if ($background == 'NONE') { $csstagstr .= '	BACKGROUND-IMAGE: '.$background.';'.chr(10);
			} else { $csstagstr .= '	BACKGROUND-IMAGE: URL('.$GLOBALS["rootref"].$GLOBALS["image_home"].$background.');'.chr(10); }
			if ($backgroundrepeat != '') {
				$csstagstr .= 'BACKGROUND-REPEAT: ';
				if ($backgroundrepeat != "Y") { $csstagstr .= 'NO-'; }
				$csstagstr .= 'REPEAT;'.chr(10);
			}
		}
	}
	if ($bgtype == 'COLOUR') {
		if ($background != '') {
			$csstagstr .= '	BACKGROUND-COLOR: ';
			if (is_numeric($background)) { $csstagstr .= '#'; }
			$csstagstr .= $background.';'.chr(10);
		}
	}
	$csstagstr .= '}'.chr(10);
	return $csstagstr;
} // function CssTag()


function CssBackTag($tagname,$colour,$font,$fontsize,$fontstyle,$bgimage,$bgimagerepeat,$bgimagefixed,$bgcolour)
{
	$csstagstr = chr(10).$tagname.chr(10);
	$csstagstr .= '{'.chr(10);
	$csstagstr .= '	MARGIN: 0;'.chr(10);
	if ($fontsize != '') { $csstagstr .= '	FONT-SIZE: '.$fontsize.';'.chr(10); }
	if ($colour != "") {
		$csstagstr .= '	COLOR: ';
		if (is_numeric($colour)) { $csstagstr .= '#'; }
		$csstagstr .= $colour.';'.chr(10);
	}
	if ($font != '') { $csstagstr .= '	FONT-FAMILY: '.$font.';'.chr(10); }
	if ($fontstyle != '') { $csstagstr .= '	TEXT-DECORATION: '.$fontstyle.';'.chr(10); }
	if ($bgimage != '') {
		if ($bgimage == 'NONE') { $csstagstr .= '	BACKGROUND-IMAGE: '.$bgimage.';'.chr(10); }
		else { $csstagstr .= '	BACKGROUND-IMAGE: URL('.$GLOBALS["rootref"].$GLOBALS["image_home"].$bgimage.');'.chr(10); }
		$csstagstr .= 'BACKGROUND-REPEAT: ';
		if ($bgimagerepeat != "Y") { $csstagstr .= 'NO-'; }
		$csstagstr .= 'REPEAT;'.chr(10);
		if ($bgimagefixed != '') {
			$csstagstr .= 'BACKGROUND-ATTACHMENT: FIXED;'.chr(10);
		}
	}
	if ($bgcolour != '') {
		$csstagstr .= '	BACKGROUND-COLOR: ';
		if (is_numeric($bgcolour)) { $csstagstr .= '#'; }
		$csstagstr .= $bgcolour.';'.chr(10);
	}
	$csstagstr .= '}'.chr(10);
	return $csstagstr;
} // function CssBackTag()


function RebuildStyleSheet()
{
	GLOBAL $EZ_SESSION_VARS;

	// If site is configured with Safe Mode enabled, or open_basedir defined, we always generate the stylesheet at run-time,
	//		so don't bother building it now.
	if ($GLOBALS["safe_mode"] || $GLOBALS["open_basedir"] <> '') { return false; }


	//  Retrieve the settings we've just updated
	GetSettings();
	$savedir = getcwd();

	//  Work out the directory that we need to save the file to based on Site and Theme
	if ($EZ_SESSION_VARS["Site"] != '') {
		$setdir = $GLOBALS["rootdp"].$GLOBALS["sites_home"];
		$setdir .= $EZ_SESSION_VARS["Site"];
		if ($EZ_SESSION_VARS["Theme"] != '') {
			$setdir .= '/themes/';
			$setdir .= $EZ_SESSION_VARS["Theme"];
		}
	} else {
		$setdir = $GLOBALS["rootdp"].$GLOBALS["themes_home"];
		if ($EZ_SESSION_VARS["Theme"] != '') {
			$setdir .= $EZ_SESSION_VARS["Theme"];
		}
	}
	if (substr($setdir,-1) == '/') { $setdir = substr($setdir,0,-1); }
	chdir($setdir);
	//  Images referenced in the stylesheet are relative to the stylesheet directory, so work
	//			out the relative directory
	$reldir = explode('/',$setdir);
	$count = count($reldir) - 1;
	$GLOBALS["rootref"] = str_repeat('../',$count);
	//  Write the stylesheet file
	$fp = fopen("ezc.css", "wb");

	fwrite($fp,CssTag('A',$GLOBALS["color_ahref"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));
	fwrite($fp,CssTag('A:visited',$GLOBALS["color_ahref_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));
	fwrite($fp,CssTag('A:hover',$GLOBALS["color_ahref_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));

	if ($GLOBALS["gsSmallFontSize"] != "") {
		fwrite($fp,CssTag('A.small',$GLOBALS["color_ahref_small"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],$GLOBALS["gsFontStyle1"]));
		fwrite($fp,CssTag('A.small:visited',$GLOBALS["color_ahref_small_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],$GLOBALS["gsFontStyle1"]));
		fwrite($fp,CssTag('A.small:hover',$GLOBALS["color_ahref_small_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],$GLOBALS["gsFontStyle1"]));
	} else {
		fwrite($fp,CssTag('A.small',$GLOBALS["color_ahref_small"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));
		fwrite($fp,CssTag('A.small:visited',$GLOBALS["color_ahref_small_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));
		fwrite($fp,CssTag('A.small:hover',$GLOBALS["color_ahref_small_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],$GLOBALS["gsFontStyle1"]));
	}

	fwrite($fp,CssTag('A.menulink',$GLOBALS["menu_color_ahref"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize3"],$GLOBALS["gsFontStyle3"]));
	fwrite($fp,CssTag('A.menulink:visited',$GLOBALS["menu_color_ahref_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize3"],$GLOBALS["gsFontStyle3"]));
	fwrite($fp,CssTag('A.menulink:hover',$GLOBALS["menu_color_ahref_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize3"],$GLOBALS["gsFontStyle3"]));

	fwrite($fp,CssTag('A.topmenulink',$GLOBALS["topmenu_color_ahref"],$GLOBALS["gsFont1"],$GLOBALS["gsTopMenuFontSize"],$GLOBALS["gsTopMenuFontStyle"]));
	fwrite($fp,CssTag('A.topmenulink:visited',$GLOBALS["topmenu_color_ahref_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsTopMenuFontSize"],$GLOBALS["gsTopMenuFontStyle"]));
	fwrite($fp,CssTag('A.topmenulink:hover',$GLOBALS["topmenu_color_ahref_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsTopMenuFontSize"],$GLOBALS["gsTopMenuFontStyle"]));

	fwrite($fp,CssTag('A.rightcol',$GLOBALS["rcol_color_ahref"],$GLOBALS["gsFont1"],$GLOBALS["gsRColFontSize"],$GLOBALS["gsRColFontStyle"]));
	fwrite($fp,CssTag('A.rightcol:visited',$GLOBALS["rcol_color_ahref_visited"],$GLOBALS["gsFont1"],$GLOBALS["gsRColFontSize"],$GLOBALS["gsRColFontStyle"]));
	fwrite($fp,CssTag('A.rightcol:hover',$GLOBALS["rcol_color_ahref_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsRColFontSize"],$GLOBALS["gsRColFontStyle"]));

	fwrite($fp,CssTag('A.heading',$GLOBALS["color_header"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize2"]));
	fwrite($fp,CssTag('A.heading:visited',$GLOBALS["color_header"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize2"]));
	fwrite($fp,CssTag('A.heading:hover',$GLOBALS["color_ahref_hover"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize2"]));

	fwrite($fp,CssTag('TD',$GLOBALS["color_td"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','IMAGE','NONE'));
	fwrite($fp,CssTag('H1',$GLOBALS["color_h1"],$GLOBALS["gsFont1"],'20px'));
	fwrite($fp,CssTag('.header',$GLOBALS["color_header"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize2"],'','IMAGE',$GLOBALS["gsHeaderBg"],$GLOBALS["gbHeaderBgRep"]));
	fwrite($fp,CssTag('.rcolheader',$GLOBALS["rcol_color_header"],$GLOBALS["gsFont1"],$GLOBALS["gsRColHeaderFontSize"],'','IMAGE',$GLOBALS["gsHeaderBg"],$GLOBALS["gbHeaderBgRep"]));
	fwrite($fp,CssTag('.teaserheader',$GLOBALS["gsColor_tsrheader"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize2"],'','IMAGE',$GLOBALS["gsHeaderBg"],$GLOBALS["gbHeaderBgRep"]));

	fwrite($fp,CssTag('.headercontent','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["bgcolor_headercnt"]));
	fwrite($fp,CssTag('.teaserheadercontent','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["gsBgcolor_headertsr"]));
	fwrite($fp,CssTag('.rcolheadercontent','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["rcol_bgcolor_headercnt"]));

	fwrite($fp,CssTag('.tablecontent',$GLOBALS["color_td"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["bgcolor_cnttbl"]));
	fwrite($fp,CssTag('.teasercontent',$GLOBALS["gsColor_tsrtd"],$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["gsBgcolor_tsrtbl"]));
	fwrite($fp,CssTag('.rcolcontent',$GLOBALS["rcol_color_td"],$GLOBALS["gsFont1"],$GLOBALS["gsRColFontSize"],'','COLOUR',$GLOBALS["rcol_bgcolor_cnttbl"]));

	fwrite($fp,CssTag('.tablecontentfooter',$GLOBALS["color_td"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],'','COLOUR',$GLOBALS["bgcolor_cnttbl"]));
	fwrite($fp,CssTag('.teasercontentfooter',$GLOBALS["gsColor_tsrtd"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],'','COLOUR',$GLOBALS["gsBgcolor_tsrtbl"]));

	fwrite($fp,CssTag('.menu','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["bgcolor_menu"]));
	fwrite($fp,CssTag('.topmenu','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'','COLOUR',$GLOBALS["bgcolor_topmenu"]));

	fwrite($fp,CssTag('.helptext',$GLOBALS["gsHelptextColor"],$GLOBALS["gsFont1"],$GLOBALS["gsHelptextFontSize"]));
	fwrite($fp,CssTag('.smalldropdown',$GLOBALS["gsHelptextColor"],$GLOBALS["gsFont1"],$GLOBALS["gsSmallFontSize"],$GLOBALS["gsFontStyle1"]));

	fwrite($fp,CssBackTag('.topback','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'',$GLOBALS["gsTopBg"],$GLOBALS["gbTopBgRep"],$GLOBALS["gbTopBgFix"],$GLOBALS["bgcolor_header"]));
	fwrite($fp,CssBackTag('.menuback','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'',$GLOBALS["gsMenuBg"],$GLOBALS["gbMenuBgRep"],$GLOBALS["gbMenuBgFix"],$GLOBALS["bgcolor_menu"]));
	fwrite($fp,CssBackTag('.mainback','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'',$GLOBALS["gsMainBg"],$GLOBALS["gbMainBgRep"],$GLOBALS["gbMainBgFix"],$GLOBALS["bgcolor_main"]));
	fwrite($fp,CssBackTag('.topmenuback','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'',$GLOBALS["gsTopMenuBg"],$GLOBALS["gbTopMenuBgRep"],$GLOBALS["gbTopMenuBgFix"],$GLOBALS["bgcolor_topmenu"]));
	fwrite($fp,CssBackTag('.bottomback','#FFFFFF',$GLOBALS["gsFont1"],$GLOBALS["gsFontSize1"],'',$GLOBALS["gsFooterBg"],$GLOBALS["gbFooterBgRep"],$GLOBALS["gbFooterBgFix"],$GLOBALS["bgcolor_footer"]));

	if ($GLOBALS["gnImageColumnBreak"] != '') {
		$csstagstr = chr(10).'.sep_column'.chr(10);
		$csstagstr .= '{'.chr(10);
		$csstagstr .= '	BACKGROUND-REPEAT : REPEAT-Y;'.chr(10);
		$csstagstr .= '	BACKGROUND : URL('.$GLOBALS["rootref"].$GLOBALS["image_home"].$GLOBALS["gnImageColumnBreak"].');'.chr(10);
		$csstagstr .= '}'.chr(10);
		fwrite($fp,$csstagstr);
	}

	$csstagstr = chr(10).'body, select, textarea'.chr(10);
	$csstagstr .= '{'.chr(10);
	$csstagstr .= '	scrollbar-face-color: '.$GLOBALS["bgcolor_main"].';'.chr(10);
	$csstagstr .= '	scrollbar-shadow-color: '.$GLOBALS["bgcolor_footer"].';'.chr(10);
	$csstagstr .= '	scrollbar-highlight-color: '.$GLOBALS["bgcolor_footer"].';'.chr(10);
	$csstagstr .= '	scrollbar-3dlight-color: '.$GLOBALS["bgcolor_main"].';'.chr(10);
	$csstagstr .= '	scrollbar-darkshadow-color: '.$GLOBALS["bgcolor_main"].';'.chr(10);
	$csstagstr .= '	scrollbar-track-color: '.$GLOBALS["bgcolor_main"].';'.chr(10);
	$csstagstr .= '	scrollbar-arrow-color: '.$GLOBALS["bgcolor_footer"].';'.chr(10);
	$csstagstr .= '}'.chr(10);
	fwrite($fp,$csstagstr);

	fclose($fp);
	chdir($savedir);
} // function RebuildStyleSheet()


function display_size($file_size)
{
	if ($file_size >= 1073741824) {
		$file_size = round($file_size / 1073741824 * 100) / 100 ." GB";
	} elseif ($file_size >= 1048576) {
		$file_size = round($file_size / 1048576 * 100) / 100 ." MB";
	} elseif ($file_size >= 1024) {
		$file_size = round($file_size / 1024 * 100) / 100 ." KB";
	} else {
		$file_size = $file_size." bytes";
	}
	return $file_size;
} // function display_size()


function formError($cols=1)
{
	$errorstring = implode('<li>',$GLOBALS["strErrors"]);
	echo '<tr bgcolor=#900000><td colspan="'.$cols.'"><b><ul><li>'.$errorstring.'</ul></b></td></tr>';
} // function formError()


function charsetText($text,$convertcharset,$fromcharset)
{
	$returntext = $text;
	if ($convertcharset) { $returntext = mb_convert_encoding($returntext,"UTF-8",$fromcharset); }
	return $returntext;
} // function charsetText()


function UTF8Text($text,$convertcharset,$tocharset)
{
	$returntext = $text;
	if ($convertcharset) { $returntext = mb_convert_encoding($returntext,$tocharset,"UTF-8"); }
	return $returntext;
} // function charsetText()


function SiteBaseUrl($Site='')
{
	$scriptpath = explode('/',$GLOBALS["PAGE_URL"]);
	$dummy = array_pop($scriptpath);
	$adp = explode('/',$GLOBALS["rootdp"]);
	$dpCount = count($adp);
	$i = 1;
	while ($i < $dpCount) {
		$dummy = array_pop($scriptpath);
		$i++;
	}
	if ($Site != '') { array_push($scriptpath, 'sites',$Site); }
	$SiteBaseUrl = implode('/',$scriptpath).'/';
	return $SiteBaseUrl;
} // function SiteBaseUrl()


function formatWYSIWYGText (&$ftext,$rtext)
{
	$nCurrent = 0;
	while ($nCurrent >= 0) {
		$nCurrent = strpos($ftext, $rtext, $nCurrent);
		if ($nCurrent === false) { $nCurrent = -1;
		} else {
			$nCurrent += strlen($rtext);
			$pretext = substr($ftext, 0, $nCurrent);
			$posttext = substr($ftext, $nCurrent);

			if ( (isExternalLink($posttext)) || (substr($posttext,0,1) == '#') ||
				 (substr($posttext,0,11) == 'javascript:') ) {
			} elseif (substr($posttext,0,2) == './') {
				$posttext = $GLOBALS["base_url"].substr($posttext,2);
			} else {
				$posttext = $GLOBALS["base_url"].$posttext;
			}
			$ftext = $pretext.$posttext;
		}
	}
	return $ftext;
} // formatWYSIWYGText ()


function formatWYSIWYG ($text)
{
	$ftext = $text;
	$pos = strpos($ftext, chr(10));
	if ($pos !== false) { $ftext = str_replace(chr(10),'<br />',$ftext); }
	//	Strip obsolete [html] tags
	$pos = strpos($ftext, $GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"]);
	if ($pos !== false) { 
		$ftext = str_replace($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"],'', $ftext);
		$ftext = str_replace($GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"],'', $ftext);
	}
	formatWYSIWYGText($ftext,'src="');
	formatWYSIWYGText($ftext,'href="');

	return $ftext;
} // function formatWYSIWYG ()


function array_csort()
{
	$args = func_get_args();
	$marray = array_shift($args);

	$msortline = "return(array_multisort(";
	foreach ($args as $arg) {
		$i++;
		if (is_string($arg)) {
			foreach ($marray as $row) {
				$sortarr[$i][] = $row[$arg];
			}
		} else {
			$sortarr[$i] = $arg;
		}
		$msortline .= "\$sortarr[".$i."],";
	}
	$msortline .= "\$marray));";

	eval($msortline);
	return $marray;
} // array_csort()


function safeModeWarning($colcount)
{
	if ($GLOBALS["safe_mode"] || $GLOBALS["open_basedir"] <> '') {
		echo '<tr bgcolor="#900000"><td colspan="'.$colcount.'"><b>'.$GLOBALS["eSafeModeWarning"].'</b></td></tr>';
	}
} // function safeModeWarning()

?>
