<?php

/***************************************************************************

 createbackup.php
 -----------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


$GLOBALS["form"] = 'backup';
$GLOBALS["validaccess"] = VerifyAdminLogin();
if ($GLOBALS["canadd"] == False) {
	Header("Location: ".BuildLink('adminlogin.php'));
}
$GLOBALS["specialedit"] = True;


$BackupFileTypes = array('sql', 'gz');


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','backup');


if (!isset($HTTP_POST_VARS["subdir"])) {
	$HTTP_GET_VARS["subdir"] = $HTTP_POST_VARS["subdir"];
}
if (isset($HTTP_GET_VARS["subdir"])) {
	$HTTP_GET_VARS["subdir"] = str_replace($GLOBALS["rootdp"], '', $HTTP_GET_VARS["subdir"]);
} else {
	$HTTP_GET_VARS["subdir"] = '';
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
	// User has submitted the data
	if (bCheckForm()) {
		$rval = CreateBackup();
		Header("Location: ".BuildLink('m_backup.php')."&subdir=".$HTTP_POST_VARS["subdir"].'&returncode='.$rval);
	}
} else {
	frmBackupForm();
}

function frmBackupForm()
{
	global $HTTP_GET_VARS;

	adminformheader();
	adminformopen('filename');
	adminformtitle(2,$GLOBALS["tFormTitle4"]);
	echo $GLOBALS["strErrors"];
	?>
	<tr class="tablecontent">
		<?php FieldHeading("Filename","filename"); ?>
		<td valign="top" class="content">
			<input type="text" name="filename" size="50" value="" maxlength="50">
		</td>
	</tr>
	<?php
	if (function_exists('gzopen')) {
		?>
		<tr class="tablecontent">
			<?php FieldHeading("UseGzip","use_compression"); ?>
			<td valign="top" class="content">
				<select name="use_compression" size="1">
					<option value="1" ><?php echo $GLOBALS["tGzipCompression"]; ?>
					<option value="0" selected><?php echo $GLOBALS["tGzipNoCompression"]; ?>
				</select>
			</td>
		</tr>
	<?php
	}

	adminformsavebar(2,'m_backup.php');
	adminhelpmsg(2);
	?><input type="hidden" name="subdir" value="<?php echo $HTTP_GET_VARS["subdir"]; ?>"><?php
	adminformclose();
} // function frmBackupForm()


function bCheckForm()
{
	global $HTTP_POST_VARS;

	$bFormOK = true;
	$strMessage = "<tr bgcolor=#900000><td colspan=\"2\"><b>";
	if ($HTTP_POST_VARS["filename"] == "") {
		$strMessage .= $GLOBALS["eFilenameEmpty"].'<br />';
		$bFormOK = false;
	}
	$strMessage .= "</b></td></tr>";
	if (!$bFormOK) { $GLOBALS["strErrors"] = $strMessage; }
	return $bFormOK;
} // function bCheckForm()





function get_tabledef($tablename)
{
	$tabledef = "";
	$tabledef .= "DROP TABLE IF EXISTS ".$tablename.";".chr(10);
	$tabledef .= "#".chr(10);
	$tabledef .= dbTableDef($tablename);

	return (stripslashes($tabledef));
} // function get_tabledef()


function get_content($tablename)
{
	$content = "";
	$sqlQuery = "SELECT * FROM ".$tablename;
	$result = dbExecute($sqlQuery,true);
	while ($row = dbFetch($result)) {
		$insert = "INSERT INTO ".$tablename." VALUES(";
		$fields = $GLOBALS["dbConn"]->MetaColumnNames($tablename);
		for ($j=0; $j<$result->FieldCount();$j++) {
			$fldname = $fields[$j];
			if ($row[$fldname] != "") { $row[$fldname] = addslashes($row[$fldname]); }
			if ($row[$fldname] != "") { $insert .= "'".$row[$fldname]."',";
			} else { $insert .= "'',"; }
		}
		$insert = ereg_replace(",$","",$insert);
		$insert .= ");".chr(10);
		$content .= $insert;
	}
	dbFreeResult($result);
	return $content;
} // function get_content()


function CreateBackup()
{
	global $HTTP_POST_VARS;

	set_time_limit(300);

	$rval = -2;

	$path = $GLOBALS["backup_home"].$HTTP_POST_VARS["subdir"];
	$filename = $HTTP_POST_VARS["filename"];
	$compression = $HTTP_POST_VARS["use_compression"];
	if ($compression == 1) { $filetype = "sql.gz";
	} else { $filetype = "sql"; }
//	flush();

	$comment = "#";

	$displaydate = sprintf("%s, %s %02d %04d, at %02d:%02d:%02d %s", strftime("%A"), strftime("%B"), strftime("%d"), strftime("%Y"), strftime("%I"), strftime("%M"), strftime("%S"), strftime("%p"));
	$newfile = "# Dump created with ezContents Backup ".$GLOBALS["Version"]." on ".$displaydate.chr(10).chr(10);

	$newfile .= $comment." --------------------------------------------------------".chr(10);
	$newfile .= $comment." ezContents ".$GLOBALS["ezContentsDB"]." backup".chr(10);
	$newfile .= $comment." ".$GLOBALS["Version"].chr(10);
	$newfile .= $comment.chr(10);
	$newfile .= $comment." Site            : ".$GLOBALS["gsSitetitle"].chr(10);
	$newfile .= $comment." Generation Time : ".$displaydate.chr(10);
	$newfile .= $comment." MySQL version   : ".mysql_get_server_info().chr(10);
	$newfile .= $comment." PHP Version     : ".phpversion().chr(10);
	$newfile .= $comment." Database        : '".$GLOBALS["ezContentsDBName"]."'".chr(10);
	$newfile .= $comment.chr(10).chr(10);

	$tables = $GLOBALS["dbConn"]->MetaTables();
	$num_tables = count($tables);
	$i = 0;
	while ($i < $num_tables) {
		$tablename = $tables[$i];

		$backitup = False;
		if ($GLOBALS["eztbPrefix"] != '') {
			if (substr($tablename,0,strlen($GLOBALS["eztbPrefix"])) == $GLOBALS["eztbPrefix"]) { $backitup = True; }
		} else { $backitup = True; }
		if ($backitup) {
			$newfile .= $comment." ----------------------------------------------------------".chr(10);
			$newfile .= $comment.chr(10);
			$newfile .= $comment." Table structure for table '".$tablename."'".chr(10);
			$newfile .= $comment.chr(10);
			$newfile .= get_tabledef($tablename);
			$newfile .= chr(10).chr(10);
			//  We don't dump data from the sessions table for security reasons
			if ($tablename == $GLOBALS["eztbSessions"]) {
				$newfile .= $comment.chr(10);
			} else {
				$newfile .= $comment.chr(10);
				$newfile .= $comment." Dumping data for table '".$tablename."'".chr(10);
				$newfile .= $comment.chr(10);
				$newfile .= get_content($tablename);
				$newfile .= chr(10).chr(10);
			}
		}
		$i++;
	}

	if ($compression == 1) {
		$fp = gzopen($GLOBALS["rootdp"].$path.$filename.".".$filetype,"wb9");
		if ($fp) {
			if (gzwrite($fp,$newfile) != -1) { $rval = 2; }
			gzclose($fp);
		}
	} else {
		$fp = fopen ($GLOBALS["rootdp"].$path.$filename.".".$filetype,"w");
		if ($fp) {
			if (fwrite($fp,$newfile) != -1) { $rval = 2; }
			fclose($fp);
		}
	}
	return $rval;
} // function CreateBackup()

include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
