<?php

/***************************************************************************

 datepicker.php
 ---------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the License which can be found within the
 *	zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."/include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
include ("adminbutton.php");
includeLanguageFiles('admin','main');


$todaydate = strftime("%d");
$todaymonth = strftime("%m");
$todayyear = strftime("%Y");

if (!isset($HTTP_POST_VARS["control"]))	{ $HTTP_POST_VARS["control"] = $HTTP_GET_VARS["control"]; }

if (!isset($HTTP_POST_VARS["day"]))		{ $HTTP_POST_VARS["day"] = $HTTP_GET_VARS["day"]; }
if (!isset($HTTP_POST_VARS["month"]))	{ $HTTP_POST_VARS["month"] = $HTTP_GET_VARS["month"]; }
if (!isset($HTTP_POST_VARS["year"]))	{ $HTTP_POST_VARS["year"] = $HTTP_GET_VARS["year"]; }

if ($HTTP_POST_VARS["day"] == '')	{ $HTTP_POST_VARS["day"] = $todaydate; }
if ($HTTP_POST_VARS["month"] == '')	{ $HTTP_POST_VARS["month"] = $todaymonth; }
if ($HTTP_POST_VARS["year"] == '')	{ $HTTP_POST_VARS["year"] = $todayyear; }

if (($HTTP_POST_VARS["day"] < 10) && (strlen($HTTP_POST_VARS["day"]) > 1)) { $HTTP_POST_VARS["day"] = substr($HTTP_POST_VARS["day"],1,1); }
if (($HTTP_POST_VARS["month"] < 10) && (strlen($HTTP_POST_VARS["month"]) > 1)) { $HTTP_POST_VARS["month"] = substr($HTTP_POST_VARS["month"],1,1); }


force_page_refresh();
frmDates($HTTP_POST_VARS["day"],$HTTP_POST_VARS["month"],$HTTP_POST_VARS["year"]);


function frmDates($dd,$mm,$yy)
{
	global $HTTP_POST_VARS, $EzAdmin_Style, $todaydate, $todaymonth, $todayyear;


	$month_titles = $GLOBALS["tMonth_Array"];
	$week_titles = $GLOBALS["tWeek_Array"];
	$x = $mm;
	$month_text = $month_titles[$x];

	admhdr();
	?>
	<script language="JavaScript" type="text/javascript">
		<!-- Begin
			function ReturnDate(sDD,sMM,sYY) {
				window.opener.document.MaintForm.<?php echo $HTTP_POST_VARS["control"]; ?>Day.value=sDD;
				window.opener.document.MaintForm.<?php echo $HTTP_POST_VARS["control"]; ?>Month.value=sMM;
				window.opener.document.MaintForm.<?php echo $HTTP_POST_VARS["control"]; ?>Year.value=sYY;
				window.close();
			}
		//  End -->
	</script>
	<title>DatePicker</title>
	</head>
	<body leftmargin=0 topmargin=0 marginwidth="0" marginheight="0" class="mainback">
	<table border="0" width="100%" cellspacing="3" cellpadding="3">


		<tr>
			<form name="MaintForm" action="<?php echo $GLOBALS["REQUEST_URI"]; ?>" method="POST" enctype="multipart/form-data">
				<td><select name="month"><?php RenderMonths($mm); ?></select></td>
				<td><select name="year"><?php RenderYears($yy); ?></select></td>
				<td><input type="image" name="submit" src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]; ?>go.gif" alt="Go" value="Go"></td>
				<input type="hidden" name="ezSID" value="<?php echo $GLOBALS["ezSID"]; ?>">
				<input type="hidden" name="control" value="<?php echo $HTTP_POST_VARS["control"]; ?>">
			</form>
		</tr>
		<tr><td colspan="3">
				<?php
				// Determine the total number of days in the month
				$totaldays = 31;
				while (!checkdate( $mm, $totaldays + 1, $yy )) { $totaldays--; }
				$totaldays++;

				// Build table
				?><table border="1" cellpadding="2" cellspacing="1" width="100%" class="tablecontent"><tr><?php
				for ( $x = 0; $x < 7; $x++ ) echo '<th><b>'.substr($week_titles[$x],0,1).'</b></th>';
				echo '</tr>';

				$day = 1;
				// Ensure that a number of blanks are put in so that the first day of the month lines up with the proper day of the week
				// $offset = date( "w", mktime( 0, 0, 0, $month, $day, $year )) + 1;
				$offset = date( "w", mktime( 0, 0, 0, $mm, $day, $yy ));
				if ($offset == 7) { $offset = 0; }
				echo '<tr>';
				if ($offset > 0) echo str_repeat( '<td>&nbsp;</td>', $offset );

				// Start entering in the information
				for ( $day = 1; $day <= $totaldays; $day++ ) {
					echo '<td align="center"><a href="javascript:ReturnDate('.$day.','.$mm.','.$yy.')">';
					if (($yy == $todayyear) && ($mm == $todaymonth) && ($day == $todaydate)) {
						echo '<font color="Red"><b>'.$day.'</b></font>';
					} else {
					if (($offset == 0) || ($offset == 6)) {
						echo '<font color="Blue"><b>'.$day.'</b></font>';
					} else {
						echo $day;
					}
					echo '</a></td>';
				}
				$offset++;
				// If we're on the last day of the week, wrap to the other side
				if ($offset > 6) {
					$offset = 0;
					echo '</tr>';
					if ( $day < $totaldays ) echo '<tr>';
				}
			}

			// Fill in the remaining spaces for the end of the month, just to make it look pretty
			if ($offset > 0) $offset = 7 - $offset;
			if ($offset > 0) echo str_repeat( '<td>&nbsp;</td>', $offset );
			?>
			</table>
		</td>
	</tr>
	<tr class="headercontent">
		<td colspan="3" align="<?php echo $GLOBALS["right"]; ?>"><a href="javascript:window.close();"><?php echo $GLOBALS["tCloseHelp"]; ?></a></td>
	</tr>
	</table>
	</body>
	</html>
	<?php
} // function frmModules()




function RenderMonths($sDate)
{
	$Months = $GLOBALS["tMonth_Array"];
	for ( $sMonth = 1; $sMonth <= 12; $sMonth++ ) {
		$s = "";
		if ($sMonth == $sDate) $s = " selected";
		echo '<option value="'.$sMonth.'"'.$s.'>'.$Months[$sMonth].'</option>';
	}
} // function RenderMonths()


function RenderYears($sDate)
{
	$sYear = strftime("%Y") - 2;
	$eYear = $sYear + 32;
	while ($sYear <= $eYear) {
		$s = "";
		if ($sYear == $sDate) $s = " selected";
		echo '<option value="'.$sYear.'"'.$s.'>'.$sYear.'</option>';
		$sYear++;
	}
} // function RenderYears()

?>
