<?php

/***************************************************************************

 m_authors.php
 --------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the License which can be found within the
 *	zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

$GLOBALS["form"] = 'authors';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("./adminfunctions.php");
include ("./adminbutton.php");
includeLanguageFiles('admin','authors');


force_page_refresh();
frmAuthors();


function frmAuthors()
{
	global $HTTP_GET_VARS, $EzAdmin_Style;

	adminheader();
	admintitle(7,$GLOBALS["tFormTitle"]);
	adminbuttons($GLOBALS["tViewAuthor"],$GLOBALS["tAddNewAuthor"],$GLOBALS["tEditAuthor"],$GLOBALS["tDeleteAuthor"]);
	$GLOBALS["iRelease"] = adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["ReleaseIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tReleaseUser"],0,'rel_button.gif');

	if ($HTTP_GET_VARS["filtergroupname"] != "") {
		$strQuery = "SELECT authorid FROM ".$GLOBALS["eztbAuthors"]." WHERE usergroup='".$HTTP_GET_VARS["filtergroupname"]."'";
	} else {
		$strQuery = "SELECT authorid FROM ".$GLOBALS["eztbAuthors"];
	}
	$result = dbRetrieve($strQuery,true,0,0);
	$rs	= dbFetch($result);
	$lRecCount = dbRowsReturned($result);
	dbFreeResult($result);

	$nCurrentPage = 0;
	if ($HTTP_GET_VARS["sort"] == '') { $HTTP_GET_VARS["sort"] = 2; }
	if ($HTTP_GET_VARS["page"] != '') { $nCurrentPage = $HTTP_GET_VARS["page"]; }
	$nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
	if ($nCurrentPage >= $nPages) { $nCurrentPage = 0; }
	$lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

	?>
	<form action="<?php echo $GLOBALS["REQUEST_URI"]; ?>" method="GET" enctype="multipart/form-data">
	<tr class="teaserheadercontent">
		<td colspan="7" align="<?php echo $GLOBALS["left"]; ?>" nowrap>
			<b><?php echo $GLOBALS["tAuthorFilter"]; ?>:</b>&nbsp;
			<select name="filtergroupname" size="1" onChange="submit();">
				<?php RenderGroups($HTTP_GET_VARS["filtergroupname"]); ?>
			</select>&nbsp;
			<input type="image" name="submit" src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]; ?>go.gif" alt="Go" value="Go">
			<input type="hidden" name="ezSID" value="<?php echo $GLOBALS["ezSID"]; ?>">
			<input type="hidden" name="page" value="0">
		</td>
	</tr>
	</form><?php

	adminHdFt('authors',7,$nCurrentPage,$nPages,'&filtergroupname='.$HTTP_GET_VARS["filtergroupname"]);
	?>
	<tr class="teaserheadercontent">
		<?php
		adminlistitem(10,$GLOBALS["tEditDelRel"],'c');
		adminlistitem(15,$GLOBALS["tLogin"],'',1);
		adminlistitem(23,$GLOBALS["tUsername"],'',2);
		adminlistitem(27,$GLOBALS["tEMail"],'',3);
		adminlistitem(10,$GLOBALS["tUsergroup"],'',4);
		adminlistitem(10,$GLOBALS["tCountry"],'',5);
		adminlistitem(5,$GLOBALS["tEnabled"],'c',6);
		?>
	</tr>
	<?php

	switch ($HTTP_GET_VARS["sort"]) {
		case '1' :	$sort = 'a.login';
					break;
		case '2' :	$sort = 'a.authorname';
					break;
		case '3' :	$sort = 'a.authoremail,a.authorname';
					break;
		case '4' :	$sort = 'u.usergroupdesc,a.authorname';
					break;
		case '5' :	$sort = 'c.countryname,a.authorname';
				   break;
		case '6' :	$sort = 'a.disuser DESC,a.authorname';
					break;
		default  :	$sort = 'a.authorname';
	}
	if ($HTTP_GET_VARS["filtergroupname"] != "") {
		$sqlQuery = "SELECT a.authorid as authorid,a.login as login,a.authorname as authorname,a.usergroup as usergroup,a.authoremail as authoremail,a.disuser as disuser,u.usergroupdesc as usergroupdesc,c.countryname as country,c.flag as flag FROM ".$GLOBALS["eztbAuthors"]." a, ".$GLOBALS["eztbUsergroups"]." u LEFT JOIN ".$GLOBALS["eztbCountries"]." c ON c.countrycode=a.countrycode WHERE u.usergroupname=a.usergroup AND u.language='".$GLOBALS["gsLanguage"]."' AND usergroup='".$HTTP_GET_VARS["filtergroupname"]."' ORDER BY ".$sort;
	} else {
		$sqlQuery = "SELECT a.authorid as authorid,a.login as login,a.authorname as authorname,a.usergroup as usergroup,a.authoremail as authoremail,a.disuser as disuser,u.usergroupdesc as usergroupdesc,c.countryname as country,c.flag as flag FROM ".$GLOBALS["eztbAuthors"]." a, ".$GLOBALS["eztbUsergroups"]." u LEFT JOIN ".$GLOBALS["eztbCountries"]." c ON c.countrycode=a.countrycode WHERE u.usergroupname=a.usergroup AND u.language='".$GLOBALS["gsLanguage"]."' ORDER BY ".$sort;
	}
	$result = dbRetrieve($sqlQuery,true,$lStartRec,$GLOBALS["RECORDS_PER_PAGE"]);
	while ($rs = dbFetch($result)) {
		?>
		<tr class="teasercontent">
			<td align="center" valign="top" class="content">
				<?php
				admineditcheck('authorsform','AuthorID',$rs["authorid"],$rs["authorid"]);
				// Can't delete administrator accounts
				if ($rs["usergroup"] == $GLOBALS["gsAdminPrivGroup"]) { echo $GLOBALS["iBlank"];
				} else { admindeletecheck('DelAuthor','AuthorID',$rs["authorid"]); }
				userreleasecheck($rs["authorid"]);
				?>
			</td>
			<td valign="top" class="content">
				<?php echo $rs["login"]; ?>
			</td>
			<td valign="top" class="content">
				<?php echo $rs["authorname"]; ?>
			</td>
			<td valign="top" class="content">
				<?php echo $rs["authoremail"]; ?>
			</td>
			<td valign="top" class="content">
				<?php echo $rs["usergroupdesc"]; ?>
			</td>
			<td valign="top" class="content">
				<?php
				echo $rs["country"];
				if ($rs["flag"] != '') {
					echo imagehtmltag($GLOBALS["icon_home"].'flags/',$rs["flag"].'_small.gif',$rs["countryname"],0,'');
				} else { echo '&nbsp'; }
				?>
			</td>
			<td valign="top" align="center" class="content">
				<?php
				if ($rs["disuser"] == '1') { echo $GLOBALS["tNo"]; } else { echo $GLOBALS["tYes"]; }
				?>
			</td>
		</tr>
		<?php
	}
	dbFreeResult($result);

	adminHdFt('authors',7,$nCurrentPage,$nPages,'&filtergroupname='.$HTTP_GET_VARS["filtergroupname"]);
	?>
	</table>
	</body>
	</html>
	<?php
} // function frmAuthors()


function RenderGroups($GroupName)
{
	$sqlQuery = "SELECT usergroupname,usergroupdesc FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY usergroupdesc";
	$result = dbRetrieve($sqlQuery,true,0,0);
	echo '<option value="">-- '.$GLOBALS["tShowAll"].' --</option>';
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($GroupName == $rs["usergroupname"]) { echo 'selected '; }
		echo 'value="'.$rs["usergroupname"].'">'.$rs["usergroupdesc"];
	}
	dbFreeResult($result);
} // function RenderGroups()


function userreleasecheck($UserID)
{
	global $HTTP_GET_VARS;

	if ($GLOBALS["canedit"] == False) { echo $GLOBALS["iBlank"];
	} else {
		?>
		&nbsp;<a href="javascript:RelAuthor('UserID=<?php echo $UserID; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>');" <?php echo BuildLinkMouseOver($GLOBALS["tReleaseUser"]); ?>>
		<?php echo $GLOBALS["iRelease"]; ?></a><?php
	}
} // function themereleasecheck()


?>
<script language="Javascript" type="text/javascript">
	<!-- Begin
	function DelAuthor(sParams) {
		if (window.confirm('<?php echo $GLOBALS["tConfirmDeletion"]; ?>')) {
			location.href='<?php echo BuildLink('m_authorsdel.php'); ?>&' + sParams;
		}
	}

	function RelAuthor(sParams) {
		if (window.confirm('<?php echo $GLOBALS["tConfirmRelease"]; ?>')) {
			location.href='<?php echo BuildLink('m_authorsrel.php'); ?>&' + sParams;
		}
	}
	//  End -->
</script>

