<?php

/***************************************************************************

 m_authorsform.php
 ------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'authors';
$validaccess = VerifyAdminLogin3("AuthorID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','authors');


// If we've been passed the request from the author's list, then we
//    read author data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["AuthorID"] != '') {
	$HTTP_POST_VARS["AuthorID"] = $HTTP_GET_VARS["AuthorID"];
	$HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"];
	$HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
	$HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
	GetGlobalData();
} else {
	if ($HTTP_GET_VARS["filtergroupname"] != '') {
		$GLOBALS["fsUsergroup"] = $HTTP_GET_VARS["filtergroupname"];
	}
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
	// User has submitted the data
	if (bCheckForm())    {
		AddAuthor();
		Header("Location: ".BuildLink('m_authors.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]."&filtergroupname=".$HTTP_POST_VARS["filtergroupname"]);
	} else {
		// Invalid data has been submitted
		GetFormData();
	}
}
frmAuthorForm();


function frmAuthorForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('login');
   adminformtitle(4,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(4); }
   adminsubheader(4,$GLOBALS["thLogin"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("Login","login"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="login" size="20" value="<?php echo $GLOBALS["fsLogin"]; ?>" maxlength="20"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Password","password"); ?>
       <td valign="top" class="content">
           <input type="password" name="password" size="32" value="" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("RetypePassword","re_password"); ?>
       <td valign="top" class="content">
           <input type="password" name="re_password" size="32" value="" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thUser"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Authorname","authorname"); ?>
       <td valign="top" class="content">
           <input type="text" name="authorname" size="40" value="<?php echo $GLOBALS["fsAuthorName"]; ?>" maxlength="50"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("Usergroup","usergroup"); ?>
       <td valign="top" class="content">
           <select name="usergroup" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderUsergroups($GLOBALS["fsUsergroup"]); ?></select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("EMail","authoremail"); ?>
       <td valign="top" class="content">
           <input type="text" name="authoremail" size="40" value="<?php echo $GLOBALS["fsAuthorEmail"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?> onChange="return emailCheck(this.value);">
       </td>
       <?php FieldHeading("PrivateEMail","privateemail"); ?>
       <td valign="top" class="content">
           <input type="checkbox" name="privateemail" value="Y" <?php if ($GLOBALS["fsPrivateEmail"] == 'Y') echo "checked"; ?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thConfiguration"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Country","countrycode"); ?>
       <td valign="top" class="content">
           <select name="countrycode" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><OPTION value="00"><?php RenderCountries($GLOBALS["fsCountryCode"]); ?></select>
       </td>
       <?php FieldHeading("Language","languagecode"); ?>
       <td valign="top" class="content">
           <select name="languagecode" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><OPTION value="00"><?php RenderLanguages($GLOBALS["fsLanguageCode"]); ?></select>
       </td>
   </tr>
   <?php
   if ($GLOBALS["gsAddressStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Address","address"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="address" size="70" value="<?php echo $GLOBALS["fsAddress"]; ?>" maxlength="100"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="address" value="<?php echo $GLOBALS["fsAddress"]; ?>"><?php
   }
   if ($GLOBALS["gsCityStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("City","city"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="city" size="50" value="<?php echo $GLOBALS["fsCity"]; ?>" maxlength="50"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="city" value="<?php echo $GLOBALS["fsCity"]; ?>"><?php
   }
   if ($GLOBALS["gsStateStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("State","state"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="state" size="50" value="<?php echo $GLOBALS["fsState"]; ?>" maxlength="50"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="state" value="<?php echo $GLOBALS["fsState"]; ?>"><?php
   }
   if ($GLOBALS["gsZipStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Zip","zip"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="zip" size="20" value="<?php echo $GLOBALS["fsZip"]; ?>" maxlength="20"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="zip" value="<?php echo $GLOBALS["fsZip"]; ?>"><?php
   }
   if ($GLOBALS["gsPhoneStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Phone","phone"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="phone" size="20" value="<?php echo $GLOBALS["fsPhone"]; ?>" maxlength="20"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="phone" value="<?php echo $GLOBALS["fsPhone"]; ?>"><?php
   }
   if ($GLOBALS["gsFaxStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Fax","fax"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="fax" size="20" value="<?php echo $GLOBALS["fsFax"]; ?>" maxlength="20"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="fax" value="<?php echo $GLOBALS["fsFax"]; ?>"><?php
   }
   if ($GLOBALS["gsWebsiteStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Website","website"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="text" name="website" size="70" value="<?php echo $GLOBALS["fsWebsite"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="website" value="<?php echo $GLOBALS["fsWebsite"]; ?>"><?php
   }
   if ($GLOBALS["gsCommentsStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Comments","comments"); ?>
          <td colspan="3" valign="top" class="content">
              <textarea rows="4" name="comments" cols="66"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["fsComments"]); ?></textarea>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="comments" value="<?php echo $GLOBALS["fsComments"]; ?>"><?php
   }
   if ($GLOBALS["gsNewsletterStatus"] != "N") {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Newsletter","newsletter"); ?>
          <td colspan="3" valign="top" class="content">
              <input type="checkbox" name="newsletter" value="Y" <?php if ($GLOBALS["fbNewsletter"] == 'Y') echo "checked"; ?><?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="newsletter" value="<?php echo $GLOBALS["fbNewsletter"]; ?>"><?php
   }
   fadminformsavebar(4,'m_authors.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(4);
      ?><input type="hidden" name="regdate" value="<?php echo $GLOBALS["fsRegDate"]; ?>"><?php
      ?><input type="hidden" name="AuthorID" value="<?php echo $HTTP_POST_VARS["AuthorID"]; ?>"><?php
      ?><input type="hidden" name="filtergroupname" value="<?php echo $HTTP_POST_VARS["filtergroupname"]; ?>"><?php
   }
   adminformclose();
} // function frmAuthorForm()


function AddAuthor()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	$regisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));

	$sLogin      = dbString($HTTP_POST_VARS["login"]);
	$sPassword   = dbString($HTTP_POST_VARS["password"]);
	$sAuthorName = dbString($HTTP_POST_VARS["authorname"]);
	$sComments   = dbString($HTTP_POST_VARS["comments"]);
	$sAddress    = dbString($HTTP_POST_VARS["address"]);
	$sCity       = dbString($HTTP_POST_VARS["city"]);
	$sState      = dbString($HTTP_POST_VARS["state"]);
	$sZip        = dbString($HTTP_POST_VARS["zip"]);
	$sWebSite    = dbString($HTTP_POST_VARS["website"]);

	if ($HTTP_POST_VARS["countrycode"] == '00')  { $HTTP_POST_VARS["countrycode"] = ''; }
	if ($HTTP_POST_VARS["languagecode"] == '00') { $HTTP_POST_VARS["languagecode"] = ''; }

	if ($HTTP_POST_VARS["AuthorID"] != "") {
		$strQuery = "UPDATE ".$GLOBALS["eztbAuthors"]." SET login='".$sLogin."', authorname='".$sAuthorName."', authoremail='".$HTTP_POST_VARS["authoremail"]."', countrycode='".$HTTP_POST_VARS["countrycode"]."', usergroup='".$HTTP_POST_VARS["usergroup"]."', language='".$HTTP_POST_VARS["languagecode"]."', phone='".$HTTP_POST_VARS["phone"]."', fax='".$HTTP_POST_VARS["fax"]."', address='".$sAddress."', city='".$sCity."', state='".$sState."', zip='".$sZip."', website='".$sWebSite."', comments='".$sComments."', newsletter='".$HTTP_POST_VARS["newsletter"]."', privateemail='".$HTTP_POST_VARS["privateemail"]."' WHERE authorid='".$HTTP_POST_VARS["AuthorID"]."'";
	} else {
		$sPassword = md5($sPassword);
		$strQuery = "INSERT INTO ".$GLOBALS["eztbAuthors"]." VALUES('', '".$sLogin."', '".$sPassword."', '".$sAuthorName."','".$HTTP_POST_VARS["authoremail"]."', '".$regisodate."', '".$HTTP_POST_VARS["usergroup"]."', '".$HTTP_POST_VARS["countrycode"]."', '".$HTTP_POST_VARS["languagecode"]."', '".$HTTP_POST_VARS["phone"]."', '".$HTTP_POST_VARS["fax"]."', '".$sAddress."', '".$sCity."', '".$sState."', '".$sZip."', '".$sWebSite."', '".$sComments."', '".$HTTP_POST_VARS["newsletter"]."', '".$HTTP_POST_VARS["privateemail"]."', '0')";
	}
	$result = dbExecute($strQuery,true);
	if (($sPassword != "") && ($HTTP_POST_VARS["AuthorID"] != '')) {
		// Encrypt new password
		$sPassword = md5($sPassword);
		//  Update password on the database
		$strQuery = "UPDATE ".$GLOBALS["eztbAuthors"]." SET userpassword='".$sPassword."' WHERE authorid='".$HTTP_POST_VARS["AuthorID"]."'";
		$result = dbExecute($strQuery,true);
		if ($HTTP_POST_VARS["AuthorID"] == $EZ_SESSION_VARS["UserID"]) {
			//  Update password for the session
			$EZ_SESSION_VARS["PasswordCookie"] = $sPassword;
			db_session_write();
		}
	}
	dbCommit();
} // function AddAuthor()


function GetGlobalData()
{
	global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

	$strQuery = "SELECT * FROM ".$GLOBALS["eztbAuthors"]." WHERE authorid='".$HTTP_GET_VARS["AuthorID"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rs     = dbFetch($result);

	$GLOBALS["fsLogin"]				= $rs["login"];
	$GLOBALS["fsAuthorPassword"]	= "";
	$GLOBALS["fsAuthorName"]		= $rs["authorname"];
	$GLOBALS["fsAuthorEmail"]		= $rs["authoremail"];
	$GLOBALS["fsPrivateEmail"]		= $rs["privateemail"];
	$GLOBALS["fsRegDate"]			= $rs["regdate"];
	$GLOBALS["fsUsergroup"]			= $rs["usergroup"];
	$GLOBALS["fsCountryCode"]		= $rs["countrycode"];
	$GLOBALS["fsLanguageCode"]		= $rs["language"];
	$GLOBALS["fsPhone"]				= $rs["phone"];
	$GLOBALS["fsFax"]				= $rs["fax"];
	$GLOBALS["fsAddress"]			= $rs["address"];
	$GLOBALS["fsCity"]				= $rs["city"];
	$GLOBALS["fsState"]				= $rs["state"];
	$GLOBALS["fsZip"]				= $rs["zip"];
	$GLOBALS["fsWebsite"]			= $rs["website"];
	$GLOBALS["fsComments"]			= $rs["comments"];
	$GLOBALS["fbNewsletter"]		= $rs["newsletter"];

	$HTTP_POST_VARS["authorid"] = $rs["authorid"];
	if ($HTTP_POST_VARS["AuthorID"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}
	dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
	global $EZ_SESSION_VARS, $HTTP_POST_VARS;

	$GLOBALS["fsLogin"]				= $HTTP_POST_VARS["login"];
	$GLOBALS["fsAuthorPassword"]	= $HTTP_POST_VARS["password"];
	$GLOBALS["fsAuthorName"]		= $HTTP_POST_VARS["authorname"];
	$GLOBALS["fsAuthorEmail"]		= $HTTP_POST_VARS["authoremail"];
	$GLOBALS["fsPrivateEmail"]		= $HTTP_POST_VARS["privateemail"];
	$GLOBALS["fsRegDate"]			= $HTTP_POST_VARS["regdate"];
	$GLOBALS["fsUsergroup"]			= $HTTP_POST_VARS["usergroup"];
	$GLOBALS["fsCountryCode"]		= $HTTP_POST_VARS["countrycode"];
	$GLOBALS["fsLanguageCode"]		= $HTTP_POST_VARS["languagecode"];
	$GLOBALS["fsPhone"]				= $HTTP_POST_VARS["phone"];
	$GLOBALS["fsFax"]				= $HTTP_POST_VARS["fax"];
	$GLOBALS["fsAddress"]			= $HTTP_POST_VARS["address"];
	$GLOBALS["fsCity"]				= $HTTP_POST_VARS["city"];
	$GLOBALS["fsState"]				= $HTTP_POST_VARS["state"];
	$GLOBALS["fsZip"]				= $HTTP_POST_VARS["zip"];
	$GLOBALS["fsWebsite"]			= $HTTP_POST_VARS["website"];
	$GLOBALS["fsComments"]			= $HTTP_POST_VARS["comments"];
	$GLOBALS["fbNewsletter"]		= $HTTP_POST_VARS["newsletter"];

	if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}
} // function GetFormData()


function bCheckForm()
{
	global $HTTP_POST_VARS;

	$bFormOK = true;
	if (bAuthorExists('login',str_replace("'", "\'", $HTTP_POST_VARS["login"])))	{ $GLOBALS["strErrors"][] = $GLOBALS["eLoginExists"]; }
	if ($HTTP_POST_VARS["login"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eLoginEmpty"]; }
	if ($HTTP_POST_VARS["password"] != $HTTP_POST_VARS["re_password"])	{ $GLOBALS["strErrors"][] = $GLOBALS["ePasswordError"]; }
	if (bAuthorExists('authorname',str_replace("'", "\'", $HTTP_POST_VARS["authorname"])))	{ $GLOBALS["strErrors"][] = $GLOBALS["eNameExists"]; }
	if ($HTTP_POST_VARS["authorname"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eNameEmpty"]; }
	if ($HTTP_POST_VARS["authoremail"] == "") { $GLOBALS["strErrors"][] = $GLOBALS["eEMailEmpty"];
	} else {
		if (!eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,6})$', $HTTP_POST_VARS["authoremail"])) {
			$GLOBALS["strErrors"][] = $GLOBALS["eEmailIncorrect"];
		}
	}

	if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
	return $bFormOK;
} // function bCheckForm()


function bAuthorExists($field,$value)
{
	global $HTTP_POST_VARS;

	$strQuery = "SELECT login FROM ".$GLOBALS["eztbAuthors"]." WHERE ".$field."='".$value."'";
	if ($HTTP_POST_VARS["AuthorID"] != '') {
		$strQuery .= " AND authorid <> ".$HTTP_POST_VARS["AuthorID"];
	}
	$result = dbRetrieve($strQuery,true,0,0);
	$rcheck = dbRowsReturned($result);
	if ($rcheck != 0) {
		dbFreeResult($result);
		return true;
	}
	dbFreeResult($result);
	return false;
} // function bAuthorExists()


function RenderUsergroups($GroupCode)
{
	$sqlQuery = "SELECT usergroupname,usergroupdesc FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY usergroupname";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo "<option ";
		if ($GroupCode == $rs["usergroupname"]) { echo 'selected '; }
		echo 'value="'.$rs["usergroupname"].'">'.$rs["usergroupdesc"];
	}
	dbFreeResult($result);
} // function RenderUsergroups()


function RenderCountries($CountryCode)
{
	$sqlQuery = "SELECT countrycode,countryname FROM ".$GLOBALS["eztbCountries"]." order by countryname";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($CountryCode == $rs["countrycode"]) { echo 'selected '; }
		echo 'value="'.$rs["countrycode"].'">'.$rs["countryname"];
	}
	dbFreeResult($result);
} // function RenderCountries()


function RenderLanguages($LanguageCode)
{
	$sqlQuery = "SELECT languagecode,languagename FROM ".$GLOBALS["eztbLanguages"]." WHERE enabled='Y' ORDER BY languagename";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($LanguageCode == $rs["languagecode"]) { echo 'selected '; }
		echo 'value="'.$rs["languagecode"].'">'.$rs["languagename"];
	}
	dbFreeResult($result);
} // function RenderLanguages()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
