<?php

/***************************************************************************

 m_backup.php
 -------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


$GLOBALS["form"] = 'backup';
$GLOBALS["validaccess"] = VerifyAdminLogin();
include_once ($GLOBALS["rootdp"]."include/filefunctions.php");
validatefiletypes('Backup');


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
include ("adminbutton.php");
includeLanguageFiles('admin','backup');


if (isset($HTTP_GET_VARS["subdir"])) {
	$HTTP_GET_VARS["subdir"] = str_replace('../', '', $HTTP_GET_VARS["subdir"]);
} else {
	$HTTP_GET_VARS["subdir"] = '';
}

if (($HTTP_GET_VARS["mode"] == 'delete') || ($HTTP_GET_VARS["mode"] == 'deletedir')) {
	if ($GLOBALS["candelete"] == False) {
		Header("Location: ".BuildLink('adminlogin.php'));
	} else {
		if ($HTTP_GET_VARS["mode"] == 'delete') {
			$delete = DeleteBackup();
		} else {
			$delete = DeleteBackupDir();
		}
	}
}


force_page_refresh();
frmBackup();


function frmBackup()
{
	global $HTTP_GET_VARS, $EzAdmin_Style;

	adminheader();
	admintitle(6,$GLOBALS["tFormTitle"]);
	adminbuttons('',$GLOBALS["tUploadBackup"],'',$GLOBALS["tDeleteBackup"]);
	$GLOBALS["iOpenFolder"] = imagehtmltag($GLOBALS["theme_home"],$EzAdmin_Style["FolderIcon"],'',0,'');
	if ($GLOBALS["iOpenFolder"] == '') $GLOBALS["iOpenFolder"] = imagehtmltag($GLOBALS["style_home"],$EzAdmin_Style["FolderIcon"],'',0,'');
	$GLOBALS["iBackup"] = imagehtmltag($GLOBALS["icon_home"],'backup_button.gif',$GLOBALS["tCreateBackup"],0,'');
	$GLOBALS["iRestore"] = imagehtmltag($GLOBALS["icon_home"],'restore_button.gif',$GLOBALS["tRestoreBackup"],0,'');

	$nCurrentPage = 0;
	if ($HTTP_GET_VARS["page"] != "") { $nCurrentPage = $HTTP_GET_VARS["page"]; }
	$lRecCount = lCountFiles($GLOBALS["backup_home"],'backup');
	$nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
	if ($nCurrentPage >= $nPages) { $nCurrentPage = 0; }
	$lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

	frmDisplayDir(6,$GLOBALS["backup_home"]);
	safeModeWarning(6);

	switch ($HTTP_GET_VARS["returncode"]) {
		case '-2' : $strMessage = '<tr bgcolor="#900000"><td colspan="6"><b>'.$GLOBALS["eERROR"].': '.$GLOBALS["eBackupFailed"].'</b></td></tr>';
					break;
		case '-1' : $strMessage = '<tr bgcolor="#900000"><td colspan="6"><b>'.$GLOBALS["eERROR"].': '.$GLOBALS["eRestoreFailed"].'</b></td></tr>';
					break;
		case '1'  : $strMessage = '<tr bgcolor="#009000"><td colspan="6"><b>'.$GLOBALS["mRestoreComplete"].'</b></td></tr>';
					break;
		case '2'  : $strMessage = '<tr bgcolor="#009000"><td colspan="6"><b>'.$GLOBALS["mBackupComplete"].'</b></td></tr>';
					break;
	}
	echo $strMessage;

	frmBackupsHdFt(6,$nCurrentPage,$nPages);
	?>
	<tr class="teaserheadercontent"><?php
		adminlistitem(5,$GLOBALS["tDel"],'c');
		adminlistitem(6,'&nbsp;','');
		adminlistitem(47,$GLOBALS["tBackupFilename"],'');
		adminlistitem(12,$GLOBALS["tFilesize"],'r');
		adminlistitem(25,$GLOBALS["tFiledate"],'r');
		adminlistitem(5,'&nbsp;','');
	?>
	</tr>
	<?php

	$nBackupNr = 0;
	$nBackupShowed = 0;

	if (isset($GLOBALS["files"])) {
		sort($GLOBALS["files"]);
		while (list($i,$val) = each($GLOBALS["files"])) {
			if ($GLOBALS["files"][$i]["filetype"] == 'backup') {
				if ($nBackupNr >= $lStartRec && $nBackupShowed < $GLOBALS["RECORDS_PER_PAGE"]) {
					?>
					<tr class="teasercontent">
						<td align="center" valign="top" class="content">
							<?php
							echo $GLOBALS["iBlank"].'&nbsp;';
							if ($GLOBALS["candelete"] === False) { echo $GLOBALS["iBlank"];
							} else {
								?><a href="javascript:DelBackup('subdir=<?php echo $HTTP_GET_VARS["subdir"]; ?>&Backup=<?php echo $GLOBALS["files"][$i]["filename"]; ?>&page=<?php echo $GLOBALS["page"]; ?>')" <?php echo BuildLinkMouseOver($GLOBALS["tDeleteBackup"]); ?>><?php echo $GLOBALS["iDelete"]; ?></a><?php
							}
							?>
						</td>
						<td align="center" valign="top" class="content">
							<?php
							if ($GLOBALS["files"][$i]["fileicon"] != '') {
								echo '<img src="'.$GLOBALS["rootdp"].$GLOBALS["image_home"].$GLOBALS["files"][$i]["fileicon"].'">';
							}
							?>
						</td>
						<td valign="top" class="content">
							<a href="javascript:DownloadBackup('<?php echo $GLOBALS["rootdp"].$GLOBALS["backup_home"].$HTTP_GET_VARS["subdir"].$GLOBALS["files"][$i]["filename"]; ?>')" title="<?php echo $GLOBALS["tDownloadBackup"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tDownloadBackup"]); ?>><?php echo $GLOBALS["files"][$i]["filename"]; ?></a>
						</td>
						<td align="<?php echo $GLOBALS["right"]; ?>" valign="top" class="content">
							<?php echo $GLOBALS["files"][$i]["filesize"]; ?>
						</td>
						<td align="<?php echo $GLOBALS["right"]; ?>" valign="top" class="content">
							<?php echo $GLOBALS["files"][$i]["filetime"]; ?>
						</td>
						<td align="<?php echo $GLOBALS["right"]; ?>" valign="top" class="content">
							<?php
							if ($GLOBALS["canadd"] === False) { echo $GLOBALS["iBlank"];
							} else {
								?><a href="javascript:RestoreBackup('<?php echo $GLOBALS["rootdp"].$GLOBALS["backup_home"].$HTTP_GET_VARS["subdir"].$GLOBALS["files"][$i]["filename"]; ?>')" <?php echo BuildLinkMouseOver($GLOBALS["tRestoreBackup"]); ?>><?php echo $GLOBALS["iRestore"]; ?></a><?php
							}
							?>
						</td>
					</tr>
					<?php
					$nBackupShowed++;
				}
				$nBackupNr++;
			} else {
				if ((($HTTP_GET_VARS["subdir"] != '') && ($GLOBALS["files"][$i]["filename"] != '.')) || (($HTTP_GET_VARS["subdir"] == '') && ($GLOBALS["files"][$i]["filename"] != '.') && ($GLOBALS["files"][$i]["filename"] != '..'))) {
					if ($nBackupNr >= $lStartRec && $nBackupShowed < $GLOBALS["RECORDS_PER_PAGE"]) {
						if ($GLOBALS["files"][$i]["filename"] != '..') {
							$newsubdir = $HTTP_GET_VARS["subdir"].$GLOBALS["files"][$i]["filename"].'/';
						} else {
							$dirbreakdown = explode('/',$HTTP_GET_VARS["subdir"]);
							array_pop($dirbreakdown); array_pop($dirbreakdown);
							$newsubdir = implode('/',$dirbreakdown).'/';
							if ($newsubdir == '/') { $newsubdir = ''; }
						}
						?>
						<tr class="teasercontent">
							<td align="center" valign="top" class="content">
								<?php
								if ($GLOBALS["files"][$i]["filename"] != '..') {
									?><a href="<?php echo BuildLink('m_backup.php'); ?>&subdir=<?php echo $newsubdir; ?>"><?php echo $GLOBALS["iOpenFolder"]; ?></a>&nbsp;<?php
									if ($GLOBALS["candelete"] === False) {
										echo $GLOBALS["iBlank"];
									} else {
										?><a href="javascript:DelDir('subdir=<?php echo $HTTP_GET_VARS["subdir"]; ?>&folder=<?php echo $GLOBALS["files"][$i]["filename"]; ?>&page=<?php echo $HTTP_GET_VARS["page"]; ?>')" <?php echo BuildLinkMouseOver($GLOBALS["tDeleteBackupDir"]); ?>><?php echo $GLOBALS["iDelete"]; ?></a><?php
									}
								}
								?>
							</td>
							<td align="center" valign="middle" class="content">
								&nbsp;
							</td>
							<td valign="top" class="content">
								<a href="<?php echo BuildLink('m_backup.php'); ?>&subdir=<?php echo $newsubdir; ?>">
								<?php echo $GLOBALS["files"][$i]["filename"]; ?></a>
							</td>
							<td align="center" valign="middle" class="content">
								&nbsp;
							</td>
							<td align="center" valign="middle" class="content">
								&nbsp;
							</td>
							<td align="center" valign="middle" class="content">
								&nbsp;
							</td>
						</tr>
						<?php
						$nBackupShowed++;
					}
					$nBackupNr++;
				}
			}
		}
	}

	frmBackupsHdFt(6,$nCurrentPage,$nPages);
	frmFreeSpace(6,$GLOBALS["backup_home"]);
	?>

	</table>
	</body>
	</html>
	<?php
} // function frmBackup()


?>
<script language="Javascript" type="text/javascript">
	<!-- Begin
	function DelBackup(sParams) {
		if (window.confirm('<?php echo $GLOBALS["tConfirmDeletion"]; ?>')) {
			location.href='<?php echo BuildLink('m_backup.php'); ?>&mode=delete&' + sParams;
		}
	}

	function DelDir(sParams) {
		if(window.confirm('<?php echo $GLOBALS["tConfirmDeletion"]; ?>')) {
			location.href='<?php echo BuildLink('m_backup.php'); ?>&mode=deletedir&' + sParams;
		}
	}

	function DownloadBackup(sBackupName) {
		window.open(sBackupName, "Backup", "width=1,height=1,status=no,resizable=yes,scrollbars=yes");
	}

	function UploadBackup() {
		window.open("<?php echo BuildLink('uploadbackup.php'); ?>&subdir=<?php echo $HTTP_GET_VARS["subdir"]; ?>", "UploadBackup", "width=600,height=310,status=no,resizable=no,scrollbars=no");
	}

	function RestoreBackup(sParams) {
		if (window.confirm('<?php echo $GLOBALS["tConfirmRestore"]; ?>')) {
			location.href='<?php echo BuildLink('restorebackup.php'); ?>&file=' + sParams;
		}
	}
	//  End -->
</script>
<?php


function frmBackupsHdFt($colspan,$nCurrentPage,$nPages)
{
	global $HTTP_GET_VARS;

	$pLink = BuildLink('m_backup.php').'&subdir='.$HTTP_GET_VARS["subdir"];
	$fLink = BuildLink('createbackup.php');
	$hlink = '<a href="javascript:UploadBackup();" '.BuildLinkMouseOver($GLOBALS["tUploadBackup"]).'>';
	$dlink = '<a href="'.$fLink.'" '.BuildLinkMouseOver($GLOBALS["tCreateBackup"]).'>';
	echo '<form name="PagingForm" action="'.$pLink.'" method="GET">';
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<table height="100%" width="100%" cellspacing="0" cellpadding="0">
				<tr><?php
					if (($GLOBALS["canadd"] === True) && ($GLOBALS["file_uploads"])) {
						?><td align="<?php echo $GLOBALS["left"]; ?>" valign="bottom"><?php
						echo displaybutton('addbutton','backup',$GLOBALS["tUploadBackup"].'...',$hlink);
						?></td><?php
					}
					if ($GLOBALS["canadd"] === True) {
						?><td align="<?php echo $GLOBALS["left"]; ?>" valign="bottom"><?php
						echo displaybutton('addbutton','cbackup',$GLOBALS["tBackupDB"].'...',$dlink);
						?></td><?php
					}
					?><td align="<?php echo $GLOBALS["right"]; ?>" valign="bottom"><?php
					if ($nCurrentPage != 0) {
						?><a href="<?php echo $pLink; ?>&page=0" <?php
						echo BuildLinkMouseOver($GLOBALS["tFirstPage"]); ?>><?php
						echo $GLOBALS["iFirst"]; ?></a>&nbsp;<?php
						?><a href="<?php echo $pLink; ?>&page=<?php echo $nCurrentPage - 1; ?>" <?php
						echo BuildLinkMouseOver($GLOBALS["tPrevPage"]); ?>><?php
						echo $GLOBALS["iPrev"]; ?></a><?php
					} else {
						echo $GLOBALS["iFirst"].'&nbsp;'.$GLOBALS["iPrev"];
					}
					$nCPage = $nCurrentPage + 1;
					echo RenderPageList($nCPage,$nPages,'m_backup.php',$linkmod);
					if ($nCurrentPage + 1 != $nPages) {
						?><a href="<?php echo $pLink; ?>&page=<?php echo $nCurrentPage + 1; ?>" <?php
						echo BuildLinkMouseOver($GLOBALS["tNextPage"]); ?>><?php
						echo $GLOBALS["iNext"]; ?></a>&nbsp;<?php
						?><a href="<?php echo $pLink; ?>&page=<?php echo $nPages - 1; ?>" <?php
						echo BuildLinkMouseOver($GLOBALS["tLastPage"]); ?>><?php
						echo $GLOBALS["iLast"]; ?></a><?php
					} else {
						echo $GLOBALS["iNext"].'&nbsp;'.$GLOBALS["iLast"];
					}
					?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<?php
	echo '</form>';
} // function frmBackupsHdFt()


function DeleteBackup()
{
	global $HTTP_GET_VARS;

	$path = $GLOBALS["rootdp"].$GLOBALS["backup_home"].$HTTP_GET_VARS["subdir"];
	$ffile = $HTTP_GET_VARS["Backup"];
	$delete = DeleteFile($path,$ffile);

	return $delete;
} // function DeleteBackup()


function DeleteBackupDir()
{
	global $HTTP_GET_VARS;

	$path = $GLOBALS["rootdp"].$GLOBALS["backup_home"].$HTTP_GET_VARS["subdir"];
	$ffile = $HTTP_GET_VARS["folder"];
	$delete = DeleteDir($path,$ffile);

	return $delete;
} // function DeleteBackupDir()

?>

