<?php

/***************************************************************************

 m_content.php
 --------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

$GLOBALS["form"] = 'content';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
include ("adminbutton.php");
includeLanguageFiles('admin','content');


//  Set the default filter language to the user's language, unless it's been set
//      by the filter already.
if ((!isset($HTTP_GET_VARS["filterlangname"])) || ($HTTP_GET_VARS["filterlangname"] == "")) {
	$HTTP_GET_VARS["filterlangname"] = $GLOBALS["gsLanguage"];
}

force_page_refresh();
frmContents();


function frmContents()
{
	global $HTTP_SERVER_VARS, $HTTP_GET_VARS, $EzAdmin_Style;

	adminheader();
	admintitle(8,$GLOBALS["tFormTitle"]);
	adminbuttons($GLOBALS["tViewContent"],$GLOBALS["tAddNewContent"],$GLOBALS["tEditContent"],$GLOBALS["tDeleteContent"]);
	$GLOBALS["iTranslate"]	= adminbuttontest($GLOBALS["theme_home"],$EzAdmin_Style["EditIcon"],$GLOBALS["gsLanguage"],$GLOBALS["tTranslate"],0,'edit_button.gif');
	$GLOBALS["iTick"]		= lsimagehtmltag($GLOBALS["icon_home"],'tick.gif',$GLOBALS["gsLanguage"],$GLOBALS["tTranslated"],0);
	$GLOBALS["iCross"]		= lsimagehtmltag($GLOBALS["icon_home"],'cross.gif',$GLOBALS["gsLanguage"],$GLOBALS["tNotTranslated"],0);

	$timenow	= time();
	$isodate	= strftime("%Y-%m-%d",$timenow);
	$iRed		= lsimagehtmltag($GLOBALS["icon_home"],'red_dot.gif',$GLOBALS["gsLanguage"],$GLOBALS["tExpired"],0);
	$iAmber		= lsimagehtmltag($GLOBALS["icon_home"],'orange_dot.gif',$GLOBALS["gsLanguage"],$GLOBALS["tPending"],0);
	$iGreen		= lsimagehtmltag($GLOBALS["icon_home"],'green_dot.gif',$GLOBALS["gsLanguage"],$GLOBALS["tActive"],0);
	$iEnabled	= lsimagehtmltag($GLOBALS["icon_home"],'green_dot.gif',$GLOBALS["gsLanguage"],$GLOBALS["tEnabled"],0);
	$iDisabled	= lsimagehtmltag($GLOBALS["icon_home"],'red_dot.gif',$GLOBALS["gsLanguage"],$GLOBALS["tDisabled"],0);

	//	We want the count of all content items, not just those in the current language
	//		so we use the site default language for this check.
	if ($HTTP_GET_VARS["filtergroupname"] != "") {
		$strQuery = "SELECT DISTINCT contentname FROM ".$GLOBALS["eztbContents"]." WHERE groupname='".$HTTP_GET_VARS["filtergroupname"]."' AND language='".$GLOBALS["gsDefault_language"]."'";
	} else {
		$strQuery = "SELECT DISTINCT contentname FROM ".$GLOBALS["eztbContents"]." WHERE language='".$GLOBALS["gsDefault_language"]."'";
	}
	$result = dbRetrieve($strQuery,true,0,0);
	$rs     = dbFetch($result);
	$lRecCount = dbRowsReturned($result);
	dbFreeResult($result);

	$nCurrentPage = 0;
	if ($HTTP_GET_VARS["sort"] == '') { $HTTP_GET_VARS["sort"] = 1; }
	if ($HTTP_GET_VARS["page"] != "") { $nCurrentPage = $HTTP_GET_VARS["page"]; }
	$nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
	if ($nCurrentPage >= $nPages) { $nCurrentPage = 0; }
	$lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

	?>
	<form action="<?php echo $GLOBALS["REQUEST_URI"]; ?>" method="GET" enctype="multipart/form-data">
	<tr class="teaserheadercontent">
		<td colspan="7" align="<?php echo $GLOBALS["left"]; ?>" nowrap>
			<b><?php echo $GLOBALS["tMenuFilter"]; ?>:</b>&nbsp;
			<select name="filtergroupname" size="1" onChange="submit();">
				<?php RenderGroups($HTTP_GET_VARS["filtergroupname"]); ?>
			</select>
			<?php
			if ($GLOBALS["gsMultiLanguage"] == 'Y') {
				?>
				&nbsp;
				<b><?php echo $GLOBALS["tLangFilter"]; ?>:</b>&nbsp;
				<select name="filterlangname" size="1" onChange="submit();">
					<?php RenderLanguages($HTTP_GET_VARS["filterlangname"]); ?>
				</select>&nbsp;
				<?php
			}
			?>
			<input type="image" name="submit" src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]; ?>go.gif" alt="Go" value="Go">
			<input type="hidden" name="ezSID" value="<?php echo $GLOBALS["ezSID"]; ?>">
			<input type="hidden" name="page" value="<?php echo $HTTP_GET_VARS["page"]; ?>">
			<input type="hidden" name="sort" value="<?php echo $HTTP_GET_VARS["sort"]; ?>">
		</td>
	</tr>
	</form>
	<?php

	frmContentHdFt(7,$nCurrentPage,$nPages);
	?>
	<tr class="teaserheadercontent"><?php
		adminlistitem(8,$GLOBALS["tEditDel"],'c');
		adminlistitem(15,$GLOBALS["tPageRef"],'',2);
		adminlistitem(18,$GLOBALS["tMenu"],'',3);
		adminlistitem(18,$GLOBALS["tSubmenu"],'');
		adminlistitem(26,$GLOBALS["tTitle"],'',4);
		adminlistitem(10,$GLOBALS["tActive"],'c',5);
		adminlistitem(5,$GLOBALS["toOrderID"],'',1);
	?>
	</tr>
	<?php

	if ($HTTP_GET_VARS["filterlangname"] == $GLOBALS["gsDefault_language"]) {
		//	If we're working in the site default language, it's a simple sql statement to
		//		create the paged list.
		if ($HTTP_GET_VARS["filtergroupname"] != "") {
			$strQuery = "SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE groupname='".$HTTP_GET_VARS["filtergroupname"]."' AND language='".$GLOBALS["gsLanguage"]."' ORDER BY groupname,subgroupname,orderid";
		} else {
			$strQuery = "SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY groupname,subgroupname,orderid";
		}
		$result = dbRetrieve($strQuery,true,$lStartRec,0,0);
	} else {
		//	Things get slightly more complex if we want to display entries in the filter
		//		language where they're available, but in the base language where they're not.
		//		We build the list using a select in the base language first for the paging
		//		counts, and generate an array containing all the contentnames to be
		//		displayed on this page.
		if ($HTTP_GET_VARS["filtergroupname"] != "") {
			$sqlQuery = "SELECT contentname FROM ".$GLOBALS["eztbContents"]." WHERE groupname='".$HTTP_GET_VARS["filtergroupname"]."' AND language='".$GLOBALS["gsDefault_language"]."' ORDER BY groupname,subgroupname,orderid";
		} else {
			$sqlQuery = "SELECT contentname FROM ".$GLOBALS["eztbContents"]." WHERE language='".$GLOBALS["gsDefault_language"]."' ORDER BY groupname,subgroupname,orderid";
		}
		$inlist = "";
		$result = dbRetrieve($sqlQuery,true,$lStartRec,0,0);
		while ($rs = dbFetch($result)) { $inlistelements[] = "'".$rs["contentname"]."'"; }
		dbFreeResult($result);
		if (isset($inlistelements)) { $inlist = "contentname IN (". implode(',',$inlistelements).") AND"; }
		$lOrder = '';
		if ($HTTP_GET_VARS["filterlangname"] > $GLOBALS["gsDefault_language"]) { $lOrder = ' DESC'; }
		if ($HTTP_GET_VARS["filtergroupname"] != "") {
			$strQuery = "SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE ".$inlist." groupname='".$HTTP_GET_VARS["filtergroupname"]."' AND (language='".$HTTP_GET_VARS["filterlangname"]."' OR language='".$GLOBALS["gsDefault_language"]."') ORDER BY groupname,subgroupname,orderid,language".$lOrder;
		} else {
			$strQuery = "SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE ".$inlist." (language='".$HTTP_GET_VARS["filterlangname"]."' OR language='".$GLOBALS["gsDefault_language"]."') ORDER BY groupname,subgroupname,orderid,language".$lOrder;
		}
		$result = dbRetrieve($strQuery,true,0,0);
	}

	//	Transfer our SQL query results to another array ($Articles) filtering out the duplicates as we do so
	//		This is the array we'll use to handle the actual sorting and then reduce it to a single page of
	//		entries for display
	$a = 0;
	$nArticleName = '';
	while ($rs = dbFetch($result)) {
		//	Filter out default language entries where we have duplicates.
		//		This will only apply if we're filtering on a language other than the default.
		//	We also filter out previous versions of the same article through this routine.
		if ($rs["contentname"] != $nArticleName) {
			$nArticleName = $rs["contentname"];

			$Articles[$a]["contentname"]	= $rs["contentname"];
			$Articles[$a]["language"]		= $rs["language"];
			$Articles[$a]["authorid"]		= $rs["authorid"];
			$Articles[$a]["groupname"]		= $rs["groupname"];
			$Articles[$a]["subgroupname"]	= $rs["subgroupname"];
			$Articles[$a]["title"]			= $rs["title"];
			$Articles[$a]["publishdate"]	= $rs["publishdate"];
			$Articles[$a]["expiredate"]		= $rs["expiredate"];
			$Articles[$a]["contentactive"]	= $rs["contentactive"];
			$Articles[$a]["orderid"]		= $rs["orderid"];
			$a++;
		}
	}
	dbFreeResult($result);

	if (isset($Articles)) {
		switch ($HTTP_GET_VARS["sort"]) {
			case '1' : $Articles = array_csort($Articles,'groupname','subgroupname','orderid');
					   break;
			case '2' : $Articles = array_csort($Articles,'contentname');
					   break;
			case '3' : $Articles = array_csort($Articles,'groupname','subgroupname','contentname');
					   break;
			case '4' : $Articles = array_csort($Articles,'title','contentname');
					   break;
			case '5' : $Articles = array_csort($Articles,'expiredate','publishdate','contentname');
					   break;
			default  : $Articles = array_csort($Articles,'groupname','subgroupname','orderid');
		}
	}

	$i = $lStartRec;
	$j = $lStartRec + $GLOBALS["RECORDS_PER_PAGE"];
	if ($j > $a) { $j = $a; }
	for ($c=$i; $c<$j; $c++) {
		?>
		<tr class="teasercontent">
			<td align="center" valign="top">
				<?php
				if ($HTTP_GET_VARS["filterlangname"] != $GLOBALS["gsDefault_language"]) {
					admintranslatecheck('tcontentform','ContentName',$Articles[$c]["contentname"],'LanguageCode',$HTTP_GET_VARS["filterlangname"]);
				} else {
					admineditcheck('contentform','ContentName',$Articles[$c]["contentname"],$Articles[$c]["authorid"]);
				}
				admindeletecheck('Delcontnt','ContentName',$Articles[$c]["contentname"]);
				?>
			</td>
			<td valign="top" class="content">
				<?php echo $Articles[$c]["contentname"]; ?>
			</td>
			<td valign="top" class="content">
				<?php if ($Articles[$c]["groupname"] == '999999999') { echo $GLOBALS["tAllMenus"]; } else { echo sGetGroupName($Articles[$c]["groupname"]); } ?>
			</td>
			<td valign="top" class="content">
				<?php echo sGetSubGroupName($Articles[$c]["subgroupname"]); ?>
			</td>
			<td valign="top" class="content">
				<?php
				if ($HTTP_GET_VARS["filterlangname"] != $GLOBALS["gsDefault_language"]) {
					if ($Articles[$c]["language"] != $HTTP_GET_VARS["filterlangname"]) { echo $GLOBALS["iCross"].'&nbsp;'; } else { echo $GLOBALS["iTick"].'&nbsp;'; }
				}
				echo $Articles[$c]["title"];
				?>
			</td>
			<td valign="top" align="center" class="content">
				<?php
				if (substr($Articles[$c]["publishdate"], 0, 10) > $isodate) { echo $iAmber; }
				elseif (substr($Articles[$c]["expiredate"], 0, 10) <= $isodate) { echo $iRed; }
				else { echo $iGreen; }
				?>
			</td>
			<td align="center" valign="top" class="content">
				<?php
				if ($HTTP_GET_VARS["sort"] == 1) {
					adminmovecheck('up','ContentMove','ContentName',$Articles[$c]["contentname"]);
					adminmovecheck('down','ContentMove','ContentName',$Articles[$c]["contentname"]);
				}
				?>
			</td>
		</tr>
		<?php
	}

	dbFreeResult($result);

	frmContentHdFt(7,$nCurrentPage,$nPages);
	?>
	</table>
	</form>
	</body>
	</html>
	<?php
} // function frmContents()


function sGetGroupName($GroupName)
{
	$groupname = "---";
	$strQuery = "SELECT groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE groupname='".$GroupName."' AND language='".$GLOBALS["gsLanguage"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	if ($rs = dbFetch($result)) { $groupname = $rs["groupdesc"]; }
	dbFreeResult($result);
	return $groupname;
} // function sGetGroupName()


function sGetSubGroupName($SubGroupName)
{
	$subgroupname = "---";
	$strQuery = "SELECT subgroupdesc FROM ".$GLOBALS["eztbSubgroups"]." WHERE subgroupname='".$SubGroupName."' AND language='".$GLOBALS["gsLanguage"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	if ($rs = dbFetch($result)) { $subgroupname = $rs["subgroupdesc"]; }
	dbFreeResult($result);
	return $subgroupname;
} // function sGetSubGroupName()


function RenderGroups($GroupName)
{
	if ($GLOBALS["gsShowTopMenu"] == 'Y') {
		$sqlQuery = "SELECT g.groupname AS groupname,g.groupdesc AS groupdesc,t.topgroupdesc AS topgroupdesc FROM ".$GLOBALS["eztbGroups"]." g LEFT JOIN ".$GLOBALS["eztbTopgroups"]." t ON t.topgroupname=g.topgroupname AND t.language=g.language WHERE g.language='".$GLOBALS["gsLanguage"]."' AND g.grouplink='' ORDER BY t.topgrouporderid,g.grouporderid";
	} else {
		$sqlQuery = "SELECT groupname,groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' ORDER BY grouporderid";
	}
	$result = dbRetrieve($sqlQuery,true,0,0);
	echo '<option value="">-- '.$GLOBALS["tShowAll"].' --</option>';
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($GroupName == $rs["groupname"]) { echo 'selected '; }
		echo 'value="'.$rs["groupname"].'">';
		if ($GLOBALS["gsShowTopMenu"] == 'Y') { echo $rs["topgroupdesc"].' - '; } 
		echo $rs["groupdesc"];
	}
	dbFreeResult($result);
} // function RenderGroups()


function RenderLanguages($LanguageCode)
{
	$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbLanguages"]." WHERE enabled='Y' ORDER BY languagename";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($LanguageCode == $rs["languagecode"]) { echo 'selected '; }
		echo 'value="'.$rs["languagecode"].'">'.$rs["languagename"];
	}
	dbFreeResult($result);
} // function RenderLanguages()

?>


<script language="Javascript" type="text/javascript">
	<!-- Begin
	function Delcontnt(sParams) {
		if(window.confirm('<?php echo $GLOBALS["tConfirmDeletion"]; ?>')) {
			location.href='<?php echo BuildLink('m_contentdel.php'); ?>&' + sParams;
		}
	}

	function ContentMove(sParams) {
		location.href='<?php echo BuildLink('m_contentmove.php'); ?>&' + sParams;
	}
	//  End -->
</script>

<?php

function frmContentHdFt($colspan,$nCurrentPage,$nPages)
{
	global $HTTP_GET_VARS;

	$pLink = BuildLink('m_content.php');
	$fLink = BuildLink('m_contentform.php');
	$linkmod = '&filterlangname='.$HTTP_GET_VARS["filterlangname"].'&filtergroupname='.$HTTP_GET_VARS["filtergroupname"];
	$hlink = '<a href="'.$fLink.$linkmod.'&page='.$nCurrentPage.'&sort='.$HTTP_GET_VARS["sort"].'" title="'.$GLOBALS["tAddNew"].'" '.BuildLinkMouseOver($GLOBALS["tAddNew"]).'>';
	echo '<form name="PagingForm" action="'.$pLink.'" method="GET">';
	?>
	<tr class="topmenuback">
		<td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
			<table height="100%" width="100%" cellspacing="0" cellpadding="0">
				<tr><?php
					//	Add new is only permitted in the site default language
					if ($HTTP_GET_VARS["filterlangname"] == $GLOBALS["gsDefault_language"]) {
						if ($GLOBALS["canadd"] === True) {
							?><td align="<?php echo $GLOBALS["left"]; ?>" valign="bottom"><?php
							echo displaybutton('addbutton','content',$GLOBALS["tAddNew"].'...',$hlink);
							?></td><?php
						}
					}
					?>
					<td align="<?php echo $GLOBALS["right"]; ?>" valign="bottom"><?php
						if ($nCurrentPage != 0) { ?><a href="<?php echo $pLink.$linkmod; ?>&page=0&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tFirstPage"]); ?>><?php echo $GLOBALS["iFirst"]; ?></a><?php } else { echo $GLOBALS["iFirst"]; }
						echo '&nbsp;';
						if ($nCurrentPage != 0) { ?><a href="<?php echo $pLink.$linkmod; ?>&page=<?php echo $nCurrentPage - 1; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tPrevPage"]); ?>><?php echo $GLOBALS["iPrev"]; ?></a><?php } else { echo $GLOBALS["iPrev"]; }
						$nCPage = $nCurrentPage + 1;
						echo RenderPageList($nCPage,$nPages,'m_content.php',$linkmod);
						if ($nCurrentPage + 1 != $nPages) { ?><a href="<?php echo $pLink.$linkmod; ?>&page=<?php echo $nCurrentPage + 1; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tNextPage"]); ?>><?php echo $GLOBALS["iNext"]; ?></a><?php } else { echo $GLOBALS["iNext"]; }
						echo '&nbsp;';
						if ($nCurrentPage + 1 != $nPages) { ?><a href="<?php echo $pLink.$linkmod; ?>&page=<?php echo $nPages - 1; ?>&sort=<?php echo $HTTP_GET_VARS["sort"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tLastPage"]); ?>><?php echo $GLOBALS["iLast"]; ?></a><?php } else { echo $GLOBALS["iLast"]; } ?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<?php
	echo '</form>';
} // function frmContentHdFt()

?>

