<?php

/***************************************************************************

 m_contentform.php
 ------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the License which can be found within the
 *	zipped package.
 *
 ***************************************************************************/


// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'y';	//	Time period to calculate the content expiry date (based on today's date)
$expirynumber = 1;		//	$expiryperiod = 'y' - years
						//	$expiryperiod = 'm' - months
						//	$expiryperiod = 'w' - weeks
						//	$expiryperiod = 'd' - days
						//	$expirynumber - number of $expiryperiod before expiry
$ImageFileTypes = array( 'gif', 'jpg', 'jpeg', 'png');
$GLOBALS["authorvisible_default"] = '';
$GLOBALS["updatedatevisible_default"] = 'Y';


include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");
include_once ("compile.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//	have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'content';
$validaccess = VerifyAdminLogin3("ContentName");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('main','admin','content');


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('teaser','body');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);


// If we've been passed the request from the content list, then we
//	read content data from the database for an edit request, or skip
//	if this is an 'add new' request
if ($HTTP_GET_VARS["ContentName"] != '') {
	$HTTP_POST_VARS["ContentName"] = $HTTP_GET_VARS["ContentName"];
	$HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
	$HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"];
	GetGlobalData();
} else {
	if ($HTTP_GET_VARS["filtergroupname"] != '') { $GLOBALS["fsGroupName"] = $HTTP_GET_VARS["filtergroupname"]; }
	$timenow = time();								// Calculate the default expiry date
	$GLOBALS["DefExpDate"] = date('Y-m-d H:i:s',DateAdd($expiryperiod,$expirynumber,$timenow));
	$GLOBALS["fbHeaderVisible"]	= 'Y';
	$GLOBALS["fbAuthorVisible"]	= $GLOBALS["authorvisible_default"];
	$GLOBALS["fbUpdateDateVisible"] = $GLOBALS["updatedatevisible_default"];
	$GLOBALS["fsPrinterFriendly"]	= $GLOBALS["gsPrinterFriendly"];
	$GLOBALS["fsAuthorId"]			= $EZ_SESSION_VARS["UserID"];
}

$GLOBALS["tabindex"] = 1024;
	

if ($HTTP_POST_VARS["submitted"] == "yes") {
	// User has submitted the data
	if (bCheckForm()) {
		AddContent();
		Header("Location: ".BuildLink('m_content.php')."&page=".$HTTP_POST_VARS["page"]."&filtergroupname=".$HTTP_POST_VARS["filtergroupname"]);
	} else {
		// Invalid data has been submitted
		GetFormData();
	}
}
frmContentsForm();


function frmContentsForm()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	adminformheader();
	adminformopen('contentname');
	adminformtitle(4,$GLOBALS["tFormTitle"]);
	if (isset($GLOBALS["strErrors"])) { formError(4); }
	adminsubheader(4,$GLOBALS["thContentLinks"]);
	?>
	<tr class="tablecontent">
		<?php FieldHeading("PageRef","contentname"); ?>
		<td valign="top" colspan="3" class="content">
			<input type="text" name="contentname" size="32" value="<?php echo $GLOBALS["fsContentName"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("Menu","cat"); ?>
		<td valign="top" colspan="3" class="content">
			<select name="cat" onChange="setCats(window.document.MaintForm.cat.options[selectedIndex].value)"<?php echo $GLOBALS["fieldstatus"]; ?>><option value="0"><?php echo $GLOBALS["tSelect"]; ?>:<?php
				RenderGroupOptions($GLOBALS["fsGroupName"]);
				if ($GLOBALS["fsGroupName"] == '999999999') {
					?><OPTION value="999999999" selected>-- <?php echo $GLOBALS["tAllMenus"]; ?> --<?php
				}
				elseif (($GLOBALS["gsSectionSecurity"] != 'Y') || ($GLOBALS["fieldstatus"] == ' disabled') || ($EZ_SESSION_VARS["UserGroup"] == $GLOBALS["gsAdminPrivGroup"]))
				{
					?><OPTION value="999999999">-- <?php echo $GLOBALS["tAllMenus"]; ?> --<?php
				}
				?>
			</select>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("Submenu","subgroupname"); ?>
		<td valign="top" colspan="3" class="content">
			<select name="subgroupname"<?php echo $GLOBALS["fieldstatus"]; ?>>
			<option value="0"><?php echo $GLOBALS["tSelect"]; ?>:<?php RenderSubGroupOptions($GLOBALS["fsGroupName"]); ?></select>
		</td>
	</tr>
	<?php adminsubheader(4,$GLOBALS["thDates"]); ?>
	<tr class="tablecontent">
		<?php FieldHeading("PublishDate","PublishDay"); ?>
		<td colspan="3" valign="top" class="content">
			<?php admindatedisplay('Publish',$GLOBALS["fsPublishDate"]); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("ExpiryDate","ExpireDay"); ?>
		<td colspan="3" valign="top" class="content">
			<?php admindatedisplay('Expire',$GLOBALS["fsExpireDate"],$GLOBALS["DefExpDate"]); ?>
		</td>
	</tr>
	<?php adminsubheader(4,$GLOBALS["thHeader"]); ?>
	<tr class="tablecontent">
		<?php FieldHeading("Header","title"); ?>
		<td valign="top" colspan="3" class="content">
			<input type="text" name="title" size="70" value="<?php echo htmlspecialchars($GLOBALS["fsTitle"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("HeaderImage","headerimage"); ?>
		<td valign="top" colspan="3" class="content">
			<input type="text" name="headerimage" size="64" value="<?php echo $GLOBALS["fsHeaderImage"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
			<?php adminimagedisplay('headerimage',$GLOBALS["fsHeaderImage"],$GLOBALS["tShowImage"]); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("ShowHeader","headervisible"); ?>
		<td valign="top" colspan="3" class="content">
			<input type="checkbox" name="headervisible" value="Y" <?php if($GLOBALS["fbHeaderVisible"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<?php adminsubheader(4,$GLOBALS["thTeaser"]); ?>
	<tr class="tablecontent">
		<?php adminHTMLAreadisplay("teaser","Teaser",$GLOBALS["fsTeaser"],"headervisible",3); ?>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("TeaserImage","image"); ?>
		<td colspan="3" valign="top" class="content">
			<input type="text" name="image" size="64" value="<?php echo $GLOBALS["fsImage"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
			<?php adminimagedisplay('image',$GLOBALS["fsImage"],$GLOBALS["tShowImage"]); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("TeaserImageAlign",13); ?>
		<td colspan="3" valign="top" class="content">
			<input type="radio" value="L" name="imagealign" <?php if($GLOBALS["fsImageAlign"] == "L" || $GLOBALS["fsImageAlign"] == "") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLeft"]; ?><br />
			<input type="radio" value="R" name="imagealign" <?php if($GLOBALS["fsImageAlign"] == "R") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRight"]; ?>
		</td>
	</tr>
	<?php adminsubheader(4,$GLOBALS["thBodyContent"]); ?>
	<tr class="tablecontent">
		<?php adminHTMLAreadisplay("body","BodyText",$GLOBALS["fsBody"],"imagedetails",3); ?>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("DetailImage","imagedetails"); ?>
		<td colspan="3" valign="top" class="content">
			<input type="text" name="imagedetails" size="64" value="<?php echo $GLOBALS["fsImageDetails"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
			<?php adminimagedisplay('imagedetails',$GLOBALS["fsImageDetails"],$GLOBALS["tShowImage"]); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("DetailImageAlign",17); ?>
		<td colspan="3" valign="top" class="content">
			<input type="radio" value="L" name="imagedetailsalign" <?php if($GLOBALS["fsImageDetailsAlign"] == "L" || $GLOBALS["fsImageDetailsAlign"] == "") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLeft"]; ?><br />
			<input type="radio" value="R" name="imagedetailsalign" <?php if($GLOBALS["fsImageDetailsAlign"] == "R") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRight"]; ?>
		</td>
	</tr>
	<?php adminsubheader(4,$GLOBALS["thFooter"]); ?>
	<tr class="tablecontent">
		<?php FieldHeading("ShowAuthor","authorvisible"); ?>
		<td valign="top" class="content">
			<input type="checkbox" name="authorvisible" value="Y" <?php if($GLOBALS["fbAuthorVisible"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
		<?php FieldHeading("ShowUpdate","updatedatevisible"); ?>
		<td valign="top" class="content">
			<input type="checkbox" name="updatedatevisible" value="Y" <?php if($GLOBALS["fbUpdateDateVisible"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<?php if ($EZ_SESSION_VARS["UserGroup"] == 'administrator') { $sFieldStatus = ''; } else { $sFieldStatus = ' DISABLED'; } ?>
	<tr class="tablecontent">
		<?php FieldHeading("Author",25); ?>
		<td valign="top" class="content">
			<select name="AuthorId" size="1"<?php echo $sFieldStatus; ?>><?php RenderAuthors($GLOBALS["fsAuthorId"]); ?></select>
		</td>
		<?php FieldHeading("PrinterFriendly","printerfriendly"); ?>
		<td valign="top" class="content">
			<input type="checkbox" name="printerfriendly" value="Y" <?php if($GLOBALS["fsPrinterFriendly"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<?php
	if ($GLOBALS["gsLRContentFrame"] != 'N') {
		adminsubheader(4,$GLOBALS["thPosition"]);
		?>
		<tr class="tablecontent">
			<?php FieldHeading("LeftRight",27); ?>
			<td valign="top" colspan="3" class="content">
				<input type="radio" value="L" name="leftright" <?php if($GLOBALS["fsLeftRight"] == "L" || $GLOBALS["fsLeftRight"] == "") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLeft"]; ?><br />
				<input type="radio" value="R" name="leftright" <?php if($GLOBALS["fsLeftRight"] == "R") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRight"]; ?>
			</td>
		</tr><?php
	} else {
		?>
		<input type="hidden" name="leftright" value="L">
		<?php
	}
	if (($GLOBALS["gsAllowRatings"] == 'Y') || ($GLOBALS["gsAllowComments"] == 'Y')) {
		adminsubheader(4,$GLOBALS["thRatings"]);
		?>
		<tr class="tablecontent">
		<?php
		if ($GLOBALS["gsAllowRatings"] == 'Y') {
			FieldHeading("CanRate",'canrate');
			if ($GLOBALS["gsAllowComments"] == 'Y') {
				?><td valign="top" class="content"><?php
			} else {
				?><td valign="top" colspan="3" class="content"><?php
			}
			?><input type="checkbox" name="canrate" value="Y" <?php if($GLOBALS["fbCanRate"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
			</td>
			<?php
		} else {
			?><input type="hidden" name="canrate" value="N"><?php
		}
		if ($GLOBALS["gsAllowComments"] == 'Y') {
			FieldHeading("CanComment",'cancomment');
			if ($GLOBALS["gsAllowRatings"] == 'Y') {
				?><td valign="top" class="content"><?php
			} else {
				?><td valign="top" colspan="3" class="content"><?php
			}
			?><input type="checkbox" name="cancomment" value="Y" <?php if($GLOBALS["fbCanComment"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
			</td>
			<?php
		} else {
			?><input type="hidden" name="cancomment" value="N"><?php
		}
		?></tr><?php
	} else {
		?>
		<input type="hidden" name="canrate" value="N">
		<input type="hidden" name="cancomment" value="N">
		<?php
	}
	fadminformsavebar(4,'m_content.php');
	if ($GLOBALS["specialedit"] == True) {
		adminhelpmsg(4);
		?><input type="hidden" name="ContentName" value="<?php echo $HTTP_POST_VARS["ContentName"]; ?>"><?php
		?><input type="hidden" name="contentid" value="<?php echo $GLOBALS["fsContentID"]; ?>"><?php
		?><input type="hidden" name="orderid" value="<?php echo $GLOBALS["fsOrderID"]; ?>"><?php
		?><input type="hidden" name="filtergroupname" value="<?php echo $HTTP_POST_VARS["filtergroupname"]; ?>"><?php
	}
	adminformclose();
} // function frmContentsForm()


function AddContent()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	if ($HTTP_POST_VARS["AuthorId"] == '') { $HTTP_POST_VARS["AuthorId"] = $HTTP_POST_VARS["authorid"]; }

	if ($EZ_SESSION_VARS["UserGroup"] == $GLOBALS["gsAdminPrivGroup"]) { $scriptsAllowed = 'Y'; } else { $scriptsAllowed = 'N'; }

	$publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
	$expireisodate  = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]));
	$updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
	$authorid = lGetAuthorID();

	$sTitle	= trim(dbString($HTTP_POST_VARS["title"]));
	$sBody	= trim(dbString($HTTP_POST_VARS["body"]));
	if ($sBody == '<br />') { $sBody = $cBody = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sBody	= str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sBody);
		$sBody	= str_replace($GLOBALS["base_url"],'./',$sBody);
		$sBody	= str_replace('<./','</',$sBody);
		//	Compile pre-compiled tags
		$cBody	= trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sBody.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', $HTTP_POST_VARS["leftright"], $scriptsAllowed));
	}
	$sTeaser	= trim(dbString($HTTP_POST_VARS["teaser"]));
	if ($sTeaser == '<br />') { $sTeaser = $cTeaser = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sTeaser = str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sTeaser);
		$sTeaser = str_replace($GLOBALS["base_url"],'./',$sTeaser); 
		$sTeaser = str_replace('<./','</',$sTeaser);
		//	Compile pre-compiled tags
		$cTeaser = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sTeaser.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', $HTTP_POST_VARS["leftright"], $scriptsAllowed));
	}

	if ($HTTP_POST_VARS["cat"] == '0') { $HTTP_POST_VARS["cat"] = ''; }
	if ($HTTP_POST_VARS["subgroupname"] == '0') { $HTTP_POST_VARS["subgroupname"] = ''; }
	if ($HTTP_POST_VARS["ContentName"] != '') {
		if (($HTTP_POST_VARS["cat"] == '999999999') && ($HTTP_POST_VARS["orderid"] >= 0)) { $HTTP_POST_VARS["orderid"] = 0 - $HTTP_POST_VARS["orderid"]; }
		// Update any foreign language copies of this article as well
		$strQuery = "UPDATE ".$GLOBALS["eztbContents"]." SET groupname='".$HTTP_POST_VARS["cat"]."', subgroupname='".$HTTP_POST_VARS["subgroupname"]."', publishdate='".$publishisodate."', expiredate='".$expireisodate."', orderid='".$HTTP_POST_VARS["orderid"]."', updatedate='".$updateisodate."', imagealign='".$HTTP_POST_VARS["imagealign"]."', image='".$HTTP_POST_VARS["image"]."', headervisible='".$HTTP_POST_VARS["headervisible"]."', authorvisible='".$HTTP_POST_VARS["authorvisible"]."', updatedatevisible='".$HTTP_POST_VARS["updatedatevisible"]."', headerimage='".$HTTP_POST_VARS["headerimage"]."', imagedetails='".$HTTP_POST_VARS["imagedetails"]."', imagedetailsalign='".$HTTP_POST_VARS["imagedetailsalign"]."', leftright='".$HTTP_POST_VARS["leftright"]."', contentname='".$HTTP_POST_VARS["contentname"]."', canrate='".$HTTP_POST_VARS["canrate"]."', cancomment='".$HTTP_POST_VARS["cancomment"]."', printerfriendly='".$HTTP_POST_VARS["printerfriendly"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE contentname='".$HTTP_POST_VARS["ContentName"]."' AND language<>'".$GLOBALS["gsLanguage"]."'";
		$result = dbExecute($strQuery,true);
		$strQuery = "UPDATE ".$GLOBALS["eztbContents"]." SET groupname='".$HTTP_POST_VARS["cat"]."', subgroupname='".$HTTP_POST_VARS["subgroupname"]."', title='".$sTitle."', body='".$sBody."', publishdate='".$publishisodate."', expiredate='".$expireisodate."', teaser='".$sTeaser."', orderid='".$HTTP_POST_VARS["orderid"]."', updatedate='".$updateisodate."', imagealign='".$HTTP_POST_VARS["imagealign"]."', image='".$HTTP_POST_VARS["image"]."', headervisible='".$HTTP_POST_VARS["headervisible"]."', authorvisible='".$HTTP_POST_VARS["authorvisible"]."', updatedatevisible='".$HTTP_POST_VARS["updatedatevisible"]."', headerimage='".$HTTP_POST_VARS["headerimage"]."', imagedetails='".$HTTP_POST_VARS["imagedetails"]."', imagedetailsalign='".$HTTP_POST_VARS["imagedetailsalign"]."', leftright='".$HTTP_POST_VARS["leftright"]."', contentname='".$HTTP_POST_VARS["contentname"]."', canrate='".$HTTP_POST_VARS["canrate"]."', cancomment='".$HTTP_POST_VARS["cancomment"]."', cbody='".$cBody."', cteaser='".$cTeaser."', printerfriendly='".$HTTP_POST_VARS["printerfriendly"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE contentname='".$HTTP_POST_VARS["ContentName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
	} else {
		$strQuery = "INSERT INTO ".$GLOBALS["eztbContents"]." VALUES('', '".$HTTP_POST_VARS["cat"]."', '".$sTitle."', '".$sBody."', '".$publishisodate."', '".$expireisodate."', 1, '".$sTeaser."', '".$HTTP_POST_VARS["orderid"]."', '".$HTTP_POST_VARS["AuthorId"]."', '".$updateisodate."', '".$HTTP_POST_VARS["subgroupname"]."', '".$HTTP_POST_VARS["imagealign"]."', '".$HTTP_POST_VARS["image"]."', '".$HTTP_POST_VARS["headervisible"]."', '".$HTTP_POST_VARS["authorvisible"]."', '".$HTTP_POST_VARS["updatedatevisible"]."', '".$HTTP_POST_VARS["headerimage"]."', '".$HTTP_POST_VARS["imagedetails"]."', '".$HTTP_POST_VARS["imagedetailsalign"]."', '".$HTTP_POST_VARS["leftright"]."', '".$HTTP_POST_VARS["contentname"]."', '".$GLOBALS["gsLanguage"]."', '".$HTTP_POST_VARS["canrate"]."', '".$HTTP_POST_VARS["cancomment"]."', 0, 0, '".$cBody."', '".$cTeaser."', '".$HTTP_POST_VARS["printerfriendly"]."')";
	}
	$result = dbExecute($strQuery,true);
	$dummy = dbInsertValue($GLOBALS["eztbContents"]);

	if ($dummy == 0) { $dummy = $HTTP_POST_VARS["contentid"]; }

	//	For new articles:
	//		if no name was specified, set a default
	//		if no orderid was specified, set a default
	if ((($HTTP_POST_VARS["ContentName"] == '') && ($HTTP_POST_VARS["contentname"] == '')) || ($HTTP_POST_VARS["orderid"] == '')) {
		if (($HTTP_POST_VARS["ContentName"] == '') && ($HTTP_POST_VARS["contentname"] == '')) {
			$contentname = $dummy;
		} else {
			$contentname = $HTTP_POST_VARS["contentname"];
		}
		if ($HTTP_POST_VARS["orderid"] == '') { $orderid = $dummy; }
		else { $orderid = $HTTP_POST_VARS["orderid"]; }
		if (($HTTP_POST_VARS["cat"] == '999999999') && ($orderid >= 0)) $orderid = 0 - $orderid;
		$strQuery = "UPDATE ".$GLOBALS["eztbContents"]." SET contentname='".$contentname."', orderid='".$orderid."' WHERE contentid='".$dummy."'";
		$result = dbExecute($strQuery,true);
	}
	dbCommit();
} // function AddContent()


function GetGlobalData()
{
	global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

	$strQuery="SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE contentname='".$HTTP_GET_VARS["ContentName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rs	= dbFetch($result);

	$GLOBALS["fsContentName"]		= $rs["contentname"];
	$GLOBALS["fsContentID"]			= $rs["contentid"];
	$GLOBALS["fsGroupName"]			= $rs["groupname"];
	$GLOBALS["fsSubGroupName"]		= $rs["subgroupname"];
	$GLOBALS["fsTitle"]				= $rs["title"];
	$GLOBALS["fsOrderID"]			= $rs["orderid"];
	$GLOBALS["fsPublishDate"]		= $rs["publishdate"];
	$GLOBALS["fsExpireDate"]		= $rs["expiredate"];
	$GLOBALS["fsImageAlign"]		= $rs["imagealign"];
	$GLOBALS["fsImage"]				= $rs["image"];
	$GLOBALS["fbHeaderVisible"]	= $rs["headervisible"];
	$GLOBALS["fbAuthorVisible"]	= $rs["authorvisible"];
	$GLOBALS["fbUpdateDateVisible"] = $rs["updatedatevisible"];
	$GLOBALS["fsHeaderImage"]		= $rs["headerimage"];
	$GLOBALS["fsImageDetailsAlign"] = $rs["imagedetailsalign"];
	$GLOBALS["fsImageDetails"]		= $rs["imagedetails"];
	$GLOBALS["fsLeftRight"]			= $rs["leftright"];
	$GLOBALS["fbCanRate"]			= $rs["canrate"];
	$GLOBALS["fbCanComment"]		= $rs["cancomment"];
	$GLOBALS["fsPrinterFriendly"]	= $rs["printerfriendly"];
	$GLOBALS["fsAuthorId"]			= $rs["authorid"];

	if ($EZ_SESSION_VARS["WYSIWYG"] == 'Y') {
		$GLOBALS["fsBody"]			= formatWYSIWYG($rs["cbody"]);
		$GLOBALS["fsTeaser"]		= formatWYSIWYG($rs["cteaser"]);
	} else {
		$GLOBALS["fsTeaser"]		= $rs["teaser"];
		$GLOBALS["fsBody"]			= $rs["body"];
	}

	if ($GLOBALS["fsImageAlign"] == "") $GLOBALS["fsImageAlign"] = "L";
	if ($GLOBALS["fsImageDetailsAlign"] == "") $GLOBALS["fsImageDetailsAlign"] = "L";
	if ($GLOBALS["fsLeftRight"] == "") $GLOBALS["fsLeftRight"] = "L";

	$HTTP_POST_VARS["authorid"] = $rs["authorid"];
	if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}

	$HTTP_POST_VARS["ContentName"]	= $HTTP_GET_VARS["ContentName"];
	$HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"];
	dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
	global $EZ_SESSION_VARS, $HTTP_POST_VARS;

	$publishisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]);
	$expireisodate  = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]);

	$GLOBALS["fsContentName"]		= $HTTP_POST_VARS["contentname"];
	$GLOBALS["fsContentID"]			= $HTTP_POST_VARS["contentid"];
	$GLOBALS["fsGroupName"]			= $HTTP_POST_VARS["cat"];
	$GLOBALS["fsSubGroupName"]		= $HTTP_POST_VARS["subgroupname"];
	$GLOBALS["fsTitle"]				= $HTTP_POST_VARS["title"];
	$GLOBALS["fsTeaser"]				= $HTTP_POST_VARS["teaser"];
	$GLOBALS["fsBody"]				= $HTTP_POST_VARS["body"];
	$GLOBALS["fsOrderID"]			= $HTTP_POST_VARS["orderid"];
	$GLOBALS["fsPublishDate"]		= $publishisodate;
	$GLOBALS["fsExpireDate"]		= $expireisodate;
	$GLOBALS["fsImageAlign"]		= $HTTP_POST_VARS["imagealign"];
	$GLOBALS["fsImage"]				= $HTTP_POST_VARS["image"];
	$GLOBALS["fbHeaderVisible"]	= $HTTP_POST_VARS["headervisible"];
	$GLOBALS["fbAuthorVisible"]	= $HTTP_POST_VARS["authorvisible"];
	$GLOBALS["fbUpdateDateVisible"] = $HTTP_POST_VARS["updatedatevisible"];
	$GLOBALS["fsHeaderImage"]		= $HTTP_POST_VARS["headerimage"];
	$GLOBALS["fsImageDetailsAlign"] = $HTTP_POST_VARS["imagedetailsalign"];
	$GLOBALS["fsImageDetails"]		= $HTTP_POST_VARS["imagedetails"];
	$GLOBALS["fsLeftRight"]			= $HTTP_POST_VARS["leftright"];
	$GLOBALS["fbCanRate"]			= $HTTP_POST_VARS["canrate"];
	$GLOBALS["fbCanComment"]		= $HTTP_POST_VARS["cancomment"];
	$GLOBALS["fsPrinterFriendly"]	= $HTTP_POST_VARS["printerfriendly"];
	$GLOBALS["fsAuthorId"]			= $HTTP_POST_VARS["authorid"];

	if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}
} // function GetFormData()


function bCheckForm()
{
	global $HTTP_POST_VARS;

	$bFormOK = true;
	if (bRecordExists('eztbContents','contentname',$HTTP_POST_VARS["contentname"],'contentid'))	{ $GLOBALS["strErrors"][] = $GLOBALS["eArticleExists"]; }
	if ($HTTP_POST_VARS["contentname"] <> urlencode($HTTP_POST_VARS["contentname"]))		{ $GLOBALS["strErrors"][] = $GLOBALS["eInvalidName"]; }

	if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
	return $bFormOK;
} // function bCheckForm()


function lGetAuthorID()
{
	global $EZ_SESSION_VARS;

	$strQuery = "select authorid from ".$GLOBALS["eztbAuthors"]." where login='".$EZ_SESSION_VARS["LoginCookie"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rs	= dbFetch($result);
	$authorid = $rs["authorid"];

	dbFreeResult($result);
	return $authorid;
} // function lGetAuthorID()


function RenderGroupsJava()
{
	$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' ORDER BY topgroupname,grouporderid";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		?>var <?php echo $rs["groupname"]; ?>=new Array(["0", "<?php echo $GLOBALS["tSelect"]; ?>:"]<?php
		RenderSubGroupsJava($rs["groupname"]);
		?>);<?php
	}
	dbFreeResult($result);
} // function RenderGroupsJava()


function RenderSubGroupsJava($GroupName)
{
	$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbSubgroups"]." WHERE groupname='".$GroupName."' AND language='".$GLOBALS["gsLanguage"]."' AND subgrouplink='' ORDER BY subgrouporderid";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		?>,["<?php echo $rs["subgroupname"]; ?>","<?php echo $rs["subgroupdesc"]; ?>"]<?php
	}
	dbFreeResult($result);
} // function RenderSubGroupsJava()


function RenderGroupOptions($SelectedGroupName)
{
	global $EZ_SESSION_VARS;

	if ($GLOBALS["gsShowTopMenu"] == 'Y') {
		if (($GLOBALS["gsSectionSecurity"] == 'Y') && ($GLOBALS["fieldstatus"] != ' disabled') && ($EZ_SESSION_VARS["UserGroup"] != $GLOBALS["gsAdminPrivGroup"])) {
			$sqlQuery = "SELECT g.groupname AS groupname,g.groupdesc AS groupdesc,t.topgroupdesc AS topgroupdesc FROM ".$GLOBALS["eztbGroups"]." g LEFT JOIN ".$GLOBALS["eztbTopgroups"]." t ON t.topgroupname=g.topgroupname AND t.language=g.language WHERE g.language='".$GLOBALS["gsLanguage"]."' AND g.grouplink='' AND g.authorid='".$EZ_SESSION_VARS["UserID"]."' ORDER BY t.topgrouporderid,g.grouporderid";
		} else {
			$sqlQuery = "SELECT g.groupname AS groupname,g.groupdesc AS groupdesc,t.topgroupdesc AS topgroupdesc FROM ".$GLOBALS["eztbGroups"]." g LEFT JOIN ".$GLOBALS["eztbTopgroups"]." t ON t.topgroupname=g.topgroupname AND t.language=g.language WHERE g.language='".$GLOBALS["gsLanguage"]."' AND g.grouplink='' ORDER BY t.topgrouporderid,g.grouporderid";
		}
	} else {
		if (($GLOBALS["gsSectionSecurity"] == 'Y') && ($GLOBALS["fieldstatus"] != ' disabled') && ($EZ_SESSION_VARS["UserGroup"] != $GLOBALS["gsAdminPrivGroup"])) {
			$sqlQuery = "SELECT groupname,groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' AND authorid='".$EZ_SESSION_VARS["UserID"]."' ORDER BY grouporderid";
		} else {
			$sqlQuery = "SELECT groupname,groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' ORDER BY grouporderid";
		}
	}
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($SelectedGroupName == $rs["groupname"]) { echo 'selected '; }
		echo 'value="'.$rs["groupname"].'">';
		if ($GLOBALS["gsShowTopMenu"] == 'Y') { echo $rs["topgroupdesc"].' - '; } 
		echo $rs["groupdesc"];
	}
	dbFreeResult($result);
} // function RenderGroupOptions()


function RenderSubGroupOptions($GroupName)
{
	global $EZ_SESSION_VARS;

	if (($GLOBALS["gsSectionSecurity"] == 'Y') && ($GLOBALS["fieldstatus"] != ' disabled') && ($EZ_SESSION_VARS["UserGroup"] != $GLOBALS["gsAdminPrivGroup"])) {
		$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbSubgroups"]." WHERE groupname='".$GroupName."' AND language='".$GLOBALS["gsLanguage"]."' AND subgrouplink='' AND authorid='".$EZ_SESSION_VARS["UserID"]."' ORDER BY subgrouporderid";
	} else {
		$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbSubgroups"]." WHERE groupname='".$GroupName."' AND language='".$GLOBALS["gsLanguage"]."' AND subgrouplink='' ORDER BY subgrouporderid";
	}
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		?><option <?php
		if($rs["subgroupname"] == $GLOBALS["fsSubGroupName"]) { echo "selected "; }
		?>value="<?php echo $rs["subgroupname"]; ?>"><?php echo $rs["subgroupdesc"];
	}
	dbFreeResult($result);
} // function RenderSubGroupOptions()


function RenderAuthors($AuthorId)
{
	$sqlQuery = "SELECT authorid,authorname FROM ".$GLOBALS["eztbAuthors"]." ORDER BY authorname";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($AuthorId == $rs["authorid"]) { echo 'selected '; }
		echo 'value="'.$rs["authorid"].'">'.$rs["authorname"];
	}
	dbFreeResult($result);
} // function RenderAuthors()


?>

<script language="javascript" type="text/javascript">
	<!-- Begin

	// Category groups
	var Select=new Array(["0","<?php echo $GLOBALS["tSelect"]; ?>:"]);
	<?php RenderGroupsJava(); ?>

	// setCats: sets the category dropdown options based on the selected
	// parent category option
	function setCats(parent) {
		if (parent == "0") { parent= "Select";
		} else { if (parent == "999999999") { parent= "Select";
		} else { parent=parent.replace(/\W/g,"_"); } }
		var cats=window.document.MaintForm.subgroupname;
		// destroy previous category options
		while (cats.options.length>0) {
		cats.options[0]=null;
		}
		// get new category options
		var newCats=eval(parent);
		// now build new category options dropdown
		for (var index=0;index<newCats.length;index++) {
		addOption(newCats[index],cats);
		}
		cats.selectedIndex = 0;
	}

	// addOption: adds a new option to the categories dropdown
	function addOption (category,cats) {
		// create a new option and set its attributes
		var newOption=new Option();
		newOption.value=category[0];
		newOption.text=category[1];
		// tag the option onto the list
		cats.options[cats.options.length]=newOption;
	}
	//  End -->
</script>


<?php include($GLOBALS["rootdp"]."include/javafuncs.php"); ?>
