<?php

/***************************************************************************

 m_filetypesform.php
 --------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'filetypes';
$validaccess = VerifyAdminLogin3("FiletypeID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','filetypes');


// If we've been passed the request from the filetypes list, then we
//    read the filetype data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["FiletypeID"] != '')
{
   $HTTP_POST_VARS["FiletypeID"] = $HTTP_GET_VARS["FiletypeID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
   GetGlobalData();
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes")
{
   // User has submitted the data
   if (bCheckForm())
   {
      AddFiletype();
      Header("Location: ".BuildLink('m_filetypes.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]);
   }
   else
   {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmFiletypeForm();


function frmFiletypeForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('filetypename');
   adminformtitle(2,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   adminsubheader(2,$GLOBALS["thFiletypeGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("FileCategory","filetypecat"); ?>
       <td valign="top" class="content">
           <select name="filetypecat" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderCats($GLOBALS["gsFiletypeCat"]); ?></select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("FileType","filetypename"); ?>
       <td valign="top" class="content">
           <input type="text" name="filetypename" size="32" value="<?php echo $GLOBALS["gsFiletypeName"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MIMEType","mimetype"); ?>
       <td valign="top" class="content">
           <input type="text" name="mimetype" size="40" value="<?php echo $GLOBALS["gsMIMEType"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("FileIcon","filetypeicon"); ?>
       <td valign=top class="content">
           <input type="text" name="filetypeicon" size="64" value="<?php echo $GLOBALS["gsFiletypeIcon"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('filetypeicon',$GLOBALS["gsFiletypeIcon"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_filetypes.php');
   if ($GLOBALS["specialedit"] == True)
   {
      adminhelpmsg(2);
      ?><input type="hidden" name="FiletypeID" value="<?php echo $HTTP_POST_VARS["FiletypeID"]; ?>"><?php
   }
   adminformclose();
} // function frmFiletypeForm()


function AddFiletype()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   if ($HTTP_POST_VARS["FiletypeID"] != '')
   {
      $strQuery = "UPDATE ".$GLOBALS["eztbFiletypes"]." SET filetype='".$HTTP_POST_VARS["filetypename"]."', filecat='".$HTTP_POST_VARS["filetypecat"]."', mimetype='".$HTTP_POST_VARS["mimetype"]."', fileicon='".$HTTP_POST_VARS["filetypeicon"]."' WHERE filetypeid='".$HTTP_POST_VARS["FiletypeID"]."'";
   }
   else
   {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbFiletypes"]."(filecat,filetype,mimetype,fileicon,authorid) VALUES('".$HTTP_POST_VARS["filetypecat"]."', '".$HTTP_POST_VARS["filetypename"]."', '".$HTTP_POST_VARS["mimetype"]."', '".$HTTP_POST_VARS["fileicon"]."', '".$EZ_SESSION_VARS["UserID"]."')";
   }
   $result = dbExecute($strQuery,true);

   dbCommit();
} // function AddFiletype()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["filetypename"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eNoFiletype"]; }
   if ($HTTP_POST_VARS["mimetype"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eNoMIMEType"]; }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["eztbFiletypes"]." WHERE filetypeid='".$HTTP_GET_VARS["FiletypeID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsFiletypeCat"]  = $rs["filecat"];
   $GLOBALS["gsFiletypeName"] = $rs["filetype"];
   $GLOBALS["gsMIMEType"]     = $rs["mimetype"];
   $GLOBALS["gsFiletypeIcon"] = $rs["fileicon"];

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
   dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $GLOBALS["gsFiletypeCat"]  = $HTTP_POST_VARS["filetypecat"];
   $GLOBALS["gsFiletypeName"] = $HTTP_POST_VARS["filetypename"];
   $GLOBALS["gsMIMEType"]     = $HTTP_POST_VARS["mimetype"];
   $GLOBALS["gsFiletypeIcon"] = $HTTP_POST_VARS["filetypeicon"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function RenderCats($cat)
{
   echo '<option ';
   if ($cat == $GLOBALS["tFileCatBackup"]) { echo 'selected '; }
   echo 'value="'.$GLOBALS["tFileCatBackup"].'">'.$GLOBALS["tFileCatBackup"];
   echo '<option ';
   if ($cat == $GLOBALS["tFileCatDownload"]) { echo 'selected '; }
   echo 'value="'.$GLOBALS["tFileCatDownload"].'">'.$GLOBALS["tFileCatDownload"];
   echo '<option ';
   if ($cat == $GLOBALS["tFileCatImage"]) { echo 'selected '; }
   echo 'value="'.$GLOBALS["tFileCatImage"].'">'.$GLOBALS["tFileCatImage"];
   echo '<option ';
   if ($cat == $GLOBALS["tFileCatScript"]) { echo 'selected '; }
   echo 'value="'.$GLOBALS["tFileCatScript"].'">'.$GLOBALS["tFileCatScript"];
} // function RenderCats()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
