<?php

/***************************************************************************

 m_imageformatsform.php
 -----------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'imageformats';
$validaccess = VerifyAdminLogin3("ImageformatID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','imageformats');


// If we've been passed the request from the tags list, then we
//    read the tag data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["ImageformatID"] != "") {
   $HTTP_POST_VARS["ImageformatID"] = $HTTP_GET_VARS["ImageformatID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
   GetGlobalData();
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      Addimageformat();
      Header("Location: ".BuildLink('m_imageformats.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmImageformatForm();


function frmImageformatForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('imageformatname');
   adminformtitle(2,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   adminsubheader(2,$GLOBALS["thIFGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("IFName","imageformatname"); ?>
       <td valign="top" class="content">
           <input type="text" name="imageformatname" size="50" value="<?php echo $GLOBALS["gsImageformatname"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("IFAlign",1); ?>
       <td valign="top" class="content">
           <input type="radio" value="L" name="ifalign" <?php if($GLOBALS["gsImageformatalign"] == "L" || $GLOBALS["gsImageformatalign"] == "") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLeft"]; ?><br />
           <input type="radio" value="R" name="ifalign" <?php If($GLOBALS["gsImageformatalign"] == "R") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRight"]; ?><br />
           <input type="radio" value="C" name="ifalign" <?php If($GLOBALS["gsImageformatalign"] == "C") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tCentre"]; ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("IFBorder","ifborder"); ?>
       <td valign="top" class="content">
           <select name="ifborder" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderBorders($GLOBALS["gsImageformatborder"]); ?></select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("IFBackground","ifbgcolor"); ?>
       <td valign="top" class="content">
			<?php ColourField('ifbgcolor',$GLOBALS["gsImageformatbgcolor"]); ?>
   </tr>
   <?php
   adminformsavebar(2,'m_imageformats.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(2);
      ?><input type="hidden" name="ImageformatID" value="<?php echo $HTTP_POST_VARS["ImageformatID"]; ?>"><?php
   }
   adminformclose();
} // function frmImageformatForm()


function Addimageformat()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   if ($HTTP_POST_VARS["ImageformatID"] != '') {
      $strQuery = "UPDATE ".$GLOBALS["eztbImageformattemplates"]." SET imageformatname='".$HTTP_POST_VARS["imageformatname"]."', ifalign='".$HTTP_POST_VARS["ifalign"]."', ifborder='".$HTTP_POST_VARS["ifborder"]."', ifbgcolor='".$HTTP_POST_VARS["ifbgcolor"]."' WHERE imageformatid='".$HTTP_POST_VARS["ImageformatID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbImageformattemplates"]." VALUES('', '".$HTTP_POST_VARS["imageformatname"]."', '".$HTTP_POST_VARS["ifalign"]."', '".$HTTP_POST_VARS["ifborder"]."','".$HTTP_POST_VARS["ifbgcolor"]."', ".$EZ_SESSION_VARS["UserID"].")";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
} // function Addimageformat()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["eztbImageformattemplates"]." WHERE imageformatid='".$HTTP_GET_VARS["ImageformatID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsImageformatname"]    = $rs["imageformatname"];
   $GLOBALS["gsImageformatalign"]   = $rs["ifalign"];
   $GLOBALS["gsImageformatborder"]  = $rs["ifborder"];
   $GLOBALS["gsImageformatbgcolor"] = $rs["ifbgcolor"];

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
   dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $GLOBALS["gsImageformatname"]    = $HTTP_POST_VARS["imageformatname"];
   $GLOBALS["gsImageformatalign"]   = $HTTP_POST_VARS["ifalign"];
   $GLOBALS["gsImageformatborder"]  = $HTTP_POST_VARS["ifborder"];
   $GLOBALS["gsImageformatbgcolor"] = $HTTP_POST_VARS["ifbgcolor"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["imageformatname"] == "")							{ $GLOBALS["strErrors"][] = $GLOBALS["eNoName"]; }
   if (substr($HTTP_POST_VARS["ifbgcolor"],0,1) == '#' && strlen($HTTP_POST_VARS["ifbgcolor"]) != 7)	{ $GLOBALS["strErrors"][] = $GLOBALS["eColourWrong"]; }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function RenderBorders($sBorder)
{
   for ($i=0; $i<8; $i++) {
      echo "<option";
      if ($sBorder == $i) { echo " selected"; }
      echo ">".$i;
   }
} // function RenderBorders()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
