<?php

/***************************************************************************

 m_languagesform.php
 --------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'languages';
$validaccess = VerifyAdminLogin3("LanguageCode");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','languages');


// If we've been passed the request from the languages list, then we
//    read the language data from the database for an edit request
if ($HTTP_GET_VARS["LanguageCode"] != '') {
   $HTTP_POST_VARS["LanguageCode"] = $HTTP_GET_VARS["LanguageCode"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
   GetGlobalData();
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddLanguage();
      Header("Location: ".BuildLink('m_languages.php')."&page=".$HTTP_POST_VARS["page"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmLanguageForm();


function frmLanguageForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('languagename');
   adminformtitle(2,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   adminsubheader(2,$GLOBALS["thLanguageGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("Language","languagename"); ?>
       <td valign="top" class="content">
           <input type="text" name="languagename" size="24" value="<?php echo $GLOBALS["gslanguagename"]; ?>" maxlength="24"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CharSet","charset"); ?>
       <td valign="top" class="content">
           <input type="text" name="charset" size="32" value="<?php echo $GLOBALS["gscharset"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Direction",3); ?>
       <td valign="top" class="content">
           <input type="radio" value="ltr" name="direction" <?php if ($GLOBALS["gsdirection"] != "rtl") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLtR"]; ?><br />
           <input type="radio" value="rtl" name="direction" <?php if ($GLOBALS["gsdirection"] == "rtl") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRtL"]; ?>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_languages.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(2);
      ?><input type="hidden" name="LanguageCode" value="<?php echo $HTTP_POST_VARS["LanguageCode"]; ?>"><?php
   }
   adminformclose();
} // function frmTagForm()


function AddLanguage()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $sLanguageName = dbString($HTTP_POST_VARS["languagename"]);
   $sCharSet =      dbString($HTTP_POST_VARS["charset"]);

   $strQuery = "UPDATE ".$GLOBALS["eztbLanguages"]." set languagename='".$sLanguageName."', charset='".$sCharSet."', direction='".$HTTP_POST_VARS["direction"]."' where languagecode='".$HTTP_POST_VARS["LanguageCode"]."'";
   $result = dbExecute($strQuery,true);

   //  If we're enabling a new language, we need to ensure that all privilege usergroups have an entry
   //     for that language.
   $strQuery = "SELECT usergroupdesc,usergroupname FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsDefault_language"]."'";
   $lresult = dbRetrieve($strQuery,true,0,0);
   while ($lrs = dbFetch($lresult)) {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbUsergroups"]." VALUES('', '".$lrs["usergroupdesc"].", '".$lrs["usergroupname"]."', '".$HTTP_POST_VARS["LanguageCode"]."', '".$EZ_SESSION_VARS["UserID"]."')";
      $result = dbExecute($strQuery,false);
   }
   dbFreeResult($lresult);

   dbCommit();
} // function AddTag()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if($HTTP_POST_VARS["languagename"] == "") {
      $GLOBALS["strErrors"][] = $GLOBALS["eNoLanguage"];
   }
   $strQuery = "SELECT languagecode FROM ".$GLOBALS["eztbLanguages"]." WHERE languagename='".$HTTP_POST_VARS["languagename"]."' AND languagecode != '".$HTTP_POST_VARS["LanguageCode"]."'";
   $cres = dbRetrieve($strQuery,true,0,0);
   $tagcheck = dbRowsReturned($cres);
   if ($tagcheck != 0) {
      $GLOBALS["strErrors"][] = $GLOBALS["eLanguageExists"];
   }
   dbFreeResult($cres);

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function GetGlobalData()
{
   global $HTTP_GET_VARS;

   $strQuery = "SELECT * FROM ".$GLOBALS["eztbLanguages"]." WHERE languagecode='".$HTTP_GET_VARS["LanguageCode"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gslanguagename"] = $rs["languagename"];
   $GLOBALS["gscharset"]      = $rs["charset"];
   $GLOBALS["gsenabled"]      = $rs["enabled"];
   $GLOBALS["gsdirection"]    = $rs["direction"];
   dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
   global $HTTP_POST_VARS;

   $GLOBALS["gslanguagename"] = $HTTP_POST_VARS["languagename"];
   $GLOBALS["gscharset"]      = $HTTP_POST_VARS["charset"];
   $GLOBALS["gsenabled"]      = $HTTP_POST_VARS["enabled"];
   $GLOBALS["gsdirection"]    = $HTTP_POST_VARS["direction"];
} // function GetFormData()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
