<?php

/***************************************************************************

 m_languagesform.php
 --------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'languages';
$validaccess = VerifyAdminLogin3("LanguageCode");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','languages');


$GLOBALS["tabindex"] = 1024;
if ($HTTP_POST_VARS["submitted"] == "yes") {
   if ($HTTP_POST_VARS["languagecode"] != 'xxx') { AddLanguage(); }
   Header("Location: ".BuildLink('m_languages.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]);
   exit;
} else {
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
}
frmLanguageForm();


function frmLanguageForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('languagecode');
   adminformtitle(2,$GLOBALS["tFormTitle2"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("Language","languagecode"); ?>
       <td valign="top" class="content">
           <select name="languagecode" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><?php if (RenderLanguages($HTTP_POST_VARS["languagecode"]) == 0) { echo '<option value="xxx">'.$GLOBALS["eNoEnableReady"]; }; ?></select>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_languages.php');
   adminformclose();
} // function frmLanguageForm()


function AddLanguage()
{
   global $HTTP_POST_VARS;

   $strQuery = "UPDATE ".$GLOBALS["eztbLanguages"]." SET enabled='Y' WHERE languagecode='".$HTTP_POST_VARS["languagecode"]."'";
   $result = dbExecute($strQuery,true);


   $strQuery = "SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsDefault_language"]."'";
   $tresult = dbRetrieve($strQuery,true,0,0);
   while ($rs = dbFetch($tresult)) {
      $sqlQuery = "INSERT INTO ".$GLOBALS["eztbUsergroups"]." (usergroupdesc, usergroupname, language, authorid) VALUES ('".$rs["usergroupdesc"]." (".$HTTP_POST_VARS["languagecode"].")', '".$rs["usergroupname"]."', '".$HTTP_POST_VARS["languagecode"]."', '".$HTTP_POST_VARS["AuthorId"]."')";
      $iresult = dbExecute($sqlQuery,false);
   }
   dbFreeResult($tresult);

   $strQuery = "SELECT * FROM ".$GLOBALS["eztbTagCategories"]." WHERE language='".$GLOBALS["gsDefault_language"]."'";
   $tresult = dbRetrieve($strQuery,true,0,0);
   while ($rs = dbFetch($tresult)) {
      $sqlQuery = "INSERT INTO ".$GLOBALS["eztbTagCategories"]." (catdesc, catname, language, authorid) VALUES ('".$rs["catdesc"]." (".$HTTP_POST_VARS["languagecode"].")', '".$rs["catname"]."', '".$HTTP_POST_VARS["languagecode"]."', '".$HTTP_POST_VARS["AuthorId"]."')";
      $iresult = dbExecute($sqlQuery,false);
   }
   dbFreeResult($tresult);

   dbCommit();
} // function AddLanguage()


function RenderLanguages($LanguageCode)
{
   // Count the number of files required for a full language fileset, basd on the default site language
   $filecountrequired = 0;
   $savedir = getcwd();
   chdir($GLOBALS["rootdp"].$GLOBALS["language_home"]);
   if ((file_exists($GLOBALS["gsDefault_language"])) || (is_dir($GLOBALS["gsDefault_language"]))) {
      chdir($GLOBALS["gsDefault_language"]);
      if ($handle = @opendir('.')) {
         while ($file = readdir($handle)) {
            $filename = $file;
            if (is_file($filename)) {
               $fileparts = pathinfo($filename);
               $file_ext = strtolower($fileparts["extension"]);
               $file_name = strtolower($fileparts["basename"]);
		       if ($file_ext == 'php') { $filecountrequired++; }
            }
         }
         closedir($handle);
      }
   }
   chdir($savedir);

   $count = 0;

   $sqlQuery = "SELECT * FROM ".$GLOBALS["eztbLanguages"]." WHERE enabled<>'Y' ORDER BY languagename";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      $i = 0;
      // Test if language files exist for this language before we allow it to be listed
      $savedir = getcwd();
      chdir($GLOBALS["rootdp"].$GLOBALS["language_home"]);
      //  If the directory doesn't exist for a language, then it can't be enabled
      if ((file_exists($rs["languagecode"])) || (is_dir($rs["languagecode"]))) {
         //  Otherwise we count all the files to see if the number tallies with our requirements
         chdir($rs["languagecode"]);
         if ($handle = @opendir('.')) {
            while ($file = readdir($handle)) {
               $filename = $file;
               if (is_file($filename)) {
                  $fileparts = pathinfo($filename);
                  $file_ext = strtolower($fileparts["extension"]);
                  $file_name = strtolower($fileparts["basename"]);
	   	          if ($file_ext == 'php') { $i++; }
               }
            }
            closedir($handle);
         }
      }
      chdir($savedir);

      //  We want at least one language file from the full set before we'll consider a language for release
      if ($i > 0) {
         echo '<option ';
         if ($LanguageCode == $rs["languagecode"]) { echo 'selected '; }
         echo 'value="'.$rs["languagecode"].'">'.$rs["languagename"].'&nbsp;&nbsp;-&nbsp;&nbsp;('.$i.'/'.$filecountrequired.')';
         $count++;
      }
   }
   dbFreeResult($result);

   return $count;
} // function RenderLanguages()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
