<?php

/***************************************************************************

 m_privileges.php
 -----------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the License which can be found within the
 *	zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


$GLOBALS["form"] = 'privileges';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
include ("adminbutton.php");
includeLanguageFiles('admin','privileges');


force_page_refresh();
frmPrivileges();


function frmPrivileges()
{
	global $HTTP_GET_VARS;

	adminheader();
	admintitle(4,$GLOBALS["tFormTitle"]);
	adminbuttons($GLOBALS["tViewPrivilege"],$GLOBALS["tAddNewPrivilege"],$GLOBALS["tEditPrivilege"],$GLOBALS["tDeletePrivilege"]);

	$strQuery = "SELECT usergroupname FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$lRecCount = dbRowsReturned($result);
	dbFreeResult($result);

	$nCurrentPage = 0;
	if($HTTP_GET_VARS["page"] != "") { $nCurrentPage = $HTTP_GET_VARS["page"]; }
	$nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
	if ($nCurrentPage >= $nPages) { $nCurrentPage = 0; }
	$lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

	adminHdFt('privileges',4,$nCurrentPage,$nPages,'');

	// If we've just tried to delete a usergroup and an error was returned, display the error message
	if ((isset($HTTP_GET_VARS["errmess"])) && ($HTTP_GET_VARS["errmess"] != '')) {
		$errmess = $HTTP_GET_VARS["errmess"];
		echo '<tr bgcolor=#900000><td colspan="4"><b>'.$GLOBALS[$errmess].'</b><br />'.urldecode($HTTP_GET_VARS["errqual"]).'</td></tr>';
	}
	?>
	<tr class="teaserheadercontent">
		<?php
		adminlistitem(10,$GLOBALS["tEditDel"],'c');
		adminlistitem(60,$GLOBALS["tUsergroupname"],'');
		adminlistitem(15,$GLOBALS["tDefaultGroup"],'c');
		adminlistitem(15,$GLOBALS["tAdminGroup"],'c');
		?>
	</tr>
	<?php

	$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY usergroupdesc";
	$result = dbRetrieve($sqlQuery,true,$lStartRec,$GLOBALS["RECORDS_PER_PAGE"]);
	while ($rs = dbFetch($result)) {
		?>
		<tr class="teasercontent">
			<td align="center" valign="top" class="content">
				<?php admineditcheck('privilegesform','UsergroupName',$rs["usergroupname"],$rs["authorid"]);
				// Can't delete the administrator group as this serves as a template
				//	for creating new privilege groups, and it's also the admin anyway.
				if ($rs["usergroupname"] == $GLOBALS["gsAdminPrivGroup"]) { echo $GLOBALS["iBlank"];
				} else {
					// Can't delete the default administrator group for new registrants
					if ($GLOBALS["gsPrivDefaultGroup"] != $rs["usergroupname"]) {
						admindeletecheck('DelUsergroup','UsergroupName',$rs["usergroupname"]);
					} else { echo $GLOBALS["iBlank"]; }
				}
				?>
			</td>
			<td valign="top" class="content">
				<?php echo $rs["usergroupdesc"]; ?>
			</td>
			<td valign="top" align="center" class="content">
				<?php
				if ($GLOBALS["gsPrivDefaultGroup"] != $rs["usergroupname"]) {
					if ($GLOBALS["canedit"] === False) {
						?><img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]; ?>"checkbox_off.gif"; ?>" border="0" alt=""><?php
					} else {
						?>
						<a href="<?php echo BuildLink('m_privdefault.php'); ?>&usergroupname=<?php echo $rs["usergroupname"]; ?>" title="<?php echo $GLOBALS["tMakeDefault"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tMakeDefault"]); ?>>
						<img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]."checkbox_off.gif"; ?>" border="0" alt="<?php echo $GLOBALS["tMakeDefault"]; ?>">
						</a>
						<?php
					}
				} else {
					?><img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]."checkbox_on.gif"; ?>" border="0" alt="<?php echo $GLOBALS["tDefaultSet"]; ?>"><?php
				}
				?>
			</td>
			<td valign="top" align="center" class="content">
				<?php
				if ($GLOBALS["gsAdminPrivGroup"] != $rs["usergroupname"]) {
					if ($GLOBALS["canedit"] === False) {
						?><img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]."checkbox_off.gif"; ?>" border="0" alt=""><?php
					} else {
						?>
						<a href="<?php echo BuildLink('m_privadminset.php'); ?>&usergroupname=<?php echo $rs["usergroupname"]; ?>" title="<?php echo $GLOBALS["tMakeAdmin"]; ?>" <?php echo BuildLinkMouseOver($GLOBALS["tMakeAdmin"]); ?>>
						<img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]."checkbox_off.gif"; ?>" border="0" alt="<?php echo $GLOBALS["tMakeAdmin"]; ?>">
						</a>
						<?php
					}
				} else {
					?><img src="<?php echo $GLOBALS["rootdp"].$GLOBALS["icon_home"]."checkbox_on.gif"; ?>" border="0" alt="<?php echo $GLOBALS["tAdminSet"]; ?>"><?php
				}
				?>
			</td>
		</tr>
		<?php
	}
	dbFreeResult($result);

	adminHdFt('privileges',4,$nCurrentPage,$nPages,'');
	?>
	</table>
	</body>
	</html>
	<?php
} // function frmPrivileges()

?>
<script language="Javascript" type="text/javascript">
	<!-- Begin
	function DelUsergroup(sParams) {
		if (window.confirm('<?php echo $GLOBALS["tConfirmDeletion"]; ?>')) {
			location.href='<?php echo BuildLink('m_privilegesdel.php'); ?>&' + sParams;
		}
	}
	//  End -->
</script>
