<?php

/***************************************************************************

 m_privilegesform.php
 ---------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'privileges';
$validaccess = VerifyAdminLogin3("UsergroupName");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','privileges','adminmenu');


// If we've been passed the request from the usergroups list, then we
//    read the privilege data from the database for an edit request, or use
//    the default if this is an 'add new' request.
RenderFunctions();
if ($HTTP_GET_VARS["UsergroupName"] != '') {
   $HTTP_POST_VARS["UsergroupName"] = $HTTP_GET_VARS["UsergroupName"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData('edit',$HTTP_GET_VARS["UsergroupName"]);
} else {
   if ($HTTP_POST_VARS["submitted"] != "yes") {
      $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
      GetGlobalData('add',$GLOBALS["gsAdminPrivGroup"]);
   } else {
      GetGlobalData('fix',$HTTP_POST_VARS["UsergroupName"]);
   }
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddPrivilege();
      Header("Location: ".BuildLink('m_privileges.php')."&page=".$HTTP_POST_VARS["page"]);
   }
}
frmPrivilegeForm();


function frmPrivilegeForm()
{
   global $HTTP_POST_VARS;

   if ($HTTP_POST_VARS["UsergroupName"] != '') {
      $n = 'usergroupname';
   } else {
      $n = 'usergroupcode';
   }
   adminformheader();
   adminformopen($n);
   adminformtitle(6,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(6); }
   ?>
   <tr class="tablecontent">
       <?php uFieldHeading($GLOBALS["tPrivilegesFor"]); ?>
       <td colspan="5" valign="top" class="content">
           <?php
           if ($HTTP_POST_VARS["UsergroupName"] != '') {
              ?>
              <input type="text" name="usergroupcode" size="32" value="<?php echo $GLOBALS["fsUsergroupCode"]; ?>" maxlength="32" disabled>
              <?php
           } else {
              ?>
              <input type="text" name="usergroupcode" size="32" value="<?php echo $GLOBALS["fsUsergroupCode"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
              <?php
           }
           ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php uFieldHeading($GLOBALS["tUsergroupname"]); ?>
       <td colspan="5" valign="top" class="content">
           <input type="text" name="usergroupname" size="48" value="<?php echo $GLOBALS["fsUsergroupName"]; ?>" maxlength="48"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   $cgroupname = '';
   if ($GLOBALS["groups"]) reset($GLOBALS["groups"]);
   while (list($i,$val) = each($GLOBALS["groups"])) {
      if ($GLOBALS["groups"][$i]["groupname"] != $cgroupname) {
         $cgroupname = $GLOBALS["groups"][$i]["groupname"];
         adminsubheader(6,$GLOBALS["groups"][$i]["groupdesc"]);
      }
      ?>
      <tr class="tablecontent">
          <?php uFieldHeading($GLOBALS["groups"][$i]["functiondesc"]); ?>
          <td valign="top" class="content">
              <input type="checkbox" name="<?php echo $GLOBALS["groups"][$i]["functionname"]; ?>-view" value="<?php if ($GLOBALS["groups"][$i]["view"] == 'X') { echo 'X'; } else { echo 'Y'; } ?>" <?php if ($GLOBALS["groups"][$i]["view"] == 'Y') echo "checked"; ?> <?php if ($GLOBALS["groups"][$i]["view"] == 'X') { echo "disabled"; } else { echo $GLOBALS["fieldstatus"]; } ?>><?php echo $GLOBALS["tView"]; ?>
          </td>
          <td valign="top" class="content">
              <input type="checkbox" name="<?php echo $GLOBALS["groups"][$i]["functionname"]; ?>-edit" value="<?php if ($GLOBALS["groups"][$i]["edit"] == 'X') { echo 'X'; } else { echo 'Y'; } ?>" <?php if ($GLOBALS["groups"][$i]["edit"] == 'Y') echo "checked"; ?> <?php if ($GLOBALS["groups"][$i]["edit"] == 'X') { echo "disabled"; } else { echo $GLOBALS["fieldstatus"]; } ?>><?php echo $GLOBALS["tEdit"]; ?>
          </td>
          <td valign="top" class="content">
              <input type="checkbox" name="<?php echo $GLOBALS["groups"][$i]["functionname"]; ?>-add" value="<?php if ($GLOBALS["groups"][$i]["add"] == 'X') { echo 'X'; } else { echo 'Y'; } ?>" <?php if ($GLOBALS["groups"][$i]["add"] == 'Y') echo "checked"; ?> <?php if ($GLOBALS["groups"][$i]["add"] == 'X') { echo "disabled"; } else { echo $GLOBALS["fieldstatus"]; } ?>><?php echo $GLOBALS["tAdd"]; ?>
          </td>
          <td valign="top" class="content">
              <input type="checkbox" name="<?php echo $GLOBALS["groups"][$i]["functionname"]; ?>-delete" value="<?php if ($GLOBALS["groups"][$i]["delete"] == 'X') { echo 'X'; } else { echo 'Y'; } ?>" <?php if ($GLOBALS["groups"][$i]["delete"] == 'Y') echo "checked"; ?> <?php if ($GLOBALS["groups"][$i]["delete"] == 'X') { echo "disabled"; } else { echo $GLOBALS["fieldstatus"]; } ?>><?php echo $GLOBALS["tDelete"]; ?>
          </td>
          <td valign="top" class="content">
              <input type="checkbox" name="<?php echo $GLOBALS["groups"][$i]["functionname"]; ?>-translate" value="<?php if ($GLOBALS["groups"][$i]["translate"] == 'X') { echo 'X'; } else { echo 'Y'; } ?>" <?php if ($GLOBALS["groups"][$i]["translate"] == 'Y') echo "checked"; ?> <?php if ($GLOBALS["groups"][$i]["translate"] == 'X') { echo "disabled"; } else { echo $GLOBALS["fieldstatus"]; } ?>><?php echo $GLOBALS["tTranslate"]; ?>
          </td>
      </tr>
      <?php
   }

   adminformsavebar(6,'m_privileges.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(6);
      ?><input type="hidden" name="UsergroupName" value="<?php echo $HTTP_POST_VARS["UsergroupName"]; ?>"><?php
   }
   adminformclose();
} // function frmPrivilegeForm()


function AddPrivilege()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $sUsergroupCode = dbString($HTTP_POST_VARS["usergroupcode"]);
   $sUsergroupName = dbString($HTTP_POST_VARS["usergroupname"]);

   if ($sUsergroupCode == '') $sUsergroupCode = $HTTP_POST_VARS["UsergroupName"];

   reset($GLOBALS["groups"]);
   while (list($i,$val) = each($GLOBALS["groups"])) {
      $functioname       = $GLOBALS["groups"][$i]["functionname"];
      $functionview      = $GLOBALS["groups"][$i]["view"];
      $functionedit      = $GLOBALS["groups"][$i]["edit"];
      $functionadd       = $GLOBALS["groups"][$i]["add"];
      $functiondelete    = $GLOBALS["groups"][$i]["delete"];
      $functiontranslate = $GLOBALS["groups"][$i]["translate"];
      if ($functionview != 'X') $functionview = $HTTP_POST_VARS[$functioname.'-view'];
      if ($functionedit != 'X') $functionedit = $HTTP_POST_VARS[$functioname.'-edit'];
      if ($functionadd != 'X') $functionadd = $HTTP_POST_VARS[$functioname.'-add'];
      if ($functiondelete != 'X') $functiondelete = $HTTP_POST_VARS[$functioname.'-delete'];
      if ($functiontranslate != 'X') $functiontranslate = $HTTP_POST_VARS[$functioname.'-translate'];
      if ($HTTP_POST_VARS["UsergroupName"] != "") {
         $strQuery = "UPDATE ".$GLOBALS["eztbPrivileges"]." SET usergroupname='".$sUsergroupCode."', accessview='".$functionview."', accessedit='".$functionedit."', accessadd='".$functionadd."', accessdelete='".$functiondelete."', accesstranslate='".$functiontranslate."' WHERE functionname='".$functioname."' AND usergroupname='".$HTTP_POST_VARS["UsergroupName"]."'";
      } else {
         $strQuery = "INSERT INTO ".$GLOBALS["eztbPrivileges"]." VALUES('', '".$sUsergroupCode."', '".$functioname."', '".$functionview."', '".$functionedit."', '".$functionadd."', '".$functiondelete."', '".$functiontranslate."')";
      }
      $result = dbExecute($strQuery,true);
   }

   if ($HTTP_POST_VARS["UsergroupName"] != "") {
      if ($HTTP_POST_VARS["UsergroupName"] != $sUsergroupName) {
         $strQuery = "UPDATE ".$GLOBALS["eztbUsergroups"]." SET usergroupdesc='".$sUsergroupName."' WHERE language='".$GLOBALS["gsLanguage"]."' AND usergroupname='".$HTTP_POST_VARS["UsergroupName"]."'";
         $result = dbExecute($strQuery,true);
      }
   } else {
      $strQuery = "SELECT languagecode FROM ".$GLOBALS["eztbLanguages"]." WHERE enabled='Y'";
      $lresult = dbRetrieve($strQuery,true,0,0);
      while ($lrs = dbFetch($lresult)) {
         $strQuery = "INSERT INTO ".$GLOBALS["eztbUsergroups"]." VALUES('', '".$sUsergroupName."', '".$sUsergroupCode."', '".$lrs["languagecode"]."', '".$EZ_SESSION_VARS["UserID"]."')";
         $result = dbExecute($strQuery,true);
      }
      dbFreeResult($lresult);
   }

   dbCommit();
} // function AddPrivilege()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["UsergroupName"] == '') {
      if ($HTTP_POST_VARS["usergroupcode"] == "") { $GLOBALS["strErrors"][] = $GLOBALS["eNoUsergroupCode"];
      } else {
         $strQuery="SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE usergroupname='".$HTTP_POST_VARS["usergroupcode"]."'";
         $sresult = dbRetrieve($strQuery,true,0,0);
         $sRecCount = dbRowsReturned($sresult);
         dbFreeResult($sresult);
         if ($sRecCount <> 0) { $GLOBALS["strErrors"][] = $GLOBALS["eCodeInUse"]; }
      }
   }
   if ($HTTP_POST_VARS["usergroupname"] == "") { $GLOBALS["strErrors"][] = $GLOBALS["eNoUsergroupName"]; }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function GetGlobalData($type,$UsergroupName)
{
   global $HTTP_POST_VARS;

   if ($type == 'edit') {
      $strQuery = "SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE usergroupname='".$UsergroupName."' AND language='".$GLOBALS["gsLanguage"]."'";
      $result = dbRetrieve($strQuery,true,0,0);
      $rs = dbFetch($result);
      $GLOBALS["fsUsergroupCode"] = $rs["usergroupname"];
      $GLOBALS["fsUsergroupName"] = $rs["usergroupdesc"];
      if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
         $GLOBALS["specialedit"] = True;
         $GLOBALS["fieldstatus"] = '';
      }
      dbFreeResult($result);
   } elseif ($type == 'add') {
      $GLOBALS["fsUsergroupCode"] = '';
      $GLOBALS["fsUsergroupName"] = '';
   } elseif ($type == 'fix') {
      $GLOBALS["fsUsergroupCode"] = $HTTP_POST_VARS["usergroupcode"];
      $GLOBALS["fsUsergroupName"] = $HTTP_POST_VARS["usergroupname"];
   }

   if ($UsergroupName == '') $UsergroupName = 'administrator';
   $strQuery="SELECT * FROM ".$GLOBALS["eztbPrivileges"]." WHERE usergroupname='".$UsergroupName."'";
   $result = dbRetrieve($strQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      reset($GLOBALS["groups"]);
      while (list($i,$val) = each($GLOBALS["groups"])) {
         if ($GLOBALS["groups"][$i]["functionname"] == $rs["functionname"]) {
            if ($type != 'fix') {
               $GLOBALS["groups"][$i]["view"]      = $rs["accessview"];
               $GLOBALS["groups"][$i]["edit"]      = $rs["accessedit"];
               $GLOBALS["groups"][$i]["add"]       = $rs["accessadd"];
               $GLOBALS["groups"][$i]["delete"]    = $rs["accessdelete"];
               $GLOBALS["groups"][$i]["translate"] = $rs["accesstranslate"];
            } else {
               $GLOBALS["groups"][$i]["view"]   = $HTTP_POST_VARS[$rs["functionname"].'-view'];
               if ($rs["accessview"] == 'X') $GLOBALS["groups"][$i]["view"] = 'X';
               $GLOBALS["groups"][$i]["edit"]   = $HTTP_POST_VARS[$rs["functionname"].'-edit'];
               if ($rs["accessedit"] == 'X') $GLOBALS["groups"][$i]["edit"] = 'X';
               $GLOBALS["groups"][$i]["add"]    = $HTTP_POST_VARS[$rs["functionname"].'-add'];
               if ($rs["accessadd"] == 'X') $GLOBALS["groups"][$i]["add"] = 'X';
               $GLOBALS["groups"][$i]["delete"] = $HTTP_POST_VARS[$rs["functionname"].'-delete'];;
               if ($rs["accessdelete"] == 'X') $GLOBALS["groups"][$i]["delete"] = 'X';
               $GLOBALS["groups"][$i]["translate"] = $HTTP_POST_VARS[$rs["functionname"].'-translate'];;
               if ($rs["accesstranslate"] == 'X') $GLOBALS["groups"][$i]["translate"] = 'X';
            }
         }
      }
   }
   dbFreeResult($result);

} // function GetGlobalData()


function RenderFunctions()
{
   $strQuery = "SELECT g.groupname as groupname,f.functionname as functionname FROM ".$GLOBALS["eztbFunctions"]." f, ".$GLOBALS["eztbFunctiongroups"]." g WHERE g.groupname=f.groupname ORDER BY g.grouporderid,f.functionorderid";
   $result = dbRetrieve($strQuery,true,0,0);
   $i = 0;
   while ($rs = dbFetch($result)) {
      $GLOBALS["groups"][$i]["groupname"]    = $rs["groupname"];
      $GLOBALS["groups"][$i]["groupdesc"]    = $GLOBALS["tg".$GLOBALS["groups"][$i]["groupname"]];
      $GLOBALS["groups"][$i]["functionname"] = $rs["functionname"];
      $GLOBALS["groups"][$i]["functiondesc"] = $GLOBALS["tf".$GLOBALS["groups"][$i]["functionname"]];
      $GLOBALS["groups"][$i]["view"]         = '';
      $GLOBALS["groups"][$i]["edit"]         = '';
      $GLOBALS["groups"][$i]["add"]          = '';
      $GLOBALS["groups"][$i]["delete"]       = '';
      $GLOBALS["groups"][$i]["translate"]    = '';
      $i++;
   }
   dbFreeResult($result);
} // function RenderFunctions()


function uFieldHeading($field)
{
   ?>
   <td valign="top" class="content">
       <b><?php echo $field; ?>:</b>
   </td>
   <?php
} // function uFieldHeading()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
