<?php

/***************************************************************************

 m_prunestatistics.php
 ----------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

$GLOBALS["ScreenWidthMultiplier"] = (float) 3.75;


include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

$GLOBALS["form"] = 'prunestatistics';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");


frmStats($page);
Header("Location: ".BuildLink('m_viewstatistics.php'));


function frmStats()
{
   //  We don't summarise any of the last 20 records, because those appear in their entirety in the
   //     "Who" display of m_viewstatistics, so this just gets the max statid and deducts 20 from it
   //     giving us the highest value that we'll summarise.
   if ($EZ_SESSION_VARS["Site"] != '') {
      $sqlQuery = "SELECT max(statid) AS maxstatid FROM ".$GLOBALS["eztbVisitorstats"]." WHERE site='".$EZ_SESSION_VARS["Site"]."'";
   } else {
      $sqlQuery = "SELECT max(statid) AS maxstatid FROM ".$GLOBALS["eztbVisitorstats"];
   }
   $mresult = dbRetrieve($sqlQuery,true,0,20);
   if ($rm = dbFetch($mresult)) {
      $maxstatid = $rm["maxstatid"];
   }
   dbFreeResult($mresult);
   $maxstatid = $maxstatid - 20;

   // As long as maxstatid is still a positive value, we summarise the table entries using the SQL
   //    "group by" and summing the count of all visits that match the group by criteria.
   if ($maxstatid > 2)
   {
      if ($EZ_SESSION_VARS["Site"] != '') {
         $sqlQuery = "SELECT site,visitoragent,visitorbrowser,visitoros,country,DATE_FORMAT(visitdate, '%Y-%m-%d %H') AS date,sum(countnumber) AS countnumber FROM ".$GLOBALS["eztbVisitorstats"]." WHERE statid <= '".$maxstatid."' AND site='".$EZ_SESSION_VARS["Site"]."' GROUP BY site,visitoragent,visitorbrowser,visitoros,country,DATE_FORMAT(visitdate, '%Y-%m-%d %H')";
      } else {
         $sqlQuery = "SELECT site,visitoragent,visitorbrowser,visitoros,country,DATE_FORMAT(visitdate, '%Y-%m-%d %H') AS date,sum(countnumber) AS countnumber FROM ".$GLOBALS["eztbVisitorstats"]." WHERE statid <= '".$maxstatid."' GROUP BY site,visitoragent,visitorbrowser,visitoros,country,DATE_FORMAT(visitdate, '%Y-%m-%d %H')";
      }
      $result = dbRetrieve($sqlQuery,true,0,0);
      while($r = dbFetch($result)) {
         //  Insert each summary record in the database
         $strQuery = "INSERT INTO ".$GLOBALS["eztbVisitorstats"]." VALUES('', '".$r["Site"]."', '".$r["date"].":00:00', '', '".$r["visitoragent"]."', '".$r["visitoros"]."', '".$r["visitorbrowser"]."', '', '".$r["country"]."', '".$r["countnumber"]."')";
         $presult = dbExecute($strQuery,true);
      }
      dbFreeResult($result);
   }

   //  Prune all the entries that we've just summarised.
   $strQuery = "DELETE FROM ".$GLOBALS["eztbVisitorstats"]." WHERE statid <= '".$maxstatid."'";
   $result = dbExecute($strQuery,true);

   dbCommit();
} // function frmStats()

?>
