<?php

/***************************************************************************

 m_sitesettings.php
 -------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");
include_once ("compile.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'sitesettings';
$validaccess = VerifyAdminLogin2();

include ($GLOBALS["rootdp"]."include/settings.php");
include ("adminfunctions.php");
include ($GLOBALS["rootdp"]."include/functions.php");
includeLanguageFiles('admin','sitesettings');


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('tvtophtml','tvfooter');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);


$ImageFileTypes[] = array('gif', 'jpg', 'jpeg', 'png');

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AdjustSettings();
      Header("Location: ".BuildLink('start.php')."&RefreshMenu=styles");
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
} else {
   // First visit to the form
   GetGlobalData();
}
frmSettingsForm();


function frmSettingsForm()
{
	global $EZ_SESSION_VARS;

   adminformheader();
   adminformopen('tvsitetitle');
   adminformtitle(4,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(4); }
   adminsubheader(4,$GLOBALS["thTitles"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("SiteTitle","tvsitetitle"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="tvsitetitle" size="70" value="<?php echo $GLOBALS["fsSitetitle"]; ?>" maxlength="250"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("SiteDescr","tvsitedesc"); ?>
       <td colspan="3" valign="top" class="content">
           <textarea name="tvsitedesc" cols="64" rows="3"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["fsSitedesc"]; ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("SiteKeywords","tvsitekeywords"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="tvsitekeywords" size="70" value="<?php echo $GLOBALS["fsSitekeywords"]; ?>" maxlength="250"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   if ($GLOBALS["gsUseFrames"] == 'Y') {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("SiteWidth","tvsitewidth"); ?>
          <td valign="top" class="content">
              <input type="text" name="tvsitewidth" size="5" value="<?php echo $GLOBALS["fsSiteWidth"]; ?>" maxlength="8"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
          <?php FieldHeading("SiteHeight","tvsiteheight"); ?>
          <td valign="top" class="content">
              <input type="text" name="tvsiteheight" size="5" value="<?php echo $GLOBALS["fsSiteHeight"]; ?>" maxlength="8"<?php echo $GLOBALS["fieldstatus"]; ?>>
          </td>
      </tr>
      <?php
   } else {
      ?>
         <input type="hidden" name="tvsitewidth" value="<?php echo $GLOBALS["fsSiteWidth"]; ?>">
         <input type="hidden" name="tvsiteheight" value="<?php echo $GLOBALS["fsSiteHeight"]; ?>">
      <?php
   }
   ?>
   <?php adminsubheader(4,$GLOBALS["thSecurity"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("SectionSecurity","tvsectionsecurity"); ?>
       <td colspan="3" valign="top" class="content">
           <select name="tvsectionsecurity" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsSectionSecurity"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsSectionSecurity"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thTopFrame"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("TopFrameHeight","tvtopframe_height"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="tvtopframe_height" size="5" value="<?php echo $GLOBALS["fnTopFrameHeight"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
		<?php adminHTMLAreadisplay("tvtophtml","TopHTML",$GLOBALS["fsTopHtml"],"tvtopframe_height",3); ?>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("TopMenu","tvshowtopmenu"); ?>
       <td valign="top" class="content">
           <select name="tvshowtopmenu" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsShowTopMenu"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsShowTopMenu"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
       <?php FieldHeading("TopMenuHeight","tvtopmenuframe_height"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvtopmenuframe_height" size="5" value="<?php echo $GLOBALS["fnTopMenuFrameHeight"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thMenus"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuWidth","tvleftframe_width"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvleftframe_width" size="5" value="<?php echo $GLOBALS["fnLeftFrameWidth"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("MenuFrameAlign",10); ?>
       <td valign="top" class="content">
           <input type="radio" value="L" name="tvmenuframealign" <?php if($GLOBALS["fsMenuFrameAlign"] == "L" || $GLOBALS["fsMenuFrameAlign"] == "") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tLeft"]; ?><br />
           <input type="radio" value="R" name="tvmenuframealign" <?php if($GLOBALS["fsMenuFrameAlign"] == "R") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tRight"]; ?><br />
           <input type="radio" value="A" name="tvmenuframealign" <?php if($GLOBALS["fsMenuFrameAlign"] == "A") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tAutomatic"]; ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuExpand","tvexpandmenus"); ?>
       <td valign="top" class="content">
           <select name="tvexpandmenus" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsExpandMenus"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsExpandMenus"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
       <?php FieldHeading("MenuCollapse","tvcollapsemenus"); ?>
       <td valign="top" class="content">
           <select name="tvcollapsemenus" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsCollapseMenus"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsCollapseMenus"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuHover","tvhoverdisplay"); ?>
       <td colspan="3" valign="top" class="content">
           <select name="tvhoverdisplay" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsMenuHover"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsMenuHover"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thUserdataFrame"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Userdata","tvuserdataframe"); ?>
       <td valign="top" class="content">
           <select name="tvuserdataframe" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="T" <?php if($GLOBALS["fsUserdataFrame"] == "T") echo "selected"; ?>><?php echo $GLOBALS["tHeaderPanel"]; ?>
               <option value="M" <?php if($GLOBALS["fsUserdataFrame"] == "M") echo "selected"; ?>><?php echo $GLOBALS["tMenuPanel"]; ?>
               <option value="N" <?php if($GLOBALS["fsUserdataFrame"] == "N") echo "selected"; ?>><?php echo $GLOBALS["tNoUserdata"]; ?>
           </select>
       </td>
       <?php FieldHeading("UserdataWidth","tvuserdataframe_width"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvuserdataframe_width" size="5" value="<?php echo $GLOBALS["fnUserdataFrameWidth"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thContents"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("LRContent","tvlrcontentframe"); ?>
       <td valign="top" class="content">
           <select name="tvlrcontentframe" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsLRContentFrame"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tAlways"]; ?>
               <option value="A" <?php if($GLOBALS["fsLRContentFrame"] == "A") echo "selected"; ?>><?php echo $GLOBALS["tAutomatic"]; ?>
               <option value="N" <?php if($GLOBALS["fsLRContentFrame"] == "N") echo "selected"; ?>><?php echo $GLOBALS["tNever"]; ?>
           </select>
       </td>
       <?php FieldHeading("RightWidth","tvrightcolumn_width"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvrightcolumn_width" size="5" value="<?php echo $GLOBALS["fnRightColumnWidth"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ColBreak","tvimagecolumnbreak"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="tvimagecolumnbreak" size="64" value="<?php echo $GLOBALS["fnImageColumnBreak"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('tvimagecolumnbreak',$GLOBALS["fnImageColumnBreak"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Breadcrumb","tvbreadcrumb"); ?>
       <td valign="top" class="content">
           <select name="tvbreadcrumb" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsBreadcrumb"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsBreadcrumb"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
       <?php FieldHeading("BreadcrumbSeparator","tvbreadcrumbseparator"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvbreadcrumbseparator" size="24" value="<?php echo htmlspecialchars($GLOBALS["fnBreadcrumbSeparator"]); ?>" maxlength="64"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Bookmark","tvbookmark"); ?>
       <td colspan="3" valign="top" class="content">
           <select name="tvbookmark" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsBookmark"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsBookmark"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thBanners"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Banners","tvshowbanners"); ?>
       <td colspan="3" valign="top" class="content">
           <select name="tvshowbanners" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="N" <?php if($GLOBALS["fsShowBanners"] == "N") echo "selected"; ?>><?php echo $GLOBALS["tNoBanners"]; ?>
               <option value="U" <?php if($GLOBALS["fsShowBanners"] == "U") echo "selected"; ?>><?php echo $GLOBALS["tBannersT"]; ?>
               <option value="D" <?php if($GLOBALS["fsShowBanners"] == "D") echo "selected"; ?>><?php echo $GLOBALS["tBannersB"]; ?>
               <option value="2" <?php if($GLOBALS["fsShowBanners"] == "2") echo "selected"; ?>><?php echo $GLOBALS["tBannersTB"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thFooter"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Footer","tvbottomframe"); ?>
       <td valign="top" class="content">
           <select name="tvbottomframe" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="Y" <?php if($GLOBALS["fsBottomFrame"] == "Y") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="N" <?php if($GLOBALS["fsBottomFrame"] != "Y") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
       <?php FieldHeading("FooterHeight","tvbottomframe_height"); ?>
       <td valign="top" class="content">
           <input type="text" name="tvbottomframe_height" size="5" value="<?php echo $GLOBALS["fnBottomFrameHeight"]; ?>" maxlength="5"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
		<?php adminHTMLAreadisplay("tvfooter","FooterText",$GLOBALS["fsFooter"],"tvbottomframe",3); ?>
   </tr>
   <?php
   adminformsavebar(4,'start.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(4);
      ?><input type="hidden" name="prevtopmenu" value="<?php echo $GLOBALS["prevtopmenu"]; ?>"><?php
   }
   adminformclose();
} // function frmSettingsForm()


function AdjustSettings()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	if ($EZ_SESSION_VARS["UserGroup"] == $GLOBALS["gsAdminPrivGroup"]) { $scriptsAllowed = 'Y'; } else { $scriptsAllowed = 'N'; }

	$sTopHTML		= trim(dbString($HTTP_POST_VARS["tvtophtml"]));
	if ($sTopHTML == '<br />') { $sTopHTML = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sTopHTML	= str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sTopHTML);
		$sTopHTML	= str_replace($GLOBALS["base_url"],'./',$sTopHTML);
		$sTopHTML	= str_replace('<./','</',$sTopHTML);
		//	Compile pre-compiled tags
		$sTopHTML	= trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sTopHTML.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', 'L', $scriptsAllowed));
	}
	$sSiteTitle		= trim(dbString($HTTP_POST_VARS["tvsitetitle"]));
	$sSiteDesc		= trim(dbString($HTTP_POST_VARS["tvsitedesc"]));
	$sSiteKeys		= trim(dbString($HTTP_POST_VARS["tvsitekeywords"]));
	$sFooter		= trim(dbString($HTTP_POST_VARS["tvfooter"]));
	if ($sFooter == '<br />') { $sFooter = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sFooter	= str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sFooter);
		$sFooter	= str_replace($GLOBALS["base_url"],'./',$sFooter);
		$sFooter	= str_replace('<./','</',$sFooter);
		//	Compile pre-compiled tags
		$sFooter	= trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sFooter.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', 'L', $scriptsAllowed ));
	}
	$sBreadcrumb	= trim(dbString($HTTP_POST_VARS["tvbreadcrumbseparator"]));

	$cssSettingsModified = False;
	if (UpdateSetting($sSiteTitle,'sitetitle'))											{ $cssSettingsModified = True; }
	if (UpdateSetting($sSiteDesc,'sitedesc'))											{ $cssSettingsModified = True; }
	if (UpdateSetting($sSiteKeys,'sitekeywords'))										{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvsitewidth"],'sitewidth'))						{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvsiteheight"],'siteheight'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvsectionsecurity"],'sectionsecurity'))			{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvtopframe_height"],'topframe_height'))			{ $cssSettingsModified = True; }
	if (UpdateSetting($sTopHTML,'tophtml'))												{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvshowtopmenu"],'showtopmenu'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvtopmenuframe_height"],'topmenuframe_height'))	{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvuserdataframe"],'userdataframe'))				{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvuserdataframe_width"],'userdataframewidth'))	{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvleftframe_width"],'leftframe_width'))			{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvmenuframealign"],'menuframealign'))			{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvexpandmenus"],'expandmenus'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvcollapsemenus"],'collapsemenus'))				{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvhoverdisplay"],'hoverdisplay'))				{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvlrcontentframe"],'lrcontentframe'))			{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvbreadcrumb"],'breadcrumb'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($sBreadcrumb,'breadcrumbseparator'))								{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvbookmark"],'bookmark'))						{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvrightcolumn_width"],'rightcolumnwidth'))		{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvimagecolumnbreak"],'imagecolumnbreak'))		{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvshowbanners"],'showbanners'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvbottomframe"],'bottomframe'))					{ $cssSettingsModified = True; }
	if (UpdateSetting($HTTP_POST_VARS["tvbottomframe_height"],'bottomframe_height'))	{ $cssSettingsModified = True; }
	if (UpdateSetting($sFooter,'footer')) 												{ $cssSettingsModified = True; }

	if (($HTTP_POST_VARS["tvshowtopmenu"] == 'Y') && ($HTTP_POST_VARS["tvshowtopmenu"] != $HTTP_POST_VARS["prevtopmenu"])) {
		$strQuery = "UPDATE ".$GLOBALS["eztbGroups"]." SET topgroupname='999999999' WHERE topgroupname='0' OR topgroupname='' OR topgroupname IS NULL";
		$result = dbExecute($strQuery,true);
	}
	dbCommit();

	if ($cssSettingsModified) { RebuildStyleSheet(); }
} // function AdjustSettings()


function GetFormData()
{
	global $HTTP_POST_VARS;

	$GLOBALS["fsSitetitle"]				= $HTTP_POST_VARS["tvsitetitle"];
	$GLOBALS["fsSitedesc"]				= $HTTP_POST_VARS["tvsitedesc"];
	$GLOBALS["fsSitekeywords"]			= $HTTP_POST_VARS["tvsitekeywords"];
	$GLOBALS["fsSiteWidth"]				= $HTTP_POST_VARS["tvsitewidth"];
	$GLOBALS["fsSiteHeight"]			= $HTTP_POST_VARS["tvsiteheight"];
	$GLOBALS["fsSectionSecurity"]		= $HTTP_POST_VARS["tvsectionsecurity"];
	$GLOBALS["fnTopFrameHeight"]		= $HTTP_POST_VARS["tvtopframe_height"];
	$GLOBALS["fsTopHtml"]				= $HTTP_POST_VARS["tvtophtml"];
	$GLOBALS["fsShowTopMenu"]			= $HTTP_POST_VARS["tvshowtopmenu"];
	$GLOBALS["fnTopMenuFrameHeight"]	= $HTTP_POST_VARS["tvtopmenuframe_height"];
	$GLOBALS["fsUserdataFrame"]			= $HTTP_POST_VARS["tvuserdataframe"];
	$GLOBALS["fnUserdataFrameWidth"]	= $HTTP_POST_VARS["tvuserdataframe_width"];
	$GLOBALS["fnLeftFrameWidth"]		= $HTTP_POST_VARS["tvleftframe_width"];
	$GLOBALS["fsMenuFrameAlign"]		= $HTTP_POST_VARS["tvmenuframealign"];
	$GLOBALS["fsExpandMenus"]			= $HTTP_POST_VARS["tvexpandmenus"];
	$GLOBALS["fsCollapseMenus"]			= $HTTP_POST_VARS["tvcollapsemenus"];
	$GLOBALS["fsMenuHover"]				= $HTTP_POST_VARS["tvhoverdisplay"];
	$GLOBALS["fsLRContentFrame"]		= $HTTP_POST_VARS["tvlrcontentframe"];
	$GLOBALS["fnRightColumnWidth"]		= $HTTP_POST_VARS["tvrightcolumn_width"];
	$GLOBALS["fnImageColumnBreak"]		= $HTTP_POST_VARS["tvimagecolumnbreak"];
	$GLOBALS["fsBreadcrumb"]			= $HTTP_POST_VARS["tvbreadcrumb"];
	$GLOBALS["fnBreadcrumbSeparator"]	= $HTTP_POST_VARS["tvbreadcrumbseparator"];
	$GLOBALS["fsBookmark"]				= $HTTP_POST_VARS["tvbookmark"];
	$GLOBALS["fsShowBanners"]			= $HTTP_POST_VARS["tvshowbanners"];
	$GLOBALS["fsBottomFrame"]			= $HTTP_POST_VARS["tvbottomframe"];
	$GLOBALS["fnBottomFrameHeight"]		= $HTTP_POST_VARS["tvbottomframe_height"];
	$GLOBALS["fsFooter"]				= $HTTP_POST_VARS["tvfooter"];

	$GLOBALS["prevtopmenu"]				= $HTTP_POST_VARS["prevtopmenu"];
} // function GetFormData()


function GetGlobalData()
{
	global $EZ_SESSION_VARS;

	$GLOBALS["fsSitetitle"]				= $GLOBALS["gsSitetitle"];
	$GLOBALS["fsSitedesc"]				= $GLOBALS["gsSitedesc"];
	$GLOBALS["fsSitekeywords"]			= $GLOBALS["gsSitekeywords"];
	$GLOBALS["fsSiteWidth"]				= $GLOBALS["gsSiteWidth"];
	$GLOBALS["fsSiteHeight"]			= $GLOBALS["gsSiteHeight"];
	$GLOBALS["fsSectionSecurity"]		= $GLOBALS["gsSectionSecurity"];
	$GLOBALS["fnTopFrameHeight"]		= $GLOBALS["gnTopFrameHeight"];
	$GLOBALS["fsShowTopMenu"]			= $GLOBALS["gsShowTopMenu"];
	$GLOBALS["fnTopMenuFrameHeight"]	= $GLOBALS["gnTopMenuFrameHeight"];
	$GLOBALS["fsUserdataFrame"]			= $GLOBALS["gsUserdataFrame"];
	$GLOBALS["fnUserdataFrameWidth"]	= $GLOBALS["gnUserdataFrameWidth"];
	$GLOBALS["fnLeftFrameWidth"]		= $GLOBALS["gnLeftFrameWidth"];
	$GLOBALS["fsMenuFrameAlign"]		= $GLOBALS["gsMenuFrameAlign"];
	$GLOBALS["fsExpandMenus"]			= $GLOBALS["gsExpandMenus"];
	$GLOBALS["fsCollapseMenus"]			= $GLOBALS["gsCollapseMenus"];
	$GLOBALS["fsMenuHover"]				= $GLOBALS["gsMenuHover"];
	$GLOBALS["fsLRContentFrame"]		= $GLOBALS["gsLRContentFrame"];
	$GLOBALS["fnRightColumnWidth"]		= $GLOBALS["gnRightColumnWidth"];
	$GLOBALS["fnImageColumnBreak"]		= $GLOBALS["gnImageColumnBreak"];
	$GLOBALS["fsBreadcrumb"]			= $GLOBALS["gsBreadcrumb"];
	$GLOBALS["fnBreadcrumbSeparator"]	= $GLOBALS["gnBreadcrumbSeparator"];
	$GLOBALS["fsBookmark"]				= $GLOBALS["gsBookmark"];
	$GLOBALS["fsShowBanners"]			= $GLOBALS["gsShowBanners"];
	$GLOBALS["fsBottomFrame"]			= $GLOBALS["gnBottomFrame"];
	$GLOBALS["fnBottomFrameHeight"]		= $GLOBALS["gnBottomFrameHeight"];

	if ($EZ_SESSION_VARS["WYSIWYG"] == 'Y') {
		$GLOBALS["fsTopHtml"]		= formatWYSIWYG($GLOBALS["gsTopHtml"]);
		$GLOBALS["fsFooter"]		= formatWYSIWYG($GLOBALS["gsFooter"]);
	} else {
		$GLOBALS["fsTopHtml"]		= $GLOBALS["gsTopHtml"];
		$GLOBALS["fsFooter"]		= $GLOBALS["gsFooter"];
	}

	$GLOBALS["prevtopmenu"]			= $GLOBALS["gsShowTopMenu"];
} // function GetGlobalData()


function bCheckForm()
{
	global $HTTP_POST_VARS;

	$bFormOK = true;
	if (!is_numeric($HTTP_POST_VARS["tvtopframe_height"])) { $GLOBALS["strErrors"][] = $GLOBALS["eTopFrame"]; }
	if (($HTTP_POST_VARS["tvshowtopmenu"] == 'Y') && (!is_numeric($HTTP_POST_VARS["tvtopmenuframe_height"]))) {
		$GLOBALS["strErrors"][] = $GLOBALS["eTopmenuFrame"];
	}
	if (($HTTP_POST_VARS["tvuserdataframe"] == 'T') && (!is_numeric($HTTP_POST_VARS["tvuserdataframe_width"]))) {
		$GLOBALS["strErrors"][] = $GLOBALS["eUserdataFrame"];
	}
	if (!is_numeric($HTTP_POST_VARS["tvleftframe_width"])) {
		$GLOBALS["strErrors"][] = $GLOBALS["eMenuFrame"];
	}
	if (($HTTP_POST_VARS["tvlrcontentframe"] != 'N') && (!is_numeric($HTTP_POST_VARS["tvrightcolumn_width"]))) {
		$GLOBALS["strErrors"][] = $GLOBALS["eRightFrame"];
	}
	if (($HTTP_POST_VARS["tvbottomframe"] == 'Y') && (!is_numeric($HTTP_POST_VARS["tvbottomframe_height"]))) {
		$GLOBALS["strErrors"][] = $GLOBALS["eBottomFrame"];
	}

	if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
	return $bFormOK;
} // function bCheckForm()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
