<?php

/***************************************************************************

 m_subcontentcatsform.php
 -------------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$validaccess = VerifyAdminLogin3("CatID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','subcontent');


// If we've been passed the request from the tags list, then we
//    read the tag data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_POST_VARS["SCID"] == '') { $HTTP_POST_VARS["SCID"] = $HTTP_GET_VARS["SCID"]; }
GetSpecialData($HTTP_POST_VARS["SCID"]);
if ($HTTP_GET_VARS["CatID"] != '') {
   $HTTP_POST_VARS["CatID"] = $HTTP_GET_VARS["CatID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
   GetGlobalData();
}


$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddCat();
      Header("Location: ".BuildLink('m_subcontentcats.php')."&SCID=".$HTTP_POST_VARS["SCID"]."&page=".$HTTP_POST_VARS["page"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmCatForm();


function frmCatForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('catname');
   adminformtitle(2,$GLOBALS["tFormTitle3"]);
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("CatParent","catparent"); ?>
       <td valign="top" class="content">
           <select name="catparent" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><OPTION value="0">-- <?php echo $GLOBALS["tNoParent"]; ?> --<?php
               RenderCats($GLOBALS["gsCatParent"]); ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CatName","catname"); ?>
       <td valign="top" class="content">
           <input type="text" name="catname" size="32" value="<?php echo $GLOBALS["gsCatName"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("HiddenCat","3"); ?>
       <td valign="top" class="content">
           <input type="radio" value="1" name="hiddencat" <?php if($GLOBALS["gsHiddenCat"] == "1") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tYes"]; ?><br />
           <input type="radio" value="0" name="hiddencat" <?php If($GLOBALS["gsHiddenCat"] != "1") echo "checked" ?><?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["tNo"]; ?>
       </td>
   </tr>
   <?php
   catformsavebar(2,'m_subcontentcats.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(2);
      ?><input type="hidden" name="CatID" value="<?php echo $HTTP_POST_VARS["CatID"]; ?>"><?php
      ?><input type="hidden" name="oldcatref" value="<?php echo $GLOBALS["gsOldCatRef"]; ?>"><?php
      ?><input type="hidden" name="oldhiddencat" value="<?php echo $GLOBALS["gsOldHiddenCat"]; ?>"><?php
      ?><input type="hidden" name="SCID" value="<?php echo $HTTP_POST_VARS["SCID"]; ?>"><?php
   }
   adminformclose();
} // function frmCatForm()


function AddCat()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $sCatname = dbString($HTTP_POST_VARS["catname"]);

   if ($HTTP_POST_VARS["CatID"] != '') {
      $strQuery = "UPDATE ".$GLOBALS["scCatTable"]." SET catname='".$HTTP_POST_VARS["catname"]."',hiddencat='".$HTTP_POST_VARS["hiddencat"]."' WHERE catid='".$HTTP_POST_VARS["CatID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scCatTable"]."(catname,hiddencat) VALUES('".$HTTP_POST_VARS["catname"]."','".$HTTP_POST_VARS["hiddencat"]."')";
   }
   $result = dbExecute($strQuery,true);

   // Set the cat reference to include parent category details
   $CatID = dbInsertValue($GLOBALS["scCatTable"]);
   if ($CatID == 0) { $CatID = $HTTP_POST_VARS["CatID"]; }
   if ($HTTP_POST_VARS["catparent"] == '0') { $catref = $CatID; }
   else { $catref = $HTTP_POST_VARS["catparent"].'.'.$CatID; }
   $strQuery = "UPDATE ".$GLOBALS["scCatTable"]." SET catref='".$catref."' WHERE catid='".$CatID."'";
   $result = dbExecute($strQuery,true);

   // We've changed the parent category
   if ($catref != $HTTP_POST_VARS["oldcatref"]) {
      // Move all child categories to the new parent tree
      $strQuery = "SELECT * FROM ".$GLOBALS["scCatTable"]." where catref LIKE '".$HTTP_POST_VARS["oldcatref"].".%'";
      $cresult = dbRetrieve($strQuery,true,0,0);
      while ($crs = dbFetch($cresult)) {
         $newcatref = $catref.substr($crs["catref"],strlen($HTTP_POST_VARS["oldcatref"]));
         $strQuery = "UPDATE ".$GLOBALS["scCatTable"]." SET catref='".$newcatref."' WHERE catid='".$crs["catid"]."'";
         $uresult = dbExecute($strQuery,true);
      }
      dbFreeResult($cresult);
      // Update any news articles that might be in this branch of the category hierarchy
      $strQuery = "SELECT ".$HTTP_POST_VARS["SCID"]."id AS id,catid FROM ".$GLOBALS["scTable"]." where catid='".$HTTP_POST_VARS["oldcatref"]."' or catid LIKE '".$HTTP_POST_VARS["oldcatref"].".%'";
      $cresult = dbRetrieve($strQuery,true,0,0);
      while ($crs = dbFetch($cresult)) {
         $newcatref = $catref.substr($crs["catref"],strlen($HTTP_POST_VARS["oldcatref"]));
         $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET catid='".$newcatref."' WHERE ".$HTTP_POST_VARS["SCID"]."id='".$crs["id"]."'";
         $uresult = dbExecute($strQuery,true);
      }
      dbFreeResult($cresult);
   }

   // We've changed the hidden status, so all child categories for this parent also inherit the same hidden status
   if ($HTTP_POST_VARS["hiddencat"] != $HTTP_POST_VARS["oldhiddencat"]) {
      $strQuery = "SELECT * FROM ".$GLOBALS["scCatTable"]." where catref LIKE '".$HTTP_POST_VARS["oldcatref"].".%'";
      $cresult = dbRetrieve($strQuery,true,0,0);
      while ($crs = dbFetch($cresult)) {
         $strQuery = "UPDATE ".$GLOBALS["scCatTable"]." SET hiddencat='".$HTTP_POST_VARS["hiddencat"]."' WHERE catid='".$crs["catid"]."'";
         $uresult = dbExecute($strQuery,true);
      }
      dbFreeResult($cresult);
   }

   dbCommit();
} // function AddTag()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["catname"] == "") { $GLOBALS["strErrors"][] = $GLOBALS["eNoCat"]; }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function GetGlobalData()
{
   global $HTTP_GET_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scCatTable"]." WHERE catid='".$HTTP_GET_VARS["CatID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsCatName"]      = $rs["catname"];
   $GLOBALS["gsCatParent"]    = $rs["catref"];
   $GLOBALS["gsOldCatRef"]    = $rs["catref"];
   $GLOBALS["gsHiddenCat"]    = $rs["hiddencat"];
   $GLOBALS["gsOldHiddenCat"] = $rs["hiddencat"];

   $GLOBALS["specialedit"] = True;
   $GLOBALS["fieldstatus"] = '';
} // function GetGlobalData()


function GetFormData()
{
   global $HTTP_POST_VARS;

   $GLOBALS["gsCatName"]      = $HTTP_POST_VARS["catname"];
   $GLOBALS["gsCatParent"]    = $HTTP_POST_VARS["catparent"];
   $GLOBALS["gsOldCatRef"]    = $HTTP_POST_VARS["oldcatref"];
   $GLOBALS["gsHiddenCat"]    = $HTTP_POST_VARS["hiddencat"];
   $GLOBALS["gsOldHiddenCat"] = $HTTP_POST_VARS["oldhiddencat"];

   $GLOBALS["specialedit"] = True;
   $GLOBALS["fieldstatus"] = '';
} // function GetFormData()


function catformsavebar($colspan,$cancelref)
{
   global $HTTP_GET_VARS, $HTTP_POST_VARS;

   if ($HTTP_POST_VARS["page"] == '') { $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"]; }
   if ($HTTP_POST_VARS["sort"] == '') { $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"]; }
   ?>
   <tr class="topmenuback">
       <td colspan="<?php echo $colspan; ?>" align="<?php echo $GLOBALS["left"]; ?>">
           <?php if ($GLOBALS["specialedit"] == True)
           // Save privilege
           {
              ?>
              <input type="submit" value="<?php echo $GLOBALS["tSave"]; ?>" name="submit">&nbsp;
              <input type="reset" value="<?php echo $GLOBALS["tReset"]; ?>" name="reset">&nbsp;
              <?php
           }
           ?>
           <input type="button" value="<?php echo $GLOBALS["tCancel"]; ?>" onClick="javascript:document.location.href='<?php echo BuildLink($cancelref); ?>&page=<?php echo $HTTP_POST_VARS["page"]; ?>&sort=<?php echo $HTTP_POST_VARS["sort"]; ?>&filterlangname=<?php echo $HTTP_POST_VARS["LanguageCode"]; ?>&SCID=<?php echo $HTTP_POST_VARS["SCID"]; ?>'" name="cancel">
       </td>
   </tr>
   <?php
} // function catformsavebar()


function RenderCats($CatRef)
{
   $currentparents = explode('.',$CatRef);
   $discard = array_pop($currentparents);
   $parentref = implode('.',$currentparents);

   $strQuery = "SELECT * FROM ".$GLOBALS["scCatTable"]." WHERE catref NOT LIKE '".$CatRef.".%' And catref != '".$CatRef."' ORDER BY catref";
   $cresult = dbRetrieve($strQuery,true,0,0);
   while ($crs = dbFetch($cresult))
   {
      $catparents = explode('.',$crs["catref"]);
      $catlevel = count($catparents) - 1;
      echo '<option value="'.$crs["catref"].'"';
      if ($crs["catref"] == $parentref) { echo ' selected'; }
      echo '>';
      echo str_repeat('-->&nbsp;',$catlevel);
      echo $crs["catname"];
   }
   dbFreeResult($cresult);
} // function RenderCats()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
