<?php

/***************************************************************************

 m_subgroupsform.php
 --------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subgroups';
$validaccess = VerifyAdminLogin3("SubGroupName");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','subgroups');


$ImageFileTypes = array( 'gif', 'jpg', 'jpeg', 'png');

// If we've been passed the request from the content list, then we
//    read content data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["SubGroupName"] != '') {
   $HTTP_POST_VARS["SubGroupName"] = $HTTP_GET_VARS["SubGroupName"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"];
   GetGlobalData();
} else {
   if ($HTTP_GET_VARS["filtergroupname"] != '') {
      $GLOBALS["fsGroupName"] = $HTTP_GET_VARS["filtergroupname"];
   }
   $GLOBALS["fbSubMenuVisible"] = 'Y';
   $GLOBALS["fsAuthorId"]       = $EZ_SESSION_VARS["UserID"];
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   if (bCheckForm()) {
      AddSubGroup();
      Header("Location: ".BuildLink('m_subgroups.php')."&page=".$HTTP_POST_VARS["page"]."&filtergroupname=".$HTTP_POST_VARS["filtergroupname"]);
   } else {
      GetFormData();
   }
}
frmSubGroupsForm();


function frmSubGroupsForm()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   adminformheader();
   adminformopen('subgroupname');
   adminformtitle(4,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(4); }
   adminsubheader(4,$GLOBALS["thGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuRef","subgroupname"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="subgroupname" size="32" value="<?php echo $GLOBALS["fsSubGroupName"]; ?>" maxlength="100"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("SubmenuTitle","subgroupdesc"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="subgroupdesc" size="70" value="<?php echo $GLOBALS["fsSubGroupDesc"]; ?>" maxlength="100"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ParentMenu","groupname"); ?>
       <td valign="top" colspan="3" class="content">
           <select name="groupname" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><OPTION value="0">-- <?php echo $GLOBALS["tNoParent"]; ?> --<?php
               RenderGroups($GLOBALS["fsGroupName"]);
               ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuHover","hovertitle"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="hovertitle" size="70" value="<?php echo $GLOBALS["fsHoverTitle"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ShowMenu","submenuvisible"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="checkbox" name="submenuvisible" value="Y" <?php if($GLOBALS["fbSubMenuVisible"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thGraphics"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage1","submenuimage1"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="submenuimage1" size="64" value="<?php echo $GLOBALS["fsSubMenuImage1"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('submenuimage1',$GLOBALS["fsSubMenuImage1"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage2","submenuimage2"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="submenuimage2" size="64" value="<?php echo $GLOBALS["fsSubMenuImage2"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('submenuimage2',$GLOBALS["fsSubMenuImage2"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage3","submenuimage3"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="submenuimage3" size="64" value="<?php echo $GLOBALS["fsSubMenuImage3"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('submenuimage3',$GLOBALS["fsSubMenuImage3"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage4","submenuimage4"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="submenuimage4" size="64" value="<?php echo $GLOBALS["fsSubMenuImage4"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('submenuimage4',$GLOBALS["fsSubMenuImage4"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thLinks"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuLink","subgrouplink"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="subgrouplink" size="64" value="<?php echo $GLOBALS["fsSubGroupLink"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminmoduledisplay('subgrouplink'); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("OpenMenuLink","openinpage"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="checkbox" name="openinpage" value="Y" <?php if($GLOBALS["fsOpenInPage"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thSequence"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("OrderBy","submenuorderby"); ?>
       <td valign="top" colspan="3" class="content">
           <select name="submenuorderby" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="1" <?php if($GLOBALS["fsOrderBy"] == "1") echo "selected"; ?>><?php echo $GLOBALS["toOrderID"]; ?>
               <option value="2" <?php if($GLOBALS["fsOrderBy"] == "2") echo "selected"; ?>><?php echo $GLOBALS["toPublished"]; ?>
               <option value="3" <?php if($GLOBALS["fsOrderBy"] == "3") echo "selected"; ?>><?php echo $GLOBALS["toModified"]; ?>
               <option value="4" <?php if($GLOBALS["fsOrderBy"] == "4") echo "selected"; ?>><?php echo $GLOBALS["toAlphabetic"]; ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("OrderDir","submenuorderdir"); ?>
       <td valign="top" colspan="3" class="content">
           <select name="submenuorderdir" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="A" <?php if($GLOBALS["fsOrderDir"] == "A") echo "selected"; ?>><?php echo $GLOBALS["tAscending"]; ?>
               <option value="D" <?php if($GLOBALS["fsOrderDir"] == "D") echo "selected"; ?>><?php echo $GLOBALS["tDescending"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thAccess"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MLoginReq","loginreq"); ?>
       <td valign="top" class="content">
           <input type="checkbox" name="loginreq" value="Y" <?php if($GLOBALS["fsLoginReq"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("Usergroups",19); ?>
       <td valign="top" class="content" rowspan="2" >
           <select name="usergroups[]" multiple size="4"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderUsergroups($GLOBALS["fsUsergroups"]); ?></select>
       </td>
   </tr>
   <?php if ($EZ_SESSION_VARS["UserGroup"] == 'administrator') { $sFieldStatus = ''; } else { $sFieldStatus = ' DISABLED'; } ?>
   <tr class="tablecontent">
       <?php FieldHeading("Author",20); ?>
       <td valign="top" class="content">
           <select name="AuthorId" size="1"<?php echo $sFieldStatus; ?>><?php RenderAuthors($GLOBALS["fsAuthorId"]); ?></select>
       </td>
       <td valign="top" class="content">
           &nbsp;
       </td>
   </tr>
   <?php
   fadminformsavebar(4,'m_subgroups.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(4);
      ?><input type="hidden" name="subgroupid" value="<?php echo $GLOBALS["fsSubGroupID"]; ?>"><?php
      ?><input type="hidden" name="SubGroupName" value="<?php echo $HTTP_POST_VARS["SubGroupName"]; ?>"><?php
      ?><input type="hidden" name="oldgroupname" value="<?php echo $GLOBALS["OldGroupName"]; ?>"><?php
      ?><input type="hidden" name="subgrouporderid" value="<?php echo $GLOBALS["fsSubGroupOrderID"]; ?>"><?php
      ?><input type="hidden" name="filtergroupname" value="<?php echo $HTTP_POST_VARS["filtergroupname"]; ?>"><?php
   }
   adminformclose();
} // function frmSubGroupsForm()


function AddSubGroup()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   if ($HTTP_POST_VARS["AuthorId"] == '') { $HTTP_POST_VARS["AuthorId"] = $HTTP_POST_VARS["authorid"]; }

   $sSubGroupDesc  = dbString($HTTP_POST_VARS["subgroupdesc"]);
   $sHoverTitle    = dbString($HTTP_POST_VARS["hovertitle"]);

   $sUserGroups = '';
   if (isset($HTTP_POST_VARS["usergroups"])) {
      reset ($HTTP_POST_VARS["usergroups"]);
      while (list ($userkey, $userval) = each ($HTTP_POST_VARS["usergroups"])) {
         $sUserGroups .= ','.$userval;
      }
   }

   if ($HTTP_POST_VARS["groupname"] == '0') { $HTTP_POST_VARS["groupname"] = ''; }
   if ($HTTP_POST_VARS["SubGroupName"] != '') {
      // Update any foreign language copies of this group as well
      $strQuery = "UPDATE ".$GLOBALS["eztbSubgroups"]." SET groupname='".$HTTP_POST_VARS["groupname"]."', subgrouplink='".$HTTP_POST_VARS["subgrouplink"]."', subgrouporderid='".$HTTP_POST_VARS["subgrouporderid"]."', submenuvisible='".$HTTP_POST_VARS["submenuvisible"]."', submenuorderby='".$HTTP_POST_VARS["submenuorderby"]."', submenuorderdir='".$HTTP_POST_VARS["submenuorderdir"]."', openinpage='".$HTTP_POST_VARS["openinpage"]."', loginreq='".$HTTP_POST_VARS["loginreq"]."', usergroups='".$sUserGroups."', subgroupname='".$HTTP_POST_VARS["subgroupname"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE subgroupname='".$HTTP_POST_VARS["SubGroupName"]."' AND language<>'".$GLOBALS["gsLanguage"]."'";
      $result = dbExecute($strQuery,true);
      $strQuery = "UPDATE ".$GLOBALS["eztbSubgroups"]." SET groupname='".$HTTP_POST_VARS["groupname"]."', subgroupdesc='".$sSubGroupDesc."', subgrouplink='".$HTTP_POST_VARS["subgrouplink"]."', subgrouporderid='".$HTTP_POST_VARS["subgrouporderid"]."', submenuimage1='".$HTTP_POST_VARS["submenuimage1"]."', submenuimage2='".$HTTP_POST_VARS["submenuimage2"]."', submenuvisible='".$HTTP_POST_VARS["submenuvisible"]."', submenuorderby='".$HTTP_POST_VARS["submenuorderby"]."', submenuorderdir='".$HTTP_POST_VARS["submenuorderdir"]."', hovertitle='".$sHoverTitle."', openinpage='".$HTTP_POST_VARS["openinpage"]."', loginreq='".$HTTP_POST_VARS["loginreq"]."', usergroups='".$sUserGroups."', subgroupname='".$HTTP_POST_VARS["subgroupname"]."', submenuimage3='".$HTTP_POST_VARS["submenuimage3"]."', submenuimage4='".$HTTP_POST_VARS["submenuimage4"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE subgroupname='".$HTTP_POST_VARS["SubGroupName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbSubgroups"]." values('', '".$HTTP_POST_VARS["groupname"]."', '".$sSubGroupDesc."', '".$HTTP_POST_VARS["subgrouplink"]."', '".$HTTP_POST_VARS["subgrouporderid"]."', '".$HTTP_POST_VARS["submenuimage1"]."', '".$HTTP_POST_VARS["submenuimage2"]."', '".$HTTP_POST_VARS["submenuvisible"]."', '".$HTTP_POST_VARS["submenuorderby"]."', '".$HTTP_POST_VARS["submenuorderdir"]."', '".$sHoverTitle."', '".$HTTP_POST_VARS["openinpage"]."', '".$HTTP_POST_VARS["loginreq"]."', '".$sUserGroups."', '".$HTTP_POST_VARS["subgroupname"]."', '".$GLOBALS["gsLanguage"]."', '".$HTTP_POST_VARS["submenuimage3"]."', '".$HTTP_POST_VARS["submenuimage4"]."', '".$HTTP_POST_VARS["AuthorId"]."')";
   }
   $result = dbExecute($strQuery,true);
   $dummy = dbInsertValue($GLOBALS["eztbSubgroups"]);
   if ($dummy == 0) { $dummy = $HTTP_POST_VARS["subgroupid"]; }

   // If we've changed the subgroup name, we need to reflect that in any content pages that are attached to that menu
   if (($HTTP_POST_VARS["SubGroupName"] != '') && ($HTTP_POST_VARS["subgroupname"] != $HTTP_POST_VARS["SubGroupName"])) {
      $strQuery = "UPDATE ".$GLOBALS["eztbContents"]." SET subgroupname='".$HTTP_POST_VARS["subgroupname"]."' WHERE subgroupname='".$HTTP_POST_VARS["SubGroupName"]."'";
      $result = dbExecute($strQuery,true);
   }

   // For new groups:
   //     if no name was specified, set a default
   //     if no orderid was specified, set a default
   if ((($HTTP_POST_VARS["SubGroupName"] == '') && ($HTTP_POST_VARS["subgroupname"] == '')) || ($HTTP_POST_VARS["subgrouporderid"] == '')) {
      if (($HTTP_POST_VARS["SubGroupName"] == '') && ($HTTP_POST_VARS["subgroupname"] == '')) {
         $subgroupname = $dummy;
      } else { $subgroupname = $HTTP_POST_VARS["subgroupname"]; }
      if ($HTTP_POST_VARS["subgrouporderid"] == '') { $subgrouporderid = $dummy;
      } else { $subgrouporderid = $HTTP_POST_VARS["subgrouporderid"]; }
      $strQuery = "UPDATE ".$GLOBALS["eztbSubgroups"]." SET subgroupname='".$subgroupname."', subgrouporderid='".$subgrouporderid."' WHERE subgroupid='".$dummy."'";
      $result = dbExecute($strQuery,true);
   }

   //  If we've switched this subgroup from one group to another, then we adjust the subgroup count
   //     for those group record (across all languages).
   if ($HTTP_POST_VARS["groupname"] != $HTTP_POST_VARS["oldgroupname"]) {
      if ($HTTP_POST_VARS["oldgroupname"] != '') {
         $strQuery = "UPDATE ".$GLOBALS["eztbGroups"]." SET subgroupcount=subgroupcount - 1 WHERE groupname='".$HTTP_POST_VARS["oldgroupname"]."'";
         $result = dbExecute($strQuery,true);
      }
      if ($HTTP_POST_VARS["groupname"] != '') {
         $strQuery = "UPDATE ".$GLOBALS["eztbGroups"]." SET subgroupcount=subgroupcount + 1 WHERE groupname='".$HTTP_POST_VARS["groupname"]."'";
         $result = dbExecute($strQuery,true);
      }
   }
   dbCommit();
} // function AddSubGroup()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["eztbSubgroups"]." WHERE subgroupname='".$HTTP_GET_VARS["SubGroupName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["fsSubGroupID"]      = $rs["subgroupid"];
   $GLOBALS["fsSubGroupName"]    = $rs["subgroupname"];
   $GLOBALS["fsSubGroupDesc"]    = $rs["subgroupdesc"];
   $GLOBALS["fsGroupName"]       = $rs["groupname"];
   $GLOBALS["fsSubGroupLink"]    = $rs["subgrouplink"];
   $GLOBALS["fsSubGroupOrderID"] = $rs["subgrouporderid"];
   $GLOBALS["fsSubMenuImage1"]   = $rs["submenuimage1"];
   $GLOBALS["fsSubMenuImage2"]   = $rs["submenuimage2"];
   $GLOBALS["fsSubMenuImage3"]   = $rs["submenuimage3"];
   $GLOBALS["fsSubMenuImage4"]   = $rs["submenuimage4"];
   $GLOBALS["fbSubMenuVisible"]  = $rs["submenuvisible"];
   $GLOBALS["fsOrderBy"]         = $rs["submenuorderby"];
   $GLOBALS["fsOrderDir"]        = $rs["submenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $rs["hovertitle"];
   $GLOBALS["fsOpenInPage"]      = $rs["openinpage"];
   $GLOBALS["fsLoginReq"]        = $rs["loginreq"];
   $GLOBALS["fsUsergroups"]      = $rs["usergroups"];
   $GLOBALS["OldGroupName"]      = $rs["groupname"];
   $GLOBALS["fsAuthorId"]        = $rs["authorid"];

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }

   $HTTP_POST_VARS["SubGroupName"]    = $HTTP_GET_VARS["SubGroupName"];
   $HTTP_POST_VARS["filtergroupname"] = $HTTP_GET_VARS["filtergroupname"];
   dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $GLOBALS["fsSubGroupID"]      = $HTTP_POST_VARS["subgroupid"];
   $GLOBALS["fsSubGroupName"]    = $HTTP_POST_VARS["subgroupname"];
   $GLOBALS["fsSubGroupDesc"]    = $HTTP_POST_VARS["subgroupdesc"];
   $GLOBALS["fsGroupName"]       = $HTTP_POST_VARS["groupname"];
   $GLOBALS["fsSubGroupLink"]    = $HTTP_POST_VARS["subgrouplink"];
   $GLOBALS["fsSubGroupOrderID"] = $HTTP_POST_VARS["subgrouporderid"];
   $GLOBALS["fsSubMenuImage1"]   = $HTTP_POST_VARS["submenuimage1"];
   $GLOBALS["fsSubMenuImage2"]   = $HTTP_POST_VARS["submenuimage2"];
   $GLOBALS["fsSubMenuImage3"]   = $HTTP_POST_VARS["submenuimage3"];
   $GLOBALS["fsSubMenuImage4"]   = $HTTP_POST_VARS["submenuimage4"];
   $GLOBALS["fbSubMenuVisible"]  = $HTTP_POST_VARS["submenuvisible"];
   $GLOBALS["fsOrderBy"]         = $HTTP_POST_VARS["submenuorderby"];
   $GLOBALS["fsOrderDir"]        = $HTTP_POST_VARS["submenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $HTTP_POST_VARS["hovertitle"];
   $GLOBALS["fsOpenInPage"]      = $HTTP_POST_VARS["openinpage"];
   $GLOBALS["fsLoginReq"]        = $HTTP_POST_VARS["loginreq"];
   $GLOBALS["fsUsergroups"]      = $HTTP_POST_VARS["usergroups"];
   $GLOBALS["OldGroupName"]      = $HTTP_POST_VARS["oldgroupname"];
   $GLOBALS["fsAuthorId"]        = $HTTP_POST_VARS["authorid"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function RenderGroups($SubGroupName)
{
   global $EZ_SESSION_VARS;

   if ($GLOBALS["gsShowTopMenu"] == 'Y') {
      if (($GLOBALS["gsSectionSecurity"] == 'Y') && ($GLOBALS["fieldstatus"] != ' disabled') && ($EZ_SESSION_VARS["UserGroup"] != $GLOBALS["gsAdminPrivGroup"])) {
         $sqlQuery = "SELECT g.groupname AS groupname,g.groupdesc AS groupdesc,t.topgroupdesc AS topgroupdesc FROM ".$GLOBALS["eztbGroups"]." g LEFT JOIN ".$GLOBALS["eztbTopgroups"]." t ON t.topgroupname=g.topgroupname AND t.language=g.language WHERE g.language='".$GLOBALS["gsLanguage"]."' AND g.grouplink='' AND g.authorid='".$EZ_SESSION_VARS["UserID"]."' ORDER BY t.topgrouporderid,g.grouporderid";
      } else {
         $sqlQuery = "SELECT g.groupname AS groupname,g.groupdesc AS groupdesc,t.topgroupdesc AS topgroupdesc FROM ".$GLOBALS["eztbGroups"]." g LEFT JOIN ".$GLOBALS["eztbTopgroups"]." t ON t.topgroupname=g.topgroupname AND t.language=g.language WHERE g.language='".$GLOBALS["gsLanguage"]."' AND g.grouplink='' ORDER BY t.topgrouporderid,g.grouporderid";
      }
   } else {
      if (($GLOBALS["gsSectionSecurity"] == 'Y') && ($GLOBALS["fieldstatus"] != ' disabled') && ($EZ_SESSION_VARS["UserGroup"] != $GLOBALS["gsAdminPrivGroup"])) {
         $sqlQuery = "SELECT groupname,groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' AND authorid='".$EZ_SESSION_VARS["UserID"]."' ORDER BY grouporderid";
      } else {
         $sqlQuery = "SELECT groupname,groupdesc FROM ".$GLOBALS["eztbGroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' AND grouplink='' ORDER BY grouporderid";
      }
   }
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if ($SubGroupName == $rs["groupname"]) { echo 'selected '; }
      echo 'value="'.$rs["groupname"].'">';
      if ($GLOBALS["gsShowTopMenu"] == 'Y') { echo $rs["topgroupdesc"].' - '; } 
      echo $rs["groupdesc"];
   }
   dbFreeResult($result);
} // function RenderGroups()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if (bRecordExists('eztbSubgroups','subgroupname',$HTTP_POST_VARS["subgroupname"],'subgroupid')) {
      $GLOBALS["strErrors"][] = $GLOBALS["eMenuExists"];
   }
   if ($HTTP_POST_VARS["subgroupname"] <> urlencode($HTTP_POST_VARS["subgroupname"]))
   {
      $GLOBALS["strErrors"][] = $GLOBALS["eInvalidName"];
   }
   if($HTTP_POST_VARS["subgroupdesc"] == "") {
      $GLOBALS["strErrors"][] = $GLOBALS["eTitleEmpty"];
   }

   if(!$bFormOK) { $GLOBALS["strErrors"] = $strMessage; }
   return $bFormOK;
} // function bCheckForm()


function RenderUsergroups($GroupNames)
{
   $sqlQuery = "SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY usergroupname";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if (strpos($GroupNames, $rs["usergroupname"], 0)) { echo 'selected '; }
      echo 'value="'.$rs["usergroupname"].'">'.$rs["usergroupdesc"];
   }
   dbFreeResult($result);
} // function RenderUsergroups()


function RenderAuthors($AuthorId)
{
   $sqlQuery = "SELECT authorid,authorname FROM ".$GLOBALS["eztbAuthors"]." ORDER BY authorname";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if ($AuthorId == $rs["authorid"]) { echo 'selected '; }
      echo 'value="'.$rs["authorid"].'">'.$rs["authorname"];
   }
   dbFreeResult($result);
} // function RenderAuthors()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
