<?php

/***************************************************************************

 m_tagsform.php
 ---------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");
include_once ("compile.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'tags';
$validaccess = VerifyAdminLogin3("TagID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','tags');


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('translation');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);



// If we've been passed the request from the tags list, then we
//    read the tag data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["TagID"] != '') {
	$HTTP_POST_VARS["TagID"] = $HTTP_GET_VARS["TagID"];
	$HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
	$HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
	GetGlobalData();
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
	// User has submitted the data
	if (bCheckForm()) {
		AddTag();
		Header("Location: ".BuildLink('m_tags.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]);
	} else {
		// Invalid data has been submitted
		GetFormData();
	}
}
frmTagForm();


function frmTagForm()
{
	global $EZ_SESSION_VARS, $HTTP_POST_VARS;

	adminformheader();
	adminformopen('tagname');
	adminformtitle(2,$GLOBALS["tFormTitle"]);
	if (isset($GLOBALS["strErrors"])) { formError(2); }
	adminsubheader(2,$GLOBALS["thTagGeneral"]);
	?>
	<tr class="tablecontent">
		<?php FieldHeading("Tag","tagname"); ?>
		<td valign="top" class="content">
			<input type="text" name="tagname" size="32" value="<?php echo $GLOBALS["gsTagName"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("Category","cat"); ?>
		<td valign="top" class="content">
			<select name="cat" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderCats($GLOBALS["gsCat"]); ?></select>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php adminHTMLAreadisplay("translation","Translation",$GLOBALS["gsTranslation"],"cat"); ?>
	</tr>
	<?php
	adminformsavebar(2,'m_tags.php');
	if ($GLOBALS["specialedit"] == True) {
		adminhelpmsg(2);
		?><input type="hidden" name="TagID" value="<?php echo $HTTP_POST_VARS["TagID"]; ?>"><?php
	}
	adminformclose();
} // function frmTagForm()


function AddTag()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	if ($EZ_SESSION_VARS["UserGroup"] == $GLOBALS["gsAdminPrivGroup"]) { $scriptsAllowed = 'Y'; } else { $scriptsAllowed = 'N'; }

	$sTranslation = trim(dbString($HTTP_POST_VARS["translation"]));
	if ($sTranslation == '<br />') { $sTranslation = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sTranslation	= str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sTranslation);
		$sTranslation	= str_replace($GLOBALS["base_url"],'./',$sTranslation);
		$sTranslation	= str_replace('<./','</',$sTranslation);
		//	Compile pre-compiled tags
		$sTranslation	= trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sTranslation.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', 'L', $scriptsAllowed ));
	}

	if ($HTTP_POST_VARS["TagID"] != '') {
		$strQuery = "UPDATE ".$GLOBALS["eztbTags"]." SET tag='".$HTTP_POST_VARS["tagname"]."', cat='".$HTTP_POST_VARS["cat"]."', translation='".$sTranslation."' WHERE tagid='".$HTTP_POST_VARS["TagID"]."'";
	} else {
		$strQuery = "INSERT INTO ".$GLOBALS["eztbTags"]."(tag,canedit,candelete,translation,authorid,cat) VALUES('".$HTTP_POST_VARS["tagname"]."', 'Y', 'Y', '".$sTranslation."', ".$EZ_SESSION_VARS["UserID"].", '".$HTTP_POST_VARS["cat"]."')";
	}
	$result = dbExecute($strQuery,true);

	if ($HTTP_POST_VARS["TagID"] != '') {
		$strQuery = "SELECT contentname,language,body,teaser,leftright FROM ".$GLOBALS["eztbContents"]." WHERE body LIKE '%[".$HTTP_POST_VARS["tagname"]."]%' OR teaser LIKE '%[".$HTTP_POST_VARS["tagname"]."]%'";
		$sresult = dbRetrieve($strQuery,true,0,0);
		$results_found = dbRowsReturned($sresult);
		if ($results_found != 0) {
			while ($rsContent = dbFetch($sresult)) {
				$nContentName = $rsContent["contentname"];
				$nContentLang = $rsContent["language"];

				$sBody   = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$rsContent["body"].$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', $rsContent["leftright"], $scriptsAllowed));
				$sTeaser = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$rsContent["teaser"].$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], 'Y', $rsContent["leftright"], $scriptsAllowed));
				$strQuery = "UPDATE ".$GLOBALS["eztbContents"]." SET cbody='".str_replace("'","\'", $sBody)."',cteaser='".str_replace("'","\'", $sTeaser)."' WHERE contentname='".$nContentName."' AND language='".$nContentLang."'";
				$cresult = dbExecute($strQuery,true);
			}
		}
		dbFreeResult($sresult);
	}
	dbCommit();
} // function AddTag()


function bCheckForm()
{
	global $HTTP_POST_VARS;

	$bFormOK = true;
	if ($HTTP_POST_VARS["tagname"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eNoTag"]; }
	if ((trim($HTTP_POST_VARS["translation"]) == "") || (trim($HTTP_POST_VARS["translation"]) == "<br />"))	{ $GLOBALS["strErrors"][] = $GLOBALS["eNoTranslation"]; }

	if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
	return $bFormOK;
} // function bCheckForm()


function GetGlobalData()
{
	global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

	$strQuery="SELECT * FROM ".$GLOBALS["eztbTags"]." WHERE tagid='".$HTTP_GET_VARS["TagID"]."'";
	$result = dbRetrieve($strQuery,true,0,0);
	$rs     = dbFetch($result);

	$GLOBALS["gsTagName"]     = $rs["tag"];
	$GLOBALS["gsCat"]         = $rs["cat"];

	if ($GLOBALS["WYSIWYG"] == 'Y') {
		$GLOBALS["gsTranslation"]		= formatWYSIWYG($rs["translation"]);
	} else {
		$GLOBALS["gsTranslation"]		= $rs["translation"];
	}

	$HTTP_POST_VARS["authorid"] = $rs["authorid"];
	if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}
	dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
	global $HTTP_POST_VARS, $EZ_SESSION_VARS;

	$GLOBALS["gsTagName"]     = $HTTP_POST_VARS["tagname"];
	$GLOBALS["gsCat"]         = $HTTP_POST_VARS["cat"];
	$GLOBALS["gsTranslation"] = $HTTP_POST_VARS["translation"];

	if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
		$GLOBALS["specialedit"] = True;
		$GLOBALS["fieldstatus"] = '';
	}
} // function GetFormData()


function RenderCats($cat)
{
   $sqlQuery = "SELECT * FROM ".$GLOBALS["eztbTagCategories"]." WHERE language='".$GLOBALS["gsLanguage"]."'";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if ($cat == $rs["catname"]) { echo 'selected '; }
      echo 'value="'.$rs["catname"].'">'.$rs["catdesc"];
   }
   dbFreeResult($result);
} // function RenderCats()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
