<?php

/***************************************************************************

 m_themesform.php
 -----------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'themes';
$validaccess = VerifyAdminLogin3("ThemeID");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','themes');


// If we've been passed the request from the themes list, then we
//    read the theme data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["ThemeCode"] != '') {
   $HTTP_POST_VARS["ThemeCode"] = $HTTP_GET_VARS["ThemeCode"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   $HTTP_POST_VARS["sort"] = $HTTP_GET_VARS["sort"];
   GetGlobalData();
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddTheme();
      Header("Location: ".BuildLink('m_themes.php')."&page=".$HTTP_POST_VARS["page"]."&sort=".$HTTP_POST_VARS["sort"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmThemeForm();


function frmThemeForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   if ($HTTP_POST_VARS["ThemeCode"] != '') {
      adminformopen('themename');
   } else {
      adminformopen('themecode');
   }
   adminformtitle(2,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   adminsubheader(2,$GLOBALS["thThemeGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("ThemeCode","themecode"); ?>
       <td valign="top" class="content">
           <?php
           if ($HTTP_POST_VARS["ThemeCode"] != '') {
              ?><input type="text" name="themecode" size="32" value="<?php echo $GLOBALS["gsThemeCode"]; ?>" maxlength="32" disabled><?php
           } else {
              ?><input type="text" name="themecode" size="32" value="<?php echo $GLOBALS["gsThemeCode"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>><?php
           }
           ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ThemeName","themename"); ?>
       <td valign="top" class="content">
           <input type="text" name="themename" size="32" value="<?php echo $GLOBALS["gsThemeName"]; ?>" maxlength="64"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ThemeDescription","themedescription"); ?>
       <td valign="top" class="content">
           <textarea name="themedescription" rows="6" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsThemeDescription"]); ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ThemeEnabled","themeenabled"); ?>
       <td valign="top" class="content">
           <select name="themeenabled" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="1" <?php if($GLOBALS["gsThemeEnabled"] == "1") echo "selected"; ?>><?php echo $GLOBALS["tYes"]; ?>
               <option value="0" <?php if($GLOBALS["gsThemeEnabled"] != "1") echo "selected"; ?>><?php echo $GLOBALS["tNo"]; ?>
           </select>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_themes.php');
   adminhelpmsg(2);
   ?><input type="hidden" name="ThemeCode" value="<?php echo $HTTP_POST_VARS["ThemeCode"]; ?>"><?php
   adminformclose();
} // function frmThemeForm()


function AddTheme()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $sThemeName        = dbString($HTTP_POST_VARS["themename"]);
   $sThemeDescription = dbString($HTTP_POST_VARS["themedescription"]);

   if ($HTTP_POST_VARS["ThemeCode"] != '') {
      $strQuery = "UPDATE ".$GLOBALS["eztbThemes"]." SET themename='".$sThemeName."', themedescription='".$sThemeDescription."', themeenabled='".$HTTP_POST_VARS["themeenabled"]."' WHERE themecode='".$HTTP_POST_VARS["ThemeCode"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbThemes"]."(themecode,themename,themedescription,themeenabled) VALUES('".$HTTP_POST_VARS["themecode"]."', '".$sThemeName."', '".$sThemeDescription."', '".$HTTP_POST_VARS["themeenabled"]."')";
   }
   $result = dbExecute($strQuery,true);

   //  If this is a brand new theme, we need to set up the directories, config file,
   //     and new database table for settings
   if ($HTTP_POST_VARS["ThemeCode"] == '') {
      $savedir = getcwd();

      chdir($GLOBALS["rootdp"].$GLOBALS["themes_home"]);
      //  Create the theme-specific config file
      $fullfilename = 'config.'.$HTTP_POST_VARS["themecode"].'.php';
      $fp = fopen($fullfilename, "wb");
      fwrite($fp,'<?php'.chr(10).chr(10));
      fwrite($fp,'// ezContents Table Names'.chr(10));
      fwrite($fp,'$GLOBALS["eztbThemePrefix"]'.chr(9).'= "'.$EZ_SESSION_VARS["Site"].$HTTP_POST_VARS["themecode"].'";'.chr(10));
      fwrite($fp,'$GLOBALS["eztbSettings"]'.chr(9).'= $GLOBALS["eztbThemePrefix"]."settings";'.chr(10));
      fwrite($fp,chr(10).'?>'.chr(10));
      fclose($fp);


      //  Create a new directory under the multi-theme home directory
      //  If a directory doesn't exist for a theme, then we create it
      if ((!file_exists($HTTP_POST_VARS["themecode"])) || (!is_dir($HTTP_POST_VARS["themecode"]))) { mkdir ($HTTP_POST_VARS["themecode"], 0777); }
      chdir($HTTP_POST_VARS["themecode"]);
      chdir($savedir);


      //  Create the data tables for this theme
      //  For each table, we generate a 'create' definition from the existing table,
      //      then simply modify the table name for the new theme and execute the script.
      //  SETTINGS
      $dbString  = dbTableDef($GLOBALS["eztbSettings"]);
      $sqlString = str_replace ($GLOBALS["eztbSettings"], $EZ_SESSION_VARS["Site"].$HTTP_POST_VARS["themecode"]."settings", $dbString);
      $result = dbExecute($sqlString,true);

      //  Copy all settings from the current master theme
      $sqlString = "INSERT INTO ".$EZ_SESSION_VARS["Site"].$HTTP_POST_VARS["themecode"]."settings SELECT * FROM ".$GLOBALS["eztbSettings"];
      $r = dbExecute($sqlString,true);

      $EZ_SESSION_VARS["Theme"] = $HTTP_POST_VARS["themecode"];
      RebuildStyleSheet();
   }

   dbCommit();
} // function AddTheme()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["ThemeCode"] == '') {
      if ($HTTP_POST_VARS["themecode"] == "") {
         $GLOBALS["strErrors"][] = $GLOBALS["eNoCode"];
      } elseif ($HTTP_POST_VARS["themecode"] <> urlencode($HTTP_POST_VARS["themecode"])) {
         $GLOBALS["strErrors"][] = $GLOBALS["eInvalidCode"];
      } elseif ($HTTP_POST_VARS["themecode"] == $GLOBALS["gsThemeCode"]) {
         $GLOBALS["strErrors"][] = $GLOBALS["eMasterCode"];
      } else {
         $strQuery="SELECT * FROM ".$GLOBALS["eztbThemes"]." WHERE themecode='".$HTTP_POST_VARS["themecode"]."'";
         $sresult = dbRetrieve($strQuery,true,0,0);
         $sRecCount = dbRowsReturned($sresult);
         dbFreeResult($sresult);
         if ($sRecCount <> 0) { $GLOBALS["strErrors"][] = $GLOBALS["eCodeInUse"];
         } else {
	         $strQuery="SELECT * FROM ".$GLOBALS["eztbSites"]." WHERE sitecode='".$HTTP_POST_VARS["themecode"]."'";
	         $sresult = dbRetrieve($strQuery,true,0,0);
	         $sRecCount = dbRowsReturned($sresult);
	         dbFreeResult($sresult);
	         if ($sRecCount <> 0) { $GLOBALS["strErrors"][] = $GLOBALS["eCodeInUse"]; }
         }
      }
   }
   if ($HTTP_POST_VARS["themename"] == "")		{ $GLOBALS["strErrors"][] = $GLOBALS["eNoName"]; }
   if ($HTTP_POST_VARS["themedescription"] == "")	{ $GLOBALS["strErrors"][] = $GLOBALS["eNoDescription"]; }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["eztbThemes"]." WHERE themecode='".$HTTP_GET_VARS["ThemeCode"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsThemeCode"]        = $rs["themecode"];
   $GLOBALS["gsThemeName"]        = $rs["themename"];
   $GLOBALS["gsThemeDescription"] = $rs["themedescription"];
   $GLOBALS["gsThemeEnabled"]     = $rs["themeenabled"];
   dbFreeResult($result);
} // function GetGlobalData()


function GetFormData()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $GLOBALS["gsThemeCode"]        = $HTTP_POST_VARS["themecode"];
   $GLOBALS["gsThemeName"]        = $HTTP_POST_VARS["themename"];
   $GLOBALS["gsThemeDescription"] = $HTTP_POST_VARS["themedescription"];
   $GLOBALS["gsThemeEnabled"]     = $HTTP_POST_VARS["themeEnabled"];
} // function GetFormData()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
