<?php

/***************************************************************************

 m_topgroupsform.php
 --------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'topgroups';
$validaccess = VerifyAdminLogin3("TopGroupName");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','topgroups');


$ImageFileTypes = array('gif', 'jpg', 'jpeg', 'png');

// If we've been passed the request from the content list, then we
//    read content data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["TopGroupName"] != '') {
   $HTTP_POST_VARS["TopGroupName"] = $HTTP_GET_VARS["TopGroupName"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   $GLOBALS["fbMenuVisible"] = 'Y';
   $GLOBALS["fsAuthorId"]    = $EZ_SESSION_VARS["UserID"];
}

$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddTopGroup();
      Header("Location: ".BuildLink('m_topgroups.php')."&page=".$HTTP_POST_VARS["page"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmTopGroupsForm();


function frmTopGroupsForm()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   adminformheader();
   adminformopen('topgroupname');
   adminformtitle(4,$GLOBALS["tFormTitle"]);
   if (isset($GLOBALS["strErrors"])) { formError(4); }
   adminsubheader(4,$GLOBALS["thGeneral"]);
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuRef","topgroupname"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topgroupname" size="32" value="<?php echo $GLOBALS["fsTopGroupName"]; ?>" maxlength="32"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuTitle","topgroupdesc"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topgroupdesc" size="70" value="<?php echo $GLOBALS["fsTopGroupDesc"]; ?>" maxlength="100"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuHover","tophovertitle"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="tophovertitle" size="70" value="<?php echo $GLOBALS["fsHoverTitle"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ShowMenu","topmenuvisible"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="checkbox" name="topmenuvisible" value="Y" <?php if($GLOBALS["fbMenuVisible"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thGraphics"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage1","topmenuimage1"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topmenuimage1" size="64" value="<?php echo $GLOBALS["fsMenuImage1"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage1',$GLOBALS["fsMenuImage1"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage2","topmenuimage2"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topmenuimage2" size="64" value="<?php echo $GLOBALS["fsMenuImage2"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage2',$GLOBALS["fsMenuImage2"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage3","topmenuimage3"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topmenuimage3" size="64" value="<?php echo $GLOBALS["fsMenuImage3"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage3',$GLOBALS["fsMenuImage3"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage4","topmenuimage4"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topmenuimage4" size="64" value="<?php echo $GLOBALS["fsMenuImage4"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage4',$GLOBALS["fsMenuImage4"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thLinks"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuLink","topgrouplink"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="text" name="topgrouplink" size="64" value="<?php echo $GLOBALS["fsTopGroupLink"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminmoduledisplay('topgrouplink'); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("OpenMenuLink","topopeninpage"); ?>
       <td valign="top" colspan="3" class="content">
           <input type="checkbox" name="topopeninpage" value="Y" <?php if($GLOBALS["fsOpenInPage"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thSequence"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("OrderBy","topmenuorderby"); ?>
       <td valign="top" colspan="3" class="content">
           <select name="topmenuorderby" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="1" <?php if($GLOBALS["fsOrderBy"] == "1") echo "selected"; ?>><?php echo $GLOBALS["toOrderID"]; ?>
               <option value="2" <?php if($GLOBALS["fsOrderBy"] == "2") echo "selected"; ?>><?php echo $GLOBALS["toPublished"]; ?>
               <option value="3" <?php if($GLOBALS["fsOrderBy"] == "3") echo "selected"; ?>><?php echo $GLOBALS["toModified"]; ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("OrderDir","topmenuorderdir"); ?>
       <td valign="top" colspan="3" class="content">
           <select name="topmenuorderdir" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <option value="A" <?php if($GLOBALS["fsOrderDir"] == "A") echo "selected"; ?>><?php echo $GLOBALS["tAscending"]; ?>
               <option value="D" <?php if($GLOBALS["fsOrderDir"] == "D") echo "selected"; ?>><?php echo $GLOBALS["tDescending"]; ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thAccess"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MLoginReq","loginreq"); ?>
       <td valign="top" class="content">
           <input type="checkbox" name="loginreq" value="Y" <?php if($GLOBALS["fsLoginReq"] == 'Y') echo "checked"?><?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("Usergroups",18); ?>
       <td valign="top" class="content" rowspan="2">
           <select name="usergroups[]" multiple size="4"<?php echo $GLOBALS["fieldstatus"]; ?>><?php RenderUsergroups($GLOBALS["fsUsergroups"]); ?></select>
       </td>
   </tr>
   <?php if ($EZ_SESSION_VARS["UserGroup"] == 'administrator') { $sFieldStatus = ''; } else { $sFieldStatus = ' DISABLED'; } ?>
   <tr class="tablecontent">
       <?php FieldHeading("Author",19); ?>
       <td valign="top" class="content">
           <select name="AuthorId" size="1"<?php echo $sFieldStatus; ?>><?php RenderAuthors($GLOBALS["fsAuthorId"]); ?></select>
       </td>
       <td valign="top" class="content">
           &nbsp;
       </td>
   </tr>
   <?php
   adminformsavebar(4,'m_topgroups.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(4);
      ?><input type="hidden" name="topgroupid" value="<?php echo $GLOBALS["fsTopGroupID"]; ?>"><?php
      ?><input type="hidden" name="TopGroupName" value="<?php echo $HTTP_POST_VARS["TopGroupName"]; ?>"><?php
      ?><input type="hidden" name="topgrouporderid" value="<?php echo $GLOBALS["fsTopGroupOrderID"]; ?>"><?php
   }
   adminformclose();
} // function frmTopGroupsForm()


function AddTopGroup()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   if ($HTTP_POST_VARS["AuthorId"] == '') { $HTTP_POST_VARS["AuthorId"] = $HTTP_POST_VARS["authorid"]; }

   $sTopGroupDesc  = dbString($HTTP_POST_VARS["topgroupdesc"]);
   $sTopHoverTitle = dbString($HTTP_POST_VARS["tophovertitle"]);

   $sUserGroups = '';
   if (isset($HTTP_POST_VARS["usergroups"])) {
      reset ($HTTP_POST_VARS["usergroups"]);
      while (list ($userkey, $userval) = each ($HTTP_POST_VARS["usergroups"])) {
         $sUserGroups .= ','.$userval;
      }
   }

   if ($HTTP_POST_VARS["TopGroupName"] != '') {
      if ($GLOBALS["topgrouporderid"] == '') { $GLOBALS["topgrouporderid"] = $GLOBALS["topgroupid"]; }
      // Update any foreign language copies of this group as well
      $strQuery = "UPDATE ".$GLOBALS["eztbTopgroups"]." SET topgrouplink='".$HTTP_POST_VARS["topgrouplink"]."', topgrouporderid='".$HTTP_POST_VARS["topgrouporderid"]."', topmenuvisible='".$HTTP_POST_VARS["topmenuvisible"]."', topmenuorderby='".$HTTP_POST_VARS["topmenuorderby"]."', topmenuorderdir='".$HTTP_POST_VARS["topmenuorderdir"]."', topopeninpage='".$HTTP_POST_VARS["topopeninpage"]."', loginreq='".$HTTP_POST_VARS["loginreq"]."', usergroups='".$sUserGroups."', topgroupname='".$HTTP_POST_VARS["topgroupname"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE topgroupname='".$HTTP_POST_VARS["TopGroupName"]."' AND language<>'".$GLOBALS["gsLanguage"]."'";
      $result = dbExecute($strQuery,true);
      $strQuery = "UPDATE ".$GLOBALS["eztbTopgroups"]." SET topgroupdesc='".$sTopGroupDesc."', topgrouplink='".$HTTP_POST_VARS["topgrouplink"]."', topgrouporderid='".$HTTP_POST_VARS["topgrouporderid"]."', topmenuimage1='".$HTTP_POST_VARS["topmenuimage1"]."', topmenuimage2='".$HTTP_POST_VARS["topmenuimage2"]."', topmenuvisible='".$HTTP_POST_VARS["topmenuvisible"]."', topmenuorderby='".$HTTP_POST_VARS["topmenuorderby"]."', topmenuorderdir='".$HTTP_POST_VARS["topmenuorderdir"]."', tophovertitle='".$sTopHoverTitle."', topopeninpage='".$HTTP_POST_VARS["topopeninpage"]."', loginreq='".$HTTP_POST_VARS["loginreq"]."', usergroups='".$sUserGroups."', topgroupname='".$HTTP_POST_VARS["topgroupname"]."', topmenuimage3='".$HTTP_POST_VARS["topmenuimage3"]."', topmenuimage4='".$HTTP_POST_VARS["topmenuimage4"]."', authorid='".$HTTP_POST_VARS["AuthorId"]."' WHERE topgroupname='".$HTTP_POST_VARS["TopGroupName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbTopgroups"]." VALUES('', '".$sTopGroupDesc."', '".$HTTP_POST_VARS["topgrouplink"]."', '".$HTTP_POST_VARS["topgrouporderid"]."', '".$HTTP_POST_VARS["topmenuimage1"]."', '".$HTTP_POST_VARS["topmenuimage2"]."', '".$sTopHoverTitle."', '".$HTTP_POST_VARS["topmenuvisible"]."', '".$HTTP_POST_VARS["topmenuorderby"]."', '".$HTTP_POST_VARS["topmenuorderdir"]."', '".$HTTP_POST_VARS["topopeninpage"]."', '".$HTTP_POST_VARS["loginreq"]."', '".$sUserGroups."', '".$HTTP_POST_VARS["topgroupname"]."', '".$GLOBALS["gsLanguage"]."', '".$HTTP_POST_VARS["topmenuimage3"]."', '".$HTTP_POST_VARS["topmenuimage4"]."', '".$HTTP_POST_VARS["AuthorId"]."')";
   }
   $result = dbExecute($strQuery,true);
   $dummy = dbInsertValue($GLOBALS["eztbTopgroups"]);
   if ($dummy == 0) { $dummy = $HTTP_POST_VARS["topgroupid"]; }

   // If we've changed the topgroup name, we need to reflect that in any groups that are attached to the menu
   if (($HTTP_POST_VARS["TopGroupName"] != '') && ($HTTP_POST_VARS["topgroupname"] != $HTTP_POST_VARS["TopGroupName"])) {
      $strQuery = "UPDATE ".$GLOBALS["eztbGroups"]." SET topgroupname='".$HTTP_POST_VARS["topgroupname"]."' WHERE topgroupname='".$HTTP_POST_VARS["TopGroupName"]."'";
      $result = dbExecute($strQuery,true);
      // And if it's set as the top-level homepage, we need to change that as well
      if ($HTTP_POST_VARS["TopGroupName"] == $GLOBALS["gsHomepageTopGroup"]) {
         UpdateSetting($HTTP_POST_VARS["topgroupname"],'homepagetopgroup');
      }
   }

   // For new groups:
   //     if no name was specified, set a default
   //     if no orderid was specified, set a default
   if ((($HTTP_POST_VARS["TopGroupName"] == '') && ($HTTP_POST_VARS["topgroupname"] == '')) || ($HTTP_POST_VARS["topgrouporderid"] == '')) {
      if (($HTTP_POST_VARS["TopGroupName"] == '') && ($HTTP_POST_VARS["topgroupname"] == '')) { $topgroupname = $dummy;
      } else { $topgroupname = $HTTP_POST_VARS["topgroupname"]; }
      if ($HTTP_POST_VARS["topgrouporderid"] == '') { $topgrouporderid = $dummy;
      } else { $topgrouporderid = $HTTP_POST_VARS["topgrouporderid"]; }
      $strQuery = "UPDATE ".$GLOBALS["eztbTopgroups"]." SET topgroupname='".$topgroupname."', topgrouporderid='".$topgrouporderid."' WHERE topgroupid='".$dummy."'";
      $result = dbExecute($strQuery,true);
   }
   dbCommit();
} // function AddTopGroup()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["eztbTopgroups"]." WHERE topgroupname='".$HTTP_GET_VARS["TopGroupName"]."' AND language='".$GLOBALS["gsLanguage"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["fsTopGroupID"]      = $rs["topgroupid"];
   $GLOBALS["fsTopGroupName"]    = $rs["topgroupname"];
   $GLOBALS["fsTopGroupDesc"]    = $rs["topgroupdesc"];
   $GLOBALS["fsTopGroupLink"]    = $rs["topgrouplink"];
   $GLOBALS["fsTopGroupOrderID"] = $rs["topgrouporderid"];
   $GLOBALS["fsMenuImage1"]      = $rs["topmenuimage1"];
   $GLOBALS["fsMenuImage2"]      = $rs["topmenuimage2"];
   $GLOBALS["fsMenuImage3"]      = $rs["topmenuimage3"];
   $GLOBALS["fsMenuImage4"]      = $rs["topmenuimage4"];
   $GLOBALS["fbMenuVisible"]     = $rs["topmenuvisible"];
   $GLOBALS["fsOrderBy"]         = $rs["topmenuorderby"];
   $GLOBALS["fsOrderDir"]        = $rs["topmenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $rs["tophovertitle"];
   $GLOBALS["fsOpenInPage"]      = $rs["topopeninpage"];
   $GLOBALS["fsLoginReq"]        = $rs["loginreq"];
   $GLOBALS["fsUsergroups"]      = $rs["usergroups"];
   $GLOBALS["fsAuthorId"]        = $rs["authorid"];

   $HTTP_POST_VARS["authorid"]   = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }

   $HTTP_POST_VARS["TopGroupName"] = $HTTP_GET_VARS["TopGroupName"];
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $GLOBALS["fsTopGroupID"]      = $HTTP_POST_VARS["topgroupid"];
   $GLOBALS["fsTopGroupName"]    = $HTTP_POST_VARS["topgroupname"];
   $GLOBALS["fsTopGroupDesc"]    = $HTTP_POST_VARS["topgroupdesc"];
   $GLOBALS["fsTopGroupLink"]    = $HTTP_POST_VARS["topgrouplink"];
   $GLOBALS["fsTopGroupOrderID"] = $HTTP_POST_VARS["topgrouporderid"];
   $GLOBALS["fsMenuImage1"]      = $HTTP_POST_VARS["topmenuimage1"];
   $GLOBALS["fsMenuImage2"]      = $HTTP_POST_VARS["topmenuimage2"];
   $GLOBALS["fsMenuImage3"]      = $HTTP_POST_VARS["topmenuimage3"];
   $GLOBALS["fsMenuImage4"]      = $HTTP_POST_VARS["topmenuimage4"];
   $GLOBALS["fbMenuVisible"]     = $HTTP_POST_VARS["topmenuvisible"];
   $GLOBALS["fsOrderBy"]         = $HTTP_POST_VARS["topmenuorderby"];
   $GLOBALS["fsOrderDir"]        = $HTTP_POST_VARS["topmenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $HTTP_POST_VARS["tophovertitle"];
   $GLOBALS["fsOpenInPage"]      = $HTTP_POST_VARS["topopeninpage"];
   $GLOBALS["fsLoginReq"]        = $HTTP_POST_VARS["loginreq"];
   $GLOBALS["fsUsergroups"]      = $HTTP_POST_VARS["usergroups"];
   $GLOBALS["fsAuthorId"]        = $HTTP_POST_VARS["authorid"];

   if ($GLOBALS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if (bRecordExists('eztbTopgroups','topgroupname',$HTTP_POST_VARS["topgroupname"],'topgroupid')) {
      $GLOBALS["strErrors"][] = $GLOBALS["eMenuExists"];
   }
   if ($HTTP_POST_VARS["topgroupname"] <> urlencode($HTTP_POST_VARS["topgroupname"])) {
      $GLOBALS["strErrors"][] = $GLOBALS["eInvalidName"];
   }
   if ($HTTP_POST_VARS["topgroupdesc"] == "") {
      $GLOBALS["strErrors"][] = $GLOBALS["eTitleEmpty"];
   }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


function RenderUsergroups($GroupNames)
{
   $sqlQuery = "SELECT * FROM ".$GLOBALS["eztbUsergroups"]." WHERE language='".$GLOBALS["gsLanguage"]."' ORDER BY usergroupname";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if (strpos($GroupNames, $rs["usergroupname"], 0)) { echo 'selected '; }
      echo 'value="'.$rs["usergroupname"].'">'.$rs["usergroupdesc"];
   }
   dbFreeResult($result);
} // function RenderUsergroups()


function RenderAuthors($AuthorId)
{
   $sqlQuery = "SELECT authorid,authorname FROM ".$GLOBALS["eztbAuthors"]." ORDER BY authorname";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo '<option ';
      if ($AuthorId == $rs["authorid"]) { echo 'selected '; }
      echo 'value="'.$rs["authorid"].'">'.$rs["authorname"];
   }
   dbFreeResult($result);
} // function RenderAuthors()


include($GLOBALS["rootdp"]."include/javafuncs.php");

?>

