<?php

/***************************************************************************

 m_ttopgroupsform.php
 ---------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

include_once ("rootdatapath.php");
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = $GLOBALS["cantranslate"] = False;
$GLOBALS["fieldstatus"] = '';


// Validate the user's level of access for this form.
$GLOBALS["form"] = 'topgroups';
$validaccess = VerifyAdminLogin3("TopGroupName");
if ($GLOBALS["cantranslate"] == True) {
   $GLOBALS["specialedit"] = True;
   $GLOBALS["fieldstatus"] = '';
}


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ("adminfunctions.php");
includeLanguageFiles('admin','topgroups');


$ImageFileTypes = array('gif', 'jpg', 'jpeg', 'png');

// If we've been passed the request from the content list, then we
//    read content data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["TopGroupName"] != '') {
   $HTTP_POST_VARS["TopGroupName"] = $HTTP_GET_VARS["TopGroupName"];
   $HTTP_POST_VARS["LanguageCode"] = $HTTP_GET_VARS["LanguageCode"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   GetFormData();
}


$strQuery = "SELECT languagename,charset FROM ".$GLOBALS["eztbLanguages"]." WHERE languagecode='".$GLOBALS["gsDefault_language"]."'";
$result = dbRetrieve($strQuery,true,0,0);
if ($rs = dbFetch($result)) {
   $baselanguagename = $rs["languagename"];
   $basecharset = $rs["charset"];
}
dbFreeResult($result);

$strQuery = "SELECT languagename,charset FROM ".$GLOBALS["eztbLanguages"]." WHERE languagecode='".$HTTP_POST_VARS["LanguageCode"]."'";
$result = dbRetrieve($strQuery,true,0,0);
if ($rs = dbFetch($result)) {
   $languagename = $rs["languagename"];
   $charset = $rs["charset"];
}
dbFreeResult($result);


$GLOBALS["tabindex"] = 1024;

if ($HTTP_POST_VARS["submitted"] == "yes") {
   // User has submitted the data
   if (bCheckForm()) {
      AddTopGroup($basecharset,$charset);
      Header("Location: ".BuildLink('m_topgroups.php')."&page=".$HTTP_POST_VARS["page"]."&filterlangname=".$HTTP_POST_VARS["LanguageCode"]);
   } else {
      // Invalid data has been submitted
      GetFormData();
   }
}
frmTopGroupsForm($baselanguagename,$basecharset,$languagename,$charset);


function frmTopGroupsForm($baselanguagename,$basecharset,$languagename,$charset)
{
   global $HTTP_POST_VARS;

   $convertcharsets = ($basecharset != $charset);
   if ($convertcharsets) {
      if (function_exists('mb_convert_encoding')) { adminformheader('UTF-8'); }
      else {
         $convertcharsets = false;
         adminformheader($charset);
      }
   }
   else { adminformheader(); }

   adminformopen('topgroupdesc');
   adminformtitle(2,charsetText($GLOBALS["tFormTitle2"],$convertcharsets,$GLOBALS["gsCharset"]).' - '.charsetText($languagename,$convertcharsets,$GLOBALS["gsCharset"]));
   if (isset($GLOBALS["strErrors"])) { formError(2); }
   adminsubheader(2,charsetText($GLOBALS["thGeneral"],$convertcharsets,$GLOBALS["gsCharset"]));
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuRef","topgroupname"); ?>
       <td valign="top" class="content">
           <input type="text" name="topgroupname" size="32" value="<?php echo $GLOBALS["fsTopGroupName"]; ?>" maxlength="32" readonly>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuTitle","topgroupdesc"); ?>
       <td valign="top" class="content">
           <table border="0" cellpadding="1" cellspacing="0">
               <tr><td align="<?php echo $GLOBALS["right"]; ?>" valign="top">
                       <b><?php echo charsetText($baselanguagename,$convertcharsets,$basecharset); ?>:</b>
                   </td>
                   <td>
                       <input type="text" name="basetopgroupdesc" size="72" value="<?php echo charsetText($GLOBALS["bsTopGroupDesc"],$convertcharsets,$charset); ?>" maxlength="100" readonly>
                   </td>
               </tr>
               <tr><td align="<?php echo $GLOBALS["right"]; ?>" valign="top">
                       <b><?php echo charsetText($languagename,$convertcharsets,$basecharset); ?>:</b>
                   </td>
                   <td>
                       <input type="text" name="topgroupdesc" size="72" value="<?php echo charsetText($GLOBALS["fsTopGroupDesc"],$convertcharsets,$basecharset); ?>" maxlength="100"<?php echo $GLOBALS["fieldstatus"]; ?>>
                   </td>
               </tr>
           </table>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuHover","tophovertitle"); ?>
       <td valign="top" class="content">
           <table border="0" cellpadding="1" cellspacing="0">
               <tr><td align="<?php echo $GLOBALS["right"]; ?>" valign="top">
                       <b><?php echo charsetText($baselanguagename,$convertcharsets,$basecharset); ?>:</b>
                   </td>
                   <td>
                       <textarea rows="3" name="basetophovertitle" cols="66" readonly><?php echo htmlspecialchars(charsetText($GLOBALS["bsHoverTitle"],$convertcharsets,$basecharset)); ?></textarea>
                   </td>
               </tr>
               <tr><td align="<?php echo $GLOBALS["right"]; ?>" valign="top">
                       <b><?php echo charsetText($languagename,$convertcharsets,$charset); ?>:</b>
                   </td>
                   <td>
                       <input type="text" name="tophovertitle" size="72" value="<?php echo charsetText($GLOBALS["fsHoverTitle"],$convertcharsets,$charset); ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
                   </td>
               </tr>
           </table>
       </td>
   </tr>
   <?php adminsubheader(2,charsetText($GLOBALS["thGraphics"],$convertcharsets,$GLOBALS["gsCharset"])); ?>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage1","topmenuimage1"); ?>
       <td valign="top" class="content">
           <input type="text" name="topmenuimage1" size="80" value="<?php echo $GLOBALS["fsMenuImage1"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage1',$GLOBALS["fsMenuImage1"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage2","topmenuimage2"); ?>
       <td valign="top" class="content">
           <input type="text" name="topmenuimage2" size="80" value="<?php echo $GLOBALS["fsMenuImage2"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage2',$GLOBALS["fsMenuImage2"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage3","topmenuimage3"); ?>
       <td valign="top" class="content">
           <input type="text" name="topmenuimage3" size="80" value="<?php echo $GLOBALS["fsMenuImage3"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage3',$GLOBALS["fsMenuImage3"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("MenuImage4","topmenuimage4"); ?>
       <td valign="top" class="content">
           <input type="text" name="topmenuimage4" size="80" value="<?php echo $GLOBALS["fsMenuImage4"]; ?>" maxlength="255"<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('topmenuimage4',$GLOBALS["fsMenuImage4"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_topgroups.php');
   if ($GLOBALS["specialedit"] == True) {
      adminhelpmsg(2);
      ?><input type="hidden" name="topgroupid" value="<?php echo $GLOBALS["fsTopGroupID"]; ?>"><?php
      ?><input type="hidden" name="TopGroupName" value="<?php echo $HTTP_POST_VARS["TopGroupName"]; ?>"><?php
      ?><input type="hidden" name="LanguageCode" value="<?php echo $HTTP_POST_VARS["LanguageCode"]; ?>"><?php
      ?><input type="hidden" name="topgrouporderid" value="<?php echo $GLOBALS["fsTopGroupOrderID"]; ?>"><?php

      ?><input type="hidden" name="topmenuvisible" value="<?php echo $GLOBALS["fbMenuVisible"]; ?>"><?php
      ?><input type="hidden" name="topgrouplink" value="<?php echo $GLOBALS["fsTopGroupLink"]; ?>"><?php
      ?><input type="hidden" name="topopeninpage" value="<?php echo $GLOBALS["fsOpenInPage"]; ?>"><?php
      ?><input type="hidden" name="grouporderid" value="<?php echo $GLOBALS["fsGroupOrderID"]; ?>"><?php
      ?><input type="hidden" name="topmenuorderby" value="<?php echo $GLOBALS["fsOrderBy"]; ?>"><?php
      ?><input type="hidden" name="topmenuorderdir" value="<?php echo $GLOBALS["fsOrderDir"]; ?>"><?php
      ?><input type="hidden" name="loginreq" value="<?php echo $GLOBALS["fsLoginReq"]; ?>"><?php
      ?><input type="hidden" name="usergroups" value="<?php echo $GLOBALS["fsUsergroups"]; ?>"><?php

      ?><input type="hidden" name="edittype" value="<?php echo $GLOBALS["fsEditType"]; ?>"><?php

   }
   adminformclose();
} // function frmTopGroupsForm()


function AddTopGroup($basecharset,$charset)
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $convertcharsets = ($basecharset != $charset);
   if ($convertcharsets) {
      if (!(function_exists('mb_convert_encoding'))) {
         $convertcharsets = false;
      }
   }

   $sTopGroupDesc  = dbString(UTF8Text($HTTP_POST_VARS["topgroupdesc"],$convertcharsets,$charset));
   $sTopHoverTitle = dbString(UTF8Text($HTTP_POST_VARS["tophovertitle"],$convertcharsets,$charset));

   if ($HTTP_POST_VARS["edittype"] != 'add') {
      $strQuery = "UPDATE ".$GLOBALS["eztbTopgroups"]." SET topgroupdesc='".$sTopGroupDesc."', topmenuimage1='".$HTTP_POST_VARS["topmenuimage1"]."', topmenuimage2='".$HTTP_POST_VARS["topmenuimage2"]."', tophovertitle='".$sTopHoverTitle."', topmenuimage3='".$HTTP_POST_VARS["topmenuimage3"]."', topmenuimage4='".$HTTP_POST_VARS["topmenuimage4"]."' WHERE topgroupname='".$HTTP_POST_VARS["TopGroupName"]."' AND language='".$HTTP_POST_VARS["LanguageCode"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["eztbTopgroups"]." VALUES('', '".$sTopGroupDesc."', '".$HTTP_POST_VARS["topgrouplink"]."', '".$HTTP_POST_VARS["topgrouporderid"]."', '".$HTTP_POST_VARS["topmenuimage1"]."', '".$HTTP_POST_VARS["topmenuimage2"]."', '".$sTopHoverTitle."', '".$HTTP_POST_VARS["topmenuvisible"]."', '".$HTTP_POST_VARS["topmenuorderby"]."', '".$HTTP_POST_VARS["topmenuorderdir"]."', '".$HTTP_POST_VARS["topopeninpage"]."', '".$HTTP_POST_VARS["loginreq"]."', '".$HTTP_POST_VARS["usergroups"]."', '".$HTTP_POST_VARS["TopGroupName"]."', '".$HTTP_POST_VARS["LanguageCode"]."', '".$HTTP_POST_VARS["topmenuimage3"]."', '".$HTTP_POST_VARS["topmenuimage4"]."', '".$EZ_SESSION_VARS["UserID"]."')";
   }
   $result = dbExecute($strQuery,true);

   dbCommit();
} // function AddTopGroup()


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery = "SELECT * FROM ".$GLOBALS["eztbTopgroups"]." WHERE topgroupname='".$HTTP_GET_VARS["TopGroupName"]."' AND language='".$GLOBALS["gsDefault_language"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["bsTopGroupDesc"]    = $rs["topgroupdesc"];
   $GLOBALS["bsHoverTitle"]      = $rs["tophovertitle"];

   $GLOBALS["fsTopGroupID"]      = $rs["topgroupid"];
   $GLOBALS["fsTopGroupName"]    = $rs["topgroupname"];
   $GLOBALS["fsTopGroupDesc"]    = $rs["topgroupdesc"];
   $GLOBALS["fsTopGroupLink"]    = $rs["topgrouplink"];
   $GLOBALS["fsTopGroupOrderID"] = $rs["topgrouporderid"];
   $GLOBALS["fsMenuImage1"]      = $rs["topmenuimage1"];
   $GLOBALS["fsMenuImage2"]      = $rs["topmenuimage2"];
   $GLOBALS["fsMenuImage3"]      = $rs["topmenuimage3"];
   $GLOBALS["fsMenuImage4"]      = $rs["topmenuimage4"];
   $GLOBALS["fbMenuVisible"]     = $rs["topmenuvisible"];
   $GLOBALS["fsOrderBy"]         = $rs["topmenuorderby"];
   $GLOBALS["fsOrderDir"]        = $rs["topmenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $rs["tophovertitle"];
   $GLOBALS["fsOpenInPage"]      = $rs["topopeninpage"];
   $GLOBALS["fsLoginReq"]        = $rs["loginreq"];
   $GLOBALS["fsUsergroups"]      = $rs["usergroups"];


   $strQuery="SELECT * FROM ".$GLOBALS["eztbTopgroups"]." WHERE topgroupname='".$HTTP_GET_VARS["TopGroupName"]."' AND language='".$HTTP_GET_VARS["LanguageCode"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   if (dbRowsReturned($result) != 0) {
      $rs     = dbFetch($result);

      $GLOBALS["fsTopGroupID"]      = $rs["topgroupid"];
      $GLOBALS["fsTopGroupName"]    = $rs["topgroupname"];
      $GLOBALS["fsTopGroupDesc"]    = $rs["topgroupdesc"];
      $GLOBALS["fsTopGroupLink"]    = $rs["topgrouplink"];
      $GLOBALS["fsTopGroupOrderID"] = $rs["topgrouporderid"];
      $GLOBALS["fsMenuImage1"]      = $rs["topmenuimage1"];
      $GLOBALS["fsMenuImage2"]      = $rs["topmenuimage2"];
      $GLOBALS["fsMenuImage3"]      = $rs["topmenuimage3"];
      $GLOBALS["fsMenuImage4"]      = $rs["topmenuimage4"];
      $GLOBALS["fbMenuVisible"]     = $rs["topmenuvisible"];
      $GLOBALS["fsOrderBy"]         = $rs["topmenuorderby"];
      $GLOBALS["fsOrderDir"]        = $rs["topmenuorderdir"];
      $GLOBALS["fsHoverTitle"]      = $rs["tophovertitle"];
      $GLOBALS["fsOpenInPage"]      = $rs["topopeninpage"];
      $GLOBALS["fsLoginReq"]        = $rs["loginreq"];
      $GLOBALS["fsUsergroups"]      = $rs["usergroups"];
      $GLOBALS["fsEditType"]        = 'update';
   } else {
      $GLOBALS["fsEditType"]        = 'add';
   }

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }

   $HTTP_POST_VARS["TopGroupName"] = $HTTP_GET_VARS["TopGroupName"];
   $HTTP_POST_VARS["LanguageCode"] = $HTTP_GET_VARS["LanguageCode"];
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $GLOBALS["fsTopGroupID"]      = $HTTP_POST_VARS["topgroupid"];
   $GLOBALS["fsTopGroupName"]    = $HTTP_POST_VARS["topgroupname"];
   $GLOBALS["fsTopGroupDesc"]    = $HTTP_POST_VARS["topgroupdesc"];
   $GLOBALS["fsTopGroupLink"]    = $HTTP_POST_VARS["topgrouplink"];
   $GLOBALS["fsTopGroupOrderID"] = $HTTP_POST_VARS["topgrouporderid"];
   $GLOBALS["fsMenuImage1"]      = $HTTP_POST_VARS["topmenuimage1"];
   $GLOBALS["fsMenuImage2"]      = $HTTP_POST_VARS["topmenuimage2"];
   $GLOBALS["fsMenuImage3"]      = $HTTP_POST_VARS["topmenuimage3"];
   $GLOBALS["fsMenuImage4"]      = $HTTP_POST_VARS["topmenuimage4"];
   $GLOBALS["fbMenuVisible"]     = $HTTP_POST_VARS["topmenuvisible"];
   $GLOBALS["fsOrderBy"]         = $HTTP_POST_VARS["topmenuorderby"];
   $GLOBALS["fsOrderDir"]        = $HTTP_POST_VARS["topmenuorderdir"];
   $GLOBALS["fsHoverTitle"]      = $HTTP_POST_VARS["tophovertitle"];
   $GLOBALS["fsOpenInPage"]      = $HTTP_POST_VARS["topopeninpage"];
   $GLOBALS["fsLoginReq"]        = $HTTP_POST_VARS["loginreq"];
   $GLOBALS["fsUsergroups"]      = $HTTP_POST_VARS["usergroups"];

   $GLOBALS["edittype"]          = $HTTP_POST_VARS["edittype"];

   if ($GLOBALS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function bCheckForm()
{
   global $HTTP_POST_VARS;

   $bFormOK = true;
   if ($HTTP_POST_VARS["topgroupdesc"] == "") {
      $GLOBALS["strErrors"][] = $GLOBALS["eTitleEmpty"];
   }

   if (isset($GLOBALS["strErrors"])) { $bFormOK = false; }
   return $bFormOK;
} // function bCheckForm()


$GLOBALS["eztbTable"] = $GLOBALS["eztbTopgroups"];
$GLOBALS["eztbKeyField"] = 'topgroupname';
$GLOBALS["keyfieldval"] = $HTTP_POST_VARS["TopGroupName"];
include($GLOBALS["rootdp"]."include/javafuncs.php");

?>
