# --------------------------------------------------------
#
# Table structure for table `diary`
#

DROP TABLE IF EXISTS diary;
CREATE TABLE diary (
  diaryid int(11) unsigned NOT NULL auto_increment,
  eventname varchar(255) default NULL,
  publishdate datetime default NULL,
  startdate datetime default NULL,
  enddate datetime default NULL,
  contactname varchar(255) default NULL,
  contactemail varchar(255) default NULL,
  web_page varchar(255) default NULL,
  comment text,
  location varchar(255) default NULL,
  countrycode char(2) default NULL,
  activeentry char(1) default NULL,
  authorid int(11) default NULL,
  updatedate datetime default NULL,
  catid varchar(16) default NULL,
  PRIMARY KEY  (diaryid),
  KEY dates (startdate,enddate)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Table structure for table `diarycategories`
#

DROP TABLE IF EXISTS diarycategories;
CREATE TABLE diarycategories (
  catid int(11) unsigned NOT NULL auto_increment,
  catname varchar(32) NOT NULL default '',
  catref varchar(32) default NULL,
  hiddencat char(1) default '0',
  PRIMARY KEY  (catid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Data for table `modules`
#
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Event Diary', 'E', 'diary', 'showdiary.php', 'Y');
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Event List', 'E', 'diary', 'showeventlist.php', 'Y');
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Inline Event List', 'I', 'diary', 'inlineeventlist.php', 'N');


# --------------------------------------------------------
#
# Data for table `modulesettings`
#
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'version', '2.0.0');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'author', 'The ezContents Development Team');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'todaydatecolour', 'OrangeRed');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'todaycellbackground', 'DarkGray');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'todaycellhoverbackground', 'MediumSlateBlue');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'datecolour', 'Gold');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'weekenddatecolour', 'White');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'cellbackground', 'DarkSlateBlue');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('diary', 'cellhoverbackground', 'MediumSlateBlue');


# --------------------------------------------------------
#
# Data for table `specialcontents`
#
INSERT INTO specialcontents (scname, sctitle, scdb, screg, scvalid, stextdisplay, stext, sgraphicdisplay, sgraphic, usergroups, scuseprefix, scusecategories, orderby, showpostedby, showposteddate, perpage) VALUES ('diary', 'Dates for your diary', 'diary', '', 'Y', 'Y', '', 'Y', 'icons/star.gif', '', 'N', '', 'D', '', '', 8);
