<?php

/***************************************************************************

 m_diary.php
 ------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

$GLOBALS["ModuleName"] = 'diary';
include("moduleref.php");

$GLOBALS["rootdp"] = '../../';
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_diary.php');
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminbutton.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");


GetSpecialData($GLOBALS["ModuleRef"]);

frmDiary();


function frmDiary()
{
   global $HTTP_GET_VARS;

   adminheader();
   admintitle(7,$GLOBALS["tFormTitle"]);

   // Generate image tags for the different images that appear on the page
   adminbuttons($GLOBALS["tViewDiary"],$GLOBALS["tAddNewDiary"],$GLOBALS["tEditDiary"],$GLOBALS["tDeleteDiary"]);
   $GLOBALS["iRelease"] = lsimagehtmltag($GLOBALS["icon_home"],'rel_button.gif',$GLOBALS["gsLanguage"],$GLOBALS["tReleaseDiary"],0);

   $strQuery = "select diaryid FROM ".$GLOBALS["scTable"];
   $result = dbRetrieve($strQuery,true,0,0);
   $lRecCount = dbRowsReturned($result);
   dbFreeResult($result);

   $nCurrentPage = 0;
   if ($HTTP_GET_VARS["sort"] == '') { $HTTP_GET_VARS["sort"] = 6; }
   if($HTTP_GET_VARS["page"] != "") { $nCurrentPage = $HTTP_GET_VARS["page"]; }
   $nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
   $lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

   frmModuleHdFt(7,$nCurrentPage,$nPages);
   ?>
   <tr class="teaserheadercontent">
   <?php
       adminlistitem(12,$GLOBALS["tEditDelRel"],'');
       adminlistitem(24,$GLOBALS["tEventName"],'',1);
       adminlistitem(20,$GLOBALS["tLocation"],'',2);
       adminlistitem(12,$GLOBALS["tPostedBy"],'',3);
       adminlistitem(12,$GLOBALS["tStartDate"],'',4);
       adminlistitem(12,$GLOBALS["tEndDate"],'',5);
       adminlistitem(8,$GLOBALS["tStatus"],'',6);
   ?>
   </tr>
   <?php

   switch ($HTTP_GET_VARS["sort"])
   {
      case '1' : $sort = 'eventname,publishdate DESC';
                 break;
      case '2' : $sort = 'location,publishdate DESC';
                 break;
      case '3' : $sort = 'authorid,publishdate DESC';
                 break;
      case '4' : $sort = 'startdate,publishdate DESC';
                 break;
      case '5' : $sort = 'enddate,publishdate DESC';
                 break;
      case '6' : $sort = 'activeentry,publishdate DESC';
                 break;
      default  : $sort = 'activeentry,publishdate DESC';
   }
   $strQuery = "SELECT * FROM ".$GLOBALS["scTable"]." ORDER BY ".$sort;
   $result = dbRetrieve($strQuery,true,$lStartRec,$GLOBALS["RECORDS_PER_PAGE"]);
   while ($rsDiary = dbFetch($result))
   {
      ?>
      <tr class="teasercontent">
          <td align="center" valign="top" class="content">
              <?php admineditcheck('diaryform','DiaryID',$rsDiary["diaryid"],$rsDiary["authorid"]); ?>
              <?php admindeletecheck('DelEntry','DiaryID',$rsDiary["diaryid"]); ?>&nbsp;
              <?php adminreleasecheck('RelEntry','DiaryID',$rsDiary["diaryid"]); ?>&nbsp;
          </td>
         <td valign="top" class="content"><?php echo $rsDiary["eventname"]; ?></td>
         <td valign="top" class="content"><?php echo $rsDiary["location"]; ?></td>
         <td valign="top" class="content"><?php echo lGetAuthorName($rsDiary["authorid"]); ?></td>
         <td valign="top" class="content"><?php echo substr($rsDiary["startdate"], 0, 10); ?></td>
         <td valign="top" class="content"><?php echo substr($rsDiary["enddate"], 0, 10); ?></td>
         <td valign="top" class="content"><?php if ($rsDiary["activeentry"] == 1) { echo $GLOBALS["tReleased"]; } else { echo $GLOBALS["tPending"]; } ?></td>
      </tr>
      <?php
   }

   dbFreeResult($result);

   frmModuleHdFt(7,$nCurrentPage,$nPages);
   frmModuleReturn(7);
   ?>
   </table>
   </form>
   </body>
   </html>
   <?php
}

frmModuleJs();

?>
