<?php

/***************************************************************************

 m_diaryform.php
 ----------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/


// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'd';			// Time period to calculate the expiry date (based on today's date)
$expirynumber = 0;


$GLOBALS["ModuleName"] = 'diary';
include("moduleref.php");


$GLOBALS["rootdp"] = '../../';
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."compile.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_diary.php');


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();
$GLOBALS["specialedit"] = True;


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('comment');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);



GetModuleData($GLOBALS["ModuleRef"]);

// If we've been passed the request from the banner list, then we
//    read banner data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["DiaryID"] != "") {
	$HTTP_POST_VARS["DiaryID"] = $HTTP_GET_VARS["DiaryID"];
	$HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
	GetGlobalData();
} else {
	$timenow = time();		// Calculate the default expiry date
	$GLOBALS["DefExpDate"] = date('Y-m-d H:i:s',DateAdd($expiryperiod,$expirynumber,$timenow));
	GetFormData;
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
	AddDiary();
	Header("Location: ".BuildLink('m_'.$GLOBALS["ModuleName"].'.php')."&page=".$HTTP_POST_VARS["page"]);
}

frmDiaryForm();


function frmDiaryForm()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   adminformheader();
   adminformopen('eventname');
   adminformtitle(4,$GLOBALS["tFormTitle"]);
   adminsubheader(4,$GLOBALS["thDetails"]);

	if ($GLOBALS["scUseCategories"] == 'Y') {
		?>
		<tr class="tablecontent">
			<?php FieldHeading("Category","catcode"); ?>
			<td colspan="3" valign="top" class="content">
				<select name="catcode" size="1">
					<option value="0">
					<?php RenderAllCategories($GLOBALS["gsCatCode"]); ?>
				</select>
			</td>
		</tr>
		<?php
	} else {
		?><input type="hidden" name="catcode" value="0"><?php
	}
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("EventName","eventname"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="eventname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsEventName"]) ?>" maxlength=255>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("StartDate","StartDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Start',$GLOBALS["gsStartDate"]); ?>
       </td>
       <?php FieldHeading("EndDate","EndDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('End',$GLOBALS["gsEndDate"],$GLOBALS["DefExpDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Location","location"); ?>
       <td valign="top" class="content">
           <input type="text" name="location" size="40" value="<?php echo $GLOBALS["gsLocation"] ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
       <?php FieldHeading("Country","countrycode"); ?>
       <td valign="top" class="content">
           <select name="countrycode" size="1"<?php echo $GLOBALS["fieldstatus"]; ?>>
               <OPTION value="00">
               <?php RenderCountries($GLOBALS["gsCountryCode"]); ?>
           </select>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thDescription"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("Comment","comment"); ?>
       <td colspan="3" valign="top" class="content">
			<?php
			if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
				?>
				<textarea id="comment" name="comment" style="width:540; height:240"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["gsComment"]; ?></textarea>
				<?php
			} else {
	           EditButtons("Comment","comment");
				?>
				<textarea rows="6" id="comment" name="comment" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsComment"]); ?></textarea>
				<?php
			}
			admintagdisplay('comment');
			admintagdisplay2('comment');
			?>
       </td>
   </tr>
   <?php adminsubheader(4,$GLOBALS["thContact"]); ?>
   <tr class="tablecontent">
       <?php FieldHeading("CName","contactname"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CEMail","contactemail"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="contactemail" size="60" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebRef","web_page"); ?>
       <td colspan="3" valign="top" class="content">
           <input type="text" name="web_page" size="70" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   adminformsavebar(4,'m_diary.php');
   if ($GLOBALS["specialedit"] == True) {
//      adminhelpmsg(4);
      ?><input type="hidden" name="DiaryID" value="<?php echo $HTTP_POST_VARS["DiaryID"]; ?>"><?php
   }
   adminformclose();
} // function frmDiaryForm()


function AddDiary()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $startisodate   = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["StartYear"], $HTTP_POST_VARS["StartMonth"], $HTTP_POST_VARS["StartDay"]));
   $endisodate     = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["EndYear"], $HTTP_POST_VARS["EndMonth"], $HTTP_POST_VARS["EndDay"]));
   $authorid = lGetAuthorID();

   $sEventName = dbString($HTTP_POST_VARS["eventname"]);
   $sComment = trim(dbString($HTTP_POST_VARS["comment"]));
	if ($sComment == '<br />') { $sComment = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sComment = str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sComment);
		$sComment = str_replace($GLOBALS["base_url"],'./',$sComment); 
		$sComment = str_replace('<./','</',$sComment);
		//	Compile pre-compiled tags
		$sComment = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sComment.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], $GLOBALS["RestrictTags"]));
	}

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0; }
   else { $scValid = 1; }

   if ($HTTP_POST_VARS["DiaryID"] != "") {
      $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET eventname='".$sEventName."', publishdate='".$publishisodate."', startdate='".$startisodate."', enddate='".$endisodate."', contactname='".$HTTP_POST_VARS["contactname"]."', contactemail='".$HTTP_POST_VARS["contactemail"]."', web_page='".$HTTP_POST_VARS["web_page"]."', comment='".$sComment."', location='".$HTTP_POST_VARS["location"]."', countrycode='".$HTTP_POST_VARS["countrycode"]."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE diaryid='".$HTTP_POST_VARS["DiaryID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sEventName."', '".$publishisodate."', '".$startisodate."', '".$endisodate."', '".$HTTP_POST_VARS["contactname"]."','".$HTTP_POST_VARS["contactemail"]."','".$HTTP_POST_VARS["web_page"]."', '".$sComment."', '".$HTTP_POST_VARS["location"]."',  '".$HTTP_POST_VARS["countrycode"]."', ".$scValid.", '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
}


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scTable"]." WHERE diaryid='".$HTTP_GET_VARS["DiaryID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsEventName"]      = $rs["eventname"];
   $GLOBALS["gsStartDate"]      = $rs["startdate"];
   $GLOBALS["gsEndDate"]        = $rs["enddate"];
   $GLOBALS["gsLocation"]       = $rs["location"];
   $GLOBALS["gsCountryCode"]    = $rs["countrycode"];
   $GLOBALS["gsContactName"]    = $rs["contactname"];
   $GLOBALS["gsContactEmail"]   = $rs["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $rs["web_page"];
   $GLOBALS["gsCatCode"]        = $rs["catid"];

	if ($EZ_SESSION_VARS["WYSIWYG"] == 'Y') {
		$GLOBALS["gsComment"]	= formatWYSIWYG($rs["comment"]);
	} else {
		$GLOBALS["gsComment"]	= $rs["comment"];
	}

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $startisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["StartYear"], $HTTP_POST_VARS["StartMonth"], $HTTP_POST_VARS["StartDay"]);
   $endisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["EndYear"], $HTTP_POST_VARS["EndMonth"], $HTTP_POST_VARS["EndDay"]);

   $GLOBALS["gsEventName"]      = $HTTP_POST_VARS["eventname"];
   $GLOBALS["gsStartDate"]      = $startisodate;
   $GLOBALS["gsEndDate"]        = $endisodate;
   $GLOBALS["gsLocation"]       = $HTTP_POST_VARS["location"];
   $GLOBALS["gsCountryCode"]    = $HTTP_POST_VARS["countrycode"];
   $GLOBALS["gsContactName"]    = $HTTP_POST_VARS["contactname"];
   $GLOBALS["gsContactEmail"]   = $HTTP_POST_VARS["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $HTTP_POST_VARS["web_page"];
   $GLOBALS["gsComment"]        = $HTTP_POST_VARS["comment"];
   $GLOBALS["gsCatCode"]        = $HTTP_POST_VARS["catcode"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function RenderCountries($CountryCode)
{
   $sqlQuery = "SELECT * FROM ".$GLOBALS["eztbCountries"]." ORDER BY countryname";
   $result = dbRetrieve($sqlQuery,true,0,0);
   while ($rs = dbFetch($result)) {
      echo "<option ";
      if ($CountryCode == $rs["countrycode"]) { echo "selected "; }
      echo "value=\"".$rs["countrycode"]."\">".$rs["countryname"];
   }
   dbFreeResult($result);
} // function RenderCountries()


ModuleJavaFunctions();

?>
