<?php

/***************************************************************************

 showdiary.php
 --------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

global $HTTP_SERVER_VARS;
if ( (substr($HTTP_SERVER_VARS["PHP_SELF"],-11) == 'control.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-10) == 'module.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-16) == 'showcontents.php') ) {
	 require_once('./modules/moduleSec.php');
} else {
	require_once('../moduleSec.php');
}

$GLOBALS["ModuleName"] = 'diary';

if (!isset($GLOBALS["gsLanguage"])) { Header("Location: ".$GLOBALS["rootdp"]."module.php?link=".$GLOBALS["modules_home"].$GLOBALS["ModuleRef"]."/showdiary.php"); }
include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_diary.php');


if (!isset($HTTP_POST_VARS["month"])) $HTTP_POST_VARS["month"] = $HTTP_GET_VARS["month"];
if (!isset($HTTP_POST_VARS["year"])) $HTTP_POST_VARS["year"] = $HTTP_GET_VARS["year"];


$todaydate = strftime("%d");
$todaymonth = strftime("%m");
$todayyear = strftime("%Y");

if ((!isset($HTTP_POST_VARS["month"])) || ($HTTP_POST_VARS["month"] == '')) {
   $HTTP_POST_VARS["month"] = $todaymonth;
   if ($HTTP_POST_VARS["month"] < 10) { $HTTP_POST_VARS["month"] = substr($HTTP_POST_VARS["month"],1,1); }
}
if ((!isset($HTTP_POST_VARS["year"])) || ($HTTP_POST_VARS["year"] == '')) $HTTP_POST_VARS["year"] = $todayyear;

$month_titles = $GLOBALS["tMonth_Array"];
$week_titles = $GLOBALS["tWeek_Array"];
$month_text = $month_titles[$HTTP_POST_VARS["month"]];


$diaryheader  = '<table border="0" width="100%" class="headercontent"><tr><td valign="center" align="center" class="header">';
$diaryheader .= $month_text.' - '.$HTTP_POST_VARS["year"].'</td><td valign="top" align="'.$GLOBALS["right"].'" class="header"><table border="1" align="'.$GLOBALS["right"].'" cellpadding="4" cellspacing="1" class="tablecontent">';
$diaryheader .= '<form name="NewDate" action="'.$GLOBALS["REQUEST_URI"].'" method="post" enctype="multipart/form-data"><tr><td align="center"><table border=0 width="100%"><tr><td valign="bottom" align="center">';
$diaryheader .= '<tr><td align="'.$GLOBALS["right"].'"><b>'.$GLOBALS["calendar_month"].':</b></td><td><select name="month">'.RenderMonths($HTTP_POST_VARS["month"]).'</select></td></tr>';
$diaryheader .= '<tr><td align="'.$GLOBALS["right"].'"><b>'.$GLOBALS["calendar_year"].':</b></td><td><select name="year">'.RenderYears($HTTP_POST_VARS["year"]).'</select></td></tr></table>';
$diaryheader .= '<input type="Hidden" name="topgroupname" value="'.$HTTP_POST_VARS["topgroupname"].'">';
$diaryheader .= '<input type="Hidden" name="groupname" value="'.$HTTP_POST_VARS["groupname"].'">';
$diaryheader .= '<input type="Hidden" name="subgroupname" value="'.$HTTP_POST_VARS["subgroupname"].'">';
$diaryheader .= '<input type="Hidden" name="link" value="'.$GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/showdiary.php">';
$diaryheader .= '<input type="submit" name="submit" value="'.$GLOBALS["diary_button"].'">';
$diaryheader .= '</td></tr></form></table></td></tr></table>';
SubModuleHeader($diaryheader,$GLOBALS["tSubmitDiary"]);


// Determine the total number of days in the month
$totaldays = 31;
while (!checkdate( $HTTP_POST_VARS["month"], $totaldays + 1, $HTTP_POST_VARS["year"])) { $totaldays--; }
$totaldays++;


// Retrieve diary entries for this month
$mstartdate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["year"], $HTTP_POST_VARS["month"], 1);
$menddate   = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["year"], $HTTP_POST_VARS["month"], $totaldays);

$strQuery = "SELECT * FROM ".$GLOBALS["scTable"]." WHERE (((startdate >= '".$mstartdate."' AND enddate <= '".$menddate."') OR (startdate >= '".$mstartdate."' AND startdate <= '".$menddate."') OR (enddate >= '".$mstartdate."' AND enddate <= '".$menddate."')) AND (activeentry = 1)) ORDER BY startdate,enddate";
$result = dbRetrieve($strQuery,true,0,0);
while ($rsDiary = dbFetch($result)) {
   $i++;
   $events[$i]["diaryid"]   = $rsDiary["diaryid"];
   $events[$i]["eventname"] = $rsDiary["eventname"];
   $events[$i]["startdate"] = substr($rsDiary["startdate"],0,10);
   $events[$i]["enddate"]   = substr($rsDiary["enddate"],0,10);
}
dbFreeResult($result);
$ecount = $i;

if ($GLOBALS["diary"]["todaydatecolour"] == '')				{ $GLOBALS["diary"]["todaydatecolour"] = 'OrangeRed'; }
if ($GLOBALS["diary"]["todaycellbackground"] == '')			{ $GLOBALS["diary"]["todaycellbackground"] = 'DarkGray'; }
if ($GLOBALS["diary"]["todaycellhoverbackground"] == '')	{ $GLOBALS["diary"]["todaycellhoverbackground"] = 'MediumSlateBlue'; }
if ($GLOBALS["diary"]["datecolour"] == '')					{ $GLOBALS["diary"]["datecolour"] = 'Gold'; }
if ($GLOBALS["diary"]["weekenddatecolour"] == '')			{ $GLOBALS["diary"]["weekenddatecolour"] = 'White'; }
if ($GLOBALS["diary"]["cellbackground"] == '')				{ $GLOBALS["diary"]["cellbackground"] = 'DarkSlateBlue'; }
if ($GLOBALS["diary"]["cellhoverbackground"] == '')			{ $GLOBALS["diary"]["cellhoverbackground"] = 'MediumSlateBlue'; }

// Build table
?><table border="1" cellpadding="5" cellspacing="2" width="100%" class="tablecontent"><tr><?php
for ( $x = 0; $x < 7; $x++ ) echo '<th><b>'.$week_titles[$x].'</b></th>';
echo '</tr>';

$day = 1;
// Ensure that a number of blanks are put in so that the first day of the month lines up with the proper day of the week
// $offset = date( "w", mktime( 0, 0, 0, $month, $day, $year )) + 1;
$offset = date( "w", mktime( 0, 0, 0, $HTTP_POST_VARS["month"], $day, $HTTP_POST_VARS["year"]));
if ($offset == 7) { $offset = 0; }
echo '<tr>';
if ($offset > 0) echo str_repeat( '<td>&nbsp;</td>', $offset );

// Start entering in the information
for ( $day = 1; $day <= $totaldays; $day++ ) {
   if (($HTTP_POST_VARS["year"] == $todayyear) && ($HTTP_POST_VARS["month"] == $todaymonth) && ($day == $todaydate)) {
      echo '<td valign="top" align="center" bgcolor="'.$GLOBALS["diary"]["todaycellbackground"].'" onMouseOver=this.style.backgroundColor="'.$GLOBALS["diary"]["todaycellhoverbackground"].'" onMouseOut=this.style.backgroundColor="'.$GLOBALS["diary"]["todaycellbackground"].'"><b><font color="'.$GLOBALS["diary"]["todaydatecolour"].'">'.$day.'</font></b>';
   } else {
      if (($offset == 0) || ($offset == 6)) {
         echo '<td valign="top" align="center" bgcolor="'.$GLOBALS["diary"]["cellbackground"].'" onMouseOver=this.style.backgroundColor="'.$GLOBALS["diary"]["cellhoverbackground"].'" onMouseOut=this.style.backgroundColor="'.$GLOBALS["diary"]["cellbackground"].'"><b><font color="'.$GLOBALS["diary"]["weekenddatecolour"].'">'.$day.'</font></b>';
      } else {
         echo '<td valign="top" align="center" bgcolor="'.$GLOBALS["diary"]["cellbackground"].'" onMouseOver=this.style.backgroundColor="'.$GLOBALS["diary"]["cellhoverbackground"].'" onMouseOut=this.style.backgroundColor="'.$GLOBALS["diary"]["cellbackground"].'"><font color="'.$GLOBALS["diary"]["datecolour"].'">'.$day.'</font>';
      }
   }
   if ($ecount) {
      $mthisdate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["year"], $HTTP_POST_VARS["month"], $day);
      reset ($events);
      while (list ($i, $val) = each ($events)) {
         if (($events[$i]["startdate"] <= $mthisdate) && ($events[$i]["enddate"] >= $mthisdate)) {
            if (($GLOBALS["gsUseFrames"] == 'Y') && ($EZ_SESSION_VARS["noframesbrowser"] != True)) {
               ?>
               <br /><a href="<?php echo BuildLink('module.php'); ?>&link=<?php echo $GLOBALS["modules_home"].$GLOBALS["ModuleName"] ?>/showdiarydetail.php&topgroupname=<?php echo $HTTP_POST_VARS["topgroupname"]; ?>&groupname=<?php echo $HTTP_POST_VARS["groupname"]; ?>&subgroupname=<?php echo $HTTP_POST_VARS["subgroupname"]; ?>&diaryid=<?php echo $events[$i]["diaryid"]; ?>&year=<?php echo $HTTP_POST_VARS["year"]; ?>&month=<?php echo $HTTP_POST_VARS["month"]; ?>&rlink=<?php echo $HTTP_GET_VARS["link"]; ?>"
               <?php
            } else {
               ?>
               <br /><a href="<?php echo BuildLink('control.php'); ?>&topgroupname=<?php echo $HTTP_POST_VARS["topgroupname"]; ?>&groupname=<?php echo $HTTP_POST_VARS["groupname"]; ?>&subgroupname=<?php echo $HTTP_POST_VARS["subgroupname"]; ?>&link=<?php echo $GLOBALS["modules_home"].$GLOBALS["ModuleName"]; ?>/showdiarydetail.php&diaryid=<?php echo $events[$i]["diaryid"]; ?>&year=<?php echo $HTTP_POST_VARS["year"]; ?>&month=<?php echo $HTTP_POST_VARS["month"]; ?>&rlink=<?php echo $HTTP_GET_VARS["link"]; ?>"
               <?php
            }
            echo ' title="'.htmlspecialchars($events[$i]["eventname"]).'" '.BuildLinkMouseOver(htmlspecialchars($events[$i]["eventname"])).'">';
            echo htmlspecialchars($events[$i]["eventname"]).'</a>';
         }
      }
   }
   echo '</td>';
   $offset++;
   // If we're on the last day of the week, wrap to the other side
   if ($offset > 6) {
      $offset = 0;
      echo '</tr>';
      if ( $day < $totaldays ) echo '<tr>';
   }
}

// Fill in the remaining spaces for the end of the month, just to make it look pretty
if ($offset > 0) $offset = 7 - $offset;
if ($offset > 0) echo str_repeat( '<td>&nbsp;</td>', $offset );

?>
</tr></table>


<?php

function RenderMonths($sDate)
{
   global $month_titles;

   $rdata = '';
   for ( $sMonth = 1; $sMonth <= 12; $sMonth++ ) {
      $s = "";
      if ($sMonth == $sDate) $s = " selected";
      $rdata .= '<option value="'.$sMonth.'"'.$s.'>'.$month_titles[$sMonth].'</option>';
   }
   return $rdata;
} // function RenderMonths()


function RenderYears($sDate)
{
   $rdata = '';
   $sYear = strftime("%Y") - 2;
   $eYear = $sYear + 32;
   while ($sYear <= $eYear) {
      $s = "";
      if ($sYear == $sDate) $s = " selected";
      $rdata .= '<option value="'.$sYear.'"'.$s.'>'.$sYear.'</option>';
      $sYear++;
   }
   return $rdata;
} // function RenderYears()

?>
