<?php

/***************************************************************************

 submit_diary.php
 -----------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

global $HTTP_SERVER_VARS;
if ( (substr($HTTP_SERVER_VARS["PHP_SELF"],-11) == 'control.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-10) == 'module.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-16) == 'showcontents.php') ) {
	 require_once('./modules/moduleSec.php');
} else {
	require_once('../moduleSec.php');
}

// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'm';			// Time period to calculate the banner expiry date (based on today's date)
$expirynumber = 1;


$GLOBALS["ModuleName"] = 'diary';

include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"]."/",$GLOBALS["gsLanguage"],"lang_diary.php");

$validentry = True;
if ($GLOBALS["scLoginRequired"] == 'Y') {
	$validentry = VerifySubmoduleLogin($GLOBALS["tSubmitNews"]);
}

if ($validentry) {
	$timenow = time();		// Calculate the default expiry date
	$GLOBALS["DefExpDate"] = DateAdd($expiryperiod,$expirynumber,$timenow);

	if ($HTTP_POST_VARS["submitted"] == "yes") {
		AddDiary();
		SubModuleReturn('showdiary.php', $GLOBALS["tDiaryPage"],'&year='.$HTTP_POST_VARS["year"].'&month='.$HTTP_POST_VARS["month"]);
	} else {
		frmDiaryForm();
	}
}


function frmDiaryForm()
{
	global $EZ_SESSION_VARS, $HTTP_POST_VARS, $HTTP_GET_VARS;

	SubModFormHeader();
	adminformtitle(2,$GLOBALS["tFormTitle"]);
	adminsubheader(2,$GLOBALS["thDetails"]);
	$GLOBALS["specialedit"] = True;

	if ($GLOBALS["scUseCategories"] == 'Y') {
		?>
		<tr class="tablecontent">
			<?php FieldHeading("Category","catcode"); ?>
			<td valign="top" class="content">
				<select name="catcode" size="1">
					<option value="0">
					<?php RenderCategories($GLOBALS["gsCatCode"]); ?>
				</select>
			</td>
		</tr>
		<?php
	} else {
		?><input type="hidden" name="catcode" value="0"><?php
	}
	?>
	<tr class="tablecontent">
		<?php FieldHeading("EventName","eventname"); ?>
		<td valign="top" class="content">
			<input type="text" name="eventname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsEventName"]) ?>" maxlength=255>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("StartDate","StartDay"); ?>
		<td valign="top" class="content">
			<?php admindatedisplay('Start'); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("EndDate","EndDay"); ?>
		<td valign="top" class="content">
			<?php admindatedisplay('End'); ?>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("Location","location"); ?>
		<td valign="top" class="content">
			<input type="text" name="location" size="50" value="<?php echo $GLOBALS["gsLocation"] ?>" maxlength=255>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("Country","countrycode"); ?>
		<td valign="top" class="content">
			<select name="countrycode" size="1">
				<option value="00">
				<?php RenderCountries($GLOBALS["gsCountryCode"]); ?>
			</select>
		</td>
	</tr>
	<?php adminsubheader(2,$GLOBALS["thDescription"]); ?>
	<tr class="tablecontent">
		<?php FieldHeading("Comment","comment"); ?>
		<td valign="top" class="content">
			<?php EditButtons("Comment","comment"); ?>
			<textarea rows="6" name="comment" cols="44"><?php echo htmlspecialchars($GLOBALS["gsComment"]); ?></textarea>
		</td>
	</tr>
	<?php adminsubheader(2,$GLOBALS["thContact"]); ?>
	<tr class="tablecontent">
		<?php FieldHeading("CName","contactname"); ?>
		<td valign="top" class="content">
			<input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("CEMail","contactemail"); ?>
		<td valign="top" class="content">
			<input type="text" name="contactemail" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255>
		</td>
	</tr>
	<tr class="tablecontent">
		<?php FieldHeading("WebRef","web_page"); ?>
		<td valign="top" class="content">
			<input type="text" name="web_page" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255>
		</td>
	</tr>
	<?php SubModFormFooter(2); ?>
	<input type="hidden" name="year" value="<?php echo $HTTP_POST_VARS["year"]; ?>">
	<input type="hidden" name="month" value="<?php echo $HTTP_POST_VARS["month"]; ?>">
	<input type="hidden" name="DiaryID" value="<?php echo $HTTP_POST_VARS["DiaryID"]; ?>">
	<?php modformclose($GLOBALS["tSubmitDiary"]); ?>
	</td></tr></table>
	</form>
	</td></tr></table>
	<?php
} // function frmDiaryForm()


function AddDiary()
{
	global $HTTP_POST_VARS;

	$publishisodate = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
	$startisodate   = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["StartYear"], $HTTP_POST_VARS["StartMonth"], $HTTP_POST_VARS["StartDay"]));
	$endisodate     = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["EndYear"], $HTTP_POST_VARS["EndMonth"], $HTTP_POST_VARS["EndDay"]));
	$authorid = lGetAuthorID();

	$sEventName = dbString($HTTP_POST_VARS["eventname"]);
	$sComment   = dbString($HTTP_POST_VARS["comment"]);

	if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0; }
	else { $scValid = 1; }

	if ($HTTP_POST_VARS["DiaryID"] != "") {
		$strQuery = "UPDATE ".$GLOBALS["scTable"]." SET eventname='".$sEventName."', publishdate='".$publishisodate."', startdate='".$startisodate."', enddate='".$endisodate."', contactname='".$HTTP_POST_VARS["contactname"]."', contactemail='".$HTTP_POST_VARS["contactemail"]."', web_page='".$HTTP_POST_VARS["web_page"]."', comment='".$sComment."', location='".$HTTP_POST_VARS["location"]."', countrycode='".$HTTP_POST_VARS["countrycode"]."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE diaryid='".$HTTP_POST_VARS["DiaryID"]."'";
	} else {
		$strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sEventName."', '".$publishisodate."', '".$startisodate."', '".$endisodate."', '".$HTTP_POST_VARS["contactname"]."','".$HTTP_POST_VARS["contactemail"]."','".$HTTP_POST_VARS["web_page"]."', '".$sComment."', '".$HTTP_POST_VARS["location"]."',  '".$HTTP_POST_VARS["countrycode"]."', ".$scValid.", '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
	}
	$result = dbExecute($strQuery,true);
	dbCommit();
}


function RenderCountries($CountryCode)
{
	$sqlQuery = "SELECT * FROM ".$GLOBALS["eztbCountries"]." ORDER BY countryname";
	$result = dbRetrieve($sqlQuery,true,0,0);
	while ($rs = dbFetch($result)) {
		echo '<option ';
		if ($CountryCode == $rs["countrycode"]) { echo 'selected '; }
		echo 'value="'.$rs["countrycode"].'">'.$rs["countryname"];
	}
	dbFreeResult($result);
} // function RenderCountries()

ModuleJavaFunctions();

?>
