# --------------------------------------------------------
#
# Table structure for table `gallery`
#

DROP TABLE IF EXISTS gallery;
CREATE TABLE gallery (
  galleryid int(11) unsigned NOT NULL auto_increment,
  title varchar(255) default NULL,
  filename varchar(255) default NULL,
  artist varchar(255) default NULL,
  publishdate datetime default NULL,
  contactname varchar(255) default NULL,
  contactemail varchar(255) default NULL,
  web_page varchar(255) default NULL,
  caption text,
  activeentry char(1) default NULL,
  authorid int(11) default NULL,
  updatedate datetime default NULL,
  catid varchar(16) default NULL,
  PRIMARY KEY  (galleryid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Table structure for table `gallerycategories`
#

DROP TABLE IF EXISTS gallerycategories;
CREATE TABLE gallerycategories (
  catid int(11) unsigned NOT NULL auto_increment,
  catname varchar(32) NOT NULL default '',
  catref varchar(32) default NULL,
  hiddencat char(1) default '0',
  PRIMARY KEY  (catid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Data for table `modules`
#
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Image Gallery', 'E', 'gallery', 'showgallery.php', 'Y');


# --------------------------------------------------------
#
# Data for table `modulesettings`
#
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('gallery', 'version', '2.0.0');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('gallery', 'author', 'The ezContents Development Team');


# --------------------------------------------------------
#
# Data for table `specialcontents`
#
INSERT INTO specialcontents (scname, sctitle, scdb, screg, scvalid, stextdisplay, stext, sgraphicdisplay, sgraphic, usergroups, scuseprefix, scusecategories, orderby, showpostedby, showposteddate, perpage) VALUES ('gallery', 'Image Gallery', 'gallery', 'Y', 'Y', 'Y', 'Submit Image to Gallery', '', '', '', 'N', 'N', 'C', '', 'Y', 20);
